/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.widgets.SystemSelectRemoteFileOrFolderForm;
import org.eclipse.rse.filters.SystemFilterSimple;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExtractToForm
extends SystemSelectRemoteFileOrFolderForm {
    private String fileName;
    private ValidatorFolderName validator = new ValidatorFolderName();

    public ExtractToForm(ISystemMessageLine msgLine, Object caller, boolean fileMode) {
        super(msgLine, caller, fileMode);
    }

    public Control createContents(Shell shell, Composite parent) {
        Control control = super.createContents(shell, parent);
        return control;
    }

    public boolean verify() {
        boolean ok = super.verify();
        return ok;
    }

    public boolean isPageComplete() {
        String errMsg = null;
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if (this.valid) {
            this.clearErrorMessage();
        }
        return this.valid;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getAdapter((Object)o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        super.selectionChanged(e);
        this.valid = true;
        ISelection selection = e.getSelection();
        Object selectedObject = this.getFirstSelection(selection);
        if (selectedObject != null && selectedObject instanceof IRemoteFile) {
            IRemoteFile parentFile;
            ISystemRemoteElementAdapter remoteAdapter;
            IRemoteFile remoteFile = (IRemoteFile)selectedObject;
            this.fileName = remoteFile.getName();
            if (remoteFile.isRoot() && this.fileName.endsWith("\\")) {
                this.fileName = this.fileName.substring(0, 2);
            }
            if ((remoteAdapter = this.getRemoteAdapter(selectedObject)) != null && (remoteAdapter = this.getRemoteAdapter(parentFile = remoteFile)) != null) {
                String fullPath = remoteAdapter.getAbsoluteName((Object)parentFile);
                this.setNameText(fullPath);
                this.outputObjects = new Object[]{parentFile};
                SystemMessage selectionMsg = null;
                if (this.selectionValidator != null) {
                    selectionMsg = this.selectionValidator.isValid(this.outputConnection, this.getSelections(selection), this.getRemoteAdapters(selection));
                }
                if (selectionMsg != null) {
                    this.valid = false;
                    this.setErrorMessage(selectionMsg);
                }
                this.setPageComplete();
            }
        } else if (selectedObject != null) {
            this.valid = false;
            this.setPageComplete();
        }
    }

    public void setPreSelection(IRemoteFile selection) {
        if (selection.isDirectory()) {
            super.setPreSelection(selection);
        } else if (selection.isFile()) {
            IRemoteFile parentFile = selection.getParentRemoteFile();
            if (parentFile.isDirectory()) {
                super.setPreSelection(parentFile);
            }
            this.fileName = parentFile.getName();
        }
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        int filterCount;
        this.setDefaultConnection(connection);
        this.setShowNewConnectionPrompt(true);
        this.setAutoExpandDepth(0);
        RSEUIPlugin.getTheSystemRegistry();
        IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)connection);
        IRemoteFileSubSystemConfiguration ssf = ss.getParentRemoteFileSubSystemConfiguration();
        RemoteFileFilterString rffs = new RemoteFileFilterString(ssf);
        rffs.setShowFiles(this.fileMode);
        rffs.setShowSubDirs(!this.fileMode || !this.filesOnlyMode);
        if (this.fileTypes != null) {
            rffs.setFile(this.fileTypes);
        }
        String filterName = null;
        SystemFilterSimple filter = null;
        int n = filterCount = this.showRootFilter ? 2 : 1;
        if (this.preSelectRoot) {
            filterCount = 1;
        }
        ISystemFilter[] filters = new ISystemFilter[filterCount];
        int idx = 0;
        if (this.showRootFilter) {
            filterName = ssf.isUnixStyle() ? (!this.preSelectRoot ? (this.fileMode ? SystemFileResources.RESID_FILTER_ROOTFILES : SystemFileResources.RESID_FILTER_ROOTFOLDERS) : SystemFileResources.RESID_FILTER_ROOTS) : (this.fileMode ? SystemFileResources.RESID_FILTER_DRIVES : SystemFileResources.RESID_FILTER_DRIVES);
            filter = new SystemFilterSimple(filterName);
            filter.setParent((Object)ss);
            filter.setFilterString(rffs.toString());
            filters[idx++] = filter;
            if (this.preSelectRoot) {
                this.preSelectFilter = filter;
                this.preSelectFilterChild = folderAbsolutePath;
            }
        }
        if (!this.preSelectRoot) {
            rffs.setPath(folderAbsolutePath);
            filter = new SystemFilterSimple(rffs.toStringNoSwitches());
            filter.setParent((Object)ss);
            filter.setFilterString(rffs.toString());
            filters[idx] = filter;
            this.preSelectFilter = filter;
        }
        this.inputProvider.setFilterString(null);
        this.inputProvider.setQuickFilters(filters);
    }
}

