/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.servicesubsystem;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.services.files.RemoteFolderNotEmptyException;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.SearchJob;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Display;

public final class FileServiceSubSystem
extends RemoteFileSubSystem
implements IFileServiceSubSystem {
    protected ILanguageUtilityFactory _languageUtilityFactory;
    protected IFileService _hostFileService;
    protected ISearchService _hostSearchService;
    protected IHostFileToRemoteFileAdapter _hostFileToRemoteFileAdapter;
    protected IRemoteFile _userHome;
    static /* synthetic */ Class class$0;

    public FileServiceSubSystem(IHost host, IConnectorService connectorService, IFileService hostFileService, IHostFileToRemoteFileAdapter fileAdapter, ISearchService searchService) {
        super(host, connectorService);
        this._hostFileService = hostFileService;
        this._hostFileToRemoteFileAdapter = fileAdapter;
        this._hostSearchService = searchService;
    }

    public IRemoteFileContext getContextFor(IRemoteFile file) {
        return this.getContext(file);
    }

    public IRemoteFileContext getTheDefaultContext() {
        return this.getDefaultContextNoFilterString();
    }

    public IFileService getFileService() {
        return this._hostFileService;
    }

    public void setFileService(IFileService service) {
        this._hostFileService = service;
    }

    public ISearchService getSearchService() {
        return this._hostSearchService;
    }

    public void setSearchService(ISearchService service) {
        this._hostSearchService = service;
    }

    public IHostFileToRemoteFileAdapter getHostFileToRemoteFileAdapter() {
        return this._hostFileToRemoteFileAdapter;
    }

    public String getRemoteEncoding() {
        return System.getProperty("file.encoding");
    }

    public void setHostFileToRemoteFileAdapter(IHostFileToRemoteFileAdapter hostFileAdapter) {
        this._hostFileToRemoteFileAdapter = hostFileAdapter;
    }

    public IRemoteFile getRemoteFileObject(IRemoteFile parent, String folderOrFileName) throws SystemMessageException {
        String fullPath = String.valueOf(parent.getAbsolutePath()) + this.getSeparator() + folderOrFileName;
        IRemoteFile file = this.getCachedRemoteFile(fullPath);
        if (file != null && !file.isStale()) {
            return file;
        }
        IHostFile node = this.getFile(null, parent.getAbsolutePath(), folderOrFileName);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, node);
    }

    public IRemoteFile getRemoteFileObject(String folderOrFileName) throws SystemMessageException {
        int j;
        String fofName = ArchiveHandlerManager.cleanUpVirtualPath((String)folderOrFileName);
        IRemoteFile file = this.getCachedRemoteFile(fofName);
        if (file != null && !file.isStale()) {
            return file;
        }
        if (fofName.endsWith("#virtual#/")) {
            fofName = fofName.substring(0, fofName.length() - "#virtual#/".length());
        }
        if ((j = fofName.indexOf("#virtual#/")) == -1) {
            if (fofName.equals("/")) {
                try {
                    return this.listRoots(null)[0];
                }
                catch (Exception exception) {}
            }
            if (fofName.equals(".")) {
                return this.getUserHome();
            }
            String sep = PathUtility.getSeparator((String)folderOrFileName);
            if (fofName.endsWith(sep)) {
                fofName = fofName.substring(0, fofName.length() - sep.length());
            }
            if (fofName.endsWith(":")) {
                try {
                    IHostFile[] roots = this.getRoots(null);
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getAbsolutePath().toLowerCase().startsWith(fofName.toLowerCase())) {
                            return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), null, roots[i]);
                        }
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
            int lastSep = fofName.lastIndexOf(sep);
            if (lastSep > -1) {
                String name;
                IHostFile node;
                String parentPath = fofName.substring(0, lastSep);
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                if ((node = this.getFile((IProgressMonitor)new NullProgressMonitor(), parentPath, name = fofName.substring(lastSep + 1, fofName.length()))) != null) {
                    IRemoteFile parent = null;
                    node.isRoot();
                    return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, node);
                }
            }
            return null;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(fofName);
        IHostFile node = this.getFile(null, avp.getPath(), avp.getName());
        if (node != null) {
            return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), null, node);
        }
        return null;
    }

    protected IRemoteFile getUserHome() {
        if (this._userHome != null) {
            return this._userHome;
        }
        IRemoteFile root = this.getCachedRemoteFile(".");
        if (root != null && !root.isStale()) {
            return root;
        }
        IHostFile userHome = this.getFileService().getUserHome();
        IRemoteFile parent = null;
        if (!userHome.getParentPath().equals(".")) {
            // empty if block
        }
        root = this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, userHome);
        this.cacheRemoteFile(root, ".");
        this._userHome = root;
        return root;
    }

    protected IHostFile[] getFolders(IProgressMonitor monitor, String parentPath, String fileNameFilter) throws SystemMessageException {
        return this.getFileService().getFolders(monitor, parentPath, fileNameFilter);
    }

    protected IHostFile[] getFiles(IProgressMonitor monitor, String parentPath, String fileNameFilter) throws SystemMessageException {
        return this.getFileService().getFiles(monitor, parentPath, fileNameFilter);
    }

    protected IHostFile[] getFilesAndFolders(IProgressMonitor monitor, String parentPath, String fileNameFilter) throws SystemMessageException {
        return this.getFileService().getFilesAndFolders(monitor, parentPath, fileNameFilter);
    }

    protected IHostFile getFile(IProgressMonitor monitor, String parentPath, String fileName) throws SystemMessageException {
        return this.getFileService().getFile(monitor, parentPath, fileName);
    }

    protected IHostFile[] getRoots(IProgressMonitor monitor) throws InterruptedException, SystemMessageException {
        return this.getFileService().getRoots(monitor);
    }

    public IRemoteFile[] listFoldersAndFiles(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (!parent.canRead()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5020").makeSubstitution((Object)parentPath);
            throw new SystemMessageException(msg);
        }
        IHostFile[] results = this.getFilesAndFolders(monitor, parentPath, fileNameFilter);
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        return farr;
    }

    public IRemoteFile[] listFiles(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (!parent.canRead()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5020").makeSubstitution((Object)parentPath);
            throw new SystemMessageException(msg);
        }
        IHostFile[] results = null;
        try {
            results = this.getFiles(monitor, parentPath, fileNameFilter);
        }
        catch (SystemMessageException systemMessageException) {}
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        return farr;
    }

    public IRemoteFile[] listFolders(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (!parent.canRead()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5020").makeSubstitution((Object)parentPath);
            throw new SystemMessageException(msg);
        }
        IHostFile[] results = null;
        try {
            results = this.getFolders(monitor, parentPath, fileNameFilter);
        }
        catch (SystemMessageException systemMessageException) {}
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        return farr;
    }

    public IRemoteFile[] listRoots(IRemoteFileContext context, IProgressMonitor monitor) throws InterruptedException {
        IHostFile[] roots = null;
        try {
            roots = this.getRoots(monitor);
        }
        catch (SystemMessageException systemMessageException) {}
        IRemoteFile[] results = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, null, roots);
        return results;
    }

    public void download(IRemoteFile file, String localpath, String encoding, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String parentPath = file.getParentPath();
        File localFile = new File(localpath);
        try {
            this.getFileService().download(monitor, parentPath, file.getName(), localFile, this.isBinary(file), encoding);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
        }
        if (monitor.isCanceled()) {
            localFile.delete();
        }
    }

    protected boolean isBinary(String localEncoding, String hostEncoding, String remotePath) {
        boolean isText = !hostEncoding.equals(localEncoding) && SystemFileTransferModeRegistry.getDefault().isText(remotePath) && !SystemEncodingUtil.getInstance().isXML(remotePath);
        return !isText;
    }

    protected boolean isBinary(IRemoteFile source) {
        return source.isBinary() || SystemEncodingUtil.getInstance().isXML(source.getAbsolutePath());
    }

    public void upload(String source, String srcEncoding, String remotePath, String rmtEncoding, IProgressMonitor monitor) throws RemoteFileSecurityException, RemoteFileIOException {
        int slashIndex = remotePath.lastIndexOf(this.getSeparator());
        if (slashIndex > -1) {
            String remoteParentPath = remotePath.substring(0, slashIndex);
            String remoteFileName = remotePath.substring(slashIndex + 1, remotePath.length());
            boolean isBinary = this.isBinary(srcEncoding, rmtEncoding, remotePath);
            if (ArchiveHandlerManager.isVirtual((String)remotePath)) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(remotePath);
                remoteParentPath = avp.getPath();
                remoteFileName = avp.getName();
            }
            try {
                this.getFileService().upload(monitor, new File(source), remoteParentPath, remoteFileName, isBinary, srcEncoding, rmtEncoding);
            }
            catch (SystemMessageException e) {
                SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
                dlg.open();
            }
        }
    }

    public void upload(String source, IRemoteFile destination, String encoding, IProgressMonitor monitor) throws RemoteFileSecurityException, RemoteFileIOException {
        String remoteParentPath = destination.getParentPath();
        String remoteFileName = destination.getName();
        String hostEncoding = this.getRemoteEncoding();
        boolean isBinary = this.isBinary(encoding, hostEncoding, destination.getAbsolutePath());
        if (!destination.canWrite()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5003").makeSubstitution((Object)remoteFileName, (Object)this.getHostName());
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), msg);
            dlg.open();
            return;
        }
        try {
            this.getFileService().upload(monitor, new File(source), remoteParentPath, remoteFileName, isBinary, encoding, hostEncoding);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
        }
    }

    public void upload(InputStream stream, long totalBytes, IRemoteFile destination, String encoding, IProgressMonitor monitor) throws RemoteFileSecurityException, RemoteFileIOException {
        String remoteParentPath = destination.getParentPath();
        String remoteFileName = destination.getName();
        String hostEncoding = this.getRemoteEncoding();
        boolean isBinary = this.isBinary(encoding, hostEncoding, destination.getAbsolutePath());
        try {
            this.getFileService().upload(monitor, stream, remoteParentPath, remoteFileName, isBinary, hostEncoding);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
        }
    }

    public boolean copy(IRemoteFile sourceFolderOrFile, IRemoteFile targetFolder, String newName, IProgressMonitor monitor) throws RemoteFileSecurityException, RemoteFileIOException {
        IFileService service = this.getFileService();
        try {
            return service.copy(monitor, sourceFolderOrFile.getParentPath(), sourceFolderOrFile.getName(), targetFolder.getAbsolutePath(), newName);
        }
        catch (SystemMessageException e) {
            Display dis = Display.getDefault();
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dis.syncExec((Runnable)new SubSystem.SystemMessageDialogRunnable((SubSystem)this, dlg));
            return false;
        }
    }

    public boolean copyBatch(IRemoteFile[] sourceFolderOrFiles, IRemoteFile targetFolder, IProgressMonitor monitor) throws RemoteFileSecurityException, RemoteFileIOException {
        IFileService service = this.getFileService();
        String[] sourceParents = new String[sourceFolderOrFiles.length];
        String[] sourceNames = new String[sourceFolderOrFiles.length];
        int i = 0;
        while (i < sourceFolderOrFiles.length) {
            sourceParents[i] = sourceFolderOrFiles[i].getParentPath();
            sourceNames[i] = sourceFolderOrFiles[i].getName();
            ++i;
        }
        try {
            return service.copyBatch(monitor, sourceParents, sourceNames, targetFolder.getAbsolutePath());
        }
        catch (SystemMessageException e) {
            Display dis = Display.getDefault();
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dis.syncExec((Runnable)new SubSystem.SystemMessageDialogRunnable((SubSystem)this, dlg));
            return false;
        }
    }

    public IRemoteFile getParentFolder(IRemoteFile folderOrFile) {
        try {
            return this.getRemoteFileObject(folderOrFile.getParentPath());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IRemoteFile createFile(IRemoteFile fileToCreate) throws RemoteFileSecurityException, RemoteFileIOException {
        IFileService service = this.getFileService();
        String parent = fileToCreate.getParentPath();
        String name = fileToCreate.getName();
        IHostFile newFile = null;
        try {
            newFile = service.createFile(this.monitor, parent, name);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            SubSystem.SystemMessageDialogRunnable runnable = new SubSystem.SystemMessageDialogRunnable((SubSystem)this, dlg);
            Display.getDefault().asyncExec((Runnable)runnable);
            return null;
        }
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), fileToCreate.getParentRemoteFile(), newFile);
    }

    public IRemoteFile createFolder(IRemoteFile folderToCreate) throws RemoteFileSecurityException, RemoteFileIOException {
        IFileService service = this.getFileService();
        String parent = folderToCreate.getParentPath();
        String name = folderToCreate.getName();
        IHostFile newFolder = null;
        try {
            newFolder = service.createFolder(this.monitor, parent, name);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
            return null;
        }
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), folderToCreate.getParentRemoteFile(), newFolder);
    }

    public IRemoteFile createFolders(IRemoteFile folderToCreate) throws RemoteFileSecurityException, RemoteFileIOException {
        return this.createFolder(folderToCreate);
    }

    public boolean delete(IRemoteFile folderOrFile, IProgressMonitor monitor) throws RemoteFolderNotEmptyException, RemoteFileSecurityException, RemoteFileIOException {
        boolean result = false;
        IFileService service = this.getFileService();
        String parent = folderOrFile.getParentPath();
        String name = folderOrFile.getName();
        try {
            result = service.delete(monitor, parent, name);
            folderOrFile.markStale(true);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
            return false;
        }
        return result;
    }

    public boolean deleteBatch(IRemoteFile[] folderOrFiles, IProgressMonitor monitor) throws RemoteFolderNotEmptyException, RemoteFileSecurityException, RemoteFileIOException {
        boolean result = false;
        String[] parents = new String[folderOrFiles.length];
        String[] names = new String[folderOrFiles.length];
        int i = 0;
        while (i < folderOrFiles.length) {
            parents[i] = folderOrFiles[i].getParentPath();
            names[i] = folderOrFiles[i].getName();
            folderOrFiles[i].markStale(true);
            this.removeCachedRemoteFile(folderOrFiles[i]);
            ++i;
        }
        IFileService service = this.getFileService();
        try {
            result = service.deleteBatch(monitor, parents, names);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
            return false;
        }
        return result;
    }

    public boolean rename(IRemoteFile folderOrFile, String newName) throws RemoteFileSecurityException, RemoteFileIOException {
        boolean result = false;
        this.removeCachedRemoteFile(folderOrFile);
        IFileService service = this.getFileService();
        String srcParent = folderOrFile.getParentPath();
        String oldName = folderOrFile.getName();
        String newPath = String.valueOf(srcParent) + folderOrFile.getSeparator() + newName;
        try {
            result = service.rename(this.monitor, srcParent, oldName, newName);
            folderOrFile.getHostFile().renameTo(newPath);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
            return false;
        }
        return result;
    }

    public boolean move(IRemoteFile sourceFolderOrFile, IRemoteFile targetFolder, String newName, IProgressMonitor monitor) throws RemoteFileSecurityException, RemoteFileIOException {
        boolean result = false;
        IFileService service = this.getFileService();
        String srcParent = sourceFolderOrFile.getParentPath();
        String srcName = sourceFolderOrFile.getName();
        String tgtParent = targetFolder.getAbsolutePath();
        try {
            this.removeCachedRemoteFile(sourceFolderOrFile);
            result = service.move(monitor, srcParent, srcName, tgtParent, newName);
            sourceFolderOrFile.markStale(true);
            targetFolder.markStale(true);
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
            return false;
        }
        return result;
    }

    public boolean setLastModified(IRemoteFile folderOrFile, long newDate) throws RemoteFileSecurityException, RemoteFileIOException {
        return false;
    }

    public boolean setReadOnly(IRemoteFile folderOrFile) throws RemoteFileSecurityException, RemoteFileIOException {
        return false;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory() {
        if (this._languageUtilityFactory == null) {
            this._languageUtilityFactory = ((IFileServiceSubSystemConfiguration)this.getParentRemoteFileSubSystemConfiguration()).getLanguageUtilityFactory(this);
        }
        return this._languageUtilityFactory;
    }

    public void setLanguageUtilityFactory(ILanguageUtilityFactory factory) {
        this._languageUtilityFactory = factory;
    }

    public void search(IHostSearchResultConfiguration searchConfig) {
        ISearchService searchService = this.getSearchService();
        if (searchService != null) {
            SearchJob job = new SearchJob(searchConfig, searchService, this.getFileService());
            job.schedule();
        }
    }

    public void cancelSearch(IHostSearchResultConfiguration searchConfig) {
        ISearchService searchService = this.getSearchService();
        if (searchService != null) {
            searchService.cancelSearch(null, searchConfig);
        }
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        IFileServiceSubSystemConfiguration factory;
        ISearchService searchService = this.getSearchService();
        if (searchService != null && (factory = (IFileServiceSubSystemConfiguration)this.getParentRemoteFileSubSystemConfiguration()) != null) {
            return factory.createSearchConfiguration(this.getHost(), resultSet, searchTarget, searchString);
        }
        return null;
    }

    public void switchServiceFactory(IServiceSubSystemConfiguration fact) {
        if (fact != this.getSubSystemConfiguration() && fact instanceof IFileServiceSubSystemConfiguration) {
            IFileServiceSubSystemConfiguration factory = (IFileServiceSubSystemConfiguration)fact;
            try {
                this._cachedRemoteFiles.clear();
                this.disconnect();
            }
            catch (Exception exception) {}
            this._languageUtilityFactory = null;
            IHost host = this.getHost();
            this.setSubSystemConfiguration(factory);
            IConnectorService oldConnectorService = this.getConnectorService();
            oldConnectorService.deregisterSubSystem((ISubSystem)this);
            IConnectorService newConnectorService = factory.getConnectorService(host);
            this.setConnectorService(newConnectorService);
            oldConnectorService.commit();
            newConnectorService.commit();
            this.setName(factory.getName());
            this.setFileService(factory.getFileService(host));
            this.setHostFileToRemoteFileAdapter(factory.getHostFileAdapter());
            this.setSearchService(factory.getSearchService(host));
        }
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
        super.initializeSubSystem(monitor);
        this.getFileService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
        this.getFileService().uninitService(monitor);
        this._userHome = null;
    }
}

