/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.servicesubsystem;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.processes.IProcessService;
import org.eclipse.rse.subsystems.processes.core.subsystem.IHostProcessToRemoteProcessAdapter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessSubSystemImpl;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystem;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystemConfiguration;

public class ProcessServiceSubSystem
extends RemoteProcessSubSystemImpl
implements IProcessServiceSubSystem {
    protected IProcessService _hostProcessService;
    protected IHostProcessToRemoteProcessAdapter _hostProcessToRemoteProcessAdapter;
    static /* synthetic */ Class class$0;

    public ProcessServiceSubSystem(IHost host, IConnectorService connectorService, IProcessService hostProcessService, IHostProcessToRemoteProcessAdapter adapter) {
        super(host, connectorService);
        this._hostProcessService = hostProcessService;
        this._hostProcessToRemoteProcessAdapter = adapter;
    }

    public IProcessService getProcessService() {
        return this._hostProcessService;
    }

    public void setProcessService(IProcessService service) {
        this._hostProcessService = service;
    }

    public IHostProcessToRemoteProcessAdapter getHostProcessToRemoteProcessAdapter() {
        return this._hostProcessToRemoteProcessAdapter;
    }

    public void setHostProcessToRemoteProcessAdapter(IHostProcessToRemoteProcessAdapter hostProcessAdapter) {
        this._hostProcessToRemoteProcessAdapter = hostProcessAdapter;
    }

    public IRemoteProcess getRemoteProcessObject(long pid) throws SystemMessageException {
        this.checkIsConnected();
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid("" + pid);
        RemoteProcessContext context = new RemoteProcessContext(this, null, (IHostProcessFilter)rpfs);
        IHostProcess process = this.getProcessService().getProcess(null, pid);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcess(context, null, process);
    }

    public String[] getSignalTypes() throws SystemMessageException {
        return this.getProcessService().getSignalTypes();
    }

    public boolean kill(IRemoteProcess process, String signal) throws SystemMessageException {
        this.checkIsConnected();
        return this.getProcessService().kill(null, process.getPid(), signal);
    }

    public IRemoteProcess[] listAllProcesses(IHostProcessFilter processFilter, IRemoteProcessContext context, IProgressMonitor monitor) throws InterruptedException, SystemMessageException {
        this.checkIsConnected();
        IHostProcess[] processes = this.getProcessService().listAllProcesses(monitor, processFilter);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcesses(context, null, processes);
    }

    public IRemoteProcess[] listChildProcesses(IRemoteProcess parent, IHostProcessFilter processFilter, IRemoteProcessContext context, IProgressMonitor monitor) throws SystemMessageException {
        this.checkIsConnected();
        IHostProcess[] processes = this.getProcessService().listChildProcesses(monitor, parent.getPid(), processFilter);
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcesses(context, parent, processes);
    }

    public IRemoteProcess[] listChildProcesses(IRemoteProcess parent, IRemoteProcessContext context, IProgressMonitor monitor) throws SystemMessageException {
        this.checkIsConnected();
        IHostProcess[] processes = this.getProcessService().listChildProcesses(monitor, parent.getPid());
        return this.getHostProcessToRemoteProcessAdapter().convertToRemoteProcesses(context, parent, processes);
    }

    public void switchServiceFactory(IServiceSubSystemConfiguration fact) {
        if (fact != this.getSubSystemConfiguration() && fact instanceof IProcessServiceSubSystemConfiguration) {
            IProcessServiceSubSystemConfiguration factory = (IProcessServiceSubSystemConfiguration)fact;
            try {
                this.disconnect();
            }
            catch (Exception exception) {}
            IHost host = this.getHost();
            this.setSubSystemConfiguration(factory);
            this.setName(factory.getName());
            IConnectorService oldConnectorService = this.getConnectorService();
            oldConnectorService.deregisterSubSystem((ISubSystem)this);
            IConnectorService newConnectorService = factory.getConnectorService(host);
            this.setConnectorService(newConnectorService);
            oldConnectorService.commit();
            newConnectorService.commit();
            this.setProcessService(factory.getProcessService(host));
            this.setHostProcessToRemoteProcessAdapter(factory.getHostProcessAdapter());
        }
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.processes.IProcessService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
        super.initializeSubSystem(monitor);
        this.getProcessService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
        this.getProcessService().uninitService(monitor);
    }
}

