/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.model;

import java.util.Random;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;

public abstract class RemoteCommandShellOperation
implements ISystemResourceChangeListener {
    protected IRemoteCmdSubSystem _cmdSubSystem;
    protected IRemoteFile _pwd;
    protected Shell _shell;
    protected IRemoteCommandShell _remoteCmdShell;
    private Stack _commandStack;
    private int _outputOffset = 0;
    private String _cmdSeparator = ";";
    private Random _random = new Random(System.currentTimeMillis());

    public RemoteCommandShellOperation(Shell shell, IRemoteCmdSubSystem cmdSubSystem, IRemoteFile pwd) {
        this._pwd = pwd;
        this._cmdSubSystem = cmdSubSystem;
        this._shell = shell;
        this._commandStack = new Stack();
        this._cmdSeparator = this._cmdSubSystem.getParentRemoteCmdSubSystemConfiguration().getCommandSeparator();
    }

    public void setWorkingDirectory(IRemoteFile pwd) {
        this._pwd = pwd;
    }

    public IRemoteCommandShell run() {
        try {
            RSEUIPlugin.getTheSystemRegistry().addSystemResourceChangeListener((ISystemResourceChangeListener)this);
            this._remoteCmdShell = this._cmdSubSystem.runShell(this._pwd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._remoteCmdShell;
    }

    public IRemoteCommandShell getRemoteCommandShell() {
        return this._remoteCmdShell;
    }

    public void associateProject(IProject project) {
        if (this._remoteCmdShell != null) {
            this._remoteCmdShell.associateProject(project);
        }
    }

    public void finish() {
        RSEUIPlugin.getTheSystemRegistry().removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        if (this._remoteCmdShell != null && this._remoteCmdShell.isActive()) {
            try {
                this._cmdSubSystem.cancelShell(this._remoteCmdShell);
            }
            catch (Exception exception) {}
        }
    }

    private String getEchoCmd(CommandAlias alias) {
        return "echo " + this.getEchoResult(alias);
    }

    private String getEchoResult(CommandAlias alias) {
        return "BEGIN-END-TAG:" + alias.getAlias() + " done";
    }

    public String getCurrentCommand() {
        if (this._commandStack != null && this._commandStack.size() > 0) {
            CommandAlias firstCommand = (CommandAlias)this._commandStack.firstElement();
            return firstCommand.getCommand();
        }
        return null;
    }

    public void sendCommand(String cmd) {
        if (this._remoteCmdShell != null) {
            try {
                String newId = String.valueOf(this._random.nextInt());
                CommandAlias alias = new CommandAlias(newId, cmd);
                this._commandStack.push(alias);
                String echoCmd = this.getEchoCmd(alias);
                this._cmdSubSystem.sendCommandToShell(String.valueOf(cmd) + this._cmdSeparator + echoCmd, this._remoteCmdShell);
            }
            catch (Exception exception) {}
        }
    }

    public void sendInput(String input) {
        if (this._remoteCmdShell != null) {
            try {
                this._cmdSubSystem.sendCommandToShell(input, this._remoteCmdShell);
            }
            catch (Exception exception) {}
        }
    }

    public Shell getShell() {
        if (this._shell.isDisposed()) {
            this._shell = SystemBasePlugin.getActiveWorkbenchShell();
        }
        return this._shell;
    }

    public boolean isActive() {
        if (this._remoteCmdShell != null) {
            return this._remoteCmdShell.isActive() && this._cmdSubSystem.isConnected();
        }
        return false;
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object parent;
        if (event.getType() == 140) {
            Object source = event.getSource();
            if (source == this._cmdSubSystem) {
                this.handleShellFinished();
            } else if (source == this._remoteCmdShell) {
                this.handleShellFinished();
            }
        } else if (event.getType() == 82 && (parent = event.getParent()) == this._remoteCmdShell) {
            this.outputUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void outputUpdated() {
        Stack stack = this._commandStack;
        synchronized (stack) {
            Object[] outputs;
            if (this._commandStack.empty()) return;
            Object[] objectArray = outputs = this._remoteCmdShell.listOutput();
            synchronized (outputs) {
                int i = this._outputOffset;
                while (i < outputs.length && !this._commandStack.empty()) {
                    IRemoteOutput rmtOutput;
                    String text;
                    boolean handledOutput = false;
                    CommandAlias firstCommand = (CommandAlias)this._commandStack.firstElement();
                    Object output = outputs[this._outputOffset];
                    if (output instanceof IRemoteOutput && this.commandMatches(text = (rmtOutput = (IRemoteOutput)output).getText(), firstCommand)) {
                        this._commandStack.remove(0);
                        this.handleCommandFinished(firstCommand.getCommand());
                        handledOutput = true;
                    }
                    if (!handledOutput) {
                        this.handleOutputChanged(firstCommand.getCommand(), output);
                    }
                    ++this._outputOffset;
                    ++i;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    protected boolean commandMatches(String outputEcho, CommandAlias firstCommand) {
        String expected = this.getEchoResult(firstCommand);
        if (outputEcho.equals(expected)) {
            return true;
        }
        int index = outputEcho.indexOf(expected);
        return index > 0 && outputEcho.charAt(index - 1) != ';' && outputEcho.indexOf("echo") == -1;
    }

    public void handleShellFinished() {
        this.finish();
    }

    public abstract void handleCommandFinished(String var1);

    public abstract void handleOutputChanged(String var1, Object var2);

    protected class CommandAlias {
        private String _alias;
        private String _command;

        public CommandAlias(String alias, String command) {
            this._alias = alias;
            this._command = command;
        }

        public String getAlias() {
            return this._alias;
        }

        public String getCommand() {
            return this._command;
        }
    }
}

