/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.rse.core.ISystemUserIdConstants;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.RemoteServerLauncher;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.ISignonValidator;
import org.eclipse.rse.ui.dialogs.ISystemPasswordPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemChangePasswordDialog;
import org.eclipse.rse.ui.dialogs.SystemPasswordPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractConnectorService
extends RSEModelObject
implements IConnectorService,
ISystemUserIdConstants {
    private ISubSystem _primarySubSystem;
    private List _registeredSubSystems;
    private String _name;
    private String _description;
    private int _port;
    private String _userId;
    private boolean _usingSSL;
    private IHost _host;
    protected IServerLauncherProperties _remoteServerLauncherProperties = null;
    private transient SystemSignonInformation _passwordInfo;
    protected Shell shell;
    private Vector commListeners = new Vector(5);
    private IServerLauncher starter;
    protected Object launchResult;
    protected Object connectResult;
    private boolean _suppressSignonPrompt = false;
    static /* synthetic */ Class class$0;

    public AbstractConnectorService(String name, String description, IHost host, int port) {
        this._name = name;
        this._description = description;
        this._port = port;
        this._host = host;
        this._registeredSubSystems = new ArrayList();
    }

    public String getVersionReleaseModification() {
        return "";
    }

    public String getHomeDirectory() {
        return "";
    }

    public String getTempDirectory() {
        return "";
    }

    public void registerSubSystem(ISubSystem ss) {
        if (!this._registeredSubSystems.contains(ss)) {
            this._registeredSubSystems.add(ss);
        }
    }

    public void deregisterSubSystem(ISubSystem ss) {
        this._registeredSubSystems.remove(ss);
    }

    public final ISubSystem[] getSubSystems() {
        return this._registeredSubSystems.toArray(new ISubSystem[this._registeredSubSystems.size()]);
    }

    public final ISubSystem getPrimarySubSystem() {
        if (this._primarySubSystem == null && this._registeredSubSystems.size() != 0) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(0);
            this._primarySubSystem = ss.getPrimarySubSystem();
        }
        return this._primarySubSystem;
    }

    public final IHost getHost() {
        return this._host;
    }

    public final String getHostType() {
        return this.getHost().getSystemType();
    }

    public final String getName() {
        return this._name;
    }

    public final String getDescription() {
        return this._description;
    }

    public final String getHostName() {
        return this.getHost().getHostName();
    }

    public final String getUserId() {
        String result = null;
        if (this.supportsUserId() && (result = this.getLocalUserId()) == null) {
            result = this.getSubSystemUserId();
        }
        return result;
    }

    protected final String getLocalUserId() {
        return this._userId;
    }

    private String getSubSystemUserId() {
        ISubSystem ss = this.getPrimarySubSystem();
        String result = ss.getUserId();
        return result;
    }

    public final void setUserId(String newId) {
        if (this._userId == null || !this._userId.equals(newId)) {
            this._userId = newId;
            this.setDirty(true);
        }
    }

    public final void setHost(IHost host) {
        this._host = host;
    }

    public final void clearUserIdCache() {
        this._userId = null;
        this.clearPasswordCache();
    }

    public final void clearPasswordCache() {
        this.clearPasswordCache(false);
    }

    public final void clearPasswordCache(boolean onDisk) {
        this.setPasswordInformation(null);
        String userId = this.getUserId();
        if (onDisk) {
            String systemType = this.getHostType();
            String hostName = this.getHostName();
            if (userId != null) {
                PasswordPersistenceManager.getInstance().remove(systemType, hostName, userId);
            }
        }
        if (this.shareUserPasswordWithConnection()) {
            this.clearPasswordForOtherSystemsInConnection(userId, onDisk);
        }
    }

    public final boolean isPasswordCached(boolean onDisk) {
        boolean cached;
        boolean bl = cached = this.getPasswordInformation() != null;
        if (!cached && onDisk) {
            String systemType = this.getHostType();
            String hostName = this.getHostName();
            String userId = this.getUserId();
            if (userId != null) {
                return PasswordPersistenceManager.getInstance().passwordExists(systemType, hostName, this.getUserId());
            }
        }
        return cached;
    }

    public final boolean isPasswordCached() {
        return this.isPasswordCached(false);
    }

    public final boolean inheritConnectionUserPassword() {
        return true;
    }

    public boolean requiresPassword() {
        return true;
    }

    public boolean supportsPassword() {
        return true;
    }

    public boolean requiresUserId() {
        return true;
    }

    public boolean supportsUserId() {
        return true;
    }

    public boolean supportsRemoteServerLaunching() {
        return false;
    }

    public boolean hasRemoteServerLauncherProperties() {
        return false;
    }

    public boolean supportsServerLaunchProperties() {
        return false;
    }

    public boolean shareUserPasswordWithConnection() {
        return true;
    }

    public void promptForPassword(boolean forcePrompt) throws InterruptedException {
        ISignonValidator validator;
        boolean signonValid;
        String userId;
        PasswordPersistenceManager ppm;
        SystemSignonInformation savedPasswordInformation;
        if (this.isSuppressSignonPrompt()) {
            throw new InterruptedException();
        }
        ISubSystem subsystem = this.getPrimarySubSystem();
        IHost host = subsystem.getHost();
        String hostName = host.getHostName();
        String hostType = host.getSystemType();
        boolean savePassword = false;
        if (this._passwordInfo == null) {
            this._passwordInfo = new SystemSignonInformation(hostName, null, null, hostType);
        }
        if (this.supportsUserId()) {
            String userId2 = this.getUserId();
            if (this._passwordInfo.getUserid() == null) {
                this._passwordInfo.setUserid(userId2);
            }
            boolean sameUserId = host.compareUserIds(userId2, this._passwordInfo.getUserid());
            boolean sameHost = hostName.equalsIgnoreCase(this._passwordInfo.getHostname());
            if (!sameHost || !sameUserId) {
                this._passwordInfo.setPassword(null);
                this._passwordInfo.setUserid(userId2);
            }
        }
        if (this.supportsPassword() && this._passwordInfo.getPassword() == null && (savedPasswordInformation = (ppm = PasswordPersistenceManager.getInstance()).find(hostType, hostName, userId = this._passwordInfo.getUserid())) != null) {
            this._passwordInfo = savedPasswordInformation;
            savePassword = true;
        }
        boolean bl = signonValid = (validator = this.getSignonValidator()) == null || validator.isValid(this.shell, this._passwordInfo);
        if (!signonValid) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC1004");
            msg.makeSubstitution((Object)this.getLocalUserId(), (Object)this.getHostName());
            SystemMessageDialog dialog = new SystemMessageDialog(this.shell, msg);
            dialog.open();
        }
        if (this.shell == null) {
            this.shell = SystemBasePlugin.getActiveWorkbenchShell();
        }
        if (this.supportsPassword() || this.supportsUserId()) {
            if (this.shell == null) {
                this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
            if (this.shell != null) {
                ISystemPasswordPromptDialog dialog;
                boolean userIdNeeded;
                boolean passwordNeeded = this.supportsPassword() && this._passwordInfo.getPassword() == null;
                boolean bl2 = userIdNeeded = this.supportsUserId() && this._passwordInfo.getUserid() == null;
                if ((passwordNeeded || userIdNeeded || forcePrompt) && (dialog = this.getPasswordPromptDialog(this.shell)) != null) {
                    dialog.setSystemInput(this);
                    dialog.setSignonValidator(this.getSignonValidator());
                    if (this.supportsUserId()) {
                        dialog.setUserIdValidator(this.getUserIdValidator());
                    }
                    if (this.supportsPassword()) {
                        String password = this._passwordInfo.getPassword();
                        dialog.setSavePassword(savePassword);
                        dialog.setPassword(password);
                        dialog.setPasswordValidator(this.getPasswordValidator());
                    }
                    try {
                        dialog.open();
                    }
                    catch (Exception e) {
                        this.logException(e);
                    }
                    if (dialog.wasCancelled()) {
                        this._passwordInfo = null;
                        throw new InterruptedException();
                    }
                    String userId3 = dialog.getUserId();
                    boolean userIdChanged = dialog.getIsUserIdChanged();
                    boolean saveUserId = dialog.getIsUserIdChangePermanent();
                    String password = dialog.getPassword();
                    savePassword = dialog.getIsSavePassword();
                    if (this.supportsUserId() && userIdChanged) {
                        if (saveUserId) {
                            this.updateDefaultUserId(subsystem, userId3);
                        } else {
                            this.setUserId(userId3);
                            this._passwordInfo.setUserid(userId3);
                        }
                    }
                    if (this.supportsPassword()) {
                        this.setPassword(userId3, password, savePassword);
                        if (this.shareUserPasswordWithConnection()) {
                            this.updatePasswordForOtherSystemsInConnection(userId3, password, savePassword);
                        }
                    }
                }
            }
        }
    }

    protected void clearPasswordForOtherSystemsInConnection(String uid, boolean fromDisk) {
        if (uid != null) {
            IConnectorService system;
            IHost connection = this.getHost();
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            ISubSystem[] subsystems = registry.getSubSystems(connection);
            ArrayList<IConnectorService> uniqueSystems = new ArrayList<IConnectorService>();
            int i = 0;
            while (i < subsystems.length) {
                system = subsystems[i].getConnectorService();
                if (system != this && system.inheritConnectionUserPassword() && !uniqueSystems.contains(system)) {
                    uniqueSystems.add(system);
                }
                ++i;
            }
            int s = 0;
            while (s < uniqueSystems.size()) {
                system = (IConnectorService)uniqueSystems.get(s);
                if (system.isPasswordCached(fromDisk)) {
                    system.clearPasswordCache(fromDisk);
                }
                ++s;
            }
        }
    }

    protected void updatePasswordForOtherSystemsInConnection(String uid, String password, boolean persistPassword) {
        IConnectorService system;
        IHost connection = this.getPrimarySubSystem().getHost();
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] subsystems = registry.getSubSystems(connection);
        ArrayList<IConnectorService> uniqueSystems = new ArrayList<IConnectorService>();
        int i = 0;
        while (i < subsystems.length) {
            system = subsystems[i].getConnectorService();
            if (system != this && system.inheritConnectionUserPassword() && !uniqueSystems.contains(system)) {
                uniqueSystems.add(system);
            }
            ++i;
        }
        int s = 0;
        while (s < uniqueSystems.size()) {
            system = (IConnectorService)uniqueSystems.get(s);
            if (!system.isConnected() && !system.isPasswordCached()) {
                if (system.getPrimarySubSystem().forceUserIdToUpperCase()) {
                    system.setPassword(uid.toUpperCase(), password.toUpperCase(), persistPassword);
                } else {
                    system.setPassword(uid, password, persistPassword);
                }
            }
            ++s;
        }
    }

    private void updateDefaultUserId(ISubSystem subsystem, String userId) {
        String ssLocalUserId = subsystem.getLocalUserId();
        if (ssLocalUserId != null) {
            ISubSystemConfiguration ssc = subsystem.getSubSystemConfiguration();
            ssc.updateSubSystem(subsystem, true, userId, false, 0);
        } else {
            int whereToUpdate = 2;
            IHost conn = subsystem.getHost();
            SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            sr.updateHost(null, conn, conn.getSystemType(), conn.getAliasName(), conn.getHostName(), conn.getDescription(), userId, whereToUpdate);
        }
    }

    protected final ISystemPasswordPromptDialog getPasswordPromptDialog(Shell shell) {
        SystemPasswordPromptDialog dlg = new SystemPasswordPromptDialog(shell);
        dlg.setForceToUpperCase(this.forcePasswordToUpperCase());
        dlg.setUserIdValidator(this.getUserIdValidator());
        dlg.setPasswordValidator(this.getPasswordValidator());
        dlg.setSignonValidator(this.getSignonValidator());
        return dlg;
    }

    protected SystemSignonInformation getPasswordInformation() {
        return this._passwordInfo;
    }

    protected void setPasswordInformation(SystemSignonInformation passwordInfo) {
        this._passwordInfo = passwordInfo;
        if (passwordInfo != null) {
            this._userId = passwordInfo.getUserid();
        }
    }

    public void setPassword(String matchingUserId, String password, boolean persist) {
        if (this.getPrimarySubSystem().forceUserIdToUpperCase()) {
            matchingUserId = matchingUserId.toUpperCase();
        }
        SystemSignonInformation tempPasswordInfo = new SystemSignonInformation(this.getHostName(), matchingUserId, password, this.getHostType());
        this.setPasswordInformation(tempPasswordInfo);
        if (persist) {
            PasswordPersistenceManager.getInstance().add(tempPasswordInfo, true, true);
        } else {
            String systemType = this.getHostType();
            String hostName = this.getHostName();
            PasswordPersistenceManager.getInstance().remove(systemType, hostName, this._userId);
        }
    }

    public void setPassword(String matchingUserId, String password) {
        this.setPassword(matchingUserId, password, false);
    }

    protected boolean forcePasswordToUpperCase() {
        return this.getPrimarySubSystem().forceUserIdToUpperCase();
    }

    public ISystemValidator getUserIdValidator() {
        ISubSystemConfiguration ssFactory = this.getPrimarySubSystem().getSubSystemConfiguration();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz);
        return adapter.getUserIdValidator(ssFactory);
    }

    public ISystemValidator getPasswordValidator() {
        ISubSystemConfiguration ssFactory = this.getPrimarySubSystem().getSubSystemConfiguration();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz);
        return adapter.getPasswordValidator(ssFactory);
    }

    public ISignonValidator getSignonValidator() {
        return null;
    }

    public final void connect(IProgressMonitor monitor) throws Exception {
        this.internalConnect(monitor);
        this.intializeSubSystems(monitor);
    }

    protected void intializeSubSystems(IProgressMonitor monitor) {
        int i = 0;
        while (i < this._registeredSubSystems.size()) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(i);
            ss.initializeSubSystem(monitor);
            ++i;
        }
    }

    protected void unintializeSubSystems(IProgressMonitor monitor) {
        int i = 0;
        while (i < this._registeredSubSystems.size()) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(i);
            ss.uninitializeSubSystem(monitor);
            ++i;
        }
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        if (this.supportsServerLaunchProperties()) {
            this.starter = this.getRemoteServerLauncher();
            this.starter.setSignonInformation(this.getPasswordInformation());
            this.starter.setServerLauncherProperties(this.getRemoteServerLauncherProperties());
            this.launchResult = null;
            if (!this.starter.isLaunched()) {
                try {
                    this.launchResult = this.starter.launch(monitor);
                }
                catch (Exception exc) {
                    throw new InvocationTargetException(exc);
                }
            }
            this.connectResult = null;
            try {
                this.connectResult = this.starter.connect(monitor, this.getConnectPort());
            }
            catch (Exception exc) {
                throw new InvocationTargetException(exc);
            }
        }
    }

    protected int getConnectPort() {
        return this.getPort();
    }

    public final void disconnect(IProgressMonitor monitor) throws Exception {
        this.internalDisconnect(monitor);
        this.unintializeSubSystems(monitor);
        this.clearPasswordCache();
    }

    public void internalDisconnect(IProgressMonitor monitor) throws Exception {
        if (this.supportsServerLaunchProperties() && this.starter != null) {
            try {
                this.starter.disconnect();
                this.starter = null;
            }
            catch (Exception exc) {
                throw new InvocationTargetException(exc);
            }
        }
    }

    public IServerLauncher getRemoteServerLauncher() {
        return null;
    }

    public void reset() {
    }

    public void addCommunicationsListener(ICommunicationsListener listener) {
        if (!this.commListeners.contains(listener)) {
            this.commListeners.add(listener);
        }
    }

    public void removeCommunicationsListener(ICommunicationsListener listener) {
        this.commListeners.remove(listener);
    }

    protected void fireCommunicationsEvent(int eventType) {
        CommunicationsEvent e = new CommunicationsEvent((IConnectorService)this, eventType);
        Object[] items = this.commListeners.toArray();
        int loop = 0;
        while (loop < items.length) {
            ((ICommunicationsListener)items[loop]).communicationsStateChange(e);
            ++loop;
        }
    }

    protected int getCommunicationListenerCount() {
        int count = 0;
        int i = 0;
        while (i < this.commListeners.size()) {
            if (!((ICommunicationsListener)this.commListeners.get(i)).isPassiveCommunicationsListener()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected void clearCommunicationListeners() {
        this.commListeners.clear();
    }

    public boolean isSuppressSignonPrompt() {
        return this._suppressSignonPrompt;
    }

    public void setSuppressSignonPrompt(boolean suppressSignonPrompt) {
        this._suppressSignonPrompt = suppressSignonPrompt;
    }

    protected boolean isEnabledServerLaunchType(ISubSystem subsystem, ServerLaunchType serverLaunchType) {
        IServerLauncherProperties sl = this.getRemoteServerLauncherProperties();
        if (sl instanceof RemoteServerLauncher) {
            RemoteServerLauncher isl = (RemoteServerLauncher)sl;
            return isl.isEnabledServerLaunchType(serverLaunchType);
        }
        return subsystem.getSubSystemConfiguration().supportsServerLaunchType(serverLaunchType);
    }

    public void notifyDisconnection() {
        if (!this.isConnected()) {
            this.fireCommunicationsEvent(4);
        }
    }

    public void notifyConnection() {
        if (this.isConnected()) {
            this.fireCommunicationsEvent(2);
        }
    }

    public void notifyError() {
        this.fireCommunicationsEvent(5);
    }

    public void setPort(int port) {
        if (port != this._port) {
            this._port = port;
            this.setDirty(true);
        }
    }

    public int getPort() {
        return this._port;
    }

    public boolean isUsingSSL() {
        return this._usingSSL;
    }

    public void setIsUsingSSL(boolean flag) {
        if (this._usingSSL != flag) {
            this._usingSSL = flag;
            this.setDirty(true);
        }
    }

    public IServerLauncherProperties getRemoteServerLauncherProperties() {
        return this._remoteServerLauncherProperties;
    }

    public void setRemoteServerLauncherProperties(IServerLauncherProperties newRemoteServerLauncher) {
        if (this._remoteServerLauncherProperties != newRemoteServerLauncher) {
            this._remoteServerLauncherProperties = newRemoteServerLauncher;
            this.setDirty(true);
        }
    }

    public boolean hasRemoteSearchLauncherProperties() {
        return this._remoteServerLauncherProperties != null;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit(this.getHost());
    }

    private void logException(Throwable t) {
        Logger log = LoggerFactory.getLogger((Plugin)RSEUIPlugin.getDefault());
        log.logError("Unexpected exception", t);
    }

    protected NewPasswordInfo promptForNewPassword(SystemMessage prompt) throws InterruptedException {
        ShowPromptForNewPassword msgAction = new ShowPromptForNewPassword(prompt);
        Display.getDefault().syncExec((Runnable)msgAction);
        if (msgAction.isCancelled()) {
            throw new InterruptedException();
        }
        return new NewPasswordInfo(msgAction.getNewPassword(), msgAction.isSavePassword());
    }

    protected class NewPasswordInfo {
        public String newPassword;
        public boolean savePassword;

        public NewPasswordInfo(String newPW, boolean savePW) {
            this.newPassword = newPW;
            this.savePassword = savePW;
        }
    }

    private class ShowPromptForNewPassword
    implements Runnable {
        private SystemMessage _msg;
        private String newPassword;
        private boolean savePassword;
        private boolean cancelled = false;

        public ShowPromptForNewPassword(SystemMessage msg) {
            this._msg = msg;
        }

        public void run() {
            SystemChangePasswordDialog dlg = new SystemChangePasswordDialog(SystemBasePlugin.getActiveWorkbenchShell(), AbstractConnectorService.this.getHostName(), AbstractConnectorService.this.getUserId(), this._msg);
            if (AbstractConnectorService.this.getLocalUserId() != null) {
                dlg.setSavePassword(PasswordPersistenceManager.getInstance().passwordExists(AbstractConnectorService.this.getHostType(), AbstractConnectorService.this.getHostName(), AbstractConnectorService.this.getLocalUserId()));
            }
            dlg.open();
            if (dlg.wasCancelled()) {
                this.cancelled = true;
                return;
            }
            this.newPassword = dlg.getNewPassword();
            this.savePassword = dlg.getIsSavePassword();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public boolean isSavePassword() {
            return this.savePassword;
        }
    }
}

