/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.filters.IRSEFilterNamingPolicy;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.filters.SystemFilterPoolManager;
import org.eclipse.rse.core.internal.subsystems.SubSystemConfigurationProxy;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemNewConnectionWizardPage;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.RemoteServerLauncher;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.core.subsystems.SubSystemFilterNamingPolicy;
import org.eclipse.rse.filters.SystemFilterPoolWrapperInformation;
import org.eclipse.rse.filters.SystemFilterStartHere;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.model.SystemStartHere;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.filters.actions.SystemNewFilterAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.propertypages.ISystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.propertypages.SystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorSpecialChar;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.widgets.IServerLauncherForm;
import org.eclipse.rse.ui.widgets.RemoteServerLauncherForm;
import org.eclipse.rse.ui.wizards.ISubSystemPropertiesWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class SubSystemConfiguration
implements ISubSystemConfiguration {
    private Hashtable subSystemsRestoredFlags = new Hashtable();
    private ISubSystemConfigurationProxy proxy = null;
    private ISubSystem[] subsystems = null;
    private Hashtable subsystemsByConnection = new Hashtable();
    private boolean allSubSystemsRestored = false;
    private static final ISubSystem[] EMPTY_SUBSYSTEM_ARRAY = new ISubSystem[0];
    protected SubSystemFilterNamingPolicy filterNamingPolicy = new SubSystemFilterNamingPolicy();
    protected ISystemFilterPoolManager[] filterPoolManagers = null;
    protected Hashtable filterPoolManagersPerProfile = new Hashtable();
    private String translatedFilterType = null;
    private static Hashtable brokenReferenceWarningsIssued = new Hashtable();
    protected Hashtable imageTable = null;
    protected IHost currentlySelectedConnection;
    protected Object[] currentlySelected;
    protected static IHost currentlyProcessingConnection;
    protected static SubSystemConfiguration currentlyProcessingSubSystemConfiguration;
    protected List subSystemList = null;
    protected List filterPoolManagerList = null;
    protected boolean _isDirty;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SubSystemConfiguration() {
        SystemBasePlugin.logDebugMessage(this.getClass().getName(), "STARTED SSFACTORY");
    }

    public void reset() {
        this.subSystemsRestoredFlags = new Hashtable();
        this.subsystems = null;
        this.subsystemsByConnection = new Hashtable();
        this.allSubSystemsRestored = false;
        this.filterPoolManagersPerProfile = new Hashtable();
        this.filterPoolManagers = null;
        brokenReferenceWarningsIssued = new Hashtable();
    }

    public boolean supportsSubSystemConnect() {
        return true;
    }

    public boolean isPortEditable() {
        return true;
    }

    public boolean supportsCommands() {
        return false;
    }

    public boolean supportsProperties() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public boolean supportsFilterChildren() {
        return true;
    }

    public boolean supportsFilterCaching() {
        return true;
    }

    public boolean supportsMultipleFilterStrings() {
        return true;
    }

    public boolean supportsNestedFilters() {
        return this.supportsFilters();
    }

    public boolean supportsQuickFilters() {
        return this.supportsFilters();
    }

    public boolean supportsDropInFilters() {
        return false;
    }

    public boolean providesCustomDropInFilters() {
        return false;
    }

    public boolean supportsUserDefinedActions() {
        return false;
    }

    public boolean supportsUserDefinedActions(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return this.supportsUserDefinedActions();
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Iterator iter = sel.iterator();
            boolean supportsUserDefinedActions = true;
            while (iter.hasNext()) {
                ISystemRemoteElementAdapter adapter;
                Object obj = iter.next();
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (supportsUserDefinedActions = (adapter = (ISystemRemoteElementAdapter)iAdapterManager.getAdapter(obj, (Class)clazz)) != null ? adapter.supportsUserDefinedActions(obj) : this.supportsUserDefinedActions()) continue;
                return false;
            }
            return this.supportsUserDefinedActions();
        }
        return this.supportsUserDefinedActions();
    }

    public boolean supportsCompileActions() {
        return false;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsMultiStringFilters() {
        return true;
    }

    public boolean supportsFilterStringExport() {
        return true;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean supportsDuplicateFilterStrings() {
        return false;
    }

    public boolean supportsTargets() {
        return false;
    }

    public boolean supportsServerLaunchProperties(IHost host) {
        return false;
    }

    public boolean supportsServerLaunchType(ServerLaunchType serverLaunchType) {
        return true;
    }

    public boolean isFactoryFor(Class subSystemType) {
        return false;
    }

    public ISystemSubSystemPropertyPageCoreForm getSubSystemPropertyPageCoreFrom(ISystemMessageLine msgLine, Object caller) {
        return new SystemSubSystemPropertyPageCoreForm(msgLine, caller);
    }

    protected List getSubSystemPropertyPages() {
        ArrayList<PropertyPage> propertyPages = new ArrayList<PropertyPage>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] propertyPageExtensions = registry.getConfigurationElementsFor("org.eclipse.ui", "propertyPages");
        int i = 0;
        while (i < propertyPageExtensions.length) {
            IConfigurationElement configurationElement = propertyPageExtensions[i];
            String objectClass = configurationElement.getAttribute("objectClass");
            String name = configurationElement.getAttribute("name");
            Class<?> objCls = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                objCls = Class.forName(objectClass, false, loader);
            }
            catch (Exception exception) {}
            if (objCls != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.core.subsystems.ISubSystem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(objCls) && this.isFactoryFor(objCls)) {
                    try {
                        PropertyPage page = (PropertyPage)configurationElement.createExecutableExtension("class");
                        page.setTitle(name);
                        propertyPages.add(page);
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
        return propertyPages;
    }

    public boolean showFilterPools() {
        return SystemPreferencesManager.getPreferencesManager().getShowFilterPools();
    }

    public void setShowFilterPools(boolean show) {
        ISubSystem[] subsystems = this.getSubSystems(false);
        int idx = 0;
        while (idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            RSEUIPlugin.getTheSystemRegistry().fireEvent(new SystemResourceChangeEvent(ss, 95, (Object)ss));
            ++idx;
        }
    }

    public void setSubSystemConfigurationProxy(ISubSystemConfigurationProxy proxy) {
        this.proxy = proxy;
    }

    public ISubSystemConfigurationProxy getSubSystemConfigurationProxy() {
        return this.proxy;
    }

    public String getVendor() {
        return this.proxy.getVendor();
    }

    public String getName() {
        return this.proxy.getName();
    }

    public String getDescription() {
        return this.proxy.getDescription();
    }

    public String getId() {
        return this.proxy.getId();
    }

    public ImageDescriptor getImage() {
        return ((SubSystemConfigurationProxy)this.proxy).getImage();
    }

    public Image getGraphicsImage() {
        ImageDescriptor id = this.getImage();
        if (id != null) {
            Image image = null;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable();
            } else {
                image = (Image)this.imageTable.get(id);
            }
            if (image == null) {
                image = id.createImage();
                this.imageTable.put(id, image);
            }
            return image;
        }
        return null;
    }

    public ImageDescriptor getLiveImage() {
        return ((SubSystemConfigurationProxy)this.proxy).getLiveImage();
    }

    public Image getGraphicsLiveImage() {
        ImageDescriptor id = this.getLiveImage();
        if (id != null) {
            Image image = null;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable();
            } else {
                image = (Image)this.imageTable.get(id);
            }
            if (image == null) {
                image = id.createImage();
                this.imageTable.put(id, image);
            }
            return image;
        }
        return null;
    }

    public String getCategory() {
        return this.proxy.getCategory();
    }

    public String[] getSystemTypes() {
        return this.proxy.getSystemTypes();
    }

    public ISystemProfile getSystemProfile(String name) {
        return SystemProfileManager.getSystemProfileManager().getSystemProfile(name);
    }

    protected ISystemProfile getSystemProfile(ISystemFilterPoolManager poolMgr) {
        return this.getSystemProfile(this.getSystemProfileName(poolMgr));
    }

    public ISystemProfile getSystemProfile(ISystemFilterPool pool) {
        return this.getSystemProfile(pool.getSystemFilterPoolManager());
    }

    protected ISystemProfile getSystemProfile(ISystemFilter filter) {
        return this.getSystemProfile(filter.getParentFilterPool());
    }

    public void deletingSystemProfile(ISystemProfile profile) {
        this.deleteFilterPoolManager(profile);
    }

    public void changingSystemProfileActiveStatus(ISystemProfile profile, boolean newStatus) {
        if (newStatus) {
            this.allSubSystemsRestored = false;
        }
    }

    public ISystemValidator getUserIdValidator() {
        ValidatorSpecialChar userIdValidator = new ValidatorSpecialChar("=;", false, RSEUIPlugin.getPluginMessage("RSEG1026"), RSEUIPlugin.getPluginMessage("RSEG1025"));
        return userIdValidator;
    }

    public void renameSubSystemProfile(ISubSystem ss, String oldProfileName, String newProfileName) {
        ss.renamingProfile(oldProfileName, newProfileName);
        ISystemFilterPoolReferenceManager sfprm = ss.getSystemFilterPoolReferenceManager();
        if (sfprm != null) {
            sfprm.regenerateReferencedSystemFilterPoolNames();
        }
        try {
            this.saveSubSystem(ss);
        }
        catch (Exception exception) {}
    }

    public void preTestRenameSubSystemProfile(String oldProfileName) throws Exception {
        ISystemFilterPool defaultPoolForThisProfile;
        ISystemProfile profile = this.getSystemProfile(oldProfileName);
        if (profile.isDefaultPrivate() && (defaultPoolForThisProfile = this.getDefaultFilterPool(profile, oldProfileName)) != null) {
            this.getFilterPoolManager(profile).preTestRenameFilterPool(defaultPoolForThisProfile);
        }
    }

    public ISystemFilterPool getDefaultFilterPool(ISystemProfile profile, String oldProfileName) {
        ISystemFilterPool pool = null;
        ISystemFilterPoolManager mgr = this.getFilterPoolManager(profile);
        ISystemFilterPool[] pools = mgr.getSystemFilterPools();
        if (pools != null) {
            int idx = 0;
            while (pool == null && idx < pools.length) {
                if (pools[idx].isDefault() && pools[idx].getName().equals(SubSystemConfiguration.getDefaultFilterPoolName(oldProfileName, this.getId()))) {
                    pool = pools[idx];
                }
                ++idx;
            }
            if (pool == null) {
                pool = mgr.getFirstDefaultSystemFilterPool();
            }
        }
        return pool;
    }

    public void renameSubSystemsByConnection(IHost conn, String newConnectionName) {
        ISubSystem[] subsystems = this.getSubSystems(conn, true);
        int idx = 0;
        while (idx < subsystems.length) {
            subsystems[idx].renamingConnection(newConnectionName);
            ++idx;
        }
        try {
            this.saveSubSystems(conn);
        }
        catch (Exception exception) {}
    }

    public void deleteSubSystemsByConnection(IHost conn) {
        ISubSystem[] subsystems = conn.getSubSystems();
        int idx = 0;
        while (idx < subsystems.length) {
            if (subsystems[idx].isConnected()) {
                try {
                    subsystems[idx].disconnect();
                }
                catch (Exception exception) {}
            }
            subsystems[idx].deletingConnection();
            this.deleteSubSystem(subsystems[idx]);
            ++idx;
        }
        this.invalidateSubSystemCache(conn);
        try {
            this.saveSubSystems(conn);
        }
        catch (Exception exception) {}
    }

    protected void invalidateSubSystemCache(IHost conn) {
        this.subsystems = null;
        if (conn != null) {
            this.subsystemsByConnection.remove(conn);
        }
    }

    public ISubSystem[] getSubSystems(boolean force) {
        if (force && !this.allSubSystemsRestored) {
            IHost[] allActiveConnections = RSEUIPlugin.getTheSystemRegistry().getHosts();
            if (allActiveConnections != null) {
                int idx = 0;
                while (idx < allActiveConnections.length) {
                    if (this.proxy.appliesToSystemType(allActiveConnections[idx].getSystemType())) {
                        this.getSubSystems(allActiveConnections[idx], force);
                    }
                    ++idx;
                }
            }
            this.allSubSystemsRestored = true;
            this.subsystems = null;
        }
        if (this.subsystems == null || this.subsystems.length != this.getSubSystemList().size()) {
            List alist = null;
            if (SystemProfileManager.getSystemProfileManager().getSystemProfileNamesVector().size() > 0) {
                alist = this.getSubSystemList();
            }
            if (alist == null) {
                return new ISubSystem[0];
            }
            Iterator i = alist.iterator();
            this.subsystems = new ISubSystem[alist.size()];
            int idx = 0;
            while (i.hasNext()) {
                ISubSystem subsys = (ISubSystem)i.next();
                this.subsystems[idx++] = subsys;
            }
        }
        return this.subsystems;
    }

    public ISubSystem[] getSubSystems(IHost conn, boolean force) {
        boolean subsystemsRestored;
        ISubSystem[] subsystemArray = (ISubSystem[])this.subsystemsByConnection.get(conn);
        if (!(subsystemArray != null && subsystemArray.length != 0 || !(subsystemsRestored = this.subSystemsHaveBeenRestored(conn)) && force)) {
            if (!subsystemsRestored && !force) {
                return EMPTY_SUBSYSTEM_ARRAY;
            }
            subsystemArray = this.internalGetSubSystems(conn);
            this.subsystemsByConnection.put(conn, subsystemArray);
        }
        return subsystemArray;
    }

    protected ISubSystem[] internalGetSubSystems(IHost conn) {
        List mofList = this.getSubSystemList();
        Iterator i = mofList.iterator();
        Vector<ISubSystem> v = new Vector<ISubSystem>();
        while (i.hasNext()) {
            ISubSystem subsys = (ISubSystem)i.next();
            if (subsys.getHost() != conn) continue;
            v.addElement(subsys);
        }
        ISubSystem[] array = new ISubSystem[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            array[idx] = (ISubSystem)v.elementAt(idx);
            ++idx;
        }
        return array;
    }

    public ISubSystem[] getSubSystems(ISystemProfile profile) {
        ISubSystem[] allSubSystems = this.getSubSystems(true);
        Vector<ISubSystem> v = new Vector<ISubSystem>();
        int idx = 0;
        while (idx < allSubSystems.length) {
            ISubSystem ss = allSubSystems[idx];
            if (ss.getSystemProfile() == profile) {
                v.addElement(ss);
            }
            ++idx;
        }
        ISubSystem[] subsystems = new ISubSystem[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            subsystems[idx2] = (ISubSystem)v.elementAt(idx2);
            ++idx2;
        }
        return subsystems;
    }

    public ISubSystem[] getSubSystems(ISystemFilterPool pool) {
        ISubSystem[] allSubSystems = this.getSubSystems(false);
        Vector<ISubSystem> v = new Vector<ISubSystem>();
        int idx = 0;
        while (idx < allSubSystems.length) {
            ISystemFilterPoolReferenceManager mgr = this.subsystems[idx].getSystemFilterPoolReferenceManager();
            if (mgr != null && mgr.isSystemFilterPoolReferenced(pool)) {
                v.addElement(allSubSystems[idx]);
            }
            ++idx;
        }
        ISubSystem[] subsystems = new ISubSystem[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            subsystems[idx2] = (ISubSystem)v.elementAt(idx2);
            ++idx2;
        }
        return subsystems;
    }

    protected void addSubSystem(ISubSystem subsys) {
        this.getSubSystemList().add(subsys);
    }

    protected void removeSubSystem(ISubSystem subsys) {
        this.getSubSystemList().remove(subsys);
    }

    public ISubSystem createSubSystem(IHost conn, boolean creatingConnection, ISystemNewConnectionWizardPage[] yourNewConnectionWizardPages) {
        ISubSystem subsys;
        this.invalidateSubSystemCache(conn);
        if (creatingConnection) {
            if (this.subSystemsRestoredFlags == null) {
                this.reset();
            }
            this.subSystemsRestoredFlags.put(conn, Boolean.TRUE);
        }
        if ((subsys = this.createSubSystemInternal(conn)) != null) {
            IServerLauncherProperties sl;
            this.internalInitializeNewSubSystem(subsys, conn);
            if (this.supportsFilters()) {
                ISystemFilterPoolReferenceManager fprMgr = SystemFilterStartHere.getDefault().createSystemFilterPoolReferenceManager((ISystemFilterPoolReferenceManagerProvider)subsys, (ISystemFilterPoolManagerProvider)this, subsys.getName(), (IRSEFilterNamingPolicy)this.filterNamingPolicy);
                subsys.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = this.getFilterPoolManager(conn.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            IConnectorService connectorService = subsys.getConnectorService();
            if (this.supportsServerLaunchProperties(conn) && (sl = connectorService.getRemoteServerLauncherProperties()) == null && (sl = this.createServerLauncher(connectorService)) != null) {
                connectorService.setRemoteServerLauncherProperties(sl);
            }
            this.initializeSubSystem(subsys, yourNewConnectionWizardPages);
            try {
                this.saveSubSystem(subsys);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error saving new subsystem " + subsys.getName(), exc);
            }
            this.addSubSystem(subsys);
        }
        return subsys;
    }

    public ISubSystem cloneSubSystem(ISubSystem oldSubsystem, IHost newConnection, boolean copyProfileOperation) throws Exception {
        Exception lastExc = null;
        this.invalidateSubSystemCache(newConnection);
        this.subSystemsRestoredFlags.put(newConnection, Boolean.TRUE);
        ISubSystem subsys = this.createSubSystemInternal(newConnection);
        if (subsys != null) {
            IServerLauncherProperties newSL;
            IServerLauncherProperties sl;
            this.internalInitializeNewSubSystem(subsys, newConnection);
            subsys.setName(oldSubsystem.getName());
            subsys.addPropertySets(oldSubsystem.getPropertySets());
            subsys.setHidden(oldSubsystem.isHidden());
            IConnectorService oldConnectorService = oldSubsystem.getConnectorService();
            IConnectorService newConnectorService = subsys.getConnectorService();
            if (oldConnectorService != null && newConnectorService != null) {
                newConnectorService.setPort(oldConnectorService.getPort());
                newConnectorService.setUserId(oldConnectorService.getUserId());
                newConnectorService.setIsUsingSSL(oldConnectorService.isUsingSSL());
            }
            if ((sl = oldConnectorService.getRemoteServerLauncherProperties()) != null && this.supportsServerLaunchProperties(newConnection) && (newSL = this.createServerLauncher(newConnectorService)) != null) {
                newConnectorService.setRemoteServerLauncherProperties(sl.cloneServerLauncher(newSL));
            }
            this.copySubSystemData(oldSubsystem, subsys);
            if (this.supportsFilters()) {
                ISystemFilterPoolReferenceManager newRefMgr = SystemFilterStartHere.getDefault().createSystemFilterPoolReferenceManager((ISystemFilterPoolReferenceManagerProvider)subsys, (ISystemFilterPoolManagerProvider)this, subsys.getName(), (IRSEFilterNamingPolicy)this.filterNamingPolicy);
                ISystemFilterPoolManager defaultFilterPoolManager = null;
                defaultFilterPoolManager = copyProfileOperation ? this.getFilterPoolManager(newConnection.getSystemProfile()) : oldSubsystem.getFilterPoolReferenceManager().getDefaultSystemFilterPoolManager();
                newRefMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
                subsys.setFilterPoolReferenceManager(newRefMgr);
                ISystemFilterPoolReferenceManager oldRefMgr = oldSubsystem.getSystemFilterPoolReferenceManager();
                newRefMgr.setProviderEventNotification(false);
                ISystemFilterPoolReference[] oldReferences = oldRefMgr.getSystemFilterPoolReferences();
                String oldSubSystemProfileName = oldSubsystem.getSystemProfileName();
                if (oldReferences != null && oldReferences.length > 0) {
                    int idx = 0;
                    while (idx < oldReferences.length) {
                        ISystemFilterPoolReference poolRef = oldReferences[idx];
                        ISystemFilterPool pool = poolRef.getReferencedFilterPool();
                        if (pool != null) {
                            if (!copyProfileOperation) {
                                newRefMgr.addReferenceToSystemFilterPool(pool);
                            } else {
                                ISystemFilterPoolManager poolMgr = pool.getSystemFilterPoolManager();
                                String poolProfileName = this.getSystemProfileName(poolMgr);
                                if (poolProfileName.equals(oldSubSystemProfileName)) {
                                    ISystemFilterPoolManager newPoolMgr = this.getFilterPoolManager(newConnection.getSystemProfile());
                                    ISystemFilterPool newPool = newPoolMgr.getSystemFilterPool(pool.getName());
                                    newRefMgr.addReferenceToSystemFilterPool(newPool);
                                } else {
                                    newRefMgr.addReferenceToSystemFilterPool(pool);
                                }
                            }
                        }
                        ++idx;
                    }
                }
                newRefMgr.setProviderEventNotification(true);
            }
            try {
                this.saveSubSystem(subsys);
                RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(1, 4, subsys, null);
            }
            catch (Exception exc) {
                lastExc = exc;
                SystemBasePlugin.logError("Error saving cloned subsystem " + subsys.getName(), exc);
            }
            this.addSubSystem(subsys);
            if (lastExc != null) {
                throw lastExc;
            }
        }
        return subsys;
    }

    private void internalInitializeNewSubSystem(ISubSystem subsys, IHost conn) {
        subsys.setSubSystemConfiguration((ISubSystemConfiguration)this);
        subsys.setHost(conn);
        subsys.setName(this.internalGetSubSystemName(subsys));
        subsys.setConfigurationId(this.getId());
    }

    protected String internalGetSubSystemName(ISubSystem subsys) {
        return this.getName();
    }

    public abstract ISubSystem createSubSystemInternal(IHost var1);

    protected void initializeSubSystem(ISubSystem ss, ISystemNewConnectionWizardPage[] yourNewConnectionWizardPages) {
        ISystemFilterPool pool;
        IConnectorService connectorService = ss.getConnectorService();
        if (connectorService != null) {
            connectorService.setPort(0);
        }
        if (this.supportsFilters() && (pool = this.getDefaultSystemFilterPool(ss)) != null) {
            ISystemFilterPoolReferenceManager refMgr = ss.getSystemFilterPoolReferenceManager();
            refMgr.setProviderEventNotification(false);
            refMgr.addReferenceToSystemFilterPool(pool);
            refMgr.setProviderEventNotification(true);
        }
        if (yourNewConnectionWizardPages != null) {
            ISubSystemPropertiesWizardPage ourPage = null;
            int idx = 0;
            while (ourPage == null && idx < yourNewConnectionWizardPages.length) {
                if (yourNewConnectionWizardPages[idx] instanceof ISubSystemPropertiesWizardPage) {
                    ourPage = (ISubSystemPropertiesWizardPage)yourNewConnectionWizardPages[idx];
                    ourPage.applyValues(ss);
                }
                ++idx;
            }
        }
    }

    protected void copySubSystemData(ISubSystem oldSubSystem, ISubSystem newSubSystem) {
    }

    public void updateSubSystem(ISubSystem subsystem, boolean updateUserId, String userId, boolean updatePort, int port) {
        if (!this.needsUpdate(subsystem, updateUserId, userId, updatePort, port)) {
            return;
        }
        IConnectorService connectorService = subsystem.getConnectorService();
        if (connectorService != null) {
            if (updateUserId) {
                if (userId != null && userId.trim().length() > 0) {
                    connectorService.setUserId(userId);
                } else {
                    connectorService.setUserId(null);
                }
            }
            if (updatePort) {
                connectorService.setPort(port);
            }
            if (connectorService.isDirty()) {
                this.setDirty(true);
                subsystem.setDirty(true);
            }
        }
        this.fireEvent(subsystem, 86, subsystem.getHost());
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 4, subsystem, null);
    }

    public void setSubSystemPort(ISubSystem subsystem, int port) {
        this.updateSubSystem(subsystem, false, null, true, port);
    }

    public void setSubSystemUserId(ISubSystem subsystem, String userId) {
        this.updateSubSystem(subsystem, true, userId, false, 0);
    }

    protected boolean needsUpdate(ISubSystem subsystem, boolean updateUserId, String userId, boolean updatePort, int port) {
        IConnectorService connectorService = subsystem.getConnectorService();
        if (connectorService != null) {
            if (updatePort) {
                int oldPort = connectorService.getPort();
                boolean bl = updatePort = oldPort != port;
            }
            if (!updatePort && updateUserId) {
                if (userId == null || userId.trim().length() == 0) {
                    updateUserId = connectorService.getUserId() != null;
                } else {
                    String oldUserId = connectorService.getUserId();
                    if (oldUserId != null) {
                        if (subsystem.forceUserIdToUpperCase()) {
                            updateUserId = !userId.equalsIgnoreCase(oldUserId);
                        } else {
                            boolean bl = updateUserId = !userId.equals(oldUserId);
                        }
                    }
                }
            }
        }
        return updatePort || updateUserId;
    }

    public boolean isSubSystemsDeletable() {
        return false;
    }

    public boolean deleteSubSystem(ISubSystem subsystem) {
        ISystemFilterPoolReference[] fpRefs;
        if (subsystem.isConnected()) {
            try {
                subsystem.disconnect();
            }
            catch (Exception exception) {}
        }
        this.removeSubSystem(subsystem);
        ISystemFilterPoolReferenceManager fpRefMgr = subsystem.getSystemFilterPoolReferenceManager();
        if (fpRefMgr != null && (fpRefs = fpRefMgr.getSystemFilterPoolReferences()) != null) {
            int idx = 0;
            while (idx < fpRefs.length) {
                fpRefs[idx].removeReference();
                ++idx;
            }
        }
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(2, 4, subsystem, null);
        return true;
    }

    public void renameSubSystem(ISubSystem subsystem, String newName) {
        subsystem.setName(newName);
        try {
            subsystem.commit();
        }
        catch (Exception exception) {}
    }

    public void configureNewFilterAction(SystemNewFilterAction newFilterAction, Object callerData) {
        newFilterAction.setFromRSE(true);
        boolean showFilterPools = this.showFilterPools();
        if (!showFilterPools) {
            ISubSystem selectedSubSystem = (ISubSystem)callerData;
            boolean advancedUser = false;
            ISystemFilterPoolReferenceManager refMgr = selectedSubSystem.getSystemFilterPoolReferenceManager();
            ISystemFilterPool[] refdPools = refMgr.getReferencedSystemFilterPools();
            if (refdPools.length == 0) {
                SystemBasePlugin.logInfo("SubSystemConfigurationImpl::getSubSystemActions - getReferencedSystemFilterPools returned array of length zero.");
            } else if (refdPools.length > 1) {
                int idx = 0;
                while (!advancedUser && idx < refdPools.length) {
                    if (!refdPools[idx].isDefault() && refdPools[idx].getOwningParentName() == null) {
                        advancedUser = true;
                    }
                    ++idx;
                }
            }
            if (advancedUser) {
                newFilterAction.setAllowFilterPoolSelection(refdPools);
            } else {
                boolean anyAdded = false;
                SystemFilterPoolWrapperInformation poolWrapperInfo = this.getNewFilterWizardPoolWrapperInformation();
                ISystemProfile[] activeProfiles = RSEUIPlugin.getTheSystemRegistry().getActiveSystemProfiles();
                ISystemProfile activeProfile = selectedSubSystem.getHost().getSystemProfile();
                int idx = 0;
                while (idx < activeProfiles.length) {
                    ISystemFilterPool defaultPool = this.getDefaultSystemFilterPool(activeProfiles[idx]);
                    if (defaultPool != null) {
                        poolWrapperInfo.addWrapper(activeProfiles[idx].getName(), defaultPool, activeProfiles[idx] == activeProfile);
                        anyAdded = true;
                    }
                    ++idx;
                }
                if (anyAdded) {
                    newFilterAction.setAllowFilterPoolSelection(poolWrapperInfo);
                }
            }
        }
    }

    protected SystemFilterPoolWrapperInformation getNewFilterWizardPoolWrapperInformation() {
        return new SystemFilterPoolWrapperInformation(SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_LABEL, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_TOOLTIP, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_VERBAGE);
    }

    public void disconnectAllSubSystems() throws Exception {
        ISubSystem[] subsystems = this.getSubSystems(false);
        if (subsystems != null) {
            int idx = 0;
            while (idx < subsystems.length) {
                ISubSystem ss = subsystems[idx];
                if (ss.isConnected()) {
                    try {
                        ss.getConnectorService().disconnect((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {}
                }
                ++idx;
            }
        }
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            pool = mgr.createSystemFilterPool(SubSystemConfiguration.getDefaultFilterPoolName(mgr.getName(), this.getId()), true);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error creating default filter pool in default subsystem factory", exc);
        }
        return pool;
    }

    protected boolean isUserPrivateProfile(ISystemFilterPoolManager mgr) {
        ISystemProfile profile = this.getSystemProfile(mgr);
        return profile.isDefaultPrivate() || mgr.getName().equalsIgnoreCase("private");
    }

    public ISystemFilterPool getDefaultSystemFilterPool(ISubSystem subsys) {
        ISystemFilterPool pool = this.getDefaultSystemFilterPool(subsys.getSystemProfile());
        return pool;
    }

    public ISystemFilterPool getDefaultSystemFilterPool(ISystemProfile profile) {
        ISystemFilterPool pool = null;
        ISystemFilterPoolManager mgr = this.getFilterPoolManager(profile);
        pool = mgr.getFirstDefaultSystemFilterPool();
        return pool;
    }

    public void invalidateFilterCache() {
        this.filterPoolManagers = null;
    }

    public ISystemFilterPoolManager[] getFilterPoolManagers() {
        if (this.filterPoolManagers == null || this.filterPoolManagers.length != this.getFilterPoolManagerList().size()) {
            this.filterPoolManagers = new ISystemFilterPoolManager[this.getFilterPoolManagerList().size()];
            Iterator i = this.getFilterPoolManagerList().iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.filterPoolManagers[idx++] = (ISystemFilterPoolManager)i.next();
            }
        }
        return this.filterPoolManagers;
    }

    public ISystemFilterPoolManager[] getActiveFilterPoolManagers() {
        ISystemProfile[] activeProfiles = RSEUIPlugin.getTheSystemRegistry().getActiveSystemProfiles();
        ISystemFilterPoolManager[] activeManagers = new ISystemFilterPoolManager[activeProfiles.length];
        int idx = 0;
        while (idx < activeProfiles.length) {
            activeManagers[idx] = this.getFilterPoolManager(activeProfiles[idx]);
            ++idx;
        }
        return activeManagers;
    }

    public ISystemFilterPoolManager getFilterPoolManager(ISystemProfile profile) {
        ISystemFilterPoolManager mgr = (ISystemFilterPoolManager)this.filterPoolManagersPerProfile.get(profile);
        if (mgr == null) {
            try {
                mgr = SystemFilterPoolManager.createSystemFilterPoolManager((ISystemProfile)profile, (Logger)RSEUIPlugin.getDefault().getLogger(), (ISystemFilterPoolManagerProvider)this, (String)this.getFilterPoolManagerName(profile), (boolean)this.supportsNestedFilters(), (int)3, (IRSEFilterNamingPolicy)this.filterNamingPolicy);
                mgr.setSingleFilterStringOnly(!this.supportsMultipleFilterStrings());
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Restore/Creation of SystemFilterPoolManager " + this.getFilterPoolManagerName(profile) + " failed!", exc);
                SystemMessageDialog.displayExceptionMessage(null, exc);
                return null;
            }
            this.addFilterPoolManager(profile, mgr);
            boolean restored = mgr.wasRestored();
            if (!restored) {
                ISystemFilterPool defaultPool = this.createDefaultFilterPool(mgr);
                if (defaultPool != null) {
                    defaultPool.setDefault(true);
                    try {
                        RSEUIPlugin.getThePersistenceManager().commit(defaultPool);
                    }
                    catch (Exception exception) {}
                }
            } else if (this.doPostRestoreProcessing(mgr)) {
                try {
                    mgr.commit();
                }
                catch (Exception exception) {}
            }
            if (this.supportsDuplicateFilterStrings()) {
                mgr.setSupportsDuplicateFilterStrings(true);
            }
            if (this.isCaseSensitive()) {
                mgr.setStringsCaseSensitive(this.isCaseSensitive());
            }
        }
        return mgr;
    }

    protected boolean doPostRestoreProcessing(ISystemFilterPoolManager restoredFilterPoolMgr) {
        return false;
    }

    public ISystemFilterPoolManager copyFilterPoolManager(ISystemProfile oldProfile, ISystemProfile newProfile) throws Exception {
        ISystemFilterPoolManager oldMgr = this.getFilterPoolManager(oldProfile);
        ISystemFilterPoolManager mgr = SystemFilterPoolManager.createSystemFilterPoolManager((ISystemProfile)newProfile, (Logger)RSEUIPlugin.getDefault().getLogger(), (ISystemFilterPoolManagerProvider)this, (String)this.getFilterPoolManagerName(newProfile), (boolean)this.supportsNestedFilters(), (int)3, (IRSEFilterNamingPolicy)this.filterNamingPolicy);
        mgr.setStringsCaseSensitive(oldMgr.areStringsCaseSensitive());
        mgr.setSupportsDuplicateFilterStrings(oldMgr.supportsDuplicateFilterStrings());
        this.addFilterPoolManager(newProfile, mgr);
        oldMgr.copySystemFilterPools(mgr);
        return mgr;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager(String mgrName) {
        ISystemProfile profile = this.getSystemProfile(mgrName);
        if (profile != null) {
            return this.getFilterPoolManager(profile);
        }
        return null;
    }

    public ISystemFilterPoolManager[] getSystemFilterPoolManagers() {
        return this.getActiveFilterPoolManagers();
    }

    public ISystemFilterPoolManager[] getReferencableSystemFilterPoolManagers(ISystemFilterPoolReferenceManager refMgr) {
        return this.getActiveFilterPoolManagers();
    }

    public ISystemFilterPool getSystemFilterPoolForBrokenReference(ISystemFilterPoolReferenceManager callingRefMgr, String missingPoolMgrName, String missingPoolName) {
        ISubSystem ss;
        ISystemFilterPool match = null;
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile profile = sr.getSystemProfile(missingPoolMgrName);
        if (profile != null) {
            match = this.getFilterPoolManager(profile).getSystemFilterPool(missingPoolName);
        }
        if (match != null && (ss = (ISubSystem)callingRefMgr.getProvider()).getSystemProfile() != profile) {
            IHost conn = ss.getHost();
            String connectionName = String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
            SystemMessage sysMsg = RSEUIPlugin.getPluginMessage("RSEG1068");
            sysMsg.makeSubstitution((Object)missingPoolMgrName, (Object)connectionName);
            SystemBasePlugin.logWarning(String.valueOf(sysMsg.getFullMessageID()) + ": " + sysMsg.getLevelOneText());
            if (brokenReferenceWarningsIssued.get(missingPoolMgrName) == null) {
                SystemMessageDialog msgDlg = new SystemMessageDialog(null, sysMsg);
                msgDlg.open();
                brokenReferenceWarningsIssued.put(missingPoolMgrName, Boolean.TRUE);
            }
        }
        return match;
    }

    protected void addFilterPoolManager(ISystemProfile profile, ISystemFilterPoolManager mgr) {
        this.filterPoolManagersPerProfile.put(profile, mgr);
        this.getFilterPoolManagerList().add(mgr);
        this.invalidateFilterCache();
    }

    protected ISystemFilterPoolManager getFilterPoolManager(ISystemFilterPool pool) {
        return pool.getSystemFilterPoolManager();
    }

    protected ISystemFilterPoolManager getFilterPoolManager(ISystemFilterContainer poolOrFilter) {
        return poolOrFilter.getSystemFilterPoolManager();
    }

    protected ISystemFilterPoolManager getFilterPoolManager(ISystemFilterContainerReference poolOrFilterReference) {
        return this.getFilterPoolManager(poolOrFilterReference.getReferencedSystemFilterContainer());
    }

    protected ISystemFilterPoolManager getFilterPoolManager(IHost conn) {
        return this.getFilterPoolManager(conn.getSystemProfile());
    }

    protected String getFilterPoolManagerName(ISystemProfile profile) {
        return profile.getName();
    }

    protected String getSystemProfileName(ISystemFilterPoolManager manager) {
        return manager.getName();
    }

    protected void deleteFilterPoolManager(ISystemProfile profile) {
        ISystemFilterPoolManager mgr = (ISystemFilterPoolManager)this.filterPoolManagersPerProfile.get(profile);
        if (mgr != null) {
            mgr.deleteAllSystemFilterPools();
            this.filterPoolManagersPerProfile.remove(profile);
        }
        this.getFilterPoolManagerList().remove(mgr);
        this.invalidateFilterCache();
    }

    public void renameFilterPoolManager(ISystemProfile profile) {
        ISystemFilterPoolManager mgr = (ISystemFilterPoolManager)this.filterPoolManagersPerProfile.get(profile);
        if (mgr != null) {
            mgr.setName(this.getFilterPoolManagerName(profile));
        }
    }

    protected void fireEvent(SystemResourceChangeEvent event) {
        RSEUIPlugin.getTheSystemRegistry().fireEvent(event);
    }

    protected void fireEvent(Object src, int eventId, Object parent) {
        this.fireEvent(this.createEvent(src, eventId, parent));
    }

    protected void fireEvent(Object[] multiSrc, int eventId, Object parent, int delta) {
        this.fireEvent(this.createEvent(multiSrc, eventId, parent, delta));
    }

    protected SystemResourceChangeEvent createEvent(Object src, int eventId, Object parent) {
        return new SystemResourceChangeEvent(src, eventId, parent);
    }

    protected SystemResourceChangeEvent createEvent(Object[] src, int eventId, Object parent) {
        return new SystemResourceChangeEvent(src, eventId, parent);
    }

    protected SystemResourceChangeEvent createEvent(Object[] src, int eventId, Object parent, int delta) {
        SystemResourceChangeEvent event = new SystemResourceChangeEvent(src, eventId, parent);
        event.setPosition(delta);
        return event;
    }

    protected void fireSubSystemEvent(SystemResourceChangeEvent event, ISubSystem subsystem) {
        event.setGrandParent(subsystem);
        this.fireEvent(event);
    }

    protected void fireSubSystemEvent(SystemResourceChangeEvent event) {
        ISubSystem[] subsystems = this.getSubSystems(false);
        int idx = 0;
        while (idx < subsystems.length) {
            this.fireSubSystemEvent(event, subsystems[idx]);
            ++idx;
        }
    }

    protected void fireSubSystemEvent(SystemResourceChangeEvent event, ISystemProfile profile) {
        String profileName = profile.getName();
        ISubSystem[] allSubSystems = this.getSubSystems(false);
        int idx = 0;
        while (idx < allSubSystems.length) {
            if (allSubSystems[idx].getSystemProfile().getName().equals(profileName)) {
                this.fireSubSystemEvent(event, allSubSystems[idx]);
            }
            ++idx;
        }
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilter filter) {
        SystemResourceChangeEvent event = this.createEvent(filter, eventId, null);
        this.fireSubSystemFilterEvent(event, filter);
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilter[] filters) {
        if (filters.length > 0) {
            SystemResourceChangeEvent event = this.createEvent(filters, eventId, (Object)null);
            this.fireSubSystemFilterEvent(event, filters[0]);
        }
    }

    protected void fireSubSystemFilterEvent(SystemResourceChangeEvent event, ISystemFilter filter) {
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISubSystem[] subsystems = this.getSubSystems(pool);
        if (subsystems != null && subsystems.length > 0) {
            ISystemFilterContainer parent = filter.getParentFilterContainer();
            boolean nested = !(parent instanceof ISystemFilterPool);
            ISystemFilter nestedParentFilter = nested ? (ISystemFilter)parent : null;
            int idx = 0;
            while (idx < subsystems.length) {
                Object parentObj = null;
                parentObj = !nested ? (this.showFilterPools() ? subsystems[idx].getSystemFilterPoolReferenceManager().getReferenceToSystemFilterPool(pool) : subsystems[idx]) : nestedParentFilter;
                event = this.cloneEvent(event, parentObj);
                event.setParent(parentObj);
                this.fireSubSystemEvent(event, subsystems[idx]);
                ++idx;
            }
        }
    }

    protected SystemResourceChangeEvent cloneEvent(SystemResourceChangeEvent event, Object parent) {
        SystemResourceChangeEvent result = new SystemResourceChangeEvent(event.getSource(), event.getType(), parent);
        return result;
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilterString filterString) {
        SystemResourceChangeEvent event = this.createEvent(filterString, eventId, null);
        this.fireSubSystemFilterEvent(event, filterString);
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilterString[] filterStrings, int delta) {
        if (filterStrings.length > 0) {
            SystemResourceChangeEvent event = this.createEvent(filterStrings, eventId, null, delta);
            this.fireSubSystemFilterEvent(event, filterStrings[0]);
        }
    }

    protected void fireSubSystemFilterEvent(SystemResourceChangeEvent event, ISystemFilterString filterString) {
        ISystemFilter filter = filterString.getParentSystemFilter();
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISubSystem[] subsystems = this.getSubSystems(pool);
        if (subsystems != null && subsystems.length > 0) {
            event.setParent(filter);
            int idx = 0;
            while (idx < subsystems.length) {
                this.fireSubSystemEvent(event, subsystems[idx]);
                ++idx;
            }
        }
    }

    public void filterEventFilterPoolCreated(ISystemFilterPool newPool) {
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(1, 8, newPool, null);
    }

    public void filterEventFilterPoolDeleted(ISystemFilterPool oldPool) {
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(2, 8, oldPool, null);
    }

    public void filterEventFilterPoolRenamed(ISystemFilterPool pool, String oldName) {
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(8, 8, pool, oldName);
    }

    public void filterEventFilterPoolsRePositioned(ISystemFilterPool[] pools, int delta) {
        this.fireEvent(pools, 75, this, delta);
        if (pools != null) {
            int idx = 0;
            while (idx < pools.length) {
                RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(16, 8, pools[idx], null);
                ++idx;
            }
        }
    }

    public void filterEventFilterCreated(ISystemFilter newFilter) {
        this.fireSubSystemFilterEvent(10, newFilter);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(1, 32, newFilter, null);
    }

    public void filterEventFilterDeleted(ISystemFilter oldFilter) {
        this.fireSubSystemFilterEvent(20, oldFilter);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(2, 32, oldFilter, null);
    }

    public void filterEventFilterRenamed(ISystemFilter filter, String oldName) {
        this.fireSubSystemFilterEvent(15, filter);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(8, 32, filter, oldName);
    }

    public void filterEventFilterUpdated(ISystemFilter filter) {
        this.fireSubSystemFilterEvent(25, filter);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, filter, null);
    }

    public void filterEventFiltersRePositioned(ISystemFilter[] filters, int delta) {
        if (filters != null && filters.length > 0) {
            SystemResourceChangeEvent event = this.createEvent(filters, 30, (Object)null);
            event.setPosition(delta);
            this.fireSubSystemFilterEvent(event, filters[0]);
            int idx = 0;
            while (idx < filters.length) {
                RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(16, 32, filters[idx], null);
                ++idx;
            }
        }
    }

    public void filterEventFilterStringCreated(ISystemFilterString newFilterString) {
        this.fireSubSystemFilterEvent(41, newFilterString);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, newFilterString.getParentSystemFilter(), null);
    }

    public void filterEventFilterStringDeleted(ISystemFilterString oldFilterString) {
        this.fireSubSystemFilterEvent(42, oldFilterString);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, oldFilterString.getParentSystemFilter(), null);
    }

    public void filterEventFilterStringUpdated(ISystemFilterString filterString) {
        this.fireSubSystemFilterEvent(43, filterString);
        RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, filterString.getParentSystemFilter(), null);
    }

    public void filterEventFilterStringsRePositioned(ISystemFilterString[] filterStrings, int delta) {
        this.fireSubSystemFilterEvent(44, filterStrings, delta);
        if (filterStrings != null && filterStrings.length > 0) {
            RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, filterStrings[0].getParentSystemFilter(), null);
        }
    }

    public ISystemFilterPool getFilterPool(ISystemProfile profile, String name) {
        return this.getFilterPoolManager(profile).getSystemFilterPool(name);
    }

    public ISystemFilterPool[] getFilterPools(ISystemProfile profile) {
        return this.getFilterPoolManager(profile).getSystemFilterPools();
    }

    public boolean showChangeFilterStringsPropertyPage(ISystemFilter filter) {
        return true;
    }

    public ISubSystem[] testForActiveReferences(ISystemProfile profile) {
        int idx;
        ISystemFilterPool[] pools;
        Vector<ISubSystem> v = new Vector<ISubSystem>();
        ISystemProfileManager profileMgr = SystemProfileManager.getSystemProfileManager();
        ISystemFilterPoolManager sfpm = this.getFilterPoolManager(profile);
        String profileName = profile.getName();
        if (sfpm != null && (pools = sfpm.getSystemFilterPools()) != null && pools.length > 0) {
            idx = 0;
            while (idx < pools.length) {
                IRSEBaseReferencingObject[] refs = pools[idx].getReferencingObjects();
                if (refs != null && refs.length > 0) {
                    int jdx = 0;
                    while (jdx < refs.length) {
                        ISystemFilterPoolReference fpRef;
                        ISubSystem subsystem;
                        String ssProfileName;
                        if (refs[jdx] instanceof ISystemFilterPoolReference && !(ssProfileName = (subsystem = (ISubSystem)(fpRef = (ISystemFilterPoolReference)refs[jdx]).getProvider()).getSystemProfileName()).equals(profileName) && profileMgr.isSystemProfileActive(ssProfileName)) {
                            v.addElement(subsystem);
                        }
                        ++jdx;
                    }
                }
                ++idx;
            }
        }
        ISubSystem[] referencingSubSystems = null;
        if (v.size() > 0) {
            referencingSubSystems = new ISubSystem[v.size()];
            idx = 0;
            while (idx < referencingSubSystems.length) {
                referencingSubSystems[idx] = (ISubSystem)v.elementAt(idx);
                ++idx;
            }
        }
        return referencingSubSystems;
    }

    public String getTranslatedFilterTypeProperty(ISystemFilter selectedFilter) {
        if (this.translatedFilterType == null) {
            this.translatedFilterType = SystemPropertyResources.RESID_PROPERTY_FILTERTYPE_VALUE;
        }
        return this.translatedFilterType;
    }

    public boolean showRefreshOnFilter() {
        return true;
    }

    public boolean showGenericShowInTableOnFilter() {
        return true;
    }

    public IServerLauncherProperties createServerLauncher(IConnectorService connectorService) {
        RemoteServerLauncher sl = new RemoteServerLauncher("Remote Server Launcher", connectorService);
        String systemType = connectorService.getHostType();
        if (systemType.equals("Linux") || systemType.equals("Power Linux") || systemType.equals("zSeries Linux")) {
            sl.setServerScript("sh -c \"PATH=/opt/j2sdk1.4.2/bin:$PATH; export PATH; perl ./server.pl\"");
        } else if (systemType.equals("Unix") || systemType.equals("AIX")) {
            sl.setServerScript("sh -c \"PATH=/opt/j2sdk1.4.2/bin:$PATH; export PATH; sh server.sh\"");
        }
        sl.saveToProperties();
        return sl;
    }

    public IServerLauncherForm getServerLauncherForm(Shell shell, ISystemMessageLine msgLine) {
        return new RemoteServerLauncherForm(shell, msgLine);
    }

    public boolean commit() {
        boolean ok = false;
        try {
            this.saveSubSystems();
            this.saveFilterPools();
            ok = true;
        }
        catch (Exception exception) {}
        return ok;
    }

    public void saveSubSystems() throws Exception {
        this.saveSubSystems(null);
    }

    public void saveSubSystems(IHost conn) throws Exception {
        Exception lastException = null;
        ISubSystem[] subsystems = null;
        subsystems = conn != null ? this.getSubSystems(conn, false) : this.getSubSystems(false);
        if (subsystems == null) {
            return;
        }
        int idx = 0;
        while (idx < subsystems.length) {
            try {
                this.saveSubSystem(subsystems[idx]);
            }
            catch (Exception exc) {
                lastException = exc;
            }
            ++idx;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public void saveSubSystem(ISubSystem subsys) throws Exception {
        subsys.commit();
    }

    public boolean saveFilterPools() throws Exception {
        boolean ok = true;
        ISystemFilterPoolManager[] poolManagers = this.getFilterPoolManagers();
        Exception lastException = null;
        if (poolManagers != null) {
            int idx = 0;
            while (idx < poolManagers.length) {
                try {
                    this.saveFilterPools(poolManagers[idx]);
                }
                catch (Exception exc) {
                    ok = false;
                    lastException = exc;
                }
                ++idx;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return ok;
    }

    public void saveFilterPools(ISystemFilterPoolManager mgr) throws Exception {
        try {
            mgr.commit();
        }
        catch (Exception exc) {
            this.handleException("Exception saving filter pools for manager " + mgr.getName(), exc);
            throw exc;
        }
    }

    public ISubSystem createSubSystemAfterTheFact(IHost conn) {
        ISubSystem subsys = this.createSubSystemInternal(conn);
        if (subsys != null) {
            this.internalInitializeNewSubSystem(subsys, conn);
            if (this.supportsFilters()) {
                ISystemFilterPoolReferenceManager fprMgr = SystemFilterStartHere.getDefault().createSystemFilterPoolReferenceManager((ISystemFilterPoolReferenceManagerProvider)subsys, (ISystemFilterPoolManagerProvider)this, subsys.getName(), (IRSEFilterNamingPolicy)this.filterNamingPolicy);
                subsys.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = this.getFilterPoolManager(conn.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            this.initializeSubSystem(subsys, null);
            try {
                this.saveSubSystem(subsys);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error saving new subsystem " + subsys.getName(), exc);
            }
            this.addSubSystem(subsys);
        }
        return subsys;
    }

    protected boolean subSystemsHaveBeenRestored(IHost connection) {
        return this.subSystemsRestoredFlags.get(connection) != null;
    }

    public ISystemFilterPoolManager[] restoreAllFilterPoolManagersForAllProfiles() {
        ISystemProfile[] profiles = SystemStartHere.getSystemProfileManager().getSystemProfiles();
        ISystemFilterPoolManager[] allMgrs = new ISystemFilterPoolManager[profiles.length];
        int idx = 0;
        while (idx < profiles.length) {
            allMgrs[idx] = this.getFilterPoolManager(profiles[idx]);
            ++idx;
        }
        return allMgrs;
    }

    public void setConnection(IHost connection) {
        this.currentlySelectedConnection = connection;
    }

    public void setCurrentSelection(Object[] selection) {
        this.currentlySelected = selection;
    }

    protected void handleException(String msg, Exception exc) {
        SystemBasePlugin.logError(msg, exc);
    }

    public static String getConnectingMessage(String hostName, int port) {
        SystemMessage msg = null;
        if (port > 0) {
            msg = RSEUIPlugin.getPluginMessage("RSEG1055");
            msg.makeSubstitution((Object)hostName, (Object)Integer.toString(port));
        } else {
            msg = RSEUIPlugin.getPluginMessage("RSEG1054");
            msg.makeSubstitution((Object)hostName);
        }
        return msg.getLevelOneText();
    }

    public static String getDisconnectingMessage(String hostName, int port) {
        SystemMessage msg = null;
        if (port > 0) {
            msg = RSEUIPlugin.getPluginMessage("RSEG1060");
            msg.makeSubstitution((Object)hostName, (Object)Integer.toString(port));
        } else {
            msg = RSEUIPlugin.getPluginMessage("RSEG1059");
            msg.makeSubstitution((Object)hostName);
        }
        return msg.getLevelOneText();
    }

    public static String getDefaultFilterPoolName(String profileName, String factoryId) {
        StringBuffer nameBuf = new StringBuffer();
        nameBuf.append(profileName);
        nameBuf.append(":");
        nameBuf.append(factoryId);
        return nameBuf.toString();
    }

    public String toString() {
        return this.proxy.toString();
    }

    public List getSubSystemList() {
        if (this.subSystemList == null) {
            this.subSystemList = new ArrayList();
        }
        return this.subSystemList;
    }

    public List getFilterPoolManagerList() {
        if (this.filterPoolManagerList == null) {
            this.filterPoolManagerList = new ArrayList();
        }
        return this.filterPoolManagerList;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean flag) {
        this._isDirty = flag;
    }

    public boolean wasRestored() {
        return false;
    }

    public void setWasRestored(boolean flag) {
    }
}

