/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.ISystemUserIdConstants;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemConnectionFormCaller;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.RemoteSystemsPreferencePage;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorConnectionName;
import org.eclipse.rse.ui.validators.ValidatorUserId;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class SystemConnectionForm
implements Listener,
ISystemUserIdConstants,
SelectionListener,
Runnable,
IRunnableWithProgress {
    public static final boolean CREATE_MODE = false;
    public static final boolean UPDATE_MODE = true;
    public static String lastSystemType = null;
    protected Label labelType;
    protected Label labelConnectionName;
    protected Label labelHostName;
    protected Label labelUserId;
    protected Label labelDescription;
    protected Label labelProfile;
    protected Label labelTypeValue;
    protected Label labelSystemTypeValue;
    protected Label labelProfileValue;
    protected Combo textSystemType;
    protected Combo textHostName;
    protected Combo profileCombo;
    protected Text textConnectionName;
    protected Text textDescription;
    protected Button verifyHostNameCB;
    protected Button workOfflineCB;
    protected InheritableEntryField textUserId;
    protected Label textSystemTypeReadOnly;
    protected ISystemValidator[] nameValidators;
    protected ISystemValidator hostValidator;
    protected ISystemValidator userIdValidator;
    protected ISystemMessageLine msgLine;
    protected ISystemConnectionFormCaller caller;
    protected String[] restrictSystemTypesTo;
    protected String defaultSystemType;
    protected String defaultConnectionName;
    protected String defaultHostName;
    protected String defaultUserId;
    protected String defaultDescription;
    protected String defaultProfile;
    protected String[] defaultProfileNames;
    protected boolean defaultWorkOffline;
    protected boolean userPickedVerifyHostnameCB = false;
    protected int hostNameLength = 100;
    protected int connectionNameLength = 100;
    protected int userIdLength = 100;
    protected int descriptionLength = 100;
    protected int userIdLocation = 2;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected boolean callerInstanceOfPropertyPage;
    protected boolean userIdFromSystemTypeDefault;
    protected boolean updateMode = false;
    protected boolean initDone = false;
    protected boolean contentsCreated = false;
    protected boolean connectionNameEmpty = false;
    protected boolean connectionNameListen = true;
    protected boolean singleTypeMode = false;
    protected String originalHostName = null;
    protected String currentHostName = null;
    protected SystemMessage errorMessage = null;
    protected SystemMessage verifyingHostName;
    static /* synthetic */ Class class$0;

    public SystemConnectionForm(ISystemMessageLine msgLine, ISystemConnectionFormCaller caller) {
        this.msgLine = msgLine;
        this.caller = caller;
        this.defaultProfileNames = RSEUIPlugin.getTheSystemRegistry().getActiveSystemProfileNames();
        this.callerInstanceOfWizardPage = caller instanceof WizardPage;
        this.callerInstanceOfSystemPromptDialog = caller instanceof SystemPromptDialog;
        this.callerInstanceOfPropertyPage = caller instanceof PropertyPage;
        this.userIdValidator = new ValidatorUserId(true);
        this.defaultUserId = "";
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    public void setConnectionNameValidators(ISystemValidator[] v) {
        this.nameValidators = v;
    }

    public void setHostNameValidator(ISystemValidator v) {
        this.hostValidator = v;
    }

    public void setUserIdValidator(ISystemValidator v) {
        this.userIdValidator = v;
    }

    public void setProfileNames(String[] names) {
        this.defaultProfileNames = names;
        if (this.profileCombo != null) {
            this.profileCombo.setItems(names);
        }
    }

    public void setProfileNamePreSelection(String selection) {
        this.defaultProfile = selection;
        if (this.profileCombo != null && selection != null) {
            int selIdx = this.profileCombo.indexOf(selection);
            if (selIdx >= 0) {
                this.profileCombo.select(selIdx);
            } else {
                this.profileCombo.select(0);
            }
        }
    }

    public void setUserId(String userId) {
        this.defaultUserId = userId;
    }

    public void setCurrentlySelectedConnection(IHost connection) {
        if (connection != null) {
            this.initializeInputFields(connection, false);
        }
    }

    public void restrictSystemType(String systemType) {
        if (systemType.equals("*")) {
            return;
        }
        this.restrictSystemTypesTo = new String[1];
        this.restrictSystemTypesTo[0] = systemType;
        if (this.defaultSystemType == null) {
            this.defaultSystemType = systemType;
        }
    }

    public void restrictSystemTypes(String[] systemTypes) {
        if (systemTypes == null) {
            return;
        }
        if (systemTypes.length == 1 && systemTypes[0].equals("*")) {
            return;
        }
        this.restrictSystemTypesTo = systemTypes;
        if (this.defaultSystemType == null) {
            this.defaultSystemType = systemTypes[0];
        }
    }

    public void initializeInputFields(IHost conn) {
        this.initializeInputFields(conn, true);
    }

    public void initializeInputFields(IHost conn, boolean updateMode) {
        this.updateMode = updateMode;
        this.defaultSystemType = conn.getSystemType();
        this.defaultConnectionName = conn.getAliasName();
        this.defaultHostName = conn.getHostName();
        this.defaultUserId = conn.getLocalDefaultUserId();
        this.defaultDescription = conn.getDescription();
        this.defaultProfile = conn.getSystemProfile().getName();
        this.defaultWorkOffline = conn.isOffline();
        if (updateMode) {
            this.defaultProfileNames = new String[1];
            this.defaultProfileNames[0] = this.defaultProfile;
        }
        if (this.contentsCreated) {
            this.doInitializeFields();
        }
    }

    public void setConnectionName(String name) {
        this.defaultConnectionName = name;
    }

    public void setHostName(String name) {
        this.defaultHostName = name;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            pageComplete = this.getConnectionName().length() > 0 && this.getHostName().length() > 0 && this.getProfileName().length() > 0;
        }
        return pageComplete;
    }

    public boolean isConnectionUnique() {
        int selectedProfile = 0;
        if (this.profileCombo != null) {
            selectedProfile = this.profileCombo.getSelectionIndex();
        }
        if (selectedProfile < 0) {
            selectedProfile = 0;
        }
        ISystemValidator nameValidator = null;
        if (this.nameValidators != null && this.nameValidators.length > 0) {
            nameValidator = this.nameValidators[selectedProfile];
        }
        String connName = this.textConnectionName.getText().trim();
        if (nameValidator != null) {
            this.errorMessage = nameValidator.validate(connName);
        }
        return this.errorMessage == null;
    }

    public boolean verify(boolean okPressed) {
        boolean ok = true;
        Object controlInError = null;
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
        this.errorMessage = this.validateConnectionNameInput(false);
        if (this.errorMessage != null) {
            controlInError = this.textConnectionName;
        }
        if (this.errorMessage == null && this.textHostName != null) {
            this.errorMessage = this.validateHostNameInput();
            if (this.errorMessage != null) {
                controlInError = this.textHostName;
            }
        }
        if (this.errorMessage == null && this.textUserId != null) {
            this.errorMessage = this.validateUserIdInput();
            if (this.errorMessage != null) {
                controlInError = this.textUserId;
            }
        }
        if (this.errorMessage == null && okPressed && this.textHostName != null && this.verifyHostNameCB.getSelection()) {
            this.currentHostName = this.textHostName.getText().trim();
            if (this.currentHostName.length() > 0) {
                if (this.verifyingHostName == null) {
                    this.verifyingHostName = RSEUIPlugin.getPluginMessage("RSEG1221");
                }
                try {
                    this.getRunnableContext().run(true, true, (IRunnableWithProgress)this);
                }
                catch (InterruptedException interruptedException) {
                    ok = false;
                    controlInError = this.textHostName;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1220");
                    this.errorMessage.makeSubstitution((Object)this.currentHostName);
                    controlInError = this.textHostName;
                }
            }
        }
        if (ok && this.errorMessage == null && okPressed) {
            String connectionName = this.textConnectionName.getText().trim();
            if (!connectionName.equals(this.defaultConnectionName)) {
                ok = ValidatorConnectionName.validateNameNotInUse(connectionName, this.caller.getShell());
            }
            controlInError = this.textConnectionName;
        }
        if (!ok || this.errorMessage != null) {
            ok = false;
            if (okPressed) {
                controlInError.setFocus();
            }
            this.showErrorMessage(this.errorMessage);
        } else {
            boolean isLocal = false;
            this.userIdLocation = this.textUserId != null ? ((isLocal = this.textUserId.isLocal()) ? 2 : 3) : 0;
            SystemPreferencesManager.getPreferencesManager().setVerifyConnection(this.verifyHostNameCB.getSelection());
        }
        return ok;
    }

    protected IRunnableContext getRunnableContext() {
        if (this.callerInstanceOfWizardPage) {
            return ((WizardPage)this.caller).getWizard().getContainer();
        }
        if (this.callerInstanceOfSystemPromptDialog) {
            return (SystemPromptDialog)((Object)this.caller);
        }
        return new ProgressMonitorDialog(this.caller.getShell());
    }

    private boolean enableOfflineCB() {
        if (!this.updateMode) {
            return false;
        }
        IRSESystemType sysType = RSECorePlugin.getDefault().getRegistry().getSystemType(this.defaultSystemType);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.IRSESystemType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RSESystemTypeAdapter sysTypeAdapter = (RSESystemTypeAdapter)sysType.getAdapter((Class)clazz);
        return sysTypeAdapter.isEnableOffline(sysType);
    }

    public String getSystemType() {
        if (this.textSystemType != null) {
            return this.textSystemType.getText().trim();
        }
        return this.defaultSystemType;
    }

    public String getConnectionName() {
        return this.textConnectionName.getText().trim();
    }

    public String getHostName() {
        return this.textHostName.getText().trim();
    }

    public String getDefaultUserId() {
        if (this.textUserId != null) {
            return this.textUserId.getText().trim();
        }
        return "";
    }

    public boolean isWorkOffline() {
        if (this.workOfflineCB != null) {
            return this.workOfflineCB.getSelection();
        }
        return false;
    }

    public String getConnectionDescription() {
        return this.textDescription.getText().trim();
    }

    public String getProfileName() {
        return this.labelProfileValue != null ? this.labelProfileValue.getText() : this.profileCombo.getText();
    }

    public int getUserIdLocation() {
        if (this.textUserId != null && this.textUserId.getText().trim().length() > 0) {
            return this.userIdLocation;
        }
        return 0;
    }

    public Control createContents(Composite parent, boolean updateMode, String parentHelpId) {
        this.contentsCreated = true;
        Label labelSystemType = null;
        String temp = null;
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        SystemWidgetHelpers.setCompositeHelp(composite_prompts, parentHelpId);
        if (updateMode) {
            temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_TYPE_LABEL);
            this.labelType = SystemWidgetHelpers.createLabel(composite_prompts, temp);
            this.labelTypeValue = SystemWidgetHelpers.createLabel(composite_prompts, SystemResources.RESID_CONNECTION_TYPE_VALUE);
        }
        if (updateMode) {
            temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_PROFILE_LABEL);
            this.labelProfile = SystemWidgetHelpers.createLabel(composite_prompts, temp);
            this.labelProfile.setToolTipText(SystemResources.RESID_CONNECTION_PROFILE_READONLY_TIP);
            this.labelProfileValue = SystemWidgetHelpers.createLabel(composite_prompts, "");
            this.labelProfileValue.setToolTipText(SystemResources.RESID_CONNECTION_PROFILE_READONLY_TIP);
        } else {
            temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_PROFILE_LABEL);
            this.labelProfile = SystemWidgetHelpers.createLabel(composite_prompts, temp);
            this.labelProfile.setToolTipText(SystemResources.RESID_CONNECTION_PROFILE_TIP);
            if (!updateMode) {
                this.profileCombo = SystemWidgetHelpers.createReadonlyCombo(composite_prompts, null, SystemResources.RESID_CONNECTION_PROFILE_TIP);
                SystemWidgetHelpers.setHelp((Control)this.profileCombo, "org.eclipse.rse.ui.ccon0001");
            }
        }
        if (!updateMode) {
            SystemWidgetHelpers.createLabel(composite_prompts, " ", 2);
        }
        if (updateMode || this.restrictSystemTypesTo != null && this.restrictSystemTypesTo.length == 1) {
            if (updateMode) {
                temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_SYSTEMTYPE_LABEL);
                labelSystemType = SystemWidgetHelpers.createLabel(composite_prompts, temp);
                labelSystemType.setToolTipText(SystemResources.RESID_CONNECTION_SYSTEMTYPE_READONLY_TIP);
                this.textSystemTypeReadOnly = SystemWidgetHelpers.createLabel(composite_prompts, "");
                this.textSystemTypeReadOnly.setToolTipText(SystemResources.RESID_CONNECTION_SYSTEMTYPE_READONLY_TIP);
            } else {
                this.singleTypeMode = true;
            }
        }
        if (updateMode) {
            SystemWidgetHelpers.createLabel(composite_prompts, " ", nbrColumns);
        }
        temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_CONNECTIONNAME_LABEL);
        this.labelConnectionName = SystemWidgetHelpers.createLabel(composite_prompts, temp);
        this.labelConnectionName.setToolTipText(SystemResources.RESID_CONNECTION_CONNECTIONNAME_TIP);
        this.textConnectionName = SystemWidgetHelpers.createTextField(composite_prompts, null, SystemResources.RESID_CONNECTION_CONNECTIONNAME_TIP);
        SystemWidgetHelpers.setHelp((Control)this.textConnectionName, "org.eclipse.rse.ui.ccon0002");
        if (labelSystemType == null && !this.singleTypeMode) {
            temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_SYSTEMTYPE_LABEL);
            labelSystemType = SystemWidgetHelpers.createLabel(composite_prompts, temp);
            labelSystemType.setToolTipText(SystemResources.RESID_CONNECTION_SYSTEMTYPE_TIP);
            this.textSystemType = SystemWidgetHelpers.createSystemTypeCombo(composite_prompts, null, this.restrictSystemTypesTo);
            this.textSystemType.setToolTipText(SystemResources.RESID_CONNECTION_SYSTEMTYPE_TIP);
            SystemWidgetHelpers.setHelp((Control)this.textSystemType, "org.eclipse.rse.ui.ccon0003");
        }
        temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_HOSTNAME_LABEL);
        this.labelHostName = SystemWidgetHelpers.createLabel(composite_prompts, temp);
        this.labelHostName.setToolTipText(SystemResources.RESID_CONNECTION_HOSTNAME_TIP);
        if (!updateMode && this.defaultSystemType == null) {
            this.defaultSystemType = RemoteSystemsPreferencePage.getSystemTypePreference();
            if (this.defaultSystemType == null || this.defaultSystemType.length() == 0) {
                this.defaultSystemType = lastSystemType;
            }
            if (this.defaultSystemType == null || this.defaultSystemType.length() == 0) {
                this.defaultSystemType = this.textSystemType.getItem(0);
            }
        }
        this.textHostName = SystemWidgetHelpers.createHostNameCombo(composite_prompts, null, this.defaultSystemType);
        this.textHostName.setToolTipText(SystemResources.RESID_CONNECTION_HOSTNAME_TIP);
        SystemWidgetHelpers.setHelp((Control)this.textHostName, "org.eclipse.rse.ui.ccon0004");
        if (updateMode) {
            temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_DEFAULTUSERID_LABEL);
            this.labelUserId = SystemWidgetHelpers.createLabel(composite_prompts, temp);
            this.labelUserId.setToolTipText(SystemResources.RESID_CONNECTION_DEFAULTUSERID_TIP);
            this.textUserId = SystemWidgetHelpers.createInheritableTextField(composite_prompts, SystemResources.RESID_CONNECTION_DEFAULTUSERID_INHERITBUTTON_TIP, SystemResources.RESID_CONNECTION_DEFAULTUSERID_TIP);
            SystemWidgetHelpers.setHelp((Control)this.textUserId, "org.eclipse.rse.ui.ccon0005");
        }
        temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_DESCRIPTION_LABEL);
        this.labelDescription = SystemWidgetHelpers.createLabel(composite_prompts, temp);
        this.labelDescription.setToolTipText(SystemResources.RESID_CONNECTION_DESCRIPTION_TIP);
        this.textDescription = SystemWidgetHelpers.createTextField(composite_prompts, null, SystemResources.RESID_CONNECTION_DESCRIPTION_TIP);
        SystemWidgetHelpers.setHelp((Control)this.textDescription, "org.eclipse.rse.ui.ccon0006");
        SystemWidgetHelpers.createLabel(composite_prompts, " ", nbrColumns);
        this.verifyHostNameCB = SystemWidgetHelpers.createCheckBox(composite_prompts, nbrColumns, null, SystemResources.RESID_CONNECTION_VERIFYHOSTNAME_LABEL, SystemResources.RESID_CONNECTION_VERIFYHOSTNAME_TOOLTIP);
        if (updateMode) {
            this.verifyHostNameCB.setSelection(false);
        } else {
            this.verifyHostNameCB.setSelection(SystemPreferencesManager.getPreferencesManager().getVerifyConnection());
        }
        if (this.enableOfflineCB()) {
            this.workOfflineCB = SystemWidgetHelpers.createCheckBox(composite_prompts, nbrColumns, null, SystemResources.RESID_OFFLINE_WORKOFFLINE_LABEL, SystemResources.RESID_OFFLINE_WORKOFFLINE_TOOLTIP);
            SystemWidgetHelpers.setHelp((Control)this.workOfflineCB, "org.eclipse.rse.ui.wofp0000");
        }
        if (!this.initDone) {
            this.doInitializeFields();
        }
        this.connectionNameEmpty = this.textConnectionName.getText().trim().length() == 0;
        this.textConnectionName.setFocus();
        this.textConnectionName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemConnectionForm.this.validateConnectionNameInput(true);
            }
        });
        this.textHostName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemConnectionForm.this.validateHostNameInput();
                SystemConnectionForm.this.validateConnectionNameInput(false);
            }
        });
        if (this.textUserId != null) {
            this.textUserId.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemConnectionForm.this.validateUserIdInput();
                }
            });
        }
        if (this.profileCombo != null) {
            this.profileCombo.addSelectionListener((SelectionListener)this);
        }
        if (this.textSystemType != null) {
            this.originalHostName = this.textHostName.getText();
            this.textSystemType.addSelectionListener((SelectionListener)this);
        }
        if (this.verifyHostNameCB != null) {
            this.verifyHostNameCB.addSelectionListener((SelectionListener)this);
        }
        if (this.textSystemType != null && this.textSystemType.getText() != null) {
            this.caller.systemTypeSelected(this.textSystemType.getText(), true);
        } else if (this.restrictSystemTypesTo != null && this.restrictSystemTypesTo.length == 1) {
            this.caller.systemTypeSelected(this.restrictSystemTypesTo[0], true);
        }
        if (this.textUserId == null) {
            this.userIdLocation = 0;
        }
        return composite_prompts;
    }

    public Control getInitialFocusControl() {
        if (this.updateMode || !this.singleTypeMode) {
            return this.textConnectionName;
        }
        return this.textHostName;
    }

    public void handleEvent(Event evt) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Object src = event.getSource();
        if (src == this.profileCombo) {
            this.profileCombo.getDisplay().asyncExec((Runnable)this);
        } else if (src == this.textSystemType) {
            String currHostName = this.textHostName.getText().trim();
            boolean hostNameChanged = !currHostName.equals(this.originalHostName);
            String currSystemType = this.textSystemType.getText().trim();
            this.textHostName.setItems(RSEUIPlugin.getTheSystemRegistry().getHostNames(currSystemType));
            if (hostNameChanged) {
                this.textHostName.setText(currHostName);
            } else if (this.textHostName.getItemCount() > 0) {
                this.textHostName.setText(this.textHostName.getItem(0));
                this.originalHostName = this.textHostName.getText();
            } else {
                String connName = this.textConnectionName.getText().trim();
                if (connName.indexOf(32) == -1) {
                    this.textHostName.setText(connName);
                } else {
                    this.textHostName.setText("");
                }
                this.originalHostName = this.textHostName.getText();
            }
            this.initializeUserIdField(currSystemType, null);
            this.verify(false);
            this.caller.systemTypeSelected(currSystemType, false);
        } else if (src == this.verifyHostNameCB) {
            this.userPickedVerifyHostnameCB = true;
            if (!this.verifyHostNameCB.getSelection() && this.errorMessage != null && this.errorMessage == RSEUIPlugin.getPluginMessage("RSEG1220")) {
                this.errorMessage = null;
                if (this.msgLine != null) {
                    this.msgLine.clearErrorMessage();
                }
                this.setPageComplete();
                if (this.callerInstanceOfWizardPage) {
                    IWizard wizard = ((WizardPage)this.caller).getWizard();
                    IWizardPage[] pages = null;
                    if (wizard instanceof RSENewConnectionWizard) {
                        RSENewConnectionWizard connWizard = (RSENewConnectionWizard)wizard;
                        AbstractSystemWizardPage mainPage = (AbstractSystemWizardPage)connWizard.getStartingPage();
                        Vector<AbstractSystemWizardPage> pageList = new Vector<AbstractSystemWizardPage>();
                        AbstractSystemWizardPage page = mainPage;
                        while (page != null) {
                            if (page != mainPage) {
                                pageList.add(page);
                            }
                            page = connWizard.getNextPage((IWizardPage)page);
                        }
                        pages = new IWizardPage[pageList.size()];
                        int j = 0;
                        while (j < pageList.size()) {
                            pages[j] = (IWizardPage)pageList.get(j);
                            ++j;
                        }
                    } else {
                        pages = wizard.getPages();
                    }
                    int i = 0;
                    while (i < pages.length) {
                        IWizardPage page = pages[i];
                        if (page instanceof AbstractSystemWizardPage) {
                            ((AbstractSystemWizardPage)page).clearErrorMessage();
                        } else if (page instanceof WizardPage) {
                            ((WizardPage)page).setErrorMessage(null);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void doInitializeFields() {
        int selIdx;
        if (this.labelProfileValue != null) {
            if (this.defaultProfile != null) {
                this.labelProfileValue.setText(this.defaultProfile);
            }
        } else {
            if (this.defaultProfileNames != null) {
                this.profileCombo.setItems(this.defaultProfileNames);
            }
            if (this.defaultProfile != null) {
                selIdx = this.profileCombo.indexOf(this.defaultProfile);
                if (selIdx >= 0) {
                    this.profileCombo.select(selIdx);
                } else {
                    this.profileCombo.select(0);
                }
            }
        }
        if (this.textSystemTypeReadOnly != null || this.singleTypeMode) {
            if (this.restrictSystemTypesTo != null) {
                if (this.textSystemTypeReadOnly != null) {
                    this.textSystemTypeReadOnly.setText(this.restrictSystemTypesTo[0]);
                }
                if (this.defaultSystemType == null) {
                    this.defaultSystemType = this.restrictSystemTypesTo[0];
                }
            } else if (this.defaultSystemType != null && this.textSystemTypeReadOnly != null) {
                this.textSystemTypeReadOnly.setText(this.defaultSystemType);
            }
        } else {
            if (this.defaultSystemType == null) {
                this.defaultSystemType = RemoteSystemsPreferencePage.getSystemTypePreference();
                if (this.defaultSystemType == null || this.defaultSystemType.length() == 0) {
                    this.defaultSystemType = lastSystemType;
                }
            }
            if (this.defaultSystemType != null) {
                selIdx = this.textSystemType.indexOf(this.defaultSystemType);
                if (selIdx >= 0) {
                    this.textSystemType.select(selIdx);
                }
            } else {
                this.textSystemType.select(0);
                this.defaultSystemType = this.textSystemType.getText();
            }
        }
        if (this.defaultConnectionName != null) {
            this.textConnectionName.setText(this.defaultConnectionName);
        }
        this.textConnectionName.setTextLimit(this.connectionNameLength);
        if (this.defaultHostName != null) {
            this.textHostName.setText(this.defaultHostName);
        } else if (this.textHostName.getItemCount() > 0) {
            this.textHostName.select(0);
        }
        this.textHostName.setTextLimit(this.hostNameLength);
        this.textHostName.clearSelection();
        this.initializeUserIdField(this.defaultSystemType, this.defaultUserId);
        if (this.textUserId != null) {
            this.textUserId.setTextLimit(this.userIdLength);
        }
        if (this.defaultDescription != null) {
            this.textDescription.setText(this.defaultDescription);
        }
        this.textDescription.setTextLimit(this.descriptionLength);
        if (this.workOfflineCB != null) {
            this.workOfflineCB.setSelection(this.defaultWorkOffline);
        }
        this.initDone = true;
    }

    private void initializeUserIdField(String systemType, String currentUserId) {
        String parentUserId = SystemPreferencesManager.getPreferencesManager().getDefaultUserId(systemType);
        if (this.textUserId != null) {
            this.textUserId.setInheritedText(parentUserId);
            boolean allowEditingOfInherited = parentUserId == null || parentUserId.length() == 0;
            this.textUserId.setAllowEditingOfInheritedText(allowEditingOfInherited);
        }
        if (currentUserId != null && currentUserId.length() > 0) {
            if (this.textUserId != null) {
                this.textUserId.setLocalText(currentUserId);
                this.textUserId.setLocal(true);
            }
        } else {
            if (this.textUserId != null) {
                this.textUserId.setLocalText("");
            }
            if (parentUserId != null && parentUserId.length() > 0) {
                this.userIdFromSystemTypeDefault = true;
                this.defaultUserId = parentUserId;
                if (this.textUserId != null) {
                    this.textUserId.setLocal(false);
                }
            } else if (this.textUserId != null) {
                this.textUserId.setLocal(false);
            }
        }
    }

    protected SystemMessage validateConnectionNameInput(boolean userTyped) {
        if (!this.connectionNameListen) {
            return null;
        }
        this.errorMessage = null;
        int selectedProfile = 0;
        if (this.profileCombo != null) {
            selectedProfile = this.profileCombo.getSelectionIndex();
        }
        if (selectedProfile < 0) {
            selectedProfile = 0;
        }
        ISystemValidator nameValidator = null;
        if (this.nameValidators != null && this.nameValidators.length > 0) {
            nameValidator = this.nameValidators[selectedProfile];
        }
        String connName = this.textConnectionName.getText().trim();
        if (nameValidator != null) {
            this.errorMessage = nameValidator.validate(connName);
        }
        this.showErrorMessage(this.errorMessage);
        this.setPageComplete();
        if (userTyped) {
            this.connectionNameEmpty = connName.length() == 0;
        }
        return this.errorMessage;
    }

    protected void internalSetConnectionName(String name) {
        SystemMessage currErrorMessage = this.errorMessage;
        this.connectionNameListen = false;
        this.textConnectionName.setText(name);
        this.connectionNameListen = true;
        this.errorMessage = currErrorMessage;
    }

    protected SystemMessage validateHostNameInput() {
        String hostName = this.textHostName.getText().trim();
        if (this.connectionNameEmpty) {
            this.internalSetConnectionName(hostName);
        }
        this.errorMessage = null;
        if (this.hostValidator != null) {
            this.errorMessage = this.hostValidator.validate(hostName);
        } else if (this.getHostName().length() == 0) {
            this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1024");
        }
        if (this.updateMode && !this.userPickedVerifyHostnameCB) {
            boolean hostNameChanged = !hostName.equals(this.defaultHostName);
            this.verifyHostNameCB.setSelection(hostNameChanged);
        }
        this.showErrorMessage(this.errorMessage);
        this.setPageComplete();
        return this.errorMessage;
    }

    protected SystemMessage validateUserIdInput() {
        this.errorMessage = null;
        if (this.textUserId != null) {
            if (this.userIdValidator != null) {
                this.errorMessage = this.userIdValidator.validate(this.textUserId.getText());
            } else if (this.getDefaultUserId().length() == 0) {
                this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1025");
            }
        }
        this.showErrorMessage(this.errorMessage);
        this.setPageComplete();
        return this.errorMessage;
    }

    public void setPageComplete() {
        boolean complete = this.isPageComplete();
        if (complete && this.textSystemType != null) {
            lastSystemType = this.textSystemType.getText().trim();
        }
        if (this.callerInstanceOfWizardPage) {
            ((WizardPage)this.caller).setPageComplete(complete);
        } else if (this.callerInstanceOfSystemPromptDialog) {
            ((SystemPromptDialog)((Object)this.caller)).setPageComplete(complete);
        } else if (this.callerInstanceOfPropertyPage) {
            ((PropertyPage)this.caller).setValid(complete);
        }
    }

    private void showErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            if (msg != null) {
                this.msgLine.setErrorMessage(msg);
            } else {
                this.msgLine.clearErrorMessage();
            }
        } else {
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "MSGLINE NULL. TRYING TO WRITE MSG " + msg);
        }
    }

    public static ISystemValidator getConnectionNameValidator(IHost conn) {
        ISystemProfile profile = conn.getSystemProfile();
        Vector v = RSEUIPlugin.getTheSystemRegistry().getHostAliasNames(profile);
        if (conn != null) {
            v.removeElement(conn.getAliasName());
        }
        ValidatorConnectionName connNameValidator = new ValidatorConnectionName(v);
        return connNameValidator;
    }

    public static ISystemValidator getConnectionNameValidator(ISystemProfile profile) {
        Vector v = RSEUIPlugin.getTheSystemRegistry().getHostAliasNames(profile);
        ValidatorConnectionName connNameValidator = new ValidatorConnectionName(v);
        return connNameValidator;
    }

    public static ISystemValidator[] getConnectionNameValidators() {
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile[] profiles = sr.getActiveSystemProfiles();
        ISystemValidator[] connNameValidators = new ISystemValidator[profiles.length];
        int idx = 0;
        while (idx < profiles.length) {
            Vector v = sr.getHostAliasNames(profiles[idx]);
            connNameValidators[idx] = new ValidatorConnectionName(v);
            ++idx;
        }
        return connNameValidators;
    }

    public void run() {
        this.verify(false);
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        pm.beginTask(this.verifyingHostName.getLevelOneText(), -1);
        try {
            InetAddress.getByName(this.currentHostName);
        }
        catch (UnknownHostException exc) {
            pm.done();
            throw new InvocationTargetException(exc);
        }
        pm.done();
    }
}

