/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemDNDTransferRunnable;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class SystemPasteFromClipboardAction
extends SystemBaseAction
implements IValidatorRemoteSelection {
    private int _srcType;
    private Object _selection;
    private Clipboard _clipboard;
    static /* synthetic */ Class class$0;

    public SystemPasteFromClipboardAction(Shell shell, Clipboard clipboard) {
        super(SystemResources.ACTION_PASTE_LABEL, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"), shell);
        this._clipboard = clipboard;
        this._srcType = 0;
        this.setEnabled(false);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0117");
    }

    public void run() {
        if (this._selection != null) {
            this.pasteClipboardToSelection(this._selection);
        }
    }

    private void pasteClipboardToSelection(Object target) {
        List srcObjects = RSEUIPlugin.getTheSystemRegistry().getSystemClipboardObjects(this._srcType);
        if (srcObjects.size() > 0) {
            SystemDNDTransferRunnable runnable = new SystemDNDTransferRunnable(target, (ArrayList)srcObjects, this.getViewer(), this._srcType);
            if (target instanceof IAdaptable) {
                ISystemDragDropAdapter targetAdapter;
                IAdaptable iAdaptable = (IAdaptable)target;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    ArrayList rulesList = new ArrayList();
                    int j = 0;
                    int i = 0;
                    while (i < srcObjects.size()) {
                        if (srcObjects.get(i) instanceof ISchedulingRule) {
                            rulesList.add(srcObjects.get(i));
                            ++j;
                        }
                        ++i;
                    }
                    ISchedulingRule[] rules = rulesList.toArray(new ISchedulingRule[rulesList.size()]);
                    MultiRule rule = new MultiRule(rules);
                    runnable.setRule((ISchedulingRule)rule);
                }
            }
            runnable.schedule();
            RSEUIPlugin.getTheSystemRegistry().clearRunnableContext();
        }
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSource() {
        Clipboard clipboard = this._clipboard;
        synchronized (clipboard) {
            try {
                Object object = this._clipboard.getContents((Transfer)PluginTransfer.getInstance());
                if (object != null) {
                    if (!(object instanceof PluginTransferData)) return false;
                    PluginTransferData data = (PluginTransferData)object;
                    byte[] result = data.getData();
                    if (result == null) return false;
                    this._srcType = 0;
                    return true;
                }
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                object = this._clipboard.getContents((Transfer)resTransfer);
                if (object != null) {
                    IResource[] resourceData = (IResource[])object;
                    if (resourceData.length <= 0) return false;
                    this._srcType = 1;
                    return true;
                }
                FileTransfer fileTransfer = FileTransfer.getInstance();
                object = this._clipboard.getContents((Transfer)fileTransfer);
                if (object != null) {
                    String[] fileData = (String[])object;
                    if (fileData.length <= 0) return false;
                    this._srcType = 2;
                    return true;
                }
                TextTransfer textTransfer = TextTransfer.getInstance();
                object = this._clipboard.getContents((Transfer)textTransfer);
                if (object == null) return false;
                this._srcType = 3;
                return true;
            }
            catch (Exception exception) {}
            return false;
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (this.hasSource()) {
            boolean enable = true;
            Iterator e = selection.iterator();
            while (enable && e.hasNext()) {
                Object selectedObject = e.next();
                if (selectedObject instanceof IAdaptable) {
                    ISystemDragDropAdapter va;
                    IAdaptable adaptable = (IAdaptable)selectedObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((va = (ISystemDragDropAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                        enable = va.canDrop(selectedObject);
                        continue;
                    }
                    enable = false;
                    continue;
                }
                enable = false;
            }
            if (enable) {
                this._selection = selection.getFirstElement();
            }
            return enable;
        }
        return false;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        irc = new ProgressMonitorDialog(shell);
        RSEUIPlugin.getTheSystemRegistry().setRunnableContext(shell, irc);
        return irc;
    }
}

