/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPasswordPersistencePrompt;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class SignonPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Table pwdTable;
    private TableViewer pwdTableViewer;
    private PasswordContentProvider provider;
    private Button addButton;
    private Button changeButton;
    private Button removeButton;
    private List passwords;
    private List modifications;

    public SignonPreferencePage() {
        this.noDefaultAndApplyButton();
        this.provider = new PasswordContentProvider();
        this.modifications = new ArrayList();
    }

    protected Control createContents(Composite parent) {
        Composite page = SystemWidgetHelpers.createComposite(parent, 2);
        GridData gd = (GridData)page.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.pwdTable = new Table(page, 68354);
        this.pwdTable.setLinesVisible(true);
        this.pwdTable.setHeaderVisible(true);
        this.pwdTable.addListener(13, (Listener)this);
        SystemWidgetHelpers.setHelp((Control)this.pwdTable, "org.eclipse.rse.ui.pwdi0000");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.pwdTable.setLayout((Layout)tableLayout);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.pwdTable.setLayoutData((Object)gd);
        TableColumn hostnameColumn = new TableColumn(this.pwdTable, 0);
        hostnameColumn.setText(SystemResources.RESID_PREF_SIGNON_HOSTNAME_TITLE);
        TableColumn sysTypeColumn = new TableColumn(this.pwdTable, 0);
        sysTypeColumn.setText(SystemResources.RESID_PREF_SIGNON_SYSTYPE_TITLE);
        TableColumn useridColumn = new TableColumn(this.pwdTable, 0);
        useridColumn.setText(SystemResources.RESID_PREF_SIGNON_USERID_TITLE);
        this.pwdTableViewer = new TableViewer(this.pwdTable);
        this.pwdTableViewer.setContentProvider((IContentProvider)this.provider);
        this.pwdTableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.pwdTableViewer.setInput((Object)this.passwords);
        Composite buttonBar = SystemWidgetHelpers.createComposite(page, 1);
        gd = (GridData)buttonBar.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        this.addButton = SystemWidgetHelpers.createPushButton(buttonBar, this, SystemResources.RESID_PREF_SIGNON_ADD_LABEL, SystemResources.RESID_PREF_SIGNON_ADD_TOOLTIP);
        this.changeButton = SystemWidgetHelpers.createPushButton(buttonBar, this, SystemResources.RESID_PREF_SIGNON_CHANGE_LABEL, SystemResources.RESID_PREF_SIGNON_CHANGE_TOOLTIP);
        this.removeButton = SystemWidgetHelpers.createPushButton(buttonBar, this, SystemResources.RESID_PREF_SIGNON_REMOVE_LABEL, SystemResources.RESID_PREF_SIGNON_REMOVE_TOOLTIP);
        this.changeButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        SystemWidgetHelpers.setHelp((Control)this.addButton, "org.eclipse.rse.ui.pwdi0000");
        SystemWidgetHelpers.setHelp((Control)this.changeButton, "org.eclipse.rse.ui.pwdi0000");
        SystemWidgetHelpers.setHelp((Control)this.removeButton, "org.eclipse.rse.ui.pwdi0000");
        SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.pwdi0000");
        SystemWidgetHelpers.setMnemonics(parent);
        return parent;
    }

    public void init(IWorkbench workbench) {
        this.passwords = PasswordPersistenceManager.getInstance().getSavedUserIDs();
        if (this.pwdTableViewer != null) {
            this.pwdTableViewer.refresh();
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.addButton) {
                SystemPasswordPersistencePrompt dialog = new SystemPasswordPersistencePrompt(this.getShell(), SystemResources.RESID_PREF_SIGNON_ADD_DIALOG_TITLE, this.passwords, false);
                if (dialog.open() == 0) {
                    SystemSignonInformation info = dialog.getSignonInformation();
                    this.passwords.add(info);
                    this.modifications.add(new PasswordModification(1, info));
                    this.pwdTableViewer.refresh();
                    this.pwdTable.select(this.passwords.size() - 1);
                }
            } else if (event.widget == this.changeButton) {
                SystemPasswordPersistencePrompt dialog = new SystemPasswordPersistencePrompt(this.getShell(), SystemResources.RESID_PREF_SIGNON_CHANGE_DIALOG_TITLE, this.passwords, true);
                int index = this.pwdTable.getSelectionIndex();
                SystemSignonInformation info = (SystemSignonInformation)this.passwords.get(index);
                dialog.setInputData(info.getSystemType(), info.getHostname(), info.getUserid());
                if (dialog.open() == 0) {
                    info = dialog.getSignonInformation();
                    SystemSignonInformation oldInfo = (SystemSignonInformation)this.passwords.remove(index);
                    this.passwords.add(index, info);
                    this.modifications.add(new PasswordModification(2, oldInfo));
                    this.modifications.add(new PasswordModification(1, info));
                    this.pwdTableViewer.refresh();
                    this.pwdTable.select(index);
                }
            } else if (event.widget == this.removeButton) {
                int[] indicies = this.pwdTable.getSelectionIndices();
                int idx = indicies.length - 1;
                while (idx >= 0) {
                    PasswordPersistenceManager.getInstance().remove((SystemSignonInformation)this.passwords.get(indicies[idx]));
                    this.modifications.add(new PasswordModification(2, (SystemSignonInformation)this.passwords.remove(indicies[idx])));
                    --idx;
                }
                this.pwdTableViewer.refresh();
            }
            switch (this.pwdTable.getSelectionCount()) {
                case 0: {
                    this.changeButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.changeButton.setEnabled(true);
                    this.removeButton.setEnabled(true);
                    break;
                }
                default: {
                    this.changeButton.setEnabled(false);
                    this.removeButton.setEnabled(true);
                }
            }
        }
    }

    public boolean performOk() {
        if (this.modifications.size() > 0) {
            PasswordPersistenceManager manager = PasswordPersistenceManager.getInstance();
            IHost[] connections = RSEUIPlugin.getTheSystemRegistry().getHosts();
            int i = 0;
            while (i < this.modifications.size()) {
                PasswordModification mod = (PasswordModification)this.modifications.get(i);
                if (mod.changeFlag == 1) {
                    manager.add(mod.info, true);
                    if (connections != null) {
                        int j = 0;
                        while (j < connections.length) {
                            ISubSystem[] subsystems;
                            if (connections[j].getHostName().equalsIgnoreCase(mod.info.getHostname()) && (subsystems = connections[j].getSubSystems()) != null) {
                                int k = 0;
                                while (k < subsystems.length) {
                                    IConnectorService system = subsystems[k].getConnectorService();
                                    if (system != null) {
                                        system.clearPasswordCache();
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                } else if (mod.changeFlag == 2) {
                    manager.remove(mod.info);
                }
                ++i;
            }
            this.modifications.clear();
        }
        return super.performOk();
    }

    public boolean performCancel() {
        this.modifications.clear();
        return super.performCancel();
    }

    private final class PasswordContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private PasswordContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SignonPreferencePage.this.passwords.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((SystemSignonInformation)element).getHostname();
                }
                case 1: {
                    return ((SystemSignonInformation)element).getSystemType();
                }
                case 2: {
                    return ((SystemSignonInformation)element).getUserid();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class PasswordModification {
        protected static final int ADD = 1;
        protected static final int DELETE = 2;
        protected int changeFlag;
        protected SystemSignonInformation info;

        protected PasswordModification(int changeFlag, SystemSignonInformation info) {
            this.changeFlag = changeFlag;
            this.info = info;
        }
    }
}

