/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.AbstractSystemSubSystemPropertyPageCoreForm;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.rse.ui.widgets.SystemPortPrompt;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class SystemSubSystemPropertyPageCoreForm
extends AbstractSystemSubSystemPropertyPageCoreForm {
    protected SystemPortPrompt portPrompt;
    protected Label labelUserId;
    protected Label labelUserIdPrompt;
    protected InheritableEntryField textUserId;
    protected boolean portEditable = true;
    protected boolean portApplicable = true;
    protected boolean userIdApplicable = true;
    protected ISystemValidator portValidator;
    protected ISystemValidator userIdValidator;
    static /* synthetic */ Class class$0;

    public SystemSubSystemPropertyPageCoreForm(ISystemMessageLine msgLine, Object caller) {
        super(msgLine, caller);
    }

    public Control createInner(Composite composite_prompts, Object inputElement, Shell shell) {
        this.shell = shell;
        this.inputElement = inputElement;
        this.portPrompt = new SystemPortPrompt(composite_prompts, this.msgLine, true, this.isPortEditable(), this.getSubSystem().getConnectorService().getPort(), this.getPortValidator());
        String temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_SUBSYSTEM_USERID_LABEL);
        this.labelUserIdPrompt = SystemWidgetHelpers.createLabel(composite_prompts, temp);
        this.userIdApplicable = this.isUserIdApplicable();
        if (this.userIdApplicable) {
            this.textUserId = SystemWidgetHelpers.createInheritableTextField(composite_prompts, SystemResources.RESID_SUBSYSTEM_USERID_INHERITBUTTON_TIP, SystemResources.RESID_SUBSYSTEM_USERID_TIP);
            this.textUserId.setFocus();
        } else {
            this.labelUserId = SystemWidgetHelpers.createLabel(composite_prompts, this.getTranslatedNotApplicable());
        }
        if (!this.initDone) {
            this.doInitializeFields();
        }
        if (this.textUserId != null) {
            this.textUserId.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemSubSystemPropertyPageCoreForm.this.validateUserIdInput();
                }
            });
        }
        return composite_prompts;
    }

    public Control getInitialFocusControl() {
        if (this.portPrompt.isEditable()) {
            return this.portPrompt.getPortField();
        }
        if (this.userIdApplicable) {
            return this.textUserId;
        }
        return null;
    }

    protected boolean isPortEditable() {
        return this.getSubSystem().getSubSystemConfiguration().isPortEditable();
    }

    protected boolean isUserIdApplicable() {
        return this.getSubSystem().getConnectorService().supportsUserId();
    }

    private ISystemValidator getPortValidator() {
        if (this.portValidator == null) {
            ISubSystemConfiguration ssFactory = this.getSubSystem().getSubSystemConfiguration();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz);
            this.portValidator = adapter.getPortValidator(ssFactory);
        }
        return this.portValidator;
    }

    protected void doInitializeFields() {
        this.initDone = true;
        ISubSystem ss = this.getSubSystem();
        ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz);
        this.userIdValidator = adapter.getUserIdValidator(ssFactory);
        this.labelVendor.setText(ssFactory.getVendor());
        this.labelName.setText(ss.getName());
        this.labelConnection.setText(ss.getHostAliasName());
        this.labelProfile.setText(ss.getSystemProfileName());
        if (this.userIdApplicable) {
            String localUserId = ss.getLocalUserId();
            this.textUserId.setLocalText(localUserId);
            String parentUserId = ss.getHost().getDefaultUserId();
            this.textUserId.setInheritedText(String.valueOf(parentUserId) + " " + SystemPropertyResources.RESID_PROPERTY_INHERITED);
            this.textUserId.setLocal(localUserId != null && localUserId.length() > 0);
        }
    }

    public void doInitializeInnerFields() {
        this.initDone = true;
        ISubSystem ss = this.getSubSystem();
        ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz);
        this.userIdValidator = adapter.getUserIdValidator(ssFactory);
        if (this.userIdApplicable) {
            String localUserId = ss.getLocalUserId();
            this.textUserId.setLocalText(localUserId);
            String parentUserId = ss.getHost().getDefaultUserId();
            this.textUserId.setInheritedText(String.valueOf(parentUserId) + " " + SystemPropertyResources.RESID_PROPERTY_INHERITED);
            this.textUserId.setLocal(localUserId != null && localUserId.length() > 0);
        }
    }

    protected SystemMessage validateUserIdInput() {
        this.errorMessage = null;
        if (this.textUserId != null) {
            if (!this.textUserId.isLocal()) {
                return null;
            }
            if (this.userIdValidator != null) {
                this.errorMessage = this.userIdValidator.validate(this.textUserId.getText());
            } else if (this.getUserId().equals("")) {
                this.errorMessage = RSEUIPlugin.getPluginMessage("RSEG1025");
            }
        }
        this.setErrorMessage(this.errorMessage);
        return this.errorMessage;
    }

    protected String getUserId() {
        return this.textUserId.getText().trim();
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            pageComplete = this.getUserId().length() > 0 && this.portPrompt.isComplete();
        }
        return pageComplete;
    }

    public void setPageComplete() {
        boolean complete = this.isPageComplete();
        if (this.callerInstanceOfWizardPage) {
            ((WizardPage)this.caller).setPageComplete(complete);
        } else if (this.callerInstanceOfSystemPromptDialog) {
            ((SystemPromptDialog)this.caller).setPageComplete(complete);
        } else if (this.callerInstanceOfPropertyPage) {
            ((PropertyPage)this.caller).setValid(complete);
        }
    }

    public boolean verifyFormContents() {
        boolean ok = true;
        SystemMessage errMsg = null;
        Control controlInError = null;
        this.clearErrorMessage();
        errMsg = this.portPrompt.validatePortInput();
        if (errMsg != null) {
            controlInError = this.portPrompt.getPortField();
        } else {
            errMsg = this.validateUserIdInput();
            if (errMsg != null) {
                controlInError = this.textUserId.getTextField();
            }
        }
        if (errMsg != null) {
            ok = false;
            controlInError.setFocus();
            this.setErrorMessage(errMsg);
        }
        return ok;
    }

    public boolean performOk() {
        boolean ok = this.verifyFormContents();
        if (ok) {
            ISubSystem ss = this.getSubSystem();
            if (this.portPrompt.isEditable()) {
                this.updatePort(ss);
            }
            if (this.textUserId != null) {
                this.getUserId();
                this.updateUserId(ss);
            }
            ss.commit();
        }
        return ok;
    }

    private void updateUserId(ISubSystem subsys) {
        String userId = this.textUserId.getLocalText();
        ISubSystemConfiguration ssFactory = subsys.getSubSystemConfiguration();
        ssFactory.updateSubSystem(subsys, true, userId, false, subsys.getConnectorService().getPort());
    }

    private void updatePort(ISubSystem subsys) {
        int portInteger = this.portPrompt.getPort();
        ISubSystemConfiguration ssFactory = subsys.getSubSystemConfiguration();
        ssFactory.updateSubSystem(subsys, false, subsys.getLocalUserId(), true, portInteger);
    }

    private String getTranslatedNotApplicable() {
        if (this.xlatedNotApplicable == null) {
            this.xlatedNotApplicable = SystemPropertyResources.RESID_TERM_NOTAPPLICABLE;
        }
        return this.xlatedNotApplicable;
    }

    private void setErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            if (msg != null) {
                this.msgLine.setErrorMessage(msg);
            } else {
                this.msgLine.clearErrorMessage();
            }
        }
    }

    private void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
    }
}

