/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.discovery.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.tm.discovery.transport.ITransport;

public class UDPTransport
implements ITransport {
    public static int MDNS_PORT = 5353;
    public static String MULTICAST_ADDRESS = "224.0.0.251";
    private DatagramSocket socket = null;
    private InetAddress server = null;
    private int port = MDNS_PORT;

    public UDPTransport() {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void setTargetAddress(String address) throws UnknownHostException {
        Pattern pattern = Pattern.compile("([^:]*)(:(\\d+))?");
        Matcher matcher = pattern.matcher(address);
        if (matcher.matches()) {
            this.server = InetAddress.getByName(matcher.group(1));
            if (this.server.isLoopbackAddress()) {
                this.server = InetAddress.getLocalHost();
            }
            if (matcher.groupCount() == 3 && matcher.group(3) != null) {
                this.port = Integer.parseInt(matcher.group(3));
            }
        }
    }

    public void setTimeOut(int timeOut) throws SocketException {
        this.socket.setSoTimeout(timeOut);
    }

    public void send(byte[] packet) throws IOException {
        DatagramPacket packetOut = new DatagramPacket(packet, packet.length, this.server, this.port);
        this.socket.send(packetOut);
    }

    public String receive(byte[] packet) throws IOException {
        DatagramPacket packetIn = new DatagramPacket(packet, packet.length);
        this.socket.receive(packetIn);
        return packetIn.getAddress().getHostAddress();
    }
}

