/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.view;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.ISettingsPage;
import org.eclipse.tm.terminal.ITerminalConnector;
import org.eclipse.tm.terminal.internal.view.PageBook;
import org.eclipse.tm.terminal.internal.view.ViewMessages;

class TerminalSettingsDlg
extends Dialog {
    private Combo fCtlConnTypeCombo;
    private final ITerminalConnector[] fConnectors;
    private final ISettingsPage[] fPages;
    private int fSelectedConnector;
    private PageBook fPageBook;

    public TerminalSettingsDlg(Shell shell, ITerminalConnector[] connectors, ITerminalConnector connector) {
        super(shell);
        this.fConnectors = connectors;
        this.fPages = new ISettingsPage[this.fConnectors.length];
        int i = 0;
        while (i < this.fConnectors.length) {
            this.fPages[i] = this.fConnectors[i].makeSettingsPage();
            if (this.fConnectors[i] == connector) {
                this.fSelectedConnector = i;
            }
            ++i;
        }
    }

    protected void okPressed() {
        if (!this.validateSettings()) {
            return;
        }
        if (this.fSelectedConnector >= 0) {
            this.fPages[this.fSelectedConnector].saveSettings();
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.fSelectedConnector = -1;
        super.cancelPressed();
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ViewMessages.TERMINALSETTINGS);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ctlComposite = (Composite)super.createDialogArea(parent);
        this.setupPanel(ctlComposite);
        this.setupListeners();
        this.initFields();
        return ctlComposite;
    }

    private void initFields() {
        int i = 0;
        while (i < this.fPages.length) {
            String name = this.fPages[i].getName();
            this.fCtlConnTypeCombo.add(name);
            if (this.fSelectedConnector == i) {
                this.fCtlConnTypeCombo.select(i);
                this.selectPage(i);
            }
            ++i;
        }
    }

    private boolean validateSettings() {
        if (this.fSelectedConnector < 0) {
            return true;
        }
        return this.fPages[this.fSelectedConnector].validateSettings();
    }

    private void setupPanel(Composite wndParent) {
        this.setupConnTypePanel(wndParent);
        this.setupSettingsGroup(wndParent);
    }

    private void setupConnTypePanel(Composite wndParent) {
        Group wndGroup = new Group(wndParent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        GridData gridData = new GridData(768);
        wndGroup.setLayout((Layout)gridLayout);
        wndGroup.setLayoutData((Object)gridData);
        wndGroup.setText(String.valueOf(ViewMessages.CONNECTIONTYPE) + ":");
        this.fCtlConnTypeCombo = new Combo((Composite)wndGroup, 12);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fCtlConnTypeCombo.setLayoutData((Object)gridData);
    }

    private void setupSettingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        group.setText(String.valueOf(ViewMessages.SETTINGS) + ":");
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fPageBook = new PageBook((Composite)group, 0);
        int i = 0;
        while (i < this.fPages.length) {
            this.fPages[i].createControl((Composite)this.fPageBook);
            ++i;
        }
    }

    private void setupListeners() {
        this.fCtlConnTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TerminalSettingsDlg.this.selectPage(TerminalSettingsDlg.this.fCtlConnTypeCombo.getSelectionIndex());
            }
        });
    }

    public ITerminalConnector getConnector() {
        if (this.fSelectedConnector >= 0) {
            return this.fConnectors[this.fSelectedConnector];
        }
        return null;
    }

    private void selectPage(int index) {
        this.fSelectedConnector = index;
        Control[] pages = this.fPageBook.getChildren();
        this.fPageBook.showPage(pages[this.fSelectedConnector]);
    }
}

