/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.view;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TerminalViewPlugin
extends AbstractUIPlugin {
    protected static TerminalViewPlugin fDefault;
    public static final String PLUGIN_HOME = "org.eclipse.tm.terminal";
    public static final String HELP_VIEW = "org.eclipse.tm.terminal.terminal_view";

    public TerminalViewPlugin() {
        fDefault = this;
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("TerminalViewNewTerminal", "newterminal.gif");
            map.put("ImageClclConnect", "connect_co.gif");
            map.put("ImageClclDisconnect", "disconnect_co.gif");
            map.put("ImageClclSettings", "properties_tsk.gif");
            this.loadImageRegistry(imageRegistry, "clcl16/", map);
            map.clear();
            map.put("TerminalViewNewTerminal", "newterminal.gif");
            map.put("ImageElclConnect", "connect_co.gif");
            map.put("ImageElclDisconnect", "disconnect_co.gif");
            map.put("ImageElclSettings", "properties_tsk.gif");
            this.loadImageRegistry(imageRegistry, "elcl16/", map);
            map.clear();
            map.put("TerminalViewNewTerminal", "newterminal.gif");
            map.put("ImageDlclConnect", "connect_co.gif");
            map.put("ImageDlclDisconnect", "disconnect_co.gif");
            map.put("ImageDlclSettings", "properties_tsk.gif");
            this.loadImageRegistry(imageRegistry, "dlcl16/", map);
            map.clear();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("TerminalPrefLimitOutput", true);
        store.setDefault("TerminalPrefBufferLines", 1000);
        store.setDefault("TerminalPrefTimeoutSerial", 5);
        store.setDefault("TerminalPrefTimeoutNetwork", 5);
    }

    public static TerminalViewPlugin getDefault() {
        return fDefault;
    }

    public static boolean isLogInfoEnabled() {
        return TerminalViewPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/info");
    }

    public static boolean isLogErrorEnabled() {
        return TerminalViewPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/error");
    }

    public static boolean isLogEnabled() {
        return TerminalViewPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log");
    }

    public static boolean isOptionEnabled(String strOption) {
        String strEnabled = Platform.getDebugOption((String)strOption);
        if (strEnabled == null) {
            return false;
        }
        Boolean boolEnabled = new Boolean(strEnabled);
        boolean bEnabled = boolEnabled;
        return bEnabled;
    }

    protected void loadImageRegistry(ImageRegistry imageRegistry, String strDir, HashMap map) throws MalformedURLException {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String strKey = (String)keys.next();
            String strFile = (String)map.get(strKey);
            if (strFile == null) continue;
            URL url = TerminalViewPlugin.getDefault().getBundle().getEntry("icons/" + strDir + strFile);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            imageRegistry.put(strKey, imageDescriptor);
        }
    }
}

