/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ImageFigure
extends Figure {
    protected Image image;
    protected boolean useParentImageFigure = false;

    public ImageFigure() {
        this.setPreferredSize(10, 10);
    }

    public void setImage(Image newImage) {
        if (this.image != null && !this.image.isDisposed() && this.image == newImage) {
            return;
        }
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = newImage;
        if (this.image == null) {
            this.setPreferredSize(10, 10);
        } else {
            org.eclipse.swt.graphics.Rectangle bounds = newImage.getBounds();
            this.setPreferredSize(bounds.width, bounds.height);
        }
        this.revalidate();
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setUseParentImageFigure(boolean aBool) {
        if (this.useParentImageFigure == aBool) {
            return;
        }
        this.useParentImageFigure = aBool;
        this.image = null;
        this.setPreferredSize(10, 10);
        this.revalidate();
        this.repaint();
    }

    protected void paintClientArea(Graphics g) {
        Rectangle r = this.getClientArea();
        if (!r.isEmpty() && this.image != null && !this.image.isDisposed()) {
            g.drawImage(this.image, r.x, r.y);
        } else if (this.useParentImageFigure) {
            Image parentImage;
            ImageFigure parentImageFigure = null;
            IFigure parent = this.getParent();
            while (parent != null) {
                if (parent instanceof ImageFigure && ((ImageFigure)parent).getImage() != null) {
                    parentImageFigure = (ImageFigure)parent;
                    break;
                }
                parent = parent.getParent();
            }
            if (parentImageFigure != null && (parentImage = parentImageFigure.getImage()) != null) {
                Rectangle parentr = parentImageFigure.getClientArea();
                Image pImage = parentImageFigure.getImage();
                org.eclipse.swt.graphics.Rectangle pBounds = pImage.getBounds();
                parentr.setSize(Math.min(parentr.width, pBounds.width), Math.min(parentr.height, pBounds.height));
                r = r.intersect(parentr);
                g.drawImage(pImage, r.x - parentr.x, r.y - parentr.y, r.width, r.height, r.x, r.y, r.width, r.height);
            }
        }
        super.paintClientArea(g);
    }
}

