/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.ICLRFactory;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IDataProviderFactory;
import org.eclipse.e4.xwt.IEventGroup;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.INamespaceHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.IUIMold;
import org.eclipse.e4.xwt.IXWTInitializer;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.XWTLoaderManager;
import org.eclipse.e4.xwt.callback.IBeforeParsingCallback;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.databinding.IBindingContext;
import org.eclipse.e4.xwt.input.ICommand;
import org.eclipse.e4.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWT {
    private static List<IXWTInitializer> initializers = null;
    private static Thread displayThread;
    private static final Object displayLock;

    static {
        displayLock = new Object();
    }

    public static ILogger getLogger() {
        return XWTLoaderManager.getActive().getLogger();
    }

    public static Object createUIProfile() {
        return XWTLoaderManager.getActive().createUIProfile();
    }

    public static boolean applyProfile(Object profile) {
        return XWTLoaderManager.getActive().applyProfile(profile);
    }

    public static Object restoreProfile() {
        return XWTLoaderManager.getActive().restoreProfile();
    }

    public static void registerNamespaceHandler(String nsmapace, INamespaceHandler handler) {
        XWTLoaderManager.getActive().registerNamespaceHandler(nsmapace, handler);
    }

    public static void unregisterNamespaceHandler(String nsmapace) {
        XWTLoaderManager.getActive().unregisterNamespaceHandler(nsmapace);
    }

    public static INamespaceHandler getNamespaceHandler(String nsmapace) {
        return XWTLoaderManager.getActive().getNamespaceHandler(nsmapace);
    }

    public static boolean addObservableChangeListener(Object context, IChangeListener listener) {
        return XWTLoaderManager.getActive().addObservableChangeListener(context, listener);
    }

    public static void removeObservableChangeListener(Object context, IChangeListener listener) {
        XWTLoaderManager.getActive().removeObservableChangeListener(context, listener);
    }

    public static IObservableValue findObservableValue(Object context, Object data, String propertyName) {
        return XWTLoaderManager.getActive().findObservableValue(context, data, propertyName);
    }

    public static IObservableList findObservableList(Object context, Object data, String propertyName) {
        return XWTLoaderManager.getActive().findObservableList(context, data, propertyName);
    }

    public static IObservableSet findObservableSet(Object context, Object data, String propertyName) {
        return XWTLoaderManager.getActive().findObservableSet(context, data, propertyName);
    }

    public static IObservableValue observableValue(Object context, Object data, String propertyName, UpdateSourceTrigger updateSourceTrigger) {
        return XWTLoaderManager.getActive().observableValue(context, data, propertyName, updateSourceTrigger);
    }

    public static IObservable observe(Object context, Object data, String propertyName, UpdateSourceTrigger updateSourceTrigger) {
        return XWTLoaderManager.getActive().observe(context, data, propertyName, updateSourceTrigger);
    }

    public static IObservableFactory observableFactory(Object context, String propertyName, UpdateSourceTrigger updateSourceTrigger) {
        return XWTLoaderManager.getActive().observableFactory(context, propertyName, updateSourceTrigger);
    }

    public static IObservableValue observableValue(Object context, Object data, String propertyName) {
        return XWTLoaderManager.getActive().observableValue(context, data, propertyName, UpdateSourceTrigger.Default);
    }

    public static void setLogger(ILogger log) {
        XWTLoaderManager.getActive().setLogger(log);
    }

    public static String getElementName(Object object) {
        return XWTLoaderManager.getActive().getElementName(object);
    }

    public static Object findElementByName(Object context, String name) {
        return XWTLoaderManager.getActive().findElementByName(context, name);
    }

    public static Object getDataContext(Object element, Class<?> targetType) {
        Object value = XWTLoaderManager.getActive().getDataContext(element);
        if (targetType == null || !targetType.isInstance(value)) {
            if (value instanceof IBinding) {
                return ((IBinding)value).getValue(targetType);
            }
            if (value instanceof IObservableValue) {
                return ((IObservableValue)value).getValue();
            }
        }
        return value;
    }

    public static IBindingContext getBindingContext(Object element) {
        return XWTLoaderManager.getActive().getBindingContext(element);
    }

    public static Object getDataContext(Object element) {
        return XWT.getDataContext(element, null);
    }

    public static TriggerBase[] getTriggers(Widget element) {
        return XWTLoaderManager.getActive().getTriggers(element);
    }

    public static void setTriggers(Widget element, TriggerBase[] triggers) {
        XWTLoaderManager.getActive().setTriggers(element, triggers);
    }

    public static Object getCLR(Widget widget) {
        return XWTLoaderManager.getActive().getCLR(widget);
    }

    public static Shell findShell(Widget context) {
        return XWTLoaderManager.getActive().findShell(context);
    }

    public static IProperty findProperty(Object object, String name) {
        IMetaclass metaclass = XWTLoaderManager.getActive().getMetaclass(object);
        return metaclass.findProperty(name);
    }

    public static Object findResource(Object object, String name) {
        return XWTLoaderManager.getActive().findResource(object, name);
    }

    public static Map<String, Object> getResources(Object object) {
        return XWTLoaderManager.getActive().getResources(object);
    }

    public static IEvent findEvent(Object object, String name) {
        IMetaclass metaclass = XWTLoaderManager.getActive().getMetaclass(object);
        return metaclass.findEvent(name);
    }

    public static IMetaclass getMetaclass(Object object) {
        return XWTLoaderManager.getActive().getMetaclass(object);
    }

    public static Control load(URL file) throws Exception {
        XWT.checkInitialization();
        return XWTLoaderManager.getActive().load(file);
    }

    public static Control load(IUIMold mold) throws Exception {
        XWT.checkInitialization();
        return XWTLoaderManager.getActive().load(mold);
    }

    public static Control load(URL file, Object dataContext) throws Exception {
        XWT.checkInitialization();
        return XWTLoaderManager.getActive().load(file, dataContext);
    }

    public static Control load(IUIMold mold, Object dataContext) throws Exception {
        XWT.checkInitialization();
        return XWTLoaderManager.getActive().load(mold, dataContext);
    }

    public static Control load(Composite parent, URL file) throws Exception {
        return XWTLoaderManager.getActive().load(parent, file);
    }

    public static Control load(Composite parent, IUIMold mold) throws Exception {
        return XWTLoaderManager.getActive().load(parent, mold);
    }

    public static Control load(Composite parent, URL file, Object dataContext) throws Exception {
        return XWTLoaderManager.getActive().load(parent, file, dataContext);
    }

    public static IUIMold loadAsMold(InputStream stream, URL input, IBeforeParsingCallback parsingCallback) throws Exception {
        return XWTLoaderManager.getActive().loadAsMold(stream, input, parsingCallback);
    }

    public static IUIMold loadAsMold(InputStream stream, URL input) throws Exception {
        return XWTLoaderManager.getActive().loadAsMold(stream, input);
    }

    public static IUIMold loadAsMold(URL input, IBeforeParsingCallback parsingCallback) throws Exception {
        return XWTLoaderManager.getActive().loadAsMold(null, input, parsingCallback);
    }

    public static IUIMold loadAsMold(URL input) throws Exception {
        return XWTLoaderManager.getActive().loadAsMold(null, input);
    }

    public static Control load(Composite parent, IUIMold mold, Object dataContext) throws Exception {
        return XWTLoaderManager.getActive().load(parent, mold, dataContext);
    }

    public static Control load(Composite parent, IUIMold mold, Map<String, Object> options) throws Exception {
        return XWTLoaderManager.getActive().load(parent, mold, options);
    }

    public static void open(URL url) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(url);
    }

    public static void open(Class<?> type) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(type);
    }

    public static void open(IUIMold mold) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(mold);
    }

    public static Control load(Composite parent, InputStream stream, URL file, Object dataContext) throws Exception {
        return XWTLoaderManager.getActive().load(parent, stream, file, dataContext);
    }

    public static void open(URL url, Object dataContext) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(url, dataContext);
    }

    public static void open(IUIMold mold, Object dataContext) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(mold, dataContext);
    }

    public static void open(Class<?> type, Object dataContext) throws Exception {
        XWT.open(type.getResource(String.valueOf(type.getSimpleName()) + ".xwt"), dataContext);
    }

    public static void open(URL url, Map<String, Object> options) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(url, options);
    }

    public static void open(IUIMold mold, Map<String, Object> options) throws Exception {
        XWT.checkInitialization();
        XWTLoaderManager.getActive().open(mold, options);
    }

    public static Object convertFrom(Class<?> targetType, String string) {
        return XWTLoaderManager.getActive().convertFrom(targetType, string);
    }

    public static Control loadWithOptions(URL url, Map<String, Object> options) throws Exception {
        return XWTLoaderManager.getActive().loadWithOptions(url, options);
    }

    public static Control loadWithOptions(IUIMold mold, Map<String, Object> options) throws Exception {
        return XWTLoaderManager.getActive().loadWithOptions(mold, options);
    }

    public static Control load(InputStream stream, URL url) throws Exception {
        XWT.checkInitialization();
        return XWT.loadWithOptions(stream, url, Collections.EMPTY_MAP);
    }

    public static Control loadWithOptions(InputStream stream, URL url, Map<String, Object> options) throws Exception {
        XWT.checkInitialization();
        return XWTLoaderManager.getActive().loadWithOptions(stream, url, options);
    }

    public static IMetaclass[] getAllMetaclasses() {
        return XWTLoaderManager.getActive().getAllMetaclasses();
    }

    public static IMetaclass getMetaclass(String tagName, String ns) {
        return XWTLoaderManager.getActive().getMetaclass(tagName, ns);
    }

    public static void registerEventGroup(Class<?> type, IEventGroup eventGroup) {
        XWTLoaderManager.getActive().registerEventGroup(type, eventGroup);
    }

    public static void registerConvertor(IConverter converter) {
        XWTLoaderManager.getActive().registerConvertor(converter);
    }

    public static void registerCommand(String name, ICommand command) {
        XWTLoaderManager.getActive().registerCommand(name, command);
    }

    public static void addDefaultStyle(IStyle style) {
        XWTLoaderManager.getActive().addDefaultStyle(style);
    }

    public static void addDataProviderFactory(String name, IDataProviderFactory dataProviderFactory) {
        XWTLoaderManager.getActive().addDataProviderFactory(name, dataProviderFactory);
    }

    public static void removeDataProviderFactory(String name) {
        XWTLoaderManager.getActive().removeDataProviderFactory(name);
    }

    public static void removeDataProviderFactory(IDataProviderFactory dataProviderFactory) {
        XWTLoaderManager.getActive().removeDataProviderFactory(dataProviderFactory);
    }

    public static Collection<IDataProviderFactory> getDataProviderFactories() {
        return XWTLoaderManager.getActive().getDataProviderFactories();
    }

    public static IMetaclass registerMetaclass(Class<?> type) {
        return XWTLoaderManager.getActive().registerMetaclass(type);
    }

    public static void registerMetaclass(IMetaclass type) {
        XWTLoaderManager.getActive().registerMetaclass(type);
    }

    public static Object getPropertyValue(Object uiElement, IProperty property) {
        return XWTLoaderManager.getActive().getPropertyValue(uiElement, property);
    }

    public static Object getPropertyValue(Object uiElement, String propertyName) {
        IMetaclass metaclass = XWT.getMetaclass(uiElement);
        IProperty property = metaclass.findProperty(propertyName);
        if (property == null) {
            return null;
        }
        return XWTLoaderManager.getActive().getPropertyValue(uiElement, property);
    }

    public static void setPropertyValue(Object uiElement, IProperty property, Object value) {
        XWTLoaderManager.getActive().setPropertyValue(uiElement, property, value);
    }

    public static void setPropertyValue(Object uiElement, String propertyName, Object value) {
        IMetaclass metaclass = XWT.getMetaclass(uiElement);
        IProperty property = metaclass.findProperty(propertyName);
        if (property == null) {
            throw new XWTException("Property " + propertyName + " not found.");
        }
        XWTLoaderManager.getActive().setPropertyValue(uiElement, property, value);
    }

    public static void removePropertyValue(Object uiElement, IProperty property) {
        XWTLoaderManager.getActive().removePropertyValue(uiElement, property);
    }

    public static boolean hasPropertyValue(Object uiElement, IProperty property) {
        return XWTLoaderManager.getActive().hasPropertyValue(uiElement, property);
    }

    public static IConverter findConvertor(Class<?> source, Class<?> target) {
        return XWTLoaderManager.getActive().findConvertor(source, target);
    }

    public static void setLoadingContext(ILoadingContext loadingContext) {
        XWTLoaderManager.getActive().setLoadingContext(loadingContext);
    }

    public static ILoadingContext getLoadingContext() {
        return XWTLoaderManager.getActive().getLoadingContext();
    }

    public static void addTracking(Tracking tracking) {
        XWTLoaderManager.getActive().addTracking(tracking);
    }

    public static boolean isTracking(Tracking tracking) {
        return XWTLoaderManager.getActive().isTracking(tracking);
    }

    public static Set<Tracking> getTrackings() {
        return XWTLoaderManager.getActive().getTrackings();
    }

    public static void setCLRFactory(ICLRFactory factory) {
        XWTLoaderManager.getActive().setCLRFactory(factory);
    }

    public static boolean checkInitialization() {
        if (XWT.isAllInitializersInitialized()) {
            return false;
        }
        return XWT.checkInitialization(-1L);
    }

    public static boolean checkInitialization(long timeoutMillis) {
        long started = System.currentTimeMillis();
        while (timeoutMillis == -1L || System.currentTimeMillis() - started <= timeoutMillis) {
            if (XWT.isAllInitializersInitialized()) {
                return false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return false;
    }

    private static boolean isAllInitializersInitialized() {
        if (initializers == null) {
            return true;
        }
        for (IXWTInitializer initializer : initializers) {
            if (initializer.isInitialized()) continue;
            return false;
        }
        return true;
    }

    public static ICLRFactory getCLRFactory() {
        return XWTLoaderManager.getActive().getCLRFactory();
    }

    public static ICommand getCommand(String name) {
        return XWTLoaderManager.getActive().getCommand(name);
    }

    public static IDataProvider findDataProvider(Object dataContext) {
        return XWTLoaderManager.getActive().findDataProvider(dataContext);
    }

    public static Realm getRealm() {
        return XWTLoaderManager.getActive().getRealm();
    }

    public static boolean isXWTNamespace(String namespace) {
        return "http://www.eclipse.org/xwt".equals(namespace) || "http://www.eclipse.org/xwt/presentation".equals(namespace) || namespace.startsWith("clr-namespace:");
    }

    public static boolean isFileResolveType(Class<?> type) {
        return XWTLoaderManager.getActive().isFileResolveType(type);
    }

    public static void registerFileResolveType(Class<?> type) {
        XWTLoaderManager.getActive().registerFileResolveType(type);
    }

    public static void unregisterFileResolveType(Class<?> type) {
        XWTLoaderManager.getActive().unregisterFileResolveType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnUIThread(final Runnable runnable) {
        String platform = SWT.getPlatform();
        if (platform.startsWith("win")) {
            XWTLoaderManager.getDefault();
            runnable.run();
        } else if (platform.startsWith("rap")) {
            XWTLoaderManager.getDefault();
            runnable.run();
        } else if (platform.endsWith("gtk")) {
            Object object = displayLock;
            synchronized (object) {
                if (displayThread == null || !displayThread.isAlive()) {
                    displayThread = new Thread(){

                        public void run() {
                            XWTLoaderManager.getDefault();
                            runnable.run();
                            long startTime = -1L;
                            while (true) {
                                Shell[] shells;
                                if (!Display.getDefault().readAndDispatch()) {
                                    Display.getDefault().sleep();
                                }
                                if ((shells = Display.getDefault().getShells()).length == 0) {
                                    if (startTime == -1L) {
                                        startTime = System.currentTimeMillis();
                                        continue;
                                    }
                                    if (System.currentTimeMillis() - startTime <= 5000L) continue;
                                    break;
                                }
                                startTime = -1L;
                            }
                        }
                    };
                    displayThread.start();
                } else {
                    XWT.checkInitialization();
                    Display display = Display.findDisplay((Thread)displayThread);
                    if (display != null) {
                        display.syncExec(runnable);
                    }
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void addInitializer(IXWTInitializer initializer) {
        if (initializers == null) {
            initializers = new ArrayList<IXWTInitializer>();
        }
        if (!XWTLoaderManager.isStarted()) {
            initializers.add(initializer);
        }
    }

    public static List<IXWTInitializer> getInitializers() {
        if (initializers == null) {
            return Collections.EMPTY_LIST;
        }
        return initializers;
    }

    public static Object findParent(Object element, Class<?> type) {
        Widget widget = UserData.getWidget(element);
        if (widget == null) {
            return null;
        }
        return UserData.findParent(widget, type);
    }

    static class DisplayThread
    extends Thread
    implements Listener {
        protected long startTime = -1L;
        protected boolean toStop = false;
        protected Runnable runnable;

        public DisplayThread(Runnable runnable) {
            this.runnable = runnable;
        }

        public void handleEvent(Event event) {
        }
    }
}

