/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation;

import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.animation.AnimationTimeline;
import org.eclipse.e4.xwt.animation.IEasingFunction;
import org.eclipse.e4.xwt.animation.internal.ITimeline;
import org.eclipse.e4.xwt.animation.internal.TridentTimeline;
import org.eclipse.e4.xwt.animation.interpolator.PointPropertyInterpolator;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.pushingpixels.trident.TridentConfig;
import org.pushingpixels.trident.interpolator.PropertyInterpolator;

public class PointAnimation
extends AnimationTimeline {
    private Point from;
    private Point to;
    private Point by;
    private IEasingFunction easingFunction;

    static {
        TridentConfig.getInstance().addPropertyInterpolator((PropertyInterpolator)new PointPropertyInterpolator());
    }

    public IEasingFunction getEasingFunction() {
        return this.easingFunction;
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        this.easingFunction = easingFunction;
    }

    public Point getFrom() {
        return this.from;
    }

    public void setFrom(Point from) {
        this.from = from;
    }

    public Point getTo() {
        return this.to;
    }

    public void setTo(Point to) {
        this.to = to;
    }

    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        Widget widget = UserData.getWidget(target);
        if (!(widget instanceof Control)) {
            throw new XWTException("The target of the animation is not a Control.");
        }
        if (timeline instanceof TridentTimeline) {
            TridentTimeline tridentTimeline = (TridentTimeline)timeline;
            tridentTimeline.addPropertyToInterpolate(this.getTargetProperty(), this.getFrom(), this.getTo());
            tridentTimeline.setEasingFunction(this.getEasingFunction());
        }
    }
}

