/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation;

import org.eclipse.e4.xwt.animation.ParallelTimeline;
import org.eclipse.e4.xwt.animation.Timeline;
import org.eclipse.e4.xwt.animation.internal.AnimationManager;
import org.eclipse.e4.xwt.animation.internal.ITimeline;
import org.eclipse.e4.xwt.animation.internal.ITimelineGroup;
import org.eclipse.e4.xwt.animation.internal.ScenarioTimeline;
import org.eclipse.e4.xwt.animation.internal.TridentTimeline;
import org.eclipse.e4.xwt.annotation.Containment;
import org.pushingpixels.trident.TimelineScenario;

public class TimelineGroup
extends Timeline {
    private Timeline[] children = EMPTY_ARRAY;
    private ITimeline timeline;

    @Containment
    public Timeline[] getChildren() {
        return this.children;
    }

    public void setChildren(Timeline[] children) {
        this.children = children;
    }

    protected ITimelineGroup createTimelineGroup(Object target) {
        return new ScenarioTimeline(this, new TimelineScenario(), target);
    }

    public void start(Object target) {
        if (this.timeline == null) {
            this.timeline = this.createTimelineGroup(this.findTarget(target));
            this.updateTimeline(this.timeline, target);
            AnimationManager.getInstance().addTimeline(this.timeline);
        }
        AnimationManager.getInstance().play(this.timeline);
    }

    public void stop() {
        AnimationManager.getInstance().stop(this.timeline);
    }

    public void pause() {
        AnimationManager.getInstance().pause(this.timeline);
    }

    public void resume() {
        AnimationManager.getInstance().resume(this.timeline);
    }

    public void playReverse() {
        AnimationManager.getInstance().playReverse(this.timeline);
    }

    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        ITimelineGroup timelineGroup = (ITimelineGroup)timeline;
        Timeline[] timelineArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ScenarioTimeline scenarioTimeline;
            TimelineScenario.Parallel scenario;
            Timeline child = timelineArray[n2];
            if (child instanceof ParallelTimeline) {
                scenario = new TimelineScenario.Parallel();
                scenarioTimeline = new ScenarioTimeline(child, (TimelineScenario)scenario, child.findTarget(target));
                child.updateTimeline(scenarioTimeline, target);
                timelineGroup.addTimeline(scenarioTimeline);
            } else if (child instanceof TimelineGroup) {
                scenario = new TimelineScenario.Sequence();
                scenarioTimeline = new ScenarioTimeline(child, (TimelineScenario)scenario, child.findTarget(target));
                child.updateTimeline(scenarioTimeline, target);
                timelineGroup.addTimeline(scenarioTimeline);
            } else {
                TridentTimeline tridentTimeline = new TridentTimeline(child, child.findTarget(target));
                timelineGroup.addTimeline(tridentTimeline);
                child.updateTimeline(tridentTimeline, target);
            }
            ++n2;
        }
    }
}

