/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.e4.xwt.animation.RepeatBehavior;
import org.eclipse.e4.xwt.animation.Timeline;
import org.eclipse.e4.xwt.animation.internal.ITimeline;
import org.eclipse.e4.xwt.animation.internal.ITimelineGroup;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineScenarioCallback;

public class ScenarioTimeline
extends TimelineScenario
implements ITimelineGroup {
    protected TimelineScenario tridentTimelineScenario;
    protected Timeline xwtTimeline;
    protected Object target;
    protected boolean done = false;
    private Collection<ITimeline> actors = new ArrayList<ITimeline>();

    public ScenarioTimeline(Timeline xwtTimeline, TimelineScenario tridentTimelineScenario, Object target) {
        this.xwtTimeline = xwtTimeline;
        this.target = target;
        this.tridentTimelineScenario = tridentTimelineScenario;
        this.tridentTimelineScenario.addCallback(new TimelineScenarioCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimelineScenarioDone() {
                ScenarioTimeline scenarioTimeline = ScenarioTimeline.this;
                synchronized (scenarioTimeline) {
                    ScenarioTimeline.this.done = true;
                }
            }
        });
    }

    public Object getTarget() {
        return this.target;
    }

    public void play() {
        for (ITimeline timeline : this.actors) {
            timeline.resetDoneFlag();
            this.tridentTimelineScenario.addScenarioActor((TimelineScenario.TimelineScenarioActor)timeline);
        }
        this.tridentTimelineScenario.play();
    }

    public void playLoop(RepeatBehavior behavior) {
        this.tridentTimelineScenario.playLoop();
    }

    public void end() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.cancel();
        for (ITimeline timeline : this.actors) {
            timeline.end();
        }
    }

    public void cancel() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.cancel();
        for (ITimeline timeline : this.actors) {
            timeline.cancel();
        }
    }

    public void abort() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.cancel();
        for (ITimeline timeline : this.actors) {
            timeline.abort();
        }
    }

    public void pause() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.suspend();
    }

    public void resume() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.resume();
    }

    public void playReverse() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        ScenarioTimeline scenarioTimeline = this;
        synchronized (scenarioTimeline) {
            return this.done;
        }
    }

    public void resetDoneFlag() {
        this.done = false;
    }

    public boolean supportsReplay() {
        return false;
    }

    public void addTimeline(ITimeline timeline) {
        this.actors.add(timeline);
    }
}

