/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedList<K, V> {
    protected final HashMap<K, Object> internal = new HashMap();
    protected final Class<V> valueClass;
    protected final V[] empty;

    public MappedList(Class<V> valueClass) {
        this.valueClass = valueClass;
        this.empty = (Object[])Array.newInstance(valueClass, 0);
    }

    public void put(K key, V value) {
        Object existing = this.internal.get(key);
        if (existing == null) {
            this.internal.put(key, value);
        } else {
            Object[] existingValues;
            if (existing.getClass().isArray()) {
                existingValues = (Object[])existing;
            } else {
                existingValues = (Object[])Array.newInstance(this.valueClass, 1);
                existingValues[0] = existing;
            }
            int index = this.insertionIndex(existingValues, value);
            Object[] newValues = (Object[])Array.newInstance(this.valueClass, existingValues.length + 1);
            System.arraycopy(existingValues, 0, newValues, 0, index);
            newValues[index] = value;
            System.arraycopy(existingValues, index, newValues, index + 1, existingValues.length - index);
            this.internal.put(key, newValues);
        }
    }

    protected int insertionIndex(V[] existing, V value) {
        return existing.length;
    }

    public V[] remove(K key) {
        return this.get(key, true);
    }

    public V[] get(K key) {
        return this.get(key, false);
    }

    private V[] get(K key, boolean remove) {
        Object result;
        Object object = result = remove ? this.internal.remove(key) : this.internal.get(key);
        if (result != null && result.getClass().isArray()) {
            return (Object[])result;
        }
        if (result == null) {
            return this.empty;
        }
        Object[] singleValue = (Object[])Array.newInstance(this.valueClass, 1);
        singleValue[0] = result;
        return singleValue;
    }

    public int getSize() {
        return this.internal.size();
    }

    public V[] getAllValues() {
        if (this.getSize() == 0) {
            return this.empty;
        }
        ArrayList<Object> results = new ArrayList<Object>(this.getSize());
        for (Object value : this.internal.values()) {
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                int i = 0;
                while (i < values.length) {
                    results.add(values[i]);
                    ++i;
                }
                continue;
            }
            results.add(value);
        }
        return results.toArray(this.empty);
    }

    public void clear() {
        this.internal.clear();
    }
}

