/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CapabilityPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private transient Map<String, CapabilityPermission> permissions = new HashMap<String, CapabilityPermission>();
    private boolean all_allowed = false;
    private Map<String, CapabilityPermission> filterPermissions;
    private static final ObjectStreamField[] serialPersistentFields;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[3];
        try {
            clazz2 = Class.forName("java.util.Hashtable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", clazz2);
        objectStreamFieldArray[1] = new ObjectStreamField("all_allowed", Boolean.TYPE);
        try {
            clazz = Class.forName("java.util.HashMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        objectStreamFieldArray[2] = new ObjectStreamField("filterPermissions", clazz);
        serialPersistentFields = objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof CapabilityPermission)) {
            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(permission).toString());
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        CapabilityPermission sp = (CapabilityPermission)permission;
        if (sp.service != null) {
            throw new IllegalArgumentException(new StringBuffer("cannot add to collection: ").append(sp).toString());
        }
        String name = sp.getName();
        Filter f = sp.filter;
        CapabilityPermissionCollection capabilityPermissionCollection = this;
        synchronized (capabilityPermissionCollection) {
            CapabilityPermission existing;
            Map<String, CapabilityPermission> pc;
            if (f != null) {
                pc = this.filterPermissions;
                if (pc == null) {
                    this.filterPermissions = pc = new HashMap<String, CapabilityPermission>();
                }
            } else {
                pc = this.permissions;
            }
            if ((existing = pc.get(name)) != null) {
                int oldMask = existing.action_mask;
                int newMask = sp.action_mask;
                if (oldMask != newMask) {
                    pc.put(name, new CapabilityPermission(name, oldMask | newMask));
                }
            } else {
                pc.put(name, sp);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<CapabilityPermission> perms;
        if (!(permission instanceof CapabilityPermission)) {
            return false;
        }
        CapabilityPermission requested = (CapabilityPermission)permission;
        if (requested.filter != null) {
            return false;
        }
        int effective = 0;
        CapabilityPermissionCollection capabilityPermissionCollection = this;
        synchronized (capabilityPermissionCollection) {
            Map<String, CapabilityPermission> pc;
            CapabilityPermission sp;
            int desired = requested.action_mask;
            if (this.all_allowed && (sp = this.permissions.get("*")) != null && ((effective |= sp.action_mask) & desired) == desired) {
                return true;
            }
            String[] requestedNames = requested.objectClass;
            if (requestedNames == null) {
                if (((effective |= this.effective(requested.getName(), desired, effective)) & desired) == desired) {
                    return true;
                }
            } else {
                int i = 0;
                int l = requestedNames.length;
                while (i < l) {
                    if ((this.effective(requestedNames[i], desired, effective) & desired) == desired) {
                        return true;
                    }
                    ++i;
                }
            }
            if ((pc = this.filterPermissions) == null) {
                return false;
            }
            perms = pc.values();
        }
        for (CapabilityPermission perm : perms) {
            if (!perm.implies0(requested, effective)) continue;
            return true;
        }
        return false;
    }

    private int effective(String requestedName, int desired, int effective) {
        int last;
        Map<String, CapabilityPermission> pc = this.permissions;
        CapabilityPermission sp = pc.get(requestedName);
        if (sp != null && ((effective |= sp.action_mask) & desired) == desired) {
            return effective;
        }
        int offset = requestedName.length() - 1;
        while ((last = requestedName.lastIndexOf(".", offset)) != -1) {
            sp = pc.get(requestedName = new StringBuffer(String.valueOf(requestedName.substring(0, last + 1))).append("*").toString());
            if (sp != null && ((effective |= sp.action_mask) & desired) == desired) {
                return effective;
            }
            offset = last - 1;
        }
        return effective;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<CapabilityPermission> all = new ArrayList<CapabilityPermission>(this.permissions.values());
        Map<String, CapabilityPermission> pc = this.filterPermissions;
        if (pc != null) {
            all.addAll(pc.values());
        }
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, CapabilityPermission> hashtable = new Hashtable<String, CapabilityPermission>(this.permissions);
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", hashtable);
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("filterPermissions", this.filterPermissions);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        HashMap fp;
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable hashtable = (Hashtable)gfields.get("permissions", null);
        this.permissions = new HashMap<String, CapabilityPermission>(hashtable);
        this.all_allowed = gfields.get("all_allowed", false);
        this.filterPermissions = fp = (HashMap)gfields.get("filterPermissions", null);
    }
}

