/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import java.lang.reflect.Field;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;

public class DependenciesLeakTest
extends TestCase {
    static final String LEGACY_H_ID = "legacy::handler::";
    private IEclipseContext windowContext;
    private IEclipseContext perspectiveContext;
    private IEclipseContext partContext;

    protected void setUp() throws Exception {
        this.windowContext = EclipseContextFactory.create((String)"Window");
        this.perspectiveContext = this.windowContext.createChild("Perspective");
        this.partContext = this.perspectiveContext.createChild("Part");
    }

    public void testBug() {
        String handler = "<foo.bar.handler>";
        this.windowContext.set("legacy::handler::foo.bar", (Object)handler);
        this.windowContext.set("foo.bar", (Object)new HandlerSelectionFunction("foo.bar"));
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
        Object object = this.partContext.get("foo.bar");
        DependenciesLeakTest.assertEquals((Object)object, (Object)handler);
        this.windowContext.set("foo.bar", null);
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
    }

    public void testInvalidateDirectly() {
        this.windowContext.set("x", (Object)42);
        this.windowContext.set("y", (Object)11);
        this.windowContext.set("some.handler", (Object)new AddContextFunction());
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
        Object object = this.partContext.get("some.handler");
        DependenciesLeakTest.assertEquals((Object)object, (Object)53);
        this.windowContext.set("some.handler", null);
        this.assertNoListeners(this.windowContext);
        this.assertNoListeners(this.perspectiveContext);
        this.assertNoListeners(this.partContext);
    }

    private void assertNoListeners(IEclipseContext context) {
        EclipseContext c = (EclipseContext)context;
        try {
            Field field = c.getClass().getDeclaredField("listeners");
            field.setAccessible(true);
            Map listeners = (Map)field.get(c);
            DependenciesLeakTest.assertEquals((int)0, (int)listeners.size());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class HandlerSelectionFunction
    extends ContextFunction {
        private String commandId;

        public HandlerSelectionFunction(String commandId) {
            this.commandId = commandId;
        }

        public Object compute(IEclipseContext context) {
            return context.get(DependenciesLeakTest.LEGACY_H_ID + this.commandId);
        }

        public String toString() {
            return "HandlerSelectionFunction [commandId=" + this.commandId + "]";
        }
    }
}

