/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.List;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueComputation
extends Computation {
    private Object cachedValue;
    private IEclipseContext context;
    private String name;
    private boolean valid;
    private IContextFunction function;
    private EclipseContext originatingContext;
    private boolean computing;

    public ValueComputation(IEclipseContext context, IEclipseContext originatingContext, String name, IContextFunction computedValue) {
        this.context = context;
        this.originatingContext = (EclipseContext)originatingContext;
        this.name = name;
        this.function = computedValue;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.originatingContext == null ? 0 : this.originatingContext.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueComputation other = (ValueComputation)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.originatingContext == null ? other.originatingContext != null : !this.originatingContext.equals(other.originatingContext));
    }

    @Override
    protected void doHandleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
        this.valid = false;
        this.cachedValue = null;
        int eventType = event.getEventType();
        if (eventType == 3) {
            IEclipseContext eventsContext = event.getContext();
            if (this.originatingContext.equals(eventsContext)) {
                this.removeAll();
                return;
            }
            return;
        }
        if (event.getName().equals(this.name)) {
            this.originatingContext.removeLocalValueComputations(this.name, true);
        }
        this.originatingContext.invalidate(this.name, eventType == 3 ? 2 : eventType, event.getOldValue(), scheduled);
    }

    public Object get() {
        if (this.valid) {
            return this.cachedValue;
        }
        if (this.computing) {
            throw new CycleException(this.toString());
        }
        Computation oldComputation = EclipseContext.currentComputation.get();
        EclipseContext.currentComputation.set(this);
        this.computing = true;
        try {
            try {
                this.cachedValue = this.function.compute(this.originatingContext);
                this.valid = true;
            }
            catch (CycleException ex) {
                throw new CycleException(String.valueOf(ex.getCycleMessage()) + '\n' + this.toString());
            }
        }
        finally {
            this.computing = false;
            EclipseContext.currentComputation.set(oldComputation);
        }
        this.startListening();
        return this.cachedValue;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ValueComputation(");
        result.append(this.context);
        result.append('/');
        result.append(this.originatingContext);
        result.append(',');
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    static class CycleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String cycleMessage;

        CycleException(String cycleMessage) {
            super("Cycle while computing value");
            this.cycleMessage = cycleMessage;
        }

        String getCycleMessage() {
            return this.cycleMessage;
        }

        public String toString() {
            return "\n" + this.cycleMessage + '\n';
        }
    }
}

