/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import org.eclipse.e4.tm.stringconverter.AbstractStringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FontStringConverter
extends AbstractStringConverter {
    public Object convert(String source, StringConverterContext context) throws Exception {
        String[] tokens = source.split("[;, ]");
        String family = null;
        int style = 0;
        int size = 0;
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.length() != 0) {
                char c = token.charAt(0);
                if (Character.isDigit(c)) {
                    size = Integer.valueOf(token);
                } else if (Character.isLowerCase(c)) {
                    if (token.equals("bold")) {
                        style |= 1;
                    } else if (token.equals("italic")) {
                        style |= 2;
                    } else if (token.equals("plain") || token.equals("normal")) {
                        style |= 0;
                    }
                } else if (Character.isUpperCase(c)) {
                    family = token;
                }
            }
            ++i;
        }
        if (family == null || size <= 0) {
            return null;
        }
        Display display = context.adapt(null, Display.class);
        Font font = new Font((Device)display, family, size, style);
        context.registerDisposable(font);
        return font;
    }
}

