/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x.extension;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.internal.tools.wizards.classes.NewHandlerClassWizard;
import org.eclipse.e4.tools.emf.editor3x.extension.Util;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class HandlerContributionEditor
implements IContributionClassCreator {
    public void createOpen(MContribution contribution, EditingDomain domain, IProject project, Shell shell) {
        this.createOpen(contribution, domain, project, shell, false);
    }

    private void createOpen(MContribution contribution, EditingDomain domain, IProject project, Shell shell, boolean forceNew) {
        if (contribution.getContributionURI() == null || contribution.getContributionURI().trim().length() == 0 || !contribution.getContributionURI().startsWith("platform:")) {
            NewHandlerClassWizard wizard = new NewHandlerClassWizard();
            wizard.init(null, (IStructuredSelection)new StructuredSelection((Object)project));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 0) {
                IFile f = wizard.getFile();
                ICompilationUnit el = JavaCore.createCompilationUnitFrom((IFile)f);
                try {
                    String packageName = el.getPackageDeclarations()[0].getElementName();
                    String className = wizard.getDomainClass().getName();
                    Command cmd = SetCommand.create((EditingDomain)domain, (Object)contribution, (Object)ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI, (Object)("platform:/plugin/" + f.getProject().getName() + "/" + packageName + "." + className));
                    if (cmd.canExecute()) {
                        domain.getCommandStack().execute(cmd);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        } else {
            URI uri = URI.createURI((String)contribution.getContributionURI());
            if (uri.segmentCount() == 3) {
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
                if (p != null) {
                    IJavaProject jp = JavaCore.create((IProject)p);
                    try {
                        IType t = jp.findType(uri.segment(2));
                        if (t != null) {
                            JavaUI.openInEditor((IJavaElement)t);
                        } else if (MessageDialog.openQuestion((Shell)shell, (String)"Class not found", (String)("The class '" + uri.segment(2) + "' was not found. Would you like to start the class creation wizard?"))) {
                            this.createOpen(contribution, domain, project, shell, true);
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        if (MessageDialog.openQuestion((Shell)shell, (String)"Class not found", (String)("The class '" + uri.segment(2) + "' was not found. Would you like to start the class creation wizard?"))) {
                            this.createOpen(contribution, domain, project, shell, true);
                        }
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)shell, (String)"Failed to open editor", (String)e.getMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                MessageDialog.openError((Shell)shell, (String)"Invalid URL", (String)"The current url is invalid");
            }
        }
    }

    public boolean isSupported(EClass element) {
        return Util.isTypeOrSuper(CommandsPackageImpl.Literals.HANDLER, element) || Util.isTypeOrSuper(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, element) || Util.isTypeOrSuper(MenuPackageImpl.Literals.DIRECT_TOOL_ITEM, element);
    }
}

