/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.internal.workbench.ModelReconcilingService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.IModelReconcilingService;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public class E4XMIResourceFactoryTest
extends ModelReconcilerTest {
    public void testNonConflictingIds() {
        MApplication application = this.createApplication();
        this.saveModel();
        application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        E4XMIResourceFactoryTest.assertFalse((boolean)this.getId((MApplicationElement)application).equals(this.getId((MApplicationElement)window)));
    }

    public void testNonConflictingIds2() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window1 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        E4XMIResourceFactoryTest.assertEquals((int)1, (int)application.getChildren().size());
        E4XMIResourceFactoryTest.assertEquals((Object)window2, application.getChildren().get(0));
        this.applyAll(deltas);
        window1 = (MWindow)application.getChildren().get(0);
        window2 = (MWindow)application.getChildren().get(1);
        String applicationId = this.getId((MApplicationElement)application);
        String window1Id = this.getId((MApplicationElement)window1);
        String window2Id = this.getId((MApplicationElement)window2);
        E4XMIResourceFactoryTest.assertFalse((boolean)applicationId.equals(window1Id));
        E4XMIResourceFactoryTest.assertFalse((boolean)applicationId.equals(window2Id));
        E4XMIResourceFactoryTest.assertFalse((boolean)window1Id.equals(window2Id));
    }

    public void testNonConflictingIds3_Bug303841() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        command.setElementId("id");
        application.getCommands().add(command);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId("id");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        E4XMIResourceFactoryTest.assertEquals((int)0, (int)application.getChildren().size());
        E4XMIResourceFactoryTest.assertEquals((int)0, (int)application.getCommands().size());
        this.applyAll(deltas);
    }

    protected IModelReconcilingService getModelReconcilingService() {
        return new ModelReconcilingService();
    }
}

