/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor;

import java.util.List;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.DesignerMenuProvider;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.OpenBindingDialogAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.OpenExternalizeStringsAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.actions.StyleAction;
import org.eclipse.e4.xwt.tools.ui.designer.editor.menus.EventMenuManager;
import org.eclipse.e4.xwt.tools.ui.designer.editor.menus.LayoutMenuManager;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public class XWTDesignerMenuProvider
extends DesignerMenuProvider {
    private static final String BINDINGS = "Bindings";
    private static final String EXTERNALIZE = "Externalize";
    private XWTDesigner designer;

    public XWTDesignerMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry, XWTDesigner designer) {
        super(viewer, actionRegistry);
        this.designer = designer;
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.delete"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator(BINDINGS));
        menu.add((IContributionItem)new Separator(EXTERNALIZE));
        menu.add((IContributionItem)new Separator("group.additions"));
        super.menuAboutToShow(menu);
    }

    public void buildContextMenu(IMenuManager menu) {
        super.buildContextMenu(menu);
        ActionRegistry actionRegistry = this.getActionRegistry();
        List selectedEditParts = this.getViewer().getSelectedEditParts();
        if (selectedEditParts != null && !selectedEditParts.isEmpty()) {
            if (selectedEditParts.size() == 1) {
                menu.appendToGroup("group.print", actionRegistry.getAction((Object)"org.eclipse.e4.xwt.tools.ui.designer.editor.actions.PreviewAction"));
                EditPart editPart = (EditPart)selectedEditParts.get(0);
                if (this.designer.getEventHandler() != null) {
                    EventMenuManager eventPopMenu = new EventMenuManager(editPart, this.designer);
                    menu.add((IContributionItem)eventPopMenu);
                    menu.add((IContributionItem)new Separator());
                }
                LayoutMenuManager layoutPopMenu = new LayoutMenuManager(editPart, "Set Layout");
                menu.appendToGroup("group.edit", actionRegistry.getAction((Object)"org.eclipse.e4.xwt.tools.ui.designer.editor.actions.ChageTextAction"));
                menu.add((IContributionItem)layoutPopMenu);
                menu.add(actionRegistry.getAction((Object)"org.eclipse.e4.xwt.tools.ui.designer.editor.actions.LayoutAssistantAction"));
                menu.appendToGroup(BINDINGS, actionRegistry.getAction((Object)OpenBindingDialogAction.ID));
                if (editPart instanceof WidgetEditPart) {
                    menu.appendToGroup("group.edit", (IAction)new StyleAction((WidgetEditPart)editPart));
                }
            }
            menu.appendToGroup("group.additions", actionRegistry.getAction((Object)"org.eclipse.e4.xwt.tools.ui.designer.editor.actions.SurroundWithAction"));
        }
        menu.appendToGroup(EXTERNALIZE, actionRegistry.getAction((Object)OpenExternalizeStringsAction.ID));
    }
}

