/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.VersionSupplier;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHashMap<V extends VersionSupplier>
extends MappedList<String, V>
implements Comparator {
    private final ResolverImpl resolver;
    private final boolean preferSystemPackages;

    public VersionHashMap(ResolverImpl resolver, Class<V> valueClass) {
        super(valueClass);
        this.resolver = resolver;
        this.preferSystemPackages = Boolean.valueOf(ResolverImpl.secureAction.getProperty("osgi.resolver.preferSystemPackages", "true"));
    }

    @Override
    protected int insertionIndex(V[] existing, V value) {
        int index = existing.length;
        if (this.compare(existing[existing.length - 1], value) > 0 && (index = Arrays.binarySearch(existing, value, this)) < 0) {
            index = -index - 1;
        }
        return index;
    }

    public void put(V[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.put(((VersionSupplier)versionSuppliers[i]).getName(), versionSuppliers[i]);
            ++i;
        }
    }

    public boolean contains(V vs) {
        return this.contains(vs, false) != null;
    }

    private V contains(V vs, boolean remove) {
        Object existing = this.internal.get(((VersionSupplier)vs).getName());
        if (existing == null) {
            return null;
        }
        if (existing == vs) {
            if (remove) {
                this.internal.remove(((VersionSupplier)vs).getName());
            }
            return vs;
        }
        if (!existing.getClass().isArray()) {
            return null;
        }
        Object[] existingValues = (Object[])existing;
        int i = 0;
        while (i < existingValues.length) {
            if (existingValues[i] == vs) {
                if (remove) {
                    if (existingValues.length == 2) {
                        this.internal.put(((VersionSupplier)vs).getName(), existingValues[i == 0 ? 1 : 0]);
                        return vs;
                    }
                    VersionSupplier[] newExisting = (VersionSupplier[])Array.newInstance(this.valueClass, existingValues.length - 1);
                    System.arraycopy(existingValues, 0, newExisting, 0, i);
                    if (i + 1 < existingValues.length) {
                        System.arraycopy(existingValues, i + 1, newExisting, i, existingValues.length - i - 1);
                    }
                    this.internal.put(((VersionSupplier)vs).getName(), newExisting);
                }
                return vs;
            }
            ++i;
        }
        return null;
    }

    public V remove(V toBeRemoved) {
        return this.contains(toBeRemoved, true);
    }

    public void remove(V[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.remove(versionSuppliers[i]);
            ++i;
        }
    }

    void reorder() {
        for (Object existing : this.internal.values()) {
            if (!existing.getClass().isArray()) continue;
            Arrays.sort((Object[])existing, this);
        }
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof VersionSupplier) || !(o2 instanceof VersionSupplier)) {
            throw new IllegalArgumentException();
        }
        VersionSupplier vs1 = (VersionSupplier)o1;
        VersionSupplier vs2 = (VersionSupplier)o2;
        if (this.resolver.getSelectionPolicy() != null) {
            return this.resolver.getSelectionPolicy().compare(vs1.getBaseDescription(), vs2.getBaseDescription());
        }
        if (this.preferSystemPackages) {
            String systemBundle = this.resolver.getSystemBundle();
            if (systemBundle.equals(vs1.getBundleDescription().getSymbolicName()) && !systemBundle.equals(vs2.getBundleDescription().getSymbolicName())) {
                return -1;
            }
            if (!systemBundle.equals(vs1.getBundleDescription().getSymbolicName()) && systemBundle.equals(vs2.getBundleDescription().getSymbolicName())) {
                return 1;
            }
        }
        if (vs1.getBundleDescription().isResolved() != vs2.getBundleDescription().isResolved()) {
            return vs1.getBundleDescription().isResolved() ? -1 : 1;
        }
        int versionCompare = -vs1.getVersion().compareTo(vs2.getVersion());
        if (versionCompare != 0) {
            return versionCompare;
        }
        return vs1.getBundleDescription().getBundleId() <= vs2.getBundleDescription().getBundleId() ? -1 : 1;
    }
}

