/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestsLinkedResources
extends TestsContentProviderUtil {
    private static final String HTTP_TEST_URL = "http://www.eclipse.org";
    private static final String DEFAULT_PROVIDER_ID = "org.eclipse.core.resources.semantic.provider.DefaultContentProvider";
    final IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public TestsLinkedResources() {
        this(true);
    }

    TestsLinkedResources(boolean withAutoRefresh) {
        super(withAutoRefresh, "TestsLinkedResources", null);
    }

    TestsLinkedResources(boolean withAutoRefresh, String projectName, String providerName) {
        super(withAutoRefresh, projectName, providerName);
    }

    @Before
    public void beforeMethod() throws Exception {
        final IProject project = this.workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = TestsLinkedResources.this.workspace.newProjectDescription(TestsLinkedResources.this.projectName);
                project.create(description, monitor);
                project.open(monitor);
            }
        };
        this.workspace.run(myRunnable, (ISchedulingRule)this.workspace.getRoot(), 1, null);
        this.testProject = project;
        final IFolder folder = this.testProject.getFolder("test");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    URI uri = new URI("semanticfs", null, "/" + TestsLinkedResources.this.projectName + "/test", null, null);
                    folder.createLink(uri, 16, monitor);
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    @After
    public void afterMethod() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestsLinkedResources.this.testProject.delete(true, monitor);
            }
        };
        this.workspace.run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.testProject = null;
    }

    @Test
    public void testAddLinkToSFS() throws Exception {
        final IFolder folder = this.testProject.getFolder("test");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                if (sfolder != null) {
                    sfolder.addFolder("test1", null, null, 0, monitor);
                }
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)folder.exists());
        Assert.assertTrue((boolean)folder.isLinked());
        Assert.assertTrue((boolean)folder.getFolder("test1").exists());
        final IFolder folder2 = this.testProject.getFolder("test").getFolder("test1");
        IWorkspaceRunnable runnable2 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfolder = (ISemanticFolder)folder2.getAdapter(ISemanticFolder.class);
                if (sfolder != null) {
                    sfolder.addFolder("test2", null, null, 0, monitor);
                }
            }
        };
        this.workspace.run(runnable2, this.workspace.getRuleFactory().refreshRule((IResource)folder2), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)folder2.exists());
        Assert.assertTrue((boolean)folder2.getFolder("test2").exists());
        final IFolder folder3 = this.testProject.getFolder("test").getFolder("test3");
        IWorkspaceRunnable runnable3 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                folder3.create(true, true, monitor);
            }
        };
        this.workspace.run(runnable3, this.workspace.getRuleFactory().createRule((IResource)folder3), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)folder3.exists());
    }

    @Test
    public void testAddAndRemoveFile() throws Exception {
        final IFolder folder = this.testProject.getFolder("test").getFolder("someFolder");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                try {
                    File testfile = TestsLinkedResources.this.createTestFile("test.txt");
                    boolean created = testfile.createNewFile();
                    if (!created) {
                        new FileOutputStream(testfile).close();
                    }
                    ISemanticFile sfile = sFolder.addFile("SomeFile", TestsLinkedResources.this.createURI4File(testfile), 0, monitor);
                    Util.safeClose((InputStream)sfile.getAdaptedFile().getContents());
                    Assert.assertTrue((String)("Resource should exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
        final IFile file = folder.getFile("SomeFile");
        Assert.assertTrue((boolean)file.exists());
        IWorkspaceRunnable runnable2 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file.delete(true, monitor);
            }
        };
        this.workspace.run(runnable2, this.workspace.getRuleFactory().deleteRule((IResource)file), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void testAddQueryLinkWithURLToSFS() throws Exception {
        final IFolder folder = this.testProject.getFolder("querytest");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    URI uri = new URI("semanticfs", null, "/querytest", "type=folder;create=true;uri=http://www.eclipse.org", null);
                    folder.createLink(uri, 0, monitor);
                    ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                    Assert.assertTrue((boolean)folder.exists());
                    ISemanticProject sProject = (ISemanticProject)folder.getAdapter(ISemanticProject.class);
                    Assert.assertNull((Object)sProject);
                    ISemanticResourceInfo info = sFolder.fetchResourceInfo(64, monitor);
                    Assert.assertEquals((Object)TestsLinkedResources.HTTP_TEST_URL, (Object)info.getRemoteURIString());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileLinkWithURLToSFS() throws Exception {
        final IFile file = this.testProject.getFile("querytest");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    URI uri = new URI("semanticfs", null, "/filetest/test.html", "type=file;create=true;uri=http://www.eclipse.org", null);
                    file.createLink(uri, 0, monitor);
                    ISemanticFile sFile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    Assert.assertTrue((boolean)file.exists());
                    ISemanticResourceInfo info = sFile.fetchResourceInfo(64, monitor);
                    Assert.assertEquals((Object)TestsLinkedResources.HTTP_TEST_URL, (Object)info.getRemoteURIString());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)file), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddQueryLinkWithProviderToSFS() throws Exception {
        final IFolder folder = this.testProject.getFolder("querytest2");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                URI uri = null;
                try {
                    try {
                        uri = new URI("semanticfs", null, "/querytest2", "type=folder;create=true;provider=org.eclipse.core.resources.semantic.provider.DefaultContentProvider;uri=http://www.eclipse.org", null);
                        folder.createLink(uri, 0, monitor);
                        Assert.assertTrue((boolean)folder.exists());
                        ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                        Assert.assertEquals((Object)TestsLinkedResources.DEFAULT_PROVIDER_ID, (Object)sFolder.getContentProviderID());
                        ISemanticProject sProject = (ISemanticProject)folder.getAdapter(ISemanticProject.class);
                        Assert.assertNull((Object)sProject);
                        ISemanticResourceInfo info = sFolder.fetchResourceInfo(64, monitor);
                        Assert.assertEquals((Object)TestsLinkedResources.HTTP_TEST_URL, (Object)info.getRemoteURIString());
                    }
                    catch (URISyntaxException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    TestsLinkedResources.this.cleanupSFS(uri, monitor);
                    throw throwable;
                }
                TestsLinkedResources.this.cleanupSFS(uri, monitor);
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
        final IFolder folder2 = this.testProject.getFolder("querytest3");
        IWorkspaceRunnable runnable2 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                URI uri = null;
                try {
                    try {
                        uri = new URI("semanticfs", null, "/querytest3/test", "type=folder;create=true;provider=org.eclipse.core.resources.semantic.provider.DefaultContentProvider;uri=http://www.eclipse.org", null);
                        folder2.createLink(uri, 0, monitor);
                        Assert.assertTrue((boolean)folder2.exists());
                        ISemanticFolder sFolder = (ISemanticFolder)folder2.getAdapter(ISemanticFolder.class);
                        Assert.assertEquals((Object)TestsLinkedResources.DEFAULT_PROVIDER_ID, (Object)sFolder.getContentProviderID());
                        ISemanticProject sProject = (ISemanticProject)folder2.getAdapter(ISemanticProject.class);
                        Assert.assertNull((Object)sProject);
                        ISemanticResourceInfo info = sFolder.fetchResourceInfo(64, monitor);
                        Assert.assertEquals((Object)TestsLinkedResources.HTTP_TEST_URL, (Object)info.getRemoteURIString());
                    }
                    catch (URISyntaxException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    TestsLinkedResources.this.cleanupSFS(uri, monitor);
                    throw throwable;
                }
                TestsLinkedResources.this.cleanupSFS(uri, monitor);
            }
        };
        this.workspace.run(runnable2, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRuleFactory() throws Exception {
        final IFolder folder = this.testProject.getFolder("ruletest");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                URI uri = null;
                try {
                    try {
                        uri = new URI("semanticfs", null, "/rulerest", "type=folder;create=true;provider=org.eclipse.core.resources.semantic.provider.DefaultContentProvider", null);
                        folder.createLink(uri, 0, monitor);
                        Assert.assertTrue((boolean)folder.exists());
                        ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                        sFolder.synchronizeContentWithRemote(SyncDirection.BOTH, TestsLinkedResources.this.options, monitor);
                    }
                    catch (URISyntaxException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    TestsLinkedResources.this.cleanupSFS(uri, monitor);
                    throw throwable;
                }
                TestsLinkedResources.this.cleanupSFS(uri, monitor);
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    void cleanupSFS(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore store;
        if (uri != null && !(store = EFS.getStore((URI)uri)).fetchInfo(0, monitor).exists()) {
            store.delete(this.options, monitor);
        }
    }
}

