/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Computation {
    protected Map<IEclipseContext, Set<String>> dependencies = new HashMap<IEclipseContext, Set<String>>();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public void addDependency(IEclipseContext context, String name) {
        Set<String> properties = this.dependencies.get(context);
        if (properties == null) {
            properties = new HashSet<String>(4);
            this.dependencies.put(context, properties);
        }
        properties.add(name);
    }

    protected void doHandleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
    }

    public void handleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
        boolean affected;
        String name = event.getName();
        IEclipseContext context = event.getContext();
        Set<String> names = this.dependencies.get(context);
        boolean contextDisposed = event.getEventType() == 3;
        boolean bl = affected = names == null ? false : names.contains(name);
        if (contextDisposed || affected) {
            this.stopListening(context, name);
            this.doHandleInvalid(event, scheduled);
        }
    }

    protected void removeAll() {
        Iterator<IEclipseContext> it = this.dependencies.keySet().iterator();
        while (it.hasNext()) {
            ((EclipseContext)it.next()).listeners.remove(this);
        }
        this.dependencies.clear();
    }

    public void startListening() {
        for (EclipseContext eclipseContext : this.dependencies.keySet()) {
            Computation existingComputation = eclipseContext.listeners.get(this);
            if (existingComputation != null) {
                if (this == existingComputation) continue;
                Set<String> existingDependencies = existingComputation.dependencies.get(eclipseContext);
                if (existingDependencies != null) {
                    existingDependencies.addAll((Collection<String>)this.dependencies.get(eclipseContext));
                    continue;
                }
                existingComputation.dependencies.put(eclipseContext, this.dependencies.get(eclipseContext));
                continue;
            }
            eclipseContext.listeners.put(this, this);
        }
    }

    public void stopListening(IEclipseContext context, String name) {
        if (context == null) {
            Set<IEclipseContext> dependentContexts = this.dependencies.keySet();
            for (IEclipseContext dependentContext : dependentContexts) {
                ((EclipseContext)dependentContext).listeners.remove(this);
            }
            return;
        }
        if (name == null) {
            this.dependencies.remove(context);
            ((EclipseContext)context).listeners.remove(this);
            return;
        }
        Set<String> properties = this.dependencies.get(context);
        if (properties != null) {
            properties.remove(name);
            if (properties.isEmpty()) {
                this.dependencies.remove(context);
                ((EclipseContext)context).listeners.remove(this);
            }
        }
    }

    public Set<String> dependsOnNames(IEclipseContext context) {
        return this.dependencies.get(context);
    }
}

