/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.metaconfig;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.metaconfig.ConfigurationException;

public class Configuration {
    static final String CONFIGURATION_KEY = "ConfigurationLocation";
    static final String INSTALL_VAR = "${install_location}";
    static final String USER_VAR = "${user_location}";
    static final String WORKSPACE_VAR = "${workspace_location}";
    private Properties configurationProperties = null;
    private Object lock = new Object();

    public String installLocation() {
        return Platform.getInstallLocation().getURL().getPath();
    }

    public String userLocation() {
        return Platform.getUserLocation().getURL().getPath();
    }

    public String workspaceLocation() {
        return Platform.getInstanceLocation().getURL().getPath();
    }

    String metaPropertiesFileLocation() {
        return String.valueOf(this.installLocation()) + "propertiesLocation.ini";
    }

    InputStream openMetaPropertiesFile() throws FileNotFoundException {
        return new FileInputStream(this.metaPropertiesFileLocation());
    }

    String getPropertiesFileLocation() {
        try {
            InputStream in = this.openMetaPropertiesFile();
            Properties properties = new Properties();
            properties.load(in);
            return properties.getProperty(CONFIGURATION_KEY);
        }
        catch (Exception e) {
            throw new ConfigurationException("Problem opening/reading meta-properties file: " + this.metaPropertiesFileLocation(), e);
        }
    }

    String substitute(String source, String substituteFor, String substitution) {
        this.nullCheck(source, "Source cannot be null");
        this.nullCheck(substituteFor, "SubstituteFor cannot be null");
        this.nullCheck(substitution, "Substitution cannot be null");
        int position = source.indexOf(substituteFor);
        if (position >= 0) {
            String head = source.substring(0, position);
            String tail = source.substring(position + substituteFor.length());
            return String.valueOf(head) + substitution + tail;
        }
        return source;
    }

    private void nullCheck(String source, String exceptionMessage) {
        if (source == null) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    String substituteVariables(String input) {
        this.nullCheck(input, "Attempted to substitute into a null string");
        input = this.substitute(input, INSTALL_VAR, this.installLocation());
        input = this.substitute(input, USER_VAR, this.userLocation());
        input = this.substitute(input, WORKSPACE_VAR, this.workspaceLocation());
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() throws ConfigurationException {
        Object object = this.lock;
        synchronized (object) {
            if (this.configurationProperties == null) {
                this.configurationProperties = this.populateProperties(this.getPropertiesFileLocation());
            }
        }
        Properties clone = (Properties)this.configurationProperties.clone();
        return clone;
    }

    Properties populateProperties(String configFileSource) {
        Properties props = new Properties();
        if (configFileSource == null) {
            throw new ConfigurationException("null configFileSource");
        }
        configFileSource = this.substituteVariables(configFileSource);
        try {
            URL configFileURL = new URL(configFileSource);
            InputStream configFile = configFileURL.openStream();
            props.load(configFile);
        }
        catch (Exception e) {
            throw new ConfigurationException("could not load properties from config file with URL string: [" + configFileSource + "]", e);
        }
        return props;
    }
}

