/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests;

import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class CoreTestsActivator
implements BundleActivator {
    private static CoreTestsActivator defaultInstance;
    private BundleContext bundleContext;
    private ServiceTracker debugTracker = null;
    private ServiceTracker preferencesTracker = null;
    private ServiceTracker eventAdminTracker;

    public CoreTestsActivator() {
        defaultInstance = this;
    }

    public static CoreTestsActivator getDefault() {
        return defaultInstance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
            this.preferencesTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        this.bundleContext = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IPreferencesService getPreferencesService() {
        if (this.preferencesTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.preferencesTracker = new ServiceTracker(this.bundleContext, IPreferencesService.class.getName(), null);
            this.preferencesTracker.open();
        }
        return (IPreferencesService)this.preferencesTracker.getService();
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        DebugOptions options;
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(this.bundleContext, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        if ((options = (DebugOptions)this.debugTracker.getService()) != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public EventAdmin getEventAdmin() {
        if (this.eventAdminTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.eventAdminTracker = new ServiceTracker(this.bundleContext, EventAdmin.class.getName(), null);
            this.eventAdminTracker.open();
        }
        return (EventAdmin)this.eventAdminTracker.getService();
    }
}

