/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import java.lang.reflect.InvocationTargetException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ExtraDependenciesTest
extends TestCase {
    public void testExtraDependencies() throws InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("arg1", (Object)"abc");
        context.set("arg2", (Object)new Integer(123));
        IEclipseContext otherContext = EclipseContextFactory.create();
        otherContext.set("arg3", (Object)"other");
        context.set("otherContext", (Object)otherContext);
        TestObject object = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)context);
        ExtraDependenciesTest.assertEquals((String)"abc", (String)object.string);
        ExtraDependenciesTest.assertEquals((Object)new Integer(123), (Object)object.integer);
        ExtraDependenciesTest.assertEquals((String)"other", (String)object.other);
        context.set("arg2", (Object)new Integer(789));
        otherContext.set("arg3", (Object)"wrong");
        ExtraDependenciesTest.assertEquals((String)"other", (String)object.other);
        otherContext.dispose();
        ExtraDependenciesTest.assertEquals((String)"other", (String)object.other);
        ExtraDependenciesTest.assertFalse((boolean)object.disposed);
        context.remove("otherContext");
        ExtraDependenciesTest.assertEquals((String)"other", (String)object.other);
        context.set("arg1", (Object)"xyz");
        context.set("arg2", (Object)new Integer(456));
        ExtraDependenciesTest.assertEquals((String)"xyz", (String)object.string);
        ExtraDependenciesTest.assertEquals((Object)new Integer(456), (Object)object.integer);
        ExtraDependenciesTest.assertNull((Object)object.other);
        context.dispose();
        ExtraDependenciesTest.assertTrue((boolean)object.disposed);
        ExtraDependenciesTest.assertNull((Object)object.string);
        ExtraDependenciesTest.assertNull((Object)object.integer);
        ExtraDependenciesTest.assertNull((Object)object.other);
    }

    public static class TestObject {
        public String string;
        public Integer integer;
        public String other;
        public boolean disposed = false;

        @Inject
        public void injectedMethod(@Named(value="arg1") String strValue, @Named(value="arg2") Integer intValue, IEclipseContext context) {
            this.string = strValue;
            this.integer = intValue;
            if (context == null) {
                this.other = null;
                return;
            }
            IEclipseContext otherContext = (IEclipseContext)context.get("otherContext");
            this.other = otherContext == null ? null : (String)otherContext.get("arg3");
        }

        @PreDestroy
        public void finita() {
            this.disposed = true;
        }
    }
}

