/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPickPath;
import org.eclipse.e4.tm.graphics.util.Dimension;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Event;

public class PInputEvent {
    private Event inputEvent;
    private PPickPath pickPath;
    private PInputManager inputManager;
    private boolean handled;

    public PInputEvent(PInputManager inputManager, Event event) {
        this.inputEvent = event;
        this.inputManager = inputManager;
    }

    public void pushCursor(Cursor cursor) {
        PComponent component = this.getTopCamera().getComponent();
        component.pushCursor(cursor);
    }

    public void popCursor() {
        PComponent component = this.getTopCamera().getComponent();
        component.popCursor();
    }

    public PCamera getCamera() {
        return this.getPath().getBottomCamera();
    }

    public PCamera getTopCamera() {
        return this.getPath().getTopCamera();
    }

    public PComponent getComponent() {
        return this.getTopCamera().getComponent();
    }

    public PInputManager getInputManager() {
        return this.inputManager;
    }

    public PPickPath getPath() {
        return this.pickPath;
    }

    public void setPath(PPickPath path) {
        this.pickPath = path;
    }

    public PNode getPickedNode() {
        return this.pickPath.getPickedNode();
    }

    public int getKeyCode() {
        if (this.isKeyEvent()) {
            return this.inputEvent.keyCode;
        }
        throw new IllegalStateException("Can't get keycode from mouse event");
    }

    public char getKeyChar() {
        if (this.isKeyEvent()) {
            return this.inputEvent.character;
        }
        throw new IllegalStateException("Can't get keychar from mouse event");
    }

    public int getKeyLocation() {
        throw new IllegalStateException("Can't get keylocation from mouse event");
    }

    public boolean isActionKey() {
        throw new IllegalStateException("Can't get isActionKey from mouse event");
    }

    public int getModifiers() {
        return this.inputEvent.stateMask;
    }

    public int getModifiersEx() {
        throw new IllegalStateException("Can't get modifiers ex from focus event");
    }

    public int getClickCount() {
        if (this.isMouseEvent()) {
            return this.inputEvent.count;
        }
        throw new IllegalStateException("Can't get clickcount from key event");
    }

    public long getWhen() {
        if (!this.isFocusEvent()) {
            return this.inputEvent.time;
        }
        throw new IllegalStateException("Can't get when from focus event");
    }

    public boolean isAltDown() {
        try {
            return (this.getModifiers() & 0x10000) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get altdown from focus event");
        }
    }

    public boolean isControlDown() {
        try {
            return (this.getModifiers() & 0x40000) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get controldown from focus event");
        }
    }

    public boolean isMetaDown() {
        try {
            return (this.getModifiers() & SWT.MOD4) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get metadown from focus event");
        }
    }

    public boolean isShiftDown() {
        try {
            return (this.getModifiers() & 0x20000) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get shiftdown from focus event");
        }
    }

    public boolean isLeftMouseButton() {
        try {
            return (this.getModifiers() & 0x80000) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get isLeftMouseButton from focus event");
        }
    }

    public boolean isMiddleMouseButton() {
        try {
            return (this.getModifiers() & 0x100000) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get isMiddleMouseButton from focus event");
        }
    }

    public boolean isRightMouseButton() {
        try {
            return (this.getModifiers() & 0x200000) != 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Can't get isRightMouseButton from focus event");
        }
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public int getButton() {
        if (this.isMouseEvent()) {
            return this.inputEvent.button;
        }
        throw new IllegalStateException("Can't get button from key event");
    }

    public int getWheelRotation() {
        throw new IllegalStateException("Can't get wheel rotation from non-wheel event");
    }

    public Event getSourceSwtEvent() {
        return this.inputEvent;
    }

    public boolean isKeyEvent() {
        switch (this.inputEvent.type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isMouseEvent() {
        switch (this.inputEvent.type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 32: 
            case 37: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    public boolean isMouseWheelEvent() {
        switch (this.inputEvent.type) {
            case 37: {
                return true;
            }
        }
        return false;
    }

    public boolean isFocusEvent() {
        return this.inputEvent == null;
    }

    public boolean isMouseEnteredOrMouseExited() {
        switch (this.inputEvent.type) {
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isPopupTrigger() {
        if (this.isMouseEvent()) {
            return false;
        }
        throw new IllegalStateException("Can't get clickcount from key event");
    }

    public Point getCanvasPosition() {
        return (Point)this.inputManager.getCurrentCanvasPosition().clone();
    }

    public Dimension getCanvasDelta() {
        Point last = this.inputManager.getLastCanvasPosition();
        Point current = this.inputManager.getCurrentCanvasPosition();
        return new Dimension(current.getX() - last.getX(), current.getY() - last.getY());
    }

    public Point getPositionRelativeTo(PNode nodeOnPath) {
        Point r = this.getCanvasPosition();
        return this.pickPath.canvasToLocal(r, nodeOnPath);
    }

    public Dimension getDeltaRelativeTo(PNode nodeOnPath) {
        Dimension r = this.getCanvasDelta();
        return this.pickPath.canvasToLocal(r, nodeOnPath);
    }

    public Point getPosition() {
        Point r = this.getCanvasPosition();
        this.pickPath.canvasToLocal(r, (PNode)this.getCamera());
        return this.getCamera().localToView(r);
    }

    public Dimension getDelta() {
        Dimension r = this.getCanvasDelta();
        this.pickPath.canvasToLocal(r, (PNode)this.getCamera());
        return this.getCamera().localToView(r);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString().replaceAll(".*\\.", ""));
        result.append('[');
        if (this.handled) {
            result.append("handled");
        }
        result.append(']');
        return result.toString();
    }
}

