/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.graphics.util;

import org.eclipse.e4.tm.graphics.util.AbstractCloneable;
import org.eclipse.e4.tm.graphics.util.Util;

public class Point
extends AbstractCloneable
implements Comparable {
    public double x;
    public double y;
    private static String toStringPrefix = "";
    private static String toStringSuffix = "";

    public Point() {
        this(0.0, 0.0);
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        this(point.x, point.y);
    }

    public String toString() {
        return String.valueOf(toStringPrefix) + this.x + "," + this.y + toStringSuffix;
    }

    public static Point valueOf(String s) {
        double[] doubles = Util.valueOf(s, toStringPrefix, "[;,]", toStringSuffix);
        double x = doubles.length > 1 ? doubles[0] : 0.0;
        double y = doubles.length > 1 ? doubles[1] : 0.0;
        return new Point(x, y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance(double x, double y) {
        return Point.distance(this.x, this.y, x, y);
    }

    public double distance(Point p) {
        return this.distance(p.x, p.y);
    }

    public int compareTo(Object o) {
        if (o instanceof Point) {
            Point p = (Point)o;
            double diff = p.x - this.x;
            if (diff == 0.0) {
                diff = p.y - this.y;
            }
            return (int)Math.signum(diff);
        }
        throw new IllegalArgumentException("Cannot compare " + this + " with " + o);
    }
}

