/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.converters;

import org.eclipse.e4.ui.css.core.dom.properties.converters.AbstractCSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverterConfig;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSValue;

public class CSSValueSWTFontDataConverterImpl
extends AbstractCSSValueConverter {
    public static final ICSSValueConverter INSTANCE = new CSSValueSWTFontDataConverterImpl();

    public CSSValueSWTFontDataConverterImpl(Object toType) {
        super(toType);
    }

    public CSSValueSWTFontDataConverterImpl() {
        super(FontData.class);
    }

    public Object convert(CSSValue value, CSSEngine engine, Object context) throws Exception {
        FontData fontData = null;
        if (context != null) {
            Font font;
            if (context instanceof Display) {
                Display display = (Display)context;
                font = display.getSystemFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
            if (context instanceof Control) {
                Control control = (Control)context;
                font = control.getFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
            if (context instanceof CTabItem) {
                CTabItem item = (CTabItem)context;
                font = item.getFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
            if (context instanceof Font) {
                Font font2 = (Font)context;
                fontData = CSSSWTFontHelper.getFirstFontData(font2);
            }
        }
        if (fontData != null && value instanceof CSS2FontProperties) {
            return CSSSWTFontHelper.getFontData((CSS2FontProperties)value, fontData);
        }
        return null;
    }

    public String convert(Object value, CSSEngine engine, Object context, ICSSValueConverterConfig config) throws Exception {
        FontData fontData = (FontData)value;
        if (context instanceof String) {
            String property = (String)context;
            if ("font-family".equals(property)) {
                return CSSSWTFontHelper.getFontFamily(fontData);
            }
            if ("font-size".equals(property)) {
                return CSSSWTFontHelper.getFontSize(fontData);
            }
            if ("font-style".equals(property)) {
                return CSSSWTFontHelper.getFontStyle(fontData);
            }
            if ("font-weight".equals(property)) {
                return CSSSWTFontHelper.getFontWeight(fontData);
            }
            if ("font".equals(property)) {
                return CSSSWTFontHelper.getFontComposite(fontData);
            }
        }
        return null;
    }

    protected Display getDisplay(Object context) {
        if (context instanceof Display) {
            return (Display)context;
        }
        if (context instanceof Control) {
            return ((Control)context).getDisplay();
        }
        return null;
    }
}

