/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class IdClassLabelColorTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final String CSS_CLASS_NAME = "makeItGreenClass";
    static final String CSS_ID = "makeItBlueID";

    protected Label createTestLabel(String styleSheet) {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(panel, 0);
        labelToTest.setText("Some label text");
        WidgetElement.setCSSClass((Widget)labelToTest, (String)CSS_CLASS_NAME);
        WidgetElement.setID((Widget)labelToTest, (String)CSS_ID);
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return labelToTest;
    }

    public void testWidgetClass() throws Exception {
        Label label = this.createTestLabel("Label { background-color: #FF0000 }");
        IdClassLabelColorTest.assertEquals((Object)RED, (Object)label.getBackground().getRGB());
    }

    public void testCssClass() throws Exception {
        Label labelToTest = this.createTestLabel(".makeItGreenClass { background-color: #00FF00 }");
        IdClassLabelColorTest.assertEquals((String)WidgetElement.getCSSClass((Widget)labelToTest), (String)CSS_CLASS_NAME);
        IdClassLabelColorTest.assertEquals((Object)GREEN, (Object)labelToTest.getBackground().getRGB());
    }

    public void testWidgetId() throws Exception {
        Label labelToTest = this.createTestLabel("#makeItBlueID { background-color: #0000FF }");
        IdClassLabelColorTest.assertEquals((String)WidgetElement.getID((Widget)labelToTest), (String)CSS_ID);
        IdClassLabelColorTest.assertEquals((Object)BLUE, (Object)labelToTest.getBackground().getRGB());
    }
}

