/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerScenarioTest
extends ModelReconcilerTest {
    public void testApplicationElement_Id_Changed() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("name");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("customName");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        window.setElementId("id");
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)window.getLabel());
    }

    public void testApplicationElement_Id_Changed2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setElementId("id");
        window.setLabel("name");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("customName");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        window.setElementId("id2");
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)window.getLabel());
    }

    public void testPart_Name_NameChangeFromUser_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setLabel("name");
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setLabel("customName");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setLabel("name2");
        window.getChildren().add(part);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)part.getLabel());
    }

    public void testPart_Visibility_TrueFalseFromApplication_ApplicationWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setLabel("name");
        part.setToBeRendered(true);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setLabel("customName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setLabel("name2");
        part.setToBeRendered(false);
        window.getChildren().add(part);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertFalse((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertFalse((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)part.getLabel());
    }

    public void testPart_Visibility_TrueFalseFromUser_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setLabel("name");
        part.setToBeRendered(true);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setToBeRendered(false);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setLabel("name2");
        window.getChildren().add(part);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertTrue((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertFalse((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
    }

    public void testPart_Addition_PlacedAfterHiddenPart_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setToBeRendered(true);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setToBeRendered(true);
        MPart partD = BasicFactoryImpl.eINSTANCE.createPart();
        partD.setToBeRendered(true);
        window.getChildren().add(partA);
        window.getChildren().add(partB);
        window.getChildren().add(partD);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        partB.setToBeRendered(false);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partA = (MPart)window.getChildren().get(0);
        partB = (MPart)window.getChildren().get(1);
        partD = (MPart)window.getChildren().get(2);
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partC.setToBeRendered(true);
        window.getChildren().add(2, partC);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertTrue((boolean)partA.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partB.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partC.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partD.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertTrue((boolean)partA.isToBeRendered());
        ModelReconcilerScenarioTest.assertFalse((boolean)partB.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partC.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partD.isToBeRendered());
    }

    public void testPart_Addition_PlacedAfterRemovedPart_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(partA);
        window.getChildren().add(partB);
        window.getChildren().add(partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(partB);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partA = (MPart)window.getChildren().get(0);
        partB = (MPart)window.getChildren().get(1);
        partC = (MPart)window.getChildren().get(2);
        MPart partD = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(partD);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        List children = window.getChildren();
        ModelReconcilerScenarioTest.assertEquals((int)4, (int)children.size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, children.get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, children.get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partC, children.get(2));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, children.get(3));
        this.applyAll(deltas);
        children = window.getChildren();
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)children.size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, children.get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partC, children.get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, children.get(2));
    }

    public void testPart_Addition_PlacedAfterRemovedPart_UserWins2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(partA);
        window.getChildren().add(partB);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(partA);
        window.getChildren().remove(partB);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partA = (MPart)window.getChildren().get(0);
        partB = (MPart)window.getChildren().get(1);
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(partC);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partC, window.getChildren().get(2));
        this.applyAll(deltas);
        List children = window.getChildren();
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)children.size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, children.get(0));
    }

    public void testPartStack_Addition_ContainsExistingPart() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack1);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack1.getChildren().add(part1);
        stack1.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(0, stack2);
        stack2.getChildren().add(part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack1.getChildren().get(0);
        part2 = (MPart)stack1.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, stack1.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part2, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        stack2 = (MPartStack)window.getChildren().get(0);
        ModelReconcilerScenarioTest.assertEquals((Object)part1, stack2.getChildren().get(0));
    }

    public void testPartStack_Addition_ContainsExistingPart2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack1);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        stack1.getChildren().add(part1);
        stack1.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack2);
        stack2.getChildren().add(part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack1.getChildren().get(0);
        part2 = (MPart)stack1.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, stack1.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part2, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        stack2 = (MPartStack)window.getChildren().get(1);
        ModelReconcilerScenarioTest.assertEquals((Object)part1, stack2.getChildren().get(0));
    }

    private void testPartStack_AdditionInBack_ApplicationHasNewStackInFront(boolean performMoveFirst) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack1);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        stack1.getChildren().add(partA);
        stack1.getChildren().add(partB);
        stack1.getChildren().add(partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack2);
        stack2.getChildren().add(partA);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        partA = (MPart)stack1.getChildren().get(0);
        partB = (MPart)stack1.getChildren().get(1);
        partC = (MPart)stack1.getChildren().get(2);
        MPartStack stack3 = BasicFactoryImpl.eINSTANCE.createPartStack();
        if (performMoveFirst) {
            stack3.getChildren().add(partC);
            window.getChildren().add(0, stack3);
        } else {
            window.getChildren().add(0, stack3);
            stack3.getChildren().add(partC);
        }
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, stack3.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, stack1.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partB, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, stack3.getChildren().get(0));
        stack2 = (MPartStack)window.getChildren().get(2);
        ModelReconcilerScenarioTest.assertEquals((Object)partA, stack2.getChildren().get(0));
    }

    public void testPartStack_AdditionInBack_ApplicationHasNewStackInFront_True() {
        this.testPartStack_AdditionInBack_ApplicationHasNewStackInFront(true);
    }

    public void testPartStack_AdditionInBack_ApplicationHasNewStackInFront_False() {
        this.testPartStack_AdditionInBack_ApplicationHasNewStackInFront(false);
    }

    private void testPartStack_AdditionInFront_ApplicationHasNewStackInBack(boolean performMoveFirst) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack1);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        stack1.getChildren().add(partA);
        stack1.getChildren().add(partB);
        stack1.getChildren().add(partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(0, stack2);
        stack2.getChildren().add(partA);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        partA = (MPart)stack1.getChildren().get(0);
        partB = (MPart)stack1.getChildren().get(1);
        partC = (MPart)stack1.getChildren().get(2);
        MPartStack stack3 = BasicFactoryImpl.eINSTANCE.createPartStack();
        if (performMoveFirst) {
            stack3.getChildren().add(partC);
            window.getChildren().add(stack3);
        } else {
            window.getChildren().add(stack3);
            stack3.getChildren().add(partC);
        }
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, stack1.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, stack3.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, window.getChildren().get(2));
        stack2 = (MPartStack)window.getChildren().get(0);
        ModelReconcilerScenarioTest.assertEquals((Object)partA, stack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partB, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, stack3.getChildren().get(0));
    }

    public void testPartStack_AdditionInFront_ApplicationHasNewStackInBack_True() {
        this.testPartStack_AdditionInFront_ApplicationHasNewStackInBack(true);
    }

    public void testPartStack_AdditionInFront_ApplicationHasNewStackInBack_False() {
        this.testPartStack_AdditionInFront_ApplicationHasNewStackInBack(false);
    }

    public void testPart_MoveFromExistingStackToExistingStack_ToStackHasNewPart() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack1);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        stack1.getChildren().add(partA);
        stack1.getChildren().add(partB);
        MPartStack stack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack2);
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        stack2.getChildren().add(partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack2.getChildren().add(partB);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        partA = (MPart)stack1.getChildren().get(0);
        partB = (MPart)stack1.getChildren().get(1);
        stack2 = (MPartStack)window.getChildren().get(1);
        partC = (MPart)stack2.getChildren().get(0);
        MPart partD = BasicFactoryImpl.eINSTANCE.createPart();
        stack2.getChildren().add(partD);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack2, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, stack1.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, stack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, stack2.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack2, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)stack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, stack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, stack2.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, stack2.getChildren().get(2));
    }

    public void testElementContainer_ActiveChild_New() {
        MApplication application = this.createApplication();
        MWindow window1 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window1);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        application.setSelectedElement((MUIElement)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window1 = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, application.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertNotNull(application.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals(application.getChildren().get(1), (Object)application.getSelectedElement());
    }

    public void testElementContainer_ActiveChild_Removed() {
        MApplication application = this.createApplication();
        MWindow window1 = BasicFactoryImpl.eINSTANCE.createWindow();
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window1);
        application.getChildren().add(window2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.setSelectedElement((MUIElement)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window1 = (MWindow)application.getChildren().get(0);
        application.getChildren().remove(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, application.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, application.getChildren().get(0));
    }

    public void testElementContainer_ActiveChild_Removed2() {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack partStack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack1);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack1.getChildren().add(part1);
        partStack1.getChildren().add(part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack partStack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack2);
        partStack2.getChildren().add(part2);
        partStack2.setSelectedElement((MUIElement)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partStack1 = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)partStack1.getChildren().get(0);
        partStack1.getChildren().remove(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, partStack1.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, partStack1.getChildren().get(0));
        partStack2 = (MPartStack)window.getChildren().get(1);
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)partStack2.getSelectedElement());
    }

    public void testElementContainer_Children_Move_IdenticalToUserChange() {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack partStack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPartStack partStack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack1);
        window.getChildren().add(partStack2);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack1.getChildren().add(part1);
        partStack1.getChildren().add(part2);
        MPart part3 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack2.getChildren().add(part3);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        partStack2.getChildren().add(part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partStack1 = (MPartStack)window.getChildren().get(0);
        partStack2 = (MPartStack)window.getChildren().get(1);
        part1 = (MPart)partStack1.getChildren().get(0);
        part2 = (MPart)partStack1.getChildren().get(1);
        part3 = (MPart)partStack2.getChildren().get(0);
        partStack2.getChildren().add(part2);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part3, partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, partStack2.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part3, partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, partStack2.getChildren().get(1));
    }

    public void testElementContainer_Children_Move_NewHasSameChildren() {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack partStack1 = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPartStack partStack2 = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack1);
        window.getChildren().add(partStack2);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack1.getChildren().add(part1);
        partStack1.getChildren().add(part2);
        MPart part3 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack2.getChildren().add(part3);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        partStack2.getChildren().add(0, part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partStack1 = (MPartStack)window.getChildren().get(0);
        partStack2 = (MPartStack)window.getChildren().get(1);
        part1 = (MPart)partStack1.getChildren().get(0);
        part2 = (MPart)partStack1.getChildren().get(1);
        part3 = (MPart)partStack2.getChildren().get(0);
        partStack2.getChildren().add(part2);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part3, partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, partStack2.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part2, partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part3, partStack2.getChildren().get(1));
    }

    public void testElementContainer_Children_AddMultipleThenRemove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        MPart editor = BasicFactoryImpl.eINSTANCE.createPart();
        window2.getChildren().add(editor);
        application.getChildren().remove(window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)deltas.size());
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_AddMultipleThenRemove2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        application.setSelectedElement((MUIElement)window2);
        application.getChildren().remove(window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_AddMultipleThenRemove3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        MPart editor = BasicFactoryImpl.eINSTANCE.createPart();
        window2.getChildren().add(editor);
        editor.setLabel("editor");
        application.getChildren().remove(window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testMenu_MenuOrdering() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MDirectMenuItem fileMenuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        fileMenuItem.setLabel("File");
        MDirectMenuItem editMenuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        editMenuItem.setLabel("Edit");
        MDirectMenuItem helpMenuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        helpMenuItem.setLabel("Help");
        menu.getChildren().add(fileMenuItem);
        menu.getChildren().add(editMenuItem);
        menu.getChildren().add(helpMenuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MDirectMenuItem cvsMenuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        cvsMenuItem.setLabel("CVS");
        menu.getChildren().add(2, cvsMenuItem);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        fileMenuItem = (MMenuItem)menu.getChildren().get(0);
        editMenuItem = (MMenuItem)menu.getChildren().get(1);
        helpMenuItem = (MMenuItem)menu.getChildren().get(2);
        MDirectMenuItem e4MenuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        e4MenuItem.setLabel("e4");
        menu.getChildren().add(2, e4MenuItem);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerScenarioTest.assertEquals((int)4, (int)menu.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)fileMenuItem, menu.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)editMenuItem, menu.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)e4MenuItem, menu.getChildren().get(2));
        ModelReconcilerScenarioTest.assertEquals((Object)helpMenuItem, menu.getChildren().get(3));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerScenarioTest.assertEquals((int)5, (int)menu.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)fileMenuItem, menu.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)editMenuItem, menu.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((String)"CVS", (String)((MMenuElement)menu.getChildren().get(2)).getLabel());
        ModelReconcilerScenarioTest.assertEquals((Object)e4MenuItem, menu.getChildren().get(3));
        ModelReconcilerScenarioTest.assertEquals((Object)helpMenuItem, menu.getChildren().get(4));
    }

    public void testWindow_AddPartAndChangeMenu() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.setLabel("menuLabel");
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerScenarioTest.assertNull((Object)menu.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerScenarioTest.assertEquals((String)"menuLabel", (String)menu.getLabel());
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPart));
    }

    private void testApplication_Commands_MultiLevelKeyBindings(String originalApplicationKeyBindingSequence, String userApplicationKeyBindingSequence, String originalWindowKeyBindingSequence, String userWindowKeyBindingSequence) {
        MApplication application = this.createApplication();
        MBindingTable bindingTable = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        MBindingTable bindingTable2 = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        application.getBindingTables().add(bindingTable);
        application.getBindingTables().add(bindingTable2);
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MKeyBinding keyBinding = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        keyBinding.setCommand(command);
        keyBinding.setKeySequence(originalApplicationKeyBindingSequence);
        MKeyBinding keyBinding2 = CommandsFactoryImpl.eINSTANCE.createKeyBinding();
        keyBinding2.setCommand(command);
        keyBinding2.setKeySequence(originalWindowKeyBindingSequence);
        bindingTable.getBindings().add(keyBinding);
        bindingTable2.getBindings().add(keyBinding2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        keyBinding.setKeySequence(userApplicationKeyBindingSequence);
        keyBinding2.setKeySequence(userWindowKeyBindingSequence);
        Object state = reconciler.serialize();
        application = this.createApplication();
        bindingTable = (MBindingTable)application.getBindingTables().get(0);
        bindingTable2 = (MBindingTable)application.getBindingTables().get(1);
        command = (MCommand)application.getCommands().get(0);
        keyBinding = (MKeyBinding)bindingTable.getBindings().get(0);
        keyBinding2 = (MKeyBinding)bindingTable2.getBindings().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((String)originalApplicationKeyBindingSequence, (String)keyBinding.getKeySequence());
        ModelReconcilerScenarioTest.assertEquals((String)originalWindowKeyBindingSequence, (String)keyBinding2.getKeySequence());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)userApplicationKeyBindingSequence, (String)keyBinding.getKeySequence());
        ModelReconcilerScenarioTest.assertEquals((String)userWindowKeyBindingSequence, (String)keyBinding2.getKeySequence());
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", "Ctrl+D");
    }
}

