/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.properties.editors;

import org.eclipse.e4.xwt.tools.ui.designer.core.properties.editors.AbstractCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class IntegerCellEditor
extends AbstractCellEditor {
    private Spinner spinner;

    public IntegerCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite cell) {
        if (this.spinner == null || this.spinner.isDisposed()) {
            this.spinner = new Spinner(cell, 0);
            this.spinner.setMinimum(-1);
            this.spinner.setMaximum(Integer.MAX_VALUE);
        }
        return this.spinner;
    }

    protected void doSetValue(Object value) {
        if (this.spinner == null || this.spinner.isDisposed()) {
            return;
        }
        int intValue = 0;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof String) {
            try {
                intValue = Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.spinner.setSelection(intValue);
    }

    protected Object doGetValue() {
        if (this.spinner == null || this.spinner.isDisposed()) {
            return 0;
        }
        return this.spinner.getSelection();
    }

    protected void doSetFocus() {
        if (this.spinner != null && !this.spinner.isDisposed()) {
            this.spinner.setFocus();
        }
    }
}

