/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.palette;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContextType implements Enumerator
{
    XML_TAG(5, "xml_tag", "xml_tag"),
    XML_ATTRIBUTE_VALUE(1, "xml_attribute_value", "xml_attribute_value"),
    XML_ATTRIBUTE(2, "xml_attribute", "xml_attribute"),
    XML_ALL(3, "xml_all", "xml_all"),
    XML_NEW(4, "xml_new", "xml_new"),
    NONE(0, "none", "none");

    public static final int XML_TAG_VALUE = 5;
    public static final int XML_ATTRIBUTE_VALUE_VALUE = 1;
    public static final int XML_ATTRIBUTE_VALUE_ = 2;
    public static final int XML_ALL_VALUE = 3;
    public static final int XML_NEW_VALUE = 4;
    public static final int NONE_VALUE = 0;
    private static final ContextType[] VALUES_ARRAY;
    public static final List<ContextType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContextType[]{XML_TAG, XML_ATTRIBUTE_VALUE, XML_ATTRIBUTE, XML_ALL, XML_NEW, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContextType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextType get(int value) {
        switch (value) {
            case 5: {
                return XML_TAG;
            }
            case 1: {
                return XML_ATTRIBUTE_VALUE;
            }
            case 2: {
                return XML_ATTRIBUTE;
            }
            case 3: {
                return XML_ALL;
            }
            case 4: {
                return XML_NEW;
            }
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private ContextType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

