/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation.internal;

import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.animation.Duration;
import org.eclipse.e4.xwt.animation.IEasingFunction;
import org.eclipse.e4.xwt.animation.RepeatBehavior;
import org.eclipse.e4.xwt.animation.TimeSpan;
import org.eclipse.e4.xwt.animation.Timeline;
import org.eclipse.e4.xwt.animation.internal.ITimeline;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelinePropertyBuilder;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.ease.TimelineEase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TridentTimeline
implements ITimeline,
TimelineScenario.TimelineScenarioActor {
    protected org.pushingpixels.trident.Timeline tridentTimeline;
    protected Timeline xwtTimeline;
    protected Object target;
    private boolean isPlayed = false;

    public TridentTimeline(Timeline xwtTimeline, Object target) {
        this.xwtTimeline = xwtTimeline;
        this.target = target;
        this.tridentTimeline = this.createTimeline(target);
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public void play() {
        if (this.isPlayed) {
            this.tridentTimeline.replay();
        } else {
            Duration duration = this.xwtTimeline.getDuration();
            if (duration != null && duration.hasTimeSpan()) {
                this.tridentTimeline.setDuration((long)duration.getTimeSpan().getMilliseconds());
            } else {
                this.tridentTimeline.setDuration(10000L);
            }
            RepeatBehavior behavior = this.xwtTimeline.getRepeatBehavior();
            this.playLoop(behavior);
            this.isPlayed = true;
        }
    }

    protected void setInitialValue() {
    }

    protected org.pushingpixels.trident.Timeline createTimeline(Object target) {
        org.pushingpixels.trident.Timeline timeline = new org.pushingpixels.trident.Timeline(target);
        Duration duration = this.xwtTimeline.getDuration();
        if (duration != null && duration.hasTimeSpan()) {
            timeline.setDuration((long)duration.getTimeSpan().getMilliseconds());
        } else {
            timeline.setDuration(10000L);
        }
        return timeline;
    }

    public void playLoop(RepeatBehavior behavior) {
        Timeline.RepeatBehavior loopBehavior = Timeline.RepeatBehavior.LOOP;
        if (this.xwtTimeline.isAutoReverse()) {
            loopBehavior = Timeline.RepeatBehavior.REVERSE;
        }
        if (behavior.getHasCount()) {
            double loopCount = behavior.getCount();
            if (!behavior.getHasDuration()) {
                this.tridentTimeline.playLoop((int)loopCount, loopBehavior);
            } else {
                Duration duration = behavior.getDuration();
                this.tridentTimeline.playLoopSkipping((int)loopCount, loopBehavior, (long)duration.getTimeSpan().getMilliseconds());
            }
        } else if (!behavior.getHasDuration()) {
            this.tridentTimeline.playLoop(loopBehavior);
        } else {
            Duration duration = behavior.getDuration();
            this.tridentTimeline.playLoopSkipping(loopBehavior, (long)duration.getTimeSpan().getMilliseconds());
        }
    }

    @Override
    public void end() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.end();
    }

    @Override
    public void cancel() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.cancel();
    }

    @Override
    public void abort() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.abort();
    }

    @Override
    public void pause() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.suspend();
    }

    @Override
    public void resume() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.resume();
    }

    @Override
    public void playReverse() {
        if (this.tridentTimeline == null) {
            return;
        }
        this.tridentTimeline.playReverse();
    }

    public final <T> void addPropertyToInterpolate(String propName, T from, T to) {
        if (to == null) {
            throw new XWTException("\"to\" property of Animation cannot be null.");
        }
        TimelinePropertyBuilder builder = org.pushingpixels.trident.Timeline.property((String)propName);
        if (from == null) {
            builder.fromCurrent();
        } else {
            builder.from(from);
        }
        builder.to(to);
        this.tridentTimeline.addPropertyToInterpolate(builder);
        TimeSpan timeSpan = this.xwtTimeline.getBeginTime();
        if (timeSpan != null && timeSpan.ticks != 0L) {
            this.tridentTimeline.setInitialDelay((long)timeSpan.getMilliseconds());
        } else if (from != null) {
            TimelinePropertyBuilder.DefaultPropertySetter propertySetter = new TimelinePropertyBuilder.DefaultPropertySetter(this.target, propName);
            propertySetter.set(this.target, propName, from);
        }
    }

    public void setEasingFunction(IEasingFunction easingFunction) {
        if (easingFunction != null) {
            this.tridentTimeline.setEase((TimelineEase)easingFunction);
        }
    }

    public boolean isDone() {
        return this.tridentTimeline.isDone();
    }

    public void resetDoneFlag() {
        this.tridentTimeline.resetDoneFlag();
    }

    public boolean supportsReplay() {
        return this.tridentTimeline.supportsReplay();
    }
}

