/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.Capability;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreResolverHook
implements ResolverHook {
    private final BundleContextImpl context;
    private final ServiceRegistry registry;
    private final List<HookReference> hooks = new ArrayList<HookReference>(0);

    public CoreResolverHook(BundleContextImpl context, ServiceRegistry registry) {
        this.context = context;
        this.registry = registry;
    }

    private void handleHookException(Throwable t, ResolverHook hook, String method, Bundle hookBundle) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer(String.valueOf(hook.getClass().getName())).append(".").append(method).append("() exception: ").append(t.getMessage()).toString());
            Debug.printStackTrace(t);
        }
        this.context.framework.getAdaptor().handleRuntimeError(t);
        ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, hook.getClass().getName(), method), t);
        this.context.framework.publishFrameworkEvent(2, hookBundle, se);
    }

    private ServiceReferenceImpl<ResolverHook>[] getHookReferences() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.osgi.framework.hooks.resolver.ResolverHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ServiceReferenceImpl<?>[] result = this.registry.getServiceReferences(this.context, clazz.getName(), null, false, false);
            return result;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    @Override
    public void begin() {
        ServiceReferenceImpl<ResolverHook>[] refs;
        if (Debug.DEBUG_HOOKS) {
            Debug.println("ResolverHook.begin");
        }
        if ((refs = this.getHookReferences()) == null || refs.length == 0) {
            return;
        }
        ServiceReferenceImpl<ResolverHook>[] serviceReferenceImplArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReferenceImpl<ResolverHook> hookRef = serviceReferenceImplArray[n2];
            ResolverHook hook = this.context.getService(hookRef);
            if (hook != null) {
                this.hooks.add(new HookReference(hookRef, hook));
                try {
                    hook.begin();
                }
                catch (Throwable t) {
                    this.handleHookException(t, hook, "begin", hookRef.getBundle());
                }
            }
            ++n2;
        }
    }

    @Override
    public void filterResolvable(Collection<BundleRevision> candidates) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("ResolverHook.filterResolvable(").append(candidates).append(")").toString());
        }
        if (this.hooks.isEmpty()) {
            return;
        }
        candidates = new ShrinkableCollection<BundleRevision>(candidates);
        Iterator<HookReference> iHooks = this.hooks.iterator();
        while (iHooks.hasNext()) {
            HookReference hookRef = iHooks.next();
            if (hookRef.reference.getBundle() == null) {
                iHooks.remove();
                continue;
            }
            try {
                hookRef.hook.filterResolvable(candidates);
            }
            catch (Throwable t) {
                this.handleHookException(t, hookRef.hook, "filterResolvable", hookRef.reference.getBundle());
            }
        }
    }

    @Override
    public void filterSingletonCollisions(Capability singleton, Collection<Capability> collisionCandidates) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("ResolverHook.filterSingletonCollisions(").append(singleton).append(", ").append(collisionCandidates).append(")").toString());
        }
        if (this.hooks.isEmpty()) {
            return;
        }
        collisionCandidates = new ShrinkableCollection<Capability>(collisionCandidates);
        Iterator<HookReference> iHooks = this.hooks.iterator();
        while (iHooks.hasNext()) {
            HookReference hookRef = iHooks.next();
            if (hookRef.reference.getBundle() == null) {
                iHooks.remove();
                continue;
            }
            try {
                hookRef.hook.filterSingletonCollisions(singleton, collisionCandidates);
            }
            catch (Throwable t) {
                this.handleHookException(t, hookRef.hook, "filterSingletonCollisions", hookRef.reference.getBundle());
            }
        }
    }

    @Override
    public void filterMatches(BundleRevision requirer, Collection<Capability> candidates) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer("ResolverHook.filterMatches(").append(requirer).append(", ").append(candidates).append(")").toString());
        }
        if (this.hooks.isEmpty()) {
            return;
        }
        candidates = new ShrinkableCollection<Capability>(candidates);
        Iterator<HookReference> iHooks = this.hooks.iterator();
        while (iHooks.hasNext()) {
            HookReference hookRef = iHooks.next();
            if (hookRef.reference.getBundle() == null) {
                iHooks.remove();
                continue;
            }
            try {
                hookRef.hook.filterMatches(requirer, candidates);
            }
            catch (Throwable t) {
                this.handleHookException(t, hookRef.hook, "filterMatches", hookRef.reference.getBundle());
            }
        }
    }

    @Override
    public void end() {
        if (Debug.DEBUG_HOOKS) {
            Debug.println("ResolverHook.end");
        }
        if (this.hooks.isEmpty()) {
            return;
        }
        for (HookReference hookRef : this.hooks) {
            if (hookRef.reference.getBundle() == null) continue;
            try {
                hookRef.hook.end();
            }
            catch (Throwable t) {
                this.handleHookException(t, hookRef.hook, "end", hookRef.reference.getBundle());
            }
            this.context.ungetService(hookRef.reference);
        }
        this.hooks.clear();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HookReference {
        final ServiceReferenceImpl<ResolverHook> reference;
        final ResolverHook hook;

        public HookReference(ServiceReferenceImpl<ResolverHook> reference, ResolverHook hook) {
            this.reference = reference;
            this.hook = hook;
        }
    }
}

