/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPropertiesDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIUtils;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.handlers.HandlerUtil;

public class DebugUITools {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Image getImage(String key) {
        return DebugPluginImages.getImage(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return DebugPluginImages.getImageDescriptor(key);
    }

    public static ImageDescriptor getDefaultImageDescriptor(Object element) {
        String imageKey = DebugUITools.getDefaultImageKey(element);
        if (imageKey == null) {
            return null;
        }
        return DebugPluginImages.getImageDescriptor(imageKey);
    }

    private static String getDefaultImageKey(Object element) {
        return ((DefaultLabelProvider)DebugUIPlugin.getDefaultLabelProvider()).getImageKey(element);
    }

    public static IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public static IDebugModelPresentation newDebugModelPresentation() {
        return new DelegatingModelPresentation();
    }

    public static IDebugModelPresentation newDebugModelPresentation(String identifier) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "debugModelPresentations");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement elt = configElements[j];
                    String id = elt.getAttribute("id");
                    if (id != null && id.equals(identifier)) {
                        return new LazyModelPresentation(elt);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IAdaptable getDebugContext() {
        IWorkbenchWindow activeWindow = SelectedResourceManager.getDefault().getActiveWindow();
        if (activeWindow != null) {
            ISelection activeContext = DebugUITools.getDebugContextManager().getContextService(activeWindow).getActiveContext();
            return DebugUITools.getDebugContextElementForSelection(activeContext);
        }
        return null;
    }

    public static IAdaptable getPartDebugContext(IWorkbenchPartSite site) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        String id = null;
        String secondaryId = null;
        id = site.getId();
        if (site instanceof IViewSite) {
            secondaryId = ((IViewSite)site).getSecondaryId();
        }
        ISelection activeContext = service.getActiveContext(id, secondaryId);
        return DebugUITools.getDebugContextElementForSelection(activeContext);
    }

    public static void addPartDebugContextListener(IWorkbenchPartSite site, IDebugContextListener listener) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        String id = site.getId();
        String secondaryId = null;
        if (site instanceof IViewSite) {
            secondaryId = ((IViewSite)site).getSecondaryId();
        }
        service.addDebugContextListener(listener, id, secondaryId);
    }

    public static void removePartDebugContextListener(IWorkbenchPartSite site, IDebugContextListener listener) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        String id = site.getId();
        String secondaryId = null;
        if (site instanceof IViewSite) {
            secondaryId = ((IViewSite)site).getSecondaryId();
        }
        service.removeDebugContextListener(listener, id, secondaryId);
    }

    private static IAdaptable getDebugContextElementForSelection(ISelection activeContext) {
        Object firstElement;
        IStructuredSelection selection;
        if (activeContext instanceof IStructuredSelection && !(selection = (IStructuredSelection)activeContext).isEmpty() && (firstElement = selection.getFirstElement()) instanceof IAdaptable) {
            return (IAdaptable)firstElement;
        }
        return null;
    }

    public static IResource getSelectedResource() {
        return SelectedResourceManager.getDefault().getSelectedResource();
    }

    public static IProcess getCurrentProcess() {
        ILaunch[] launches;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null && (launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()).length > 0) {
            context = launches[launches.length - 1];
        }
        if (context instanceof IDebugElement) {
            return ((IDebugElement)context).getDebugTarget().getProcess();
        }
        if (context instanceof IProcess) {
            return (IProcess)context;
        }
        if (context instanceof ILaunch) {
            IProcess process;
            ILaunch launch = (ILaunch)context;
            IDebugTarget target = launch.getDebugTarget();
            if (target != null && (process = target.getProcess()) != null) {
                return process;
            }
            IProcess[] ps = launch.getProcesses();
            if (ps.length > 0) {
                return ps[ps.length - 1];
            }
        }
        if (context != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IProcess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IProcess)context.getAdapter((Class)clazz);
        }
        return null;
    }

    public static int openLaunchConfigurationDialog(Shell shell, IStructuredSelection selection, String mode) {
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        int i = 0;
        while (i < groups.length) {
            ILaunchGroup group = groups[i];
            if (group.getMode().equals(mode) && group.getCategory() == null) {
                return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, group.getIdentifier());
            }
            ++i;
        }
        return 1;
    }

    public static int openLaunchConfigurationDialogOnGroup(Shell shell, IStructuredSelection selection, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationDialogOnGroup(shell, selection, groupIdentifier, null);
    }

    public static int openLaunchConfigurationDialogOnGroup(final Shell shell, final IStructuredSelection selection, final String groupIdentifier, final IStatus status) {
        final int[] result = new int[1];
        Runnable r = new Runnable(){

            public void run() {
                LaunchConfigurationsDialog dialog = (LaunchConfigurationsDialog)LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
                if (dialog != null) {
                    dialog.setInitialSelection(selection);
                    dialog.doInitialTreeSelection();
                    if (status != null) {
                        dialog.handleStatus(status);
                    }
                    result[0] = 0;
                } else {
                    LaunchGroupExtension ext = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
                    if (ext != null) {
                        dialog = new LaunchConfigurationsDialog(shell, ext);
                        dialog.setOpenMode(3);
                        dialog.setInitialSelection(selection);
                        dialog.setInitialStatus(status);
                        result[0] = dialog.open();
                    } else {
                        result[0] = 1;
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)r);
        return result[0];
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier) {
        return DebugUITools.openLaunchConfigurationPropertiesDialog(shell, configuration, groupIdentifier, null);
    }

    public static int openLaunchConfigurationPropertiesDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationPropertiesDialog dialog = new LaunchConfigurationPropertiesDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static int openLaunchConfigurationDialog(Shell shell, ILaunchConfiguration configuration, String groupIdentifier, IStatus status) {
        LaunchGroupExtension group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(groupIdentifier);
        if (group != null) {
            LaunchConfigurationDialog dialog = new LaunchConfigurationDialog(shell, configuration, group);
            dialog.setInitialStatus(status);
            return dialog.open();
        }
        return 1;
    }

    public static boolean saveAndBuildBeforeLaunch() {
        return DebugUIPlugin.saveAndBuild();
    }

    public static boolean saveBeforeLaunch() {
        return DebugUIPlugin.preLaunchSave();
    }

    public static void launch(ILaunchConfiguration configuration, String mode) {
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if (launchInBackground) {
            DebugUIPlugin.launchInBackground(configuration, mode);
        } else {
            DebugUIPlugin.launchInForeground(configuration, mode);
        }
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return DebugUIPlugin.buildAndLaunch(configuration, mode, monitor);
    }

    public static String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        return DebugUIPlugin.getDefault().getPerspectiveManager().getLaunchPerspective(type, mode);
    }

    public static String getLaunchPerspective(ILaunchConfigurationType type, ILaunchDelegate delegate, Set modes) {
        return DebugUIPlugin.getDefault().getPerspectiveManager().getLaunchPerspective(type, modes, delegate);
    }

    public static void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        DebugUIPlugin.getDefault().getPerspectiveManager().setLaunchPerspective(type, mode, perspective);
    }

    public static void setLaunchPerspective(ILaunchConfigurationType type, ILaunchDelegate delegate, Set modes, String perspectiveid) {
        DebugUIPlugin.getDefault().getPerspectiveManager().setLaunchPerspective(type, modes, delegate, perspectiveid);
    }

    public static boolean isPrivate(ILaunchConfiguration configuration) {
        return !LaunchConfigurationManager.isVisible(configuration);
    }

    public static void setUseStepFilters(boolean useStepFilters) {
        DebugPlugin.setUseStepFilters((boolean)useStepFilters);
    }

    public static boolean isUseStepFilters() {
        return DebugPlugin.isUseStepFilters();
    }

    public static IConsole getConsole(IProcess process) {
        return DebugUIPlugin.getDefault().getProcessConsoleManager().getConsole(process);
    }

    public static IConsole getConsole(IDebugElement element) {
        IProcess process = element.getDebugTarget().getProcess();
        if (process != null) {
            return DebugUITools.getConsole(process);
        }
        return null;
    }

    public static ILaunchGroup[] getLaunchGroups() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroups();
    }

    public static ILaunchConfiguration getLastLaunch(String groupId) {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(groupId);
    }

    public static ILaunchGroup getLaunchGroup(ILaunchConfiguration configuration, String mode) {
        try {
            return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configuration.getType(), mode);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static ISourceLookupResult lookupSource(Object artifact, ISourceLocator locator) {
        return SourceLookupFacility.getDefault().lookup(artifact, locator);
    }

    public static void displaySource(ISourceLookupResult result, IWorkbenchPage page) {
        SourceLookupFacility.getDefault().display(result, page);
    }

    public static IMemoryRenderingManager getMemoryRenderingManager() {
        return MemoryRenderingManager.getDefault();
    }

    public static Image getSourceContainerImage(String id) {
        return SourceLookupUIUtils.getSourceContainerImage(id);
    }

    public static ISourceContainerBrowser getSourceContainerBrowser(String id) {
        return SourceLookupUIUtils.getSourceContainerBrowser(id);
    }

    public static Color getPreferenceColor(String id) {
        return DebugUIPlugin.getPreferenceColor(id);
    }

    public static IDebugContextManager getDebugContextManager() {
        return DebugContextManager.getDefault();
    }

    public static ISelection getDebugContextForEvent(ExecutionEvent event) {
        Object o = HandlerUtil.getVariable((ExecutionEvent)event, (String)"debugContext");
        if (o instanceof ISelection) {
            return (ISelection)o;
        }
        return null;
    }

    public static ISelection getDebugContextForEventChecked(ExecutionEvent event) throws ExecutionException {
        Object o = HandlerUtil.getVariableChecked((ExecutionEvent)event, (String)"debugContext");
        if (!(o instanceof ISelection)) {
            StringBuffer stringBuffer = new StringBuffer("Incorrect type for debugContext found while executing ").append(event.getCommand().getId()).append(", expected ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.viewers.ISelection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new ExecutionException(stringBuffer.append(clazz.getName()).append(" found ").append(o.getClass().getName()).toString());
        }
        return (ISelection)o;
    }
}

