/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.problem;

import java.io.CharConversionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.BranchStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.IntLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemHandler;
import org.eclipse.wst.jsdt.internal.compiler.util.Messages;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class ProblemReporter
extends ProblemHandler {
    public ReferenceContext referenceContext;
    private Scanner positionScanner;

    public static long getIrritant(int problemID) {
        switch (problemID) {
            case 0x20000033: {
                return 0x400000000000000L;
            }
            case 0x20000062: {
                return 0x800000000000000L;
            }
            case 16777381: {
                return 8L;
            }
            case 67108974: {
                return 1L;
            }
            case 0x22000032: {
                return 0x10000000000000L;
            }
            case 0x4000064: 
            case 67108973: 
            case 0x8000082: {
                return 0x20000000000000L;
            }
            case 1610612979: {
                return 0x100000000000000L;
            }
            case 536871009: {
                return 0x80000000000000L;
            }
            case 0x1000005: 
            case 33554505: 
            case 67108967: 
            case 67109276: 
            case 0x8000085: {
                return 4L;
            }
            case 536870973: {
                return 16L;
            }
            case 536870974: {
                return 32L;
            }
            case 33554622: 
            case 33554623: 
            case 0x40000C0: 
            case 67109057: {
                return 128L;
            }
            case 536871173: 
            case 536871177: {
                return 256L;
            }
            case 536871352: {
                return 512L;
            }
            case 536871353: {
                return 0x200000000L;
            }
            case 570425420: 
            case 603979893: {
                return 2048L;
            }
            case 0x21000012: 
            case 570425422: 
            case 603979895: {
                return 0x10000000L;
            }
            case 0x200000B2: {
                return 8192L;
            }
            case 553648135: 
            case 570425421: 
            case 603979894: 
            case 603979910: {
                return 32768L;
            }
            case 536871002: 
            case 536871006: 
            case 536871007: 
            case 570425435: {
                return 65536L;
            }
            case 570425436: 
            case 570425437: {
                return 131072L;
            }
            case 0x1000021: {
                return 0x8000000000L;
            }
            case 536871091: {
                return 262144L;
            }
            case 536871092: 
            case 553648316: {
                return 524288L;
            }
            case 536871372: {
                return 0x8000000L;
            }
            case 553648311: {
                return 0x4000000L;
            }
            case 536871096: {
                return 0x1000000L;
            }
            case 536871097: 
            case 536871098: {
                return 0x800000L;
            }
            case 570425423: {
                return 0x400000L;
            }
            case 536871101: {
                return 0x20000000L;
            }
            case 0x1000133: {
                return 0x400000000L;
            }
            case 0x1000118: {
                return 0x80000000000L;
            }
            case 536871363: {
                return 0x1000000000L;
            }
            case 536871364: {
                return 0x4000000000000L;
            }
            case 536870967: {
                return 0x200000000000000L;
            }
            case 536871365: 
            case 536871366: 
            case 536871367: 
            case 536871368: 
            case 536871369: 
            case 536871370: {
                return 0x8000000000000L;
            }
            case 536871111: {
                return 0x400000000000L;
            }
            case -1610612271: 
            case -1610612270: 
            case -1610612269: 
            case -1610612268: 
            case -1610612266: 
            case -1610612264: 
            case -1610612263: 
            case -1610612262: 
            case -1610612260: 
            case -1610612258: 
            case -1610612257: 
            case -1610612256: 
            case -1610612255: 
            case -1610612254: 
            case -1610612253: 
            case -1610612252: 
            case -1610612251: 
            case -1610612249: 
            case -1610612248: 
            case -1610612247: 
            case -1610612246: 
            case -1610612245: 
            case -1610612244: 
            case -1610612243: 
            case -1610612242: 
            case -1610612241: 
            case -1610612240: 
            case -1610612239: 
            case -1610612238: 
            case -1610612237: 
            case -1610612236: 
            case -1610612235: 
            case -1610612234: 
            case -1610612233: 
            case -1610612232: 
            case -1610612231: 
            case -1610612230: 
            case -1610612229: 
            case -1610612228: 
            case -1610612227: 
            case -1610612226: 
            case -1610612224: 
            case -1610612223: 
            case -1610612221: 
            case -1610612220: 
            case -1610612218: 
            case -1610612217: {
                return 0x2000000L;
            }
            case -1610612265: 
            case -1610612261: 
            case -1610612259: {
                return 0x200000L;
            }
            case -1610612250: {
                return 0x100000L;
            }
            case 536870971: {
                return 0x800000000000L;
            }
            case 0x200000C2: {
                return 0x1000000000000L;
            }
            case 67109280: {
                return 0x2000000000000L;
            }
            case 33554502: {
                return 2L;
            }
            case 603979896: {
                return 128L;
            }
            case 0x600000E0: {
                return 0x100000000000000L;
            }
        }
        return 0L;
    }

    public static int getProblemCategory(int severity, int problemID) {
        if ((severity & 0x80) == 0) {
            long irritant = ProblemReporter.getIrritant(problemID);
            int irritantInt = (int)irritant;
            if ((long)irritantInt == irritant) {
                switch (irritantInt) {
                    case 1: 
                    case 128: 
                    case 512: 
                    case 2048: 
                    case 0x400000: 
                    case 0x8000000: 
                    case 0x10000000: {
                        return 80;
                    }
                    case 2: 
                    case 8: 
                    case 8192: 
                    case 262144: 
                    case 524288: 
                    case 0x1000000: {
                        return 90;
                    }
                    case 65536: 
                    case 131072: {
                        return 100;
                    }
                    case 16: 
                    case 32: 
                    case 32768: 
                    case 0x800000: 
                    case 0x4000000: 
                    case 0x20000000: {
                        return 120;
                    }
                    case 4096: {
                        return 0;
                    }
                    case 0x100000: 
                    case 0x200000: 
                    case 0x2000000: 
                    case 0x2000004: {
                        return 70;
                    }
                }
            } else {
                irritantInt = (int)(irritant >>> 32);
                switch (irritantInt) {
                    case 0: 
                    case 2: 
                    case 32768: {
                        return 80;
                    }
                    case 16: 
                    case 65536: 
                    case 131072: 
                    case 262144: 
                    case 524288: 
                    case 0x2000000: 
                    case 0x4000000: 
                    case 0x8000000: {
                        return 90;
                    }
                    case 128: {
                        return 100;
                    }
                    case 16384: {
                        return 120;
                    }
                    case 4: 
                    case 2048: {
                        return 150;
                    }
                }
            }
        }
        switch (problemID) {
            case 0x1000144: 
            case 536871612: {
                return 10;
            }
        }
        if ((problemID & 0x40000000) != 0) {
            return 20;
        }
        if ((problemID & 0x10000000) != 0) {
            return 30;
        }
        if ((problemID & 0x1000000) != 0) {
            return 40;
        }
        if ((problemID & 0xE000000) != 0) {
            return 50;
        }
        return 60;
    }

    public ProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        super(policy, options, problemFactory);
    }

    public void abortDueToInternalError(String errorMessage) {
        this.abortDueToInternalError(errorMessage, null);
    }

    public void abortDueToInternalError(String errorMessage, ASTNode location) {
        String[] arguments = new String[]{errorMessage};
        this.handle(0, arguments, arguments, 159, location == null ? 0 : location.sourceStart, location == null ? 0 : location.sourceEnd);
    }

    public void abstractMethodCannotBeOverridden(SourceTypeBinding type, MethodBinding concreteMethod) {
        this.handle(67109275, new String[]{new String(type.sourceName()), new String(CharOperation.concat(concreteMethod.declaringClass.readableName(), concreteMethod.readableName(), '.'))}, new String[]{new String(type.sourceName()), new String(CharOperation.concat(concreteMethod.declaringClass.shortReadableName(), concreteMethod.shortReadableName(), '.'))}, type.sourceStart(), type.sourceEnd());
    }

    public void abstractMethodInAbstractClass(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.getSafeName())};
        this.handle(67109227, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void abstractMethodMustBeImplemented(SourceTypeBinding type, MethodBinding abstractMethod) {
        this.handle(67109264, new String[]{new String(abstractMethod.selector), this.typesAsString(abstractMethod.isVarargs(), abstractMethod.parameters, false), new String(abstractMethod.declaringClass.readableName()), new String(type.readableName())}, new String[]{new String(abstractMethod.selector), this.typesAsString(abstractMethod.isVarargs(), abstractMethod.parameters, true), new String(abstractMethod.declaringClass.shortReadableName()), new String(type.shortReadableName())}, type.sourceStart(), type.sourceEnd());
    }

    public void abstractMethodNeedingNoBody(AbstractMethodDeclaration method) {
        this.handle(603979889, NoArgument, NoArgument, method.sourceStart, method.sourceEnd, method, method.compilationResult());
    }

    public void alreadyDefinedLabel(char[] labelName, ASTNode location) {
        String[] arguments = new String[]{new String(labelName)};
        this.handle(536871083, arguments, arguments, location.sourceStart, location.sourceEnd);
    }

    public void argumentTypeCannotBeVoid(SourceTypeBinding type, AbstractMethodDeclaration methodDecl, Argument arg) {
        String[] arguments = new String[]{new String(methodDecl.getSafeName()), new String(arg.name)};
        this.handle(67109228, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void argumentTypeCannotBeVoidArray(Argument arg) {
        this.handle(536870966, NoArgument, NoArgument, arg.type.sourceStart, arg.type.sourceEnd);
    }

    public void arrayConstantsOnlyInArrayInitializers(int sourceStart, int sourceEnd) {
        this.handle(0x600000D0, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void assignmentHasNoEffect(AbstractVariableDeclaration location, char[] name) {
        int severity = this.computeSeverity(0x200000B2);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(name)};
        int start = location.sourceStart;
        int end = location.sourceEnd;
        if (location.initialization != null) {
            end = location.initialization.sourceEnd;
        }
        this.handle(0x200000B2, arguments, arguments, severity, start, end);
    }

    public void assignmentHasNoEffect(Assignment location, char[] name) {
        int severity = this.computeSeverity(0x200000B2);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(name)};
        this.handle(0x200000B2, arguments, arguments, severity, location.sourceStart, location.sourceEnd);
    }

    public void attemptToReturnNonVoidExpression(ReturnStatement returnStatement, TypeBinding expectedType) {
        this.handle(67108969, new String[]{new String(expectedType.readableName())}, new String[]{new String(expectedType.shortReadableName())}, returnStatement.sourceStart, returnStatement.sourceEnd);
    }

    public void attemptToReturnVoidValue(ReturnStatement returnStatement) {
        this.handle(67108970, NoArgument, NoArgument, returnStatement.sourceStart, returnStatement.sourceEnd);
    }

    public void cannotAllocateVoidArray(Expression expression) {
        this.handle(536870966, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void cannotAssignToFinalField(FieldBinding field, ASTNode location) {
        this.handle(0x2000050, new String[]{field.declaringClass == null ? "array" : new String(field.declaringClass.readableName()), new String(field.readableName())}, new String[]{field.declaringClass == null ? "array" : new String(field.declaringClass.shortReadableName()), new String(field.shortReadableName())}, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void cannotAssignToFinalLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870970, arguments, arguments, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void cannotAssignToFinalOuterLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870972, arguments, arguments, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void cannotDefineDimensionsAndInitializer(ArrayAllocationExpression expresssion) {
        this.handle(536871070, NoArgument, NoArgument, expresssion.sourceStart, expresssion.sourceEnd);
    }

    public void cannotDireclyInvokeAbstractMethod(MessageSend messageSend, MethodBinding method) {
        this.handle(67108968, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, messageSend.sourceStart, messageSend.sourceEnd);
    }

    public void cannotImportPackage(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(268435843, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void cannotInstantiate(TypeReference typeRef, TypeBinding type) {
        this.handle(16777373, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, typeRef.sourceStart, typeRef.sourceEnd);
    }

    public void cannotReadSource(CompilationUnitDeclaration unit, AbortCompilationUnit abortException, boolean verbose) {
        String fileName = new String(unit.compilationResult.fileName);
        if (abortException.exception instanceof CharConversionException) {
            String encoding = abortException.encoding;
            if (encoding == null) {
                encoding = System.getProperty("file.encoding");
            }
            String[] arguments = new String[]{fileName, encoding};
            this.handle(536871613, arguments, arguments, 0, 0);
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        if (verbose) {
            abortException.exception.printStackTrace(writer);
        } else {
            writer.print(abortException.exception.getClass().getName());
            writer.print(':');
            writer.print(abortException.exception.getMessage());
        }
        String exceptionTrace = stringWriter.toString();
        String[] arguments = new String[]{fileName, exceptionTrace};
        this.handle(536871614, arguments, arguments, 0, 0);
    }

    public void cannotReferToNonFinalOuterLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870937, arguments, arguments, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void cannotReturnOutsideFunction(ASTNode location) {
        this.handle(0x200000A2, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void cannotThrowNull(ASTNode expression) {
        this.handle(536871089, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void cannotThrowType(ASTNode exception, TypeBinding expectedType) {
        this.handle(0x1000140, new String[]{new String(expectedType.readableName())}, new String[]{new String(expectedType.shortReadableName())}, exception.sourceStart, exception.sourceEnd);
    }

    public void classExtendFinalClass(SourceTypeBinding type, TypeReference superclass, TypeBinding superTypeBinding) {
        String name = new String(type.sourceName());
        String superTypeFullName = new String(superTypeBinding.readableName());
        String superTypeShortName = new String(superTypeBinding.shortReadableName());
        if (superTypeShortName.equals(name)) {
            superTypeShortName = superTypeFullName;
        }
        this.handle(16777529, new String[]{superTypeFullName, name}, new String[]{superTypeShortName, name}, superclass.sourceStart, superclass.sourceEnd);
    }

    public void codeSnippetMissingClass(String missing, int start, int end) {
        String[] arguments = new String[]{missing};
        this.handle(536871332, arguments, arguments, 159, start, end);
    }

    public void codeSnippetMissingMethod(String className, String missingMethod, String argumentTypes, int start, int end) {
        String[] arguments = new String[]{className, missingMethod, argumentTypes};
        this.handle(536871333, arguments, arguments, 159, start, end);
    }

    public int computeSeverity(int problemID) {
        if (!this.options.enableSemanticValidation && (problemID & 0x40000000) == 0 && (problemID & Integer.MIN_VALUE) == 0 && problemID != 536871362) {
            return -1;
        }
        switch (problemID) {
            case 536871362: {
                return 0;
            }
            case 16777538: {
                return 0;
            }
            case 0x1000011: 
            case 603979897: {
                return 0;
            }
            case -1610612270: 
            case -1610612269: 
            case -1610612268: 
            case -1610612264: 
            case -1610612263: 
            case -1610612262: 
            case -1610612258: 
            case -1610612256: 
            case -1610612255: 
            case -1610612254: 
            case -1610612248: 
            case -1610612246: 
            case -1610612244: 
            case -1610612242: 
            case -1610612240: 
            case -1610612238: 
            case -1610612236: 
            case -1610612235: 
            case -1610612234: 
            case -1610612233: 
            case -1610612231: 
            case -1610612229: 
            case -1610612228: 
            case -1610612227: 
            case -1610612226: 
            case -1610612220: {
                if (this.options.reportInvalidJavadocTags) break;
                return -1;
            }
            case -1610612245: 
            case -1610612241: 
            case -1610612237: 
            case -1610612230: {
                if (this.options.reportInvalidJavadocTags && this.options.reportInvalidJavadocTagsDeprecatedRef) break;
                return -1;
            }
            case -1610612271: 
            case -1610612247: 
            case -1610612243: 
            case -1610612239: 
            case -1610612232: {
                if (this.options.reportInvalidJavadocTags && this.options.reportInvalidJavadocTagsNotVisibleRef) break;
                return -1;
            }
        }
        long irritant = ProblemReporter.getIrritant(problemID);
        if (irritant != 0L) {
            if ((problemID & Integer.MIN_VALUE) != 0 && !this.options.docCommentSupport) {
                return -1;
            }
            return this.options.getSeverity(irritant);
        }
        return 129;
    }

    public void conditionalArgumentsIncompatibleTypes(ConditionalExpression expression, TypeBinding trueType, TypeBinding falseType) {
        this.handle(0x1000010, new String[]{new String(trueType.readableName()), new String(falseType.readableName())}, new String[]{new String(trueType.readableName()), new String(falseType.readableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void conflictingImport(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(0x10000181, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void constantOutOfFormat(NumberLiteral literal) {
        if (literal instanceof IntLiteral) {
            char[] source = literal.source();
            try {
                String Radix;
                int radix;
                if (source[1] == 'x' || source[1] == 'X') {
                    radix = 16;
                    Radix = "Hex";
                } else {
                    radix = 8;
                    Radix = "Octal";
                }
                int place = -1;
                int i = radix == 8 ? 1 : 2;
                while (i < source.length) {
                    if (ScannerHelper.digit(source[i], radix) == -1) {
                        place = i;
                        break;
                    }
                    ++i;
                }
                String[] arguments = new String[]{new String(literal.literalType(null).readableName()), String.valueOf(Radix) + " " + new String(source) + " (digit " + new String(new char[]{source[place]}) + ")"};
                this.handle(536871066, arguments, arguments, literal.sourceStart, literal.sourceEnd);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.constantOutOfRange(literal, literal.literalType(null));
            }
        }
    }

    public void constantOutOfRange(Literal literal, TypeBinding literalType) {
        String[] arguments = new String[]{new String(literalType.readableName()), new String(literal.source())};
        this.handle(536871066, arguments, arguments, literal.sourceStart, literal.sourceEnd);
    }

    public void corruptedSignature(TypeBinding enclosingType, char[] signature, int position) {
        this.handle(536871612, new String[]{new String(enclosingType.readableName()), new String(signature), String.valueOf(position)}, new String[]{new String(enclosingType.shortReadableName()), new String(signature), String.valueOf(position)}, 159, 0, 0);
    }

    public void deprecatedField(FieldBinding field, ASTNode location) {
        int severity = this.computeSeverity(33554505);
        if (severity == -1) {
            return;
        }
        this.handle(33554505, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void deprecatedMethod(MethodBinding method, ASTNode location) {
        boolean isConstructor = method.isConstructor();
        int severity = this.computeSeverity(isConstructor ? 0x8000085 : 67108967);
        if (severity == -1) {
            return;
        }
        if (isConstructor) {
            this.handle(0x8000085, new String[]{new String(method.declaringClass.readableName()), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(67108967, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
        }
    }

    public void deprecatedType(TypeBinding type, ASTNode location) {
        if (location == null) {
            return;
        }
        int severity = this.computeSeverity(0x1000005);
        if (severity == -1) {
            return;
        }
        type = type.leafComponentType();
        this.handle(0x1000005, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, severity, location.sourceStart, this.nodeSourceEnd(null, location));
    }

    public void duplicateCase(CaseStatement caseStatement) {
        this.handle(0x20000AA, NoArgument, NoArgument, caseStatement.sourceStart, caseStatement.sourceEnd);
    }

    public void duplicateDefaultCase(ASTNode statement) {
        this.handle(536871078, NoArgument, NoArgument, statement.sourceStart, statement.sourceEnd);
    }

    public void duplicateFieldInType(SourceTypeBinding type, FieldDeclaration fieldDecl) {
        this.handle(33554772, new String[]{new String(type.sourceName()), new String(fieldDecl.name)}, new String[]{new String(type.shortReadableName()), new String(fieldDecl.name)}, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void duplicateFieldInType(SourceTypeBinding type, InferredAttribute fieldDecl) {
        this.handle(33554772, new String[]{new String(type.sourceName()), new String(fieldDecl.name)}, new String[]{new String(type.shortReadableName()), new String(fieldDecl.name)}, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void duplicateImport(ImportReference importRef) {
        String[] arguments = new String[]{CharOperation.toString(importRef.tokens)};
        this.handle(268435842, arguments, arguments, importRef.sourceStart, importRef.sourceEnd);
    }

    public void duplicateInitializationOfBlankFinalField(FieldBinding field, Reference reference) {
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(0x2000052, arguments, arguments, this.nodeSourceStart(field, reference), this.nodeSourceEnd(field, reference));
    }

    public void duplicateInitializationOfFinalLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870969, arguments, arguments, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void duplicateMethodInType(Binding type, AbstractMethodDeclaration methodDecl) {
        MethodBinding method = methodDecl.binding;
        this.handle(67109219, new String[]{new String(methodDecl.getSafeName()), new String(method.declaringClass.readableName()), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(methodDecl.getSafeName()), new String(method.declaringClass.shortReadableName()), this.typesAsString(method.isVarargs(), method.parameters, true)}, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void duplicateModifierForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554773, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void duplicateModifierForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        this.handle(67109221, new String[]{new String(type.sourceName()), new String(methodDecl.getSafeName())}, new String[]{new String(type.shortReadableName()), new String(methodDecl.getSafeName())}, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void duplicateModifierForType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777517, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void duplicateModifierForVariable(LocalDeclaration localDecl, boolean complainForArgument) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(complainForArgument ? 67109232 : 67109259, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void duplicateNestedType(TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(typeDecl.name)};
        this.handle(16777535, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void duplicateTypes(CompilationUnitDeclaration compUnitDecl, TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(compUnitDecl.getFileName()), new String(typeDecl.name)};
        this.referenceContext = typeDecl;
        this.handle(16777539, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd, compUnitDecl.compilationResult);
    }

    public void duplicateTypes(CompilationUnitDeclaration compUnitDecl, InferredType typeDecl) {
        String[] arguments = new String[]{new String(compUnitDecl.getFileName()), new String(typeDecl.getName())};
        this.referenceContext = compUnitDecl;
        this.handle(16777539, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd, compUnitDecl.compilationResult);
    }

    public void emptyControlFlowStatement(int sourceStart, int sourceEnd) {
        this.handle(553648316, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void errorNoMethodFor(MessageSend messageSend, TypeBinding recType, TypeBinding[] params) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer shortBuffer = new StringBuffer();
        int i = 0;
        int length = params.length;
        while (i < length) {
            if (i != 0) {
                buffer.append(", ");
                shortBuffer.append(", ");
            }
            buffer.append(new String(params[i].readableName()));
            shortBuffer.append(new String(params[i].shortReadableName()));
            ++i;
        }
        String shortName = "";
        String readableName = "";
        if (recType != null) {
            readableName = new String(recType.readableName());
            shortName = new String(recType.shortReadableName());
        }
        int id = recType != null && recType.isArrayType() ? 0x4000074 : 67108978;
        this.handle(id, new String[]{readableName, new String(messageSend.selector), buffer.toString()}, new String[]{shortName, new String(messageSend.selector), shortBuffer.toString()}, messageSend.sourceStart, messageSend.sourceEnd);
    }

    public void errorThisSuperInStatic(ASTNode reference) {
        String[] arguments = new String[]{reference.isSuper() ? "super" : "this"};
        this.handle(536871112, arguments, arguments, reference.sourceStart, reference.sourceEnd);
    }

    public void expressionShouldBeAVariable(Expression expression) {
        this.handle(1610612959, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void fieldHiding(FieldDeclaration fieldDecl, Binding hiddenVariable) {
        FieldBinding field = fieldDecl.binding;
        boolean isLocal = hiddenVariable instanceof LocalVariableBinding;
        int severity = this.computeSeverity(isLocal ? 570425436 : 570425437);
        if (severity == -1) {
            return;
        }
        if (isLocal) {
            this.handle(570425436, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(hiddenVariable, fieldDecl), this.nodeSourceEnd(hiddenVariable, fieldDecl));
        } else if (hiddenVariable instanceof FieldBinding) {
            FieldBinding hiddenField = (FieldBinding)hiddenVariable;
            this.handle(570425437, new String[]{new String(field.declaringClass.readableName()), new String(field.name), new String(hiddenField.declaringClass.readableName())}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name), new String(hiddenField.declaringClass.shortReadableName())}, severity, this.nodeSourceStart(hiddenField, fieldDecl), this.nodeSourceEnd(hiddenField, fieldDecl));
        }
    }

    public void fieldsOrThisBeforeConstructorInvocation(ThisReference reference) {
        this.handle(0x800008A, NoArgument, NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    public void finallyMustCompleteNormally(Block finallyBlock) {
        this.handle(536871096, NoArgument, NoArgument, finallyBlock.sourceStart, finallyBlock.sourceEnd);
    }

    public void forbiddenReference(FieldBinding field, ASTNode location, String messageTemplate, int problemId) {
        this.handle(problemId, new String[]{new String(field.readableName())}, new String[]{MessageFormat.format(messageTemplate, new String(field.shortReadableName()), new String(field.declaringClass.shortReadableName()))}, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void forbiddenReference(MethodBinding method, ASTNode location, String messageTemplate, int problemId) {
        if (method.isConstructor()) {
            this.handle(problemId, new String[]{new String(method.readableName())}, new String[]{MessageFormat.format(messageTemplate, new String(method.shortReadableName()))}, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(problemId, new String[]{new String(method.readableName())}, new String[]{MessageFormat.format(messageTemplate, new String(method.shortReadableName()), new String(method.declaringClass.shortReadableName()))}, location.sourceStart, location.sourceEnd);
        }
    }

    public void forbiddenReference(TypeBinding type, ASTNode location, String messageTemplate, int problemId) {
        if (location == null) {
            return;
        }
        int severity = this.computeSeverity(problemId);
        if (severity == -1) {
            return;
        }
        this.handle(problemId, new String[]{new String(type.readableName())}, new String[]{MessageFormat.format(messageTemplate, new String(type.shortReadableName()))}, severity, location.sourceStart, location.sourceEnd);
    }

    public void forwardReference(Reference reference, int indexInQualification, TypeBinding type) {
        this.handle(570425419, NoArgument, NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, messageArguments, problemStartPosition, problemEndPosition, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
        this.referenceContext = null;
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition, CompilationResult unitResult) {
        this.handle(problemId, problemArguments, messageArguments, problemStartPosition, problemEndPosition, this.referenceContext, unitResult);
        this.referenceContext = null;
    }

    private void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition) {
        this.handle(problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
        this.referenceContext = null;
    }

    public void hiddenCatchBlock(ReferenceBinding exceptionType, ASTNode location) {
        this.handle(16777381, new String[]{new String(exceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void hierarchyCircularity(SourceTypeBinding sourceType, ReferenceBinding superType, TypeReference reference) {
        int start = 0;
        int end = 0;
        if (reference == null) {
            start = sourceType.sourceStart();
            end = sourceType.sourceEnd();
        } else {
            start = reference.sourceStart;
            end = reference.sourceEnd;
        }
        if (sourceType == superType) {
            this.handle(16777532, new String[]{new String(sourceType.readableName())}, new String[]{new String(sourceType.shortReadableName())}, start, end);
        } else {
            this.handle(16777533, new String[]{new String(sourceType.readableName()), new String(superType.readableName())}, new String[]{new String(sourceType.shortReadableName()), new String(superType.shortReadableName())}, start, end);
        }
    }

    public void hierarchyHasProblems(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777543, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalAbstractModifierCombinationForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.getSafeName())};
        this.handle(67109226, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalLocalTypeDeclaration(TypeDeclaration typeDeclaration) {
        if (this.isRecoveredName(typeDeclaration.name)) {
            return;
        }
        int problemID = 0;
        if (problemID != 0) {
            String[] arguments = new String[]{new String(typeDeclaration.name)};
            this.handle(problemID, arguments, arguments, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
        }
    }

    public void illegalModifierCombinationFinalAbstractForClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777524, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierCombinationFinalVolatileForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554777, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalModifierForClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777518, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554774, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalModifierForLocalClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777522, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForMemberClass(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(0x1000130, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalModifierForMethod(AbstractMethodDeclaration methodDecl) {
        this.handle(67109222, new String[]{new String(methodDecl.getSafeName()), this.typesAsString(methodDecl.binding.isVarargs(), methodDecl.binding.parameters, false), new String(methodDecl.binding.declaringClass.readableName())}, new String[]{new String(methodDecl.getSafeName()), this.typesAsString(methodDecl.binding.isVarargs(), methodDecl.binding.parameters, true), new String(methodDecl.binding.declaringClass.shortReadableName())}, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalPrimitiveOrArrayTypeForEnclosingInstance(TypeBinding enclosingType, ASTNode location) {
        this.handle(0x100001B, new String[]{new String(enclosingType.readableName())}, new String[]{new String(enclosingType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void illegalStaticModifierForMemberType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777527, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalUsageOfQualifiedTypeReference(QualifiedTypeReference qualifiedTypeReference) {
        StringBuffer buffer = new StringBuffer();
        char[][] tokens = qualifiedTypeReference.tokens;
        int i = 0;
        while (i < tokens.length) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append(tokens[i]);
            ++i;
        }
        String[] arguments = new String[]{String.valueOf(buffer)};
        this.handle(0x600000C6, arguments, arguments, qualifiedTypeReference.sourceStart, qualifiedTypeReference.sourceEnd);
    }

    public void illegalVararg(Argument argType, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{CharOperation.toString(argType.type.getTypeName()), new String(methodDecl.getSafeName())};
        this.handle(67109279, arguments, arguments, argType.sourceStart, argType.sourceEnd);
    }

    public void illegalVisibilityModifierCombinationForField(ReferenceBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554776, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void illegalVisibilityModifierCombinationForMemberType(SourceTypeBinding type) {
        String[] arguments = new String[]{new String(type.sourceName())};
        this.handle(16777526, arguments, arguments, type.sourceStart(), type.sourceEnd());
    }

    public void illegalVisibilityModifierCombinationForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.getSafeName())};
        this.handle(67109224, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void illegalVoidExpression(ASTNode location) {
        this.handle(536871076, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void importProblem(ImportReference importRef, Binding expectedImport) {
        if (expectedImport instanceof FieldBinding) {
            int id = 33554502;
            FieldBinding field = (FieldBinding)expectedImport;
            String[] readableArguments = null;
            String[] shortArguments = null;
            switch (expectedImport.problemId()) {
                case 2: {
                    id = 33554503;
                    readableArguments = new String[]{CharOperation.toString(importRef.tokens), new String(field.declaringClass.readableName())};
                    shortArguments = new String[]{CharOperation.toString(importRef.tokens), new String(field.declaringClass.shortReadableName())};
                    break;
                }
                case 3: {
                    id = 33554504;
                    readableArguments = new String[]{new String(field.readableName())};
                    shortArguments = new String[]{new String(field.readableName())};
                    break;
                }
                case 8: {
                    id = 0x1000003;
                    readableArguments = new String[]{new String(field.declaringClass.leafComponentType().readableName())};
                    shortArguments = new String[]{new String(field.declaringClass.leafComponentType().shortReadableName())};
                }
            }
            this.handle(id, readableArguments, shortArguments, this.nodeSourceStart(field, importRef), this.nodeSourceEnd(field, importRef));
            return;
        }
        if (expectedImport.problemId() == 1) {
            char[][] tokens = expectedImport instanceof ProblemReferenceBinding ? ((ProblemReferenceBinding)expectedImport).compoundName : importRef.tokens;
            String[] arguments = new String[]{CharOperation.toString(tokens)};
            this.handle(268435846, arguments, arguments, importRef.sourceStart, (int)importRef.sourcePositions[tokens.length - 1]);
            return;
        }
        this.invalidType(importRef, (TypeBinding)expectedImport);
    }

    public void incompatibleExceptionInThrowsClause(SourceTypeBinding type, MethodBinding currentMethod, MethodBinding inheritedMethod, ReferenceBinding exceptionType) {
        if (type == currentMethod.declaringClass) {
            int id = 67109266;
            this.handle(id, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(inheritedMethod.declaringClass.readableName(), inheritedMethod.readableName(), '.'))}, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(inheritedMethod.declaringClass.shortReadableName(), inheritedMethod.shortReadableName(), '.'))}, currentMethod.sourceStart(), currentMethod.sourceEnd());
        } else {
            this.handle(67109267, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(currentMethod.declaringClass.sourceName(), currentMethod.readableName(), '.')), new String(CharOperation.concat(inheritedMethod.declaringClass.readableName(), inheritedMethod.readableName(), '.'))}, new String[]{new String(exceptionType.sourceName()), new String(CharOperation.concat(currentMethod.declaringClass.sourceName(), currentMethod.shortReadableName(), '.')), new String(CharOperation.concat(inheritedMethod.declaringClass.shortReadableName(), inheritedMethod.shortReadableName(), '.'))}, type.sourceStart(), type.sourceEnd());
        }
    }

    public void incompatibleReturnType(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        StringBuffer methodSignature = new StringBuffer();
        methodSignature.append(inheritedMethod.declaringClass.readableName()).append('.').append(inheritedMethod.readableName());
        StringBuffer shortSignature = new StringBuffer();
        shortSignature.append(inheritedMethod.declaringClass.shortReadableName()).append('.').append(inheritedMethod.shortReadableName());
        ReferenceBinding declaringClass = currentMethod.declaringClass;
        int id = 67109268;
        AbstractMethodDeclaration method = currentMethod.sourceMethod();
        int sourceStart = 0;
        int sourceEnd = 0;
        if (method == null) {
            if (declaringClass instanceof SourceTypeBinding && ((SourceTypeBinding)declaringClass).classScope != null) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)declaringClass;
                sourceStart = sourceTypeBinding.sourceStart();
                sourceEnd = sourceTypeBinding.sourceEnd();
            }
        } else if (method.isConstructor() || ((MethodDeclaration)method).returnType == null) {
            sourceStart = method.sourceStart;
            sourceEnd = method.sourceEnd;
        } else {
            TypeReference returnType = ((MethodDeclaration)method).returnType;
            sourceStart = returnType.sourceStart;
            sourceEnd = returnType.sourceEnd;
        }
        this.handle(id, new String[]{methodSignature.toString()}, new String[]{shortSignature.toString()}, sourceStart, sourceEnd);
    }

    public void incorrectLocationForNonEmptyDimension(ArrayAllocationExpression expression, int index) {
        this.handle(536871114, NoArgument, NoArgument, expression.dimensions[index].sourceStart, expression.dimensions[index].sourceEnd);
    }

    public void incorrectSwitchType(Expression expression, TypeBinding testType) {
        this.handle(16777385, new String[]{new String(testType.readableName())}, new String[]{new String(testType.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void indirectAccessToStaticField(ASTNode location, FieldBinding field) {
        int severity = this.computeSeverity(570425422);
        if (severity == -1) {
            return;
        }
        this.handle(570425422, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void indirectAccessToStaticMethod(ASTNode location, MethodBinding method) {
        int severity = this.computeSeverity(603979895);
        if (severity == -1) {
            return;
        }
        this.handle(603979895, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
    }

    public void inheritedMethodReducesVisibility(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        StringBuffer concreteSignature = new StringBuffer();
        concreteSignature.append(concreteMethod.declaringClass.readableName()).append('.').append(concreteMethod.readableName());
        StringBuffer shortSignature = new StringBuffer();
        shortSignature.append(concreteMethod.declaringClass.shortReadableName()).append('.').append(concreteMethod.shortReadableName());
        this.handle(67109269, new String[]{concreteSignature.toString(), new String(abstractMethods[0].declaringClass.readableName())}, new String[]{new String(shortSignature.toString()), new String(abstractMethods[0].declaringClass.shortReadableName())}, type.sourceStart(), type.sourceEnd());
    }

    public void inheritedMethodsHaveIncompatibleReturnTypes(ASTNode location, MethodBinding[] inheritedMethods, int length) {
        StringBuffer methodSignatures = new StringBuffer();
        StringBuffer shortSignatures = new StringBuffer();
        int i = length;
        while (--i >= 0) {
            methodSignatures.append(inheritedMethods[i].declaringClass.readableName()).append('.').append(inheritedMethods[i].readableName());
            shortSignatures.append(inheritedMethods[i].declaringClass.shortReadableName()).append('.').append(inheritedMethods[i].shortReadableName());
            if (i == 0) continue;
            methodSignatures.append(", ");
            shortSignatures.append(", ");
        }
        this.handle(67109268, new String[]{methodSignatures.toString()}, new String[]{shortSignatures.toString()}, location.sourceStart, location.sourceEnd);
    }

    public void inheritedMethodsHaveIncompatibleReturnTypes(SourceTypeBinding type, MethodBinding[] inheritedMethods, int length) {
        StringBuffer methodSignatures = new StringBuffer();
        StringBuffer shortSignatures = new StringBuffer();
        int i = length;
        while (--i >= 0) {
            methodSignatures.append(inheritedMethods[i].declaringClass.readableName()).append('.').append(inheritedMethods[i].readableName());
            shortSignatures.append(inheritedMethods[i].declaringClass.shortReadableName()).append('.').append(inheritedMethods[i].shortReadableName());
            if (i == 0) continue;
            methodSignatures.append(", ");
            shortSignatures.append(", ");
        }
        this.handle(67109268, new String[]{methodSignatures.toString()}, new String[]{shortSignatures.toString()}, type.sourceStart(), type.sourceEnd());
    }

    public void initializerMustCompleteNormally(FieldDeclaration fieldDecl) {
        this.handle(536871075, NoArgument, NoArgument, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void innerTypesCannotDeclareStaticInitializers(ReferenceBinding innerType, Initializer initializer) {
        this.handle(536870936, new String[]{new String(innerType.readableName())}, new String[]{new String(innerType.shortReadableName())}, initializer.sourceStart, initializer.sourceStart);
    }

    public void invalidBreak(ASTNode location) {
        this.handle(536871084, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void invalidConstructor(Statement statement, MethodBinding targetConstructor) {
        boolean insideDefaultConstructor = this.referenceContext instanceof ConstructorDeclaration && ((ConstructorDeclaration)this.referenceContext).isDefaultConstructor();
        boolean insideImplicitConstructorCall = statement instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)statement).accessMode == 1;
        int sourceStart = statement.sourceStart;
        int sourceEnd = statement.sourceEnd;
        int id = 0x8000082;
        MethodBinding shownConstructor = targetConstructor;
        switch (targetConstructor.problemId()) {
            case 1: {
                if (insideDefaultConstructor) {
                    id = 0x800008C;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 0x800008F;
                    break;
                }
                id = 0x8000082;
                break;
            }
            case 2: {
                id = insideDefaultConstructor ? 0x800008D : (insideImplicitConstructorCall ? 0x8000090 : 0x8000083);
                ProblemMethodBinding problemConstructor = (ProblemMethodBinding)targetConstructor;
                if (problemConstructor.closestMatch == null) break;
                shownConstructor = problemConstructor.closestMatch.original();
                break;
            }
            case 3: {
                if (insideDefaultConstructor) {
                    id = 0x800008E;
                    break;
                }
                if (insideImplicitConstructorCall) {
                    id = 134217873;
                    break;
                }
                id = 0x8000084;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        this.handle(id, new String[]{new String(targetConstructor.declaringClass.readableName()), this.typesAsString(shownConstructor.isVarargs(), shownConstructor.parameters, false)}, new String[]{new String(targetConstructor.declaringClass.shortReadableName()), this.typesAsString(shownConstructor.isVarargs(), shownConstructor.parameters, true)}, sourceStart, sourceEnd);
    }

    public void invalidContinue(ASTNode location) {
        this.handle(536871085, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void invalidEnclosingType(Expression expression, TypeBinding type, ReferenceBinding enclosingType) {
        if (enclosingType.isAnonymousType()) {
            enclosingType = enclosingType.superclass();
        }
        if (enclosingType.sourceName != null && enclosingType.sourceName.length == 0) {
            return;
        }
        int flag = 0x1000002;
        switch (type.problemId()) {
            case 1: {
                flag = 0x1000002;
                break;
            }
            case 2: {
                flag = 0x1000003;
                break;
            }
            case 3: {
                flag = 0x1000004;
                break;
            }
            case 4: {
                flag = 0x1000006;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        this.handle(flag, new String[]{String.valueOf(new String(enclosingType.readableName())) + "." + new String(type.readableName())}, new String[]{String.valueOf(new String(enclosingType.shortReadableName())) + "." + new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidExplicitConstructorCall(ASTNode location) {
        this.handle(1207959691, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void invalidExpressionAsStatement(Expression expression) {
        this.handle(1610612958, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidField(FieldReference fieldRef, TypeBinding searchedType) {
        if (this.isRecoveredName(fieldRef.token)) {
            return;
        }
        int id = 33554502;
        FieldBinding field = fieldRef.binding;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                this.handle(33554503, new String[]{new String(fieldRef.token), new String(field.declaringClass.readableName())}, new String[]{new String(fieldRef.token), new String(field.declaringClass.shortReadableName())}, this.nodeSourceStart(field, fieldRef), this.nodeSourceEnd(field, fieldRef));
                return;
            }
            case 3: {
                id = 33554504;
                break;
            }
            case 7: {
                id = 33554506;
                break;
            }
            case 6: {
                id = 0x8000087;
                break;
            }
            case 5: {
                id = 33554628;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(searchedType.leafComponentType().readableName())}, new String[]{new String(searchedType.leafComponentType().shortReadableName())}, fieldRef.receiver.sourceStart, fieldRef.receiver.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(id, arguments, arguments, this.nodeSourceStart(field, fieldRef), this.nodeSourceEnd(field, fieldRef));
    }

    public void invalidField(NameReference nameRef, FieldBinding field) {
        NameReference ref;
        if (nameRef instanceof QualifiedNameReference) {
            ref = (QualifiedNameReference)nameRef;
            if (this.isRecoveredName(ref.tokens)) {
                return;
            }
        } else {
            ref = (SingleNameReference)nameRef;
            if (this.isRecoveredName(((SingleNameReference)ref).token)) {
                return;
            }
        }
        int id = 33554502;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                char[] name = field.readableName();
                name = CharOperation.lastSegment(name, '.');
                this.handle(33554503, new String[]{new String(name), new String(field.declaringClass.readableName())}, new String[]{new String(name), new String(field.declaringClass.shortReadableName())}, this.nodeSourceStart(field, nameRef), this.nodeSourceEnd(field, nameRef));
                return;
            }
            case 3: {
                id = 33554504;
                break;
            }
            case 7: {
                id = 33554506;
                break;
            }
            case 6: {
                id = 0x8000087;
                break;
            }
            case 5: {
                id = 33554628;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(field.declaringClass.leafComponentType().readableName())}, new String[]{new String(field.declaringClass.leafComponentType().shortReadableName())}, nameRef.sourceStart, nameRef.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(id, arguments, arguments, nameRef.sourceStart, nameRef.sourceEnd);
    }

    public void invalidField(QualifiedNameReference nameRef, FieldBinding field, int index, TypeBinding searchedType) {
        if (this.isRecoveredName(nameRef.tokens)) {
            return;
        }
        if (searchedType.isBaseType()) {
            this.handle(0x20000DD, new String[]{new String(searchedType.readableName()), CharOperation.toString(CharOperation.subarray(nameRef.tokens, 0, index)), new String(nameRef.tokens[index])}, new String[]{new String(searchedType.sourceName()), CharOperation.toString(CharOperation.subarray(nameRef.tokens, 0, index)), new String(nameRef.tokens[index])}, nameRef.sourceStart, (int)nameRef.sourcePositions[index]);
            return;
        }
        int id = 33554502;
        switch (field.problemId()) {
            case 1: {
                id = 33554502;
                break;
            }
            case 2: {
                String fieldName = new String(nameRef.tokens[index]);
                this.handle(33554503, new String[]{fieldName, new String(field.declaringClass.readableName())}, new String[]{fieldName, new String(field.declaringClass.shortReadableName())}, this.nodeSourceStart(field, nameRef), this.nodeSourceEnd(field, nameRef));
                return;
            }
            case 3: {
                id = 33554504;
                break;
            }
            case 7: {
                id = 33554506;
                break;
            }
            case 6: {
                id = 0x8000087;
                break;
            }
            case 5: {
                id = 33554628;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(searchedType.leafComponentType().readableName())}, new String[]{new String(searchedType.leafComponentType().shortReadableName())}, nameRef.sourceStart, nameRef.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String[] arguments = new String[]{CharOperation.toString(CharOperation.subarray(nameRef.tokens, 0, index + 1))};
        this.handle(id, arguments, arguments, nameRef.sourceStart, (int)nameRef.sourcePositions[index]);
    }

    public void invalidMethod(MessageSend messageSend, MethodBinding method) {
        String methodName;
        if (this.isRecoveredName(messageSend.selector)) {
            return;
        }
        boolean isFunction = method.declaringClass == null;
        int id = isFunction ? 67108973 : 0x4000064;
        MethodBinding shownMethod = method;
        switch (method.problemId()) {
            case 1: {
                id = isFunction ? 67108973 : 0x4000064;
                ProblemMethodBinding problemMethod = (ProblemMethodBinding)method;
                if (problemMethod.closestMatch == null) break;
                shownMethod = problemMethod.closestMatch;
                String closestParameterTypeNames = this.typesAsString(shownMethod.isVarargs(), shownMethod.parameters, false);
                String parameterTypeNames = this.typesAsString(false, problemMethod.parameters, false);
                String closestParameterTypeShortNames = this.typesAsString(shownMethod.isVarargs(), shownMethod.parameters, true);
                String parameterTypeShortNames = this.typesAsString(false, problemMethod.parameters, true);
                this.handle(67108979, new String[]{new String(shownMethod.declaringClass.readableName()), new String(shownMethod.selector), closestParameterTypeNames, parameterTypeNames}, new String[]{new String(shownMethod.declaringClass.shortReadableName()), new String(shownMethod.selector), closestParameterTypeShortNames, parameterTypeShortNames}, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
                return;
            }
            case 2: {
                id = 67108965;
                ProblemMethodBinding problemMethod = (ProblemMethodBinding)method;
                if (problemMethod.closestMatch == null) break;
                shownMethod = problemMethod.closestMatch.original();
                break;
            }
            case 3: {
                id = 0x4000066;
                break;
            }
            case 15: {
                id = 603979897;
                break;
            }
            case 5: {
                id = 67109059;
                break;
            }
            case 6: {
                id = 0x8000088;
                break;
            }
            case 7: {
                id = 603979977;
                break;
            }
            case 8: {
                this.handle(0x1000003, new String[]{new String(method.declaringClass.leafComponentType().readableName())}, new String[]{new String(method.declaringClass.leafComponentType().shortReadableName())}, messageSend.receiver.sourceStart, messageSend.receiver.sourceEnd);
                return;
            }
            default: {
                this.needImplementation();
            }
        }
        String shortName = "";
        String readableName = "";
        String string = methodName = shownMethod.selector != null ? new String(shownMethod.selector) : "";
        if (method.declaringClass != null) {
            shortName = readableName = new String(method.declaringClass.readableName());
        }
        this.handle(id, new String[]{readableName, shortName, this.typesAsString(shownMethod.isVarargs(), shownMethod.parameters, false)}, new String[]{shortName, methodName, this.typesAsString(shownMethod.isVarargs(), shownMethod.parameters, true)}, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
    }

    public void invalidNullToSynchronize(Expression expression) {
        this.handle(0x200000B0, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void wrongNumberOfArguments(MessageSend functionCall, MethodBinding binding) {
        String functionName = new String(functionCall.selector);
        int actualArguments = functionCall.arguments != null ? functionCall.arguments.length : 0;
        String actualNumber = String.valueOf(actualArguments);
        String expectingNumber = String.valueOf(binding.parameters.length);
        this.handle(603979896, new String[]{functionName, expectingNumber, actualNumber}, new String[]{functionName, expectingNumber, actualNumber}, functionCall.sourceStart, functionCall.sourceEnd);
    }

    public void wrongNumberOfArguments(AllocationExpression allocationExpression, MethodBinding binding) {
        char[] typeName = Util.getTypeName(allocationExpression.member);
        String functionName = typeName != null ? new String(typeName) : "";
        int actualArguments = allocationExpression.arguments != null ? allocationExpression.arguments.length : 0;
        String actualNumber = String.valueOf(actualArguments);
        String expectingNumber = String.valueOf(binding.parameters.length);
        this.handle(603979896, new String[]{functionName, expectingNumber, actualNumber}, new String[]{functionName, expectingNumber, actualNumber}, allocationExpression.sourceStart, allocationExpression.sourceEnd);
    }

    public void invalidOperator(BinaryExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x200000A0, new String[]{expression.operatorToString(), String.valueOf(leftName) + ", " + rightName}, new String[]{expression.operatorToString(), String.valueOf(leftShortName) + ", " + rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidOperator(CompoundAssignment assign, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x200000A0, new String[]{assign.operatorToString(), String.valueOf(leftName) + ", " + rightName}, new String[]{assign.operatorToString(), String.valueOf(leftShortName) + ", " + rightShortName}, assign.sourceStart, assign.sourceEnd);
    }

    public void invalidOperator(UnaryExpression expression, TypeBinding type) {
        this.handle(0x200000A0, new String[]{expression.operatorToString(), new String(type.readableName())}, new String[]{expression.operatorToString(), new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidParenthesizedExpression(ASTNode reference) {
        this.handle(1610612961, NoArgument, NoArgument, reference.sourceStart, reference.sourceEnd);
    }

    public void invalidType(ASTNode location, TypeBinding type) {
        TypeBinding leafType;
        if (type instanceof ReferenceBinding ? this.isRecoveredName(((ReferenceBinding)type).compoundName) : type instanceof ArrayBinding && (leafType = ((ArrayBinding)type).leafComponentType) instanceof ReferenceBinding && this.isRecoveredName(((ReferenceBinding)leafType).compoundName)) {
            return;
        }
        int id = 0x1000002;
        switch (type.problemId()) {
            case 1: {
                id = 0x1000002;
                break;
            }
            case 2: {
                id = 0x1000003;
                break;
            }
            case 3: {
                id = 0x1000004;
                break;
            }
            case 4: {
                id = 0x1000006;
                break;
            }
            case 5: {
                id = 16777413;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        int end = location.sourceEnd;
        if (location instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)location;
            if (this.isRecoveredName(ref.tokens)) {
                return;
            }
            if (ref.indexOfFirstFieldBinding >= 1) {
                end = (int)ref.sourcePositions[ref.indexOfFirstFieldBinding - 1];
            }
        } else if (location instanceof ArrayQualifiedTypeReference) {
            ArrayQualifiedTypeReference arrayQualifiedTypeReference = (ArrayQualifiedTypeReference)location;
            if (this.isRecoveredName(arrayQualifiedTypeReference.tokens)) {
                return;
            }
            long[] positions = arrayQualifiedTypeReference.sourcePositions;
            end = (int)positions[positions.length - 1];
        } else if (location instanceof QualifiedTypeReference) {
            char[][] name;
            QualifiedTypeReference ref = (QualifiedTypeReference)location;
            if (this.isRecoveredName(ref.tokens)) {
                return;
            }
            if (type instanceof ReferenceBinding && (name = ((ReferenceBinding)type).compoundName).length <= ref.sourcePositions.length) {
                end = (int)ref.sourcePositions[name.length - 1];
            }
        } else if (location instanceof ImportReference) {
            ImportReference ref = (ImportReference)location;
            if (this.isRecoveredName(ref.tokens)) {
                return;
            }
            if (type instanceof ReferenceBinding) {
                char[][] name = ((ReferenceBinding)type).compoundName;
                end = (int)ref.sourcePositions[name.length - 1];
            }
        } else if (location instanceof ArrayTypeReference) {
            ArrayTypeReference arrayTypeReference = (ArrayTypeReference)location;
            if (this.isRecoveredName(arrayTypeReference.token)) {
                return;
            }
            end = arrayTypeReference.originalSourceEnd;
        }
        this.handle(id, new String[]{new String(type.leafComponentType().readableName())}, new String[]{new String(type.leafComponentType().shortReadableName())}, location.sourceStart, end);
    }

    public void invalidTypeForCollection(Expression expression) {
        this.handle(536871493, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidTypeToSynchronize(Expression expression, TypeBinding type) {
        this.handle(536871087, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidUnaryExpression(Expression expression) {
        this.handle(1610612942, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void invalidUsageOfForeachStatements(LocalDeclaration elementVariable, Expression collection) {
        this.handle(1610613328, NoArgument, NoArgument, elementVariable.declarationSourceStart, collection.sourceEnd);
    }

    public void isClassPathCorrect(char[][] wellKnownTypeName, CompilationUnitDeclaration compUnitDecl, Object location) {
        this.referenceContext = compUnitDecl;
        String[] arguments = new String[]{CharOperation.toString(wellKnownTypeName)};
        int start = 0;
        int end = 0;
        if (location != null) {
            if (location instanceof InvocationSite) {
                InvocationSite site = (InvocationSite)location;
                start = site.sourceStart();
                end = site.sourceEnd();
            } else if (location instanceof ASTNode) {
                ASTNode node = (ASTNode)location;
                start = node.sourceStart();
                end = node.sourceEnd();
            }
        }
        this.handle(0x1000144, arguments, arguments, start, end);
    }

    private boolean isIdentifier(int token) {
        return token == 32;
    }

    private boolean isKeyword(int token) {
        switch (token) {
            case 11: 
            case 25: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: 
            case 50: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return true;
            }
        }
        return false;
    }

    private boolean isLiteral(int token) {
        switch (token) {
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    private boolean isRecoveredName(char[] simpleName) {
        return simpleName == RecoveryScanner.FAKE_IDENTIFIER;
    }

    private boolean isRecoveredName(char[][] qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        int i = 0;
        while (i < qualifiedName.length) {
            if (qualifiedName[i] == RecoveryScanner.FAKE_IDENTIFIER) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void javadocDeprecatedField(FieldBinding field, ASTNode location, int modifiers) {
        int severity = this.computeSeverity(-1610612245);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612245, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
        }
    }

    public void javadocDeprecatedMethod(MethodBinding method, ASTNode location, int modifiers) {
        boolean isConstructor = method.isConstructor();
        int severity = this.computeSeverity(isConstructor ? -1610612241 : -1610612237);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            if (isConstructor) {
                this.handle(-1610612241, new String[]{new String(method.declaringClass.readableName()), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
            } else {
                this.handle(-1610612237, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
            }
        }
    }

    public void javadocDeprecatedType(TypeBinding type, ASTNode location, int modifiers) {
        if (location == null) {
            return;
        }
        int severity = this.computeSeverity(-1610612230);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            if (type.isMemberType() && type instanceof ReferenceBinding && !this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, ((ReferenceBinding)type).modifiers)) {
                this.handle(-1610612271, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
            } else {
                this.handle(-1610612230, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, severity, location.sourceStart, location.sourceEnd);
            }
        }
    }

    public void javadocDuplicatedParamTag(char[] token, int sourceStart, int sourceEnd, int modifiers) {
        int severity = this.computeSeverity(-1610612263);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(token)};
            this.handle(-1610612263, arguments, arguments, severity, sourceStart, sourceEnd);
        }
    }

    public void javadocDuplicatedReturnTag(int sourceStart, int sourceEnd) {
        this.handle(-1610612260, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocDuplicatedThrowsClassName(TypeReference typeReference, int modifiers) {
        int severity = this.computeSeverity(-1610612256);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(typeReference.resolvedType.sourceName())};
            this.handle(-1610612256, arguments, arguments, severity, typeReference.sourceStart, typeReference.sourceEnd);
        }
    }

    public void javadocEmptyReturnTag(int sourceStart, int sourceEnd, int modifiers) {
        int severity = this.computeSeverity(-1610612220);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612220, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocErrorNoMethodFor(MessageSend messageSend, TypeBinding recType, TypeBinding[] params, int modifiers) {
        int id = recType.isArrayType() ? -1610612234 : -1610612236;
        int severity = this.computeSeverity(id);
        if (severity == -1) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        StringBuffer shortBuffer = new StringBuffer();
        int i = 0;
        int length = params.length;
        while (i < length) {
            if (i != 0) {
                buffer.append(", ");
                shortBuffer.append(", ");
            }
            buffer.append(new String(params[i].readableName()));
            shortBuffer.append(new String(params[i].shortReadableName()));
            ++i;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(id, new String[]{new String(recType.readableName()), new String(messageSend.selector), buffer.toString()}, new String[]{new String(recType.shortReadableName()), new String(messageSend.selector), shortBuffer.toString()}, severity, messageSend.sourceStart, messageSend.sourceEnd);
        }
    }

    public void javadocHiddenReference(int sourceStart, int sourceEnd, Scope scope, int modifiers) {
        Scope currentScope = scope;
        while (currentScope.parent.kind != 4) {
            if (!this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, currentScope.getDeclarationModifiers())) {
                return;
            }
            currentScope = currentScope.parent;
        }
        String[] arguments = new String[]{this.options.getVisibilityString(this.options.reportInvalidJavadocTagsVisibility), this.options.getVisibilityString(modifiers)};
        this.handle(-1610612271, arguments, arguments, sourceStart, sourceEnd);
    }

    public void javadocInvalidConstructor(Statement statement, MethodBinding targetConstructor, int modifiers) {
        if (!this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            return;
        }
        int id = -1610612244;
        switch (targetConstructor.problemId()) {
            case 1: {
                id = -1610612244;
                break;
            }
            case 2: {
                id = -1610612243;
                break;
            }
            case 3: {
                id = -1610612242;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        int severity = this.computeSeverity(id);
        if (severity == -1) {
            return;
        }
        this.handle(id, new String[]{new String(targetConstructor.declaringClass.readableName()), this.typesAsString(targetConstructor.isVarargs(), targetConstructor.parameters, false)}, new String[]{new String(targetConstructor.declaringClass.shortReadableName()), this.typesAsString(targetConstructor.isVarargs(), targetConstructor.parameters, true)}, severity, statement.sourceStart, statement.sourceEnd);
    }

    public void javadocInvalidField(int sourceStart, int sourceEnd, Binding fieldBinding, TypeBinding searchedType, int modifiers) {
        int id = -1610612248;
        switch (fieldBinding.problemId()) {
            case 1: {
                id = -1610612248;
                break;
            }
            case 2: {
                id = -1610612247;
                break;
            }
            case 3: {
                id = -1610612246;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        int severity = this.computeSeverity(id);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{new String(fieldBinding.readableName())};
            this.handle(id, arguments, arguments, severity, sourceStart, sourceEnd);
        }
    }

    public void javadocInvalidMemberTypeQualification(int sourceStart, int sourceEnd, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612270, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocInvalidMethod(MessageSend messageSend, MethodBinding method, int modifiers) {
        int severity;
        if (!this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            return;
        }
        ProblemMethodBinding problemMethod = null;
        int id = -1610612240;
        switch (method.problemId()) {
            case 1: {
                String parameterTypeShortNames;
                id = -1610612240;
                problemMethod = (ProblemMethodBinding)method;
                if (problemMethod.closestMatch == null) break;
                int severity2 = this.computeSeverity(-1610612235);
                if (severity2 == -1) {
                    return;
                }
                String closestParameterTypeNames = this.typesAsString(problemMethod.closestMatch.isVarargs(), problemMethod.closestMatch.parameters, false);
                String parameterTypeNames = this.typesAsString(method.isVarargs(), method.parameters, false);
                String closestParameterTypeShortNames = this.typesAsString(problemMethod.closestMatch.isVarargs(), problemMethod.closestMatch.parameters, true);
                if (closestParameterTypeShortNames.equals(parameterTypeShortNames = this.typesAsString(method.isVarargs(), method.parameters, true))) {
                    closestParameterTypeShortNames = closestParameterTypeNames;
                    parameterTypeShortNames = parameterTypeNames;
                }
                this.handle(-1610612235, new String[]{new String(problemMethod.closestMatch.declaringClass.readableName()), new String(problemMethod.closestMatch.selector), closestParameterTypeNames, parameterTypeNames}, new String[]{new String(problemMethod.closestMatch.declaringClass.shortReadableName()), new String(problemMethod.closestMatch.selector), closestParameterTypeShortNames, parameterTypeShortNames}, severity2, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
                return;
            }
            case 2: {
                id = -1610612239;
                break;
            }
            case 3: {
                id = -1610612238;
                break;
            }
            default: {
                this.needImplementation();
            }
        }
        if ((severity = this.computeSeverity(id)) == -1) {
            return;
        }
        this.handle(id, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, (int)(messageSend.nameSourcePosition >>> 32), (int)messageSend.nameSourcePosition);
    }

    public void javadocInvalidParamTagName(int sourceStart, int sourceEnd) {
        this.handle(-1610612217, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidReference(int sourceStart, int sourceEnd) {
        this.handle(-1610612253, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidSeeReferenceArgs(int sourceStart, int sourceEnd) {
        this.handle(-1610612251, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidSeeUrlReference(int sourceStart, int sourceEnd) {
        this.handle(-1610612252, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidTag(int sourceStart, int sourceEnd) {
        this.handle(-1610612249, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidThrowsClass(int sourceStart, int sourceEnd) {
        this.handle(-1610612257, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocInvalidThrowsClassName(TypeReference typeReference, int modifiers) {
        int severity = this.computeSeverity(-1610612255);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(typeReference.resolvedType.sourceName())};
            this.handle(-1610612255, arguments, arguments, severity, typeReference.sourceStart, typeReference.sourceEnd);
        }
    }

    public void javadocInvalidType(ASTNode location, TypeBinding type, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            int id = -1610612233;
            switch (type.problemId()) {
                case 1: {
                    id = -1610612233;
                    break;
                }
                case 2: {
                    id = -1610612232;
                    break;
                }
                case 3: {
                    id = -1610612231;
                    break;
                }
                case 4: {
                    id = -1610612229;
                    break;
                }
                case 5: {
                    id = -1610612226;
                    break;
                }
                case 7: {
                    id = -1610612268;
                    break;
                }
                default: {
                    this.needImplementation();
                }
            }
            int severity = this.computeSeverity(id);
            if (severity == -1) {
                return;
            }
            this.handle(id, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, severity, location.sourceStart, location.sourceEnd);
        }
    }

    public void javadocMalformedSeeReference(int sourceStart, int sourceEnd) {
        this.handle(-1610612223, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocMissing(int sourceStart, int sourceEnd, int modifiers) {
        String arg;
        boolean report;
        int severity = this.computeSeverity(-1610612250);
        if (severity == -1) {
            return;
        }
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x100000L) != -1 && (!overriding || this.options.reportMissingJavadocCommentsOverriding);
        if (report && (arg = this.javadocVisibilityArgument(this.options.reportMissingJavadocCommentsVisibility, modifiers)) != null) {
            String[] arguments = new String[]{arg};
            this.handle(-1610612250, arguments, arguments, severity, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingHashCharacter(int sourceStart, int sourceEnd, String ref) {
        int severity = this.computeSeverity(-1610612221);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{ref};
        this.handle(-1610612221, arguments, arguments, severity, sourceStart, sourceEnd);
    }

    public void javadocMissingIdentifier(int sourceStart, int sourceEnd, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612269, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingParamName(int sourceStart, int sourceEnd, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612264, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingParamTag(char[] name, int sourceStart, int sourceEnd, int modifiers) {
        boolean report;
        int severity = this.computeSeverity(-1610612265);
        if (severity == -1) {
            return;
        }
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x200000L) != -1 && (!overriding || this.options.reportMissingJavadocTagsOverriding);
        if (report && this.javadocVisibility(this.options.reportMissingJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(name)};
            this.handle(-1610612265, arguments, arguments, severity, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingReference(int sourceStart, int sourceEnd, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612254, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingReturnTag(int sourceStart, int sourceEnd, int modifiers) {
        boolean report;
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x200000L) != -1 && (!overriding || this.options.reportMissingJavadocTagsOverriding);
        if (report && this.javadocVisibility(this.options.reportMissingJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612261, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingThrowsClassName(int sourceStart, int sourceEnd, int modifiers) {
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            this.handle(-1610612258, NoArgument, NoArgument, sourceStart, sourceEnd);
        }
    }

    public void javadocMissingThrowsTag(TypeReference typeRef, int modifiers) {
        boolean report;
        int severity = this.computeSeverity(-1610612259);
        if (severity == -1) {
            return;
        }
        boolean overriding = (modifiers & 0x30000000) != 0;
        boolean bl = report = this.options.getSeverity(0x200000L) != -1 && (!overriding || this.options.reportMissingJavadocTagsOverriding);
        if (report && this.javadocVisibility(this.options.reportMissingJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(typeRef.resolvedType.sourceName())};
            this.handle(-1610612259, arguments, arguments, severity, typeRef.sourceStart, typeRef.sourceEnd);
        }
    }

    public void javadocUndeclaredParamTagName(char[] token, int sourceStart, int sourceEnd, int modifiers) {
        int severity = this.computeSeverity(-1610612262);
        if (severity == -1) {
            return;
        }
        if (this.javadocVisibility(this.options.reportInvalidJavadocTagsVisibility, modifiers)) {
            String[] arguments = new String[]{String.valueOf(token)};
            this.handle(-1610612262, arguments, arguments, severity, sourceStart, sourceEnd);
        }
    }

    public void javadocUnexpectedTag(int sourceStart, int sourceEnd) {
        this.handle(-1610612266, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocUnexpectedText(int sourceStart, int sourceEnd) {
        this.handle(-1610612218, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void javadocUnterminatedInlineTag(int sourceStart, int sourceEnd) {
        this.handle(-1610612224, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    private boolean javadocVisibility(int visibility, int modifiers) {
        if (modifiers < 0) {
            return true;
        }
        switch (modifiers & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return visibility != 1;
            }
            case 0: {
                return visibility == 0 || visibility == 2;
            }
            case 2: {
                return visibility == 2;
            }
        }
        return true;
    }

    private String javadocVisibilityArgument(int visibility, int modifiers) {
        String argument = null;
        switch (modifiers & 7) {
            case 1: {
                argument = "public";
                break;
            }
            case 4: {
                if (visibility == 1) break;
                argument = "protected";
                break;
            }
            case 0: {
                if (visibility != 0 && visibility != 2) break;
                argument = "default";
                break;
            }
            case 2: {
                if (visibility != 2) break;
                argument = "private";
            }
        }
        return argument;
    }

    public void localVariableHiding(LocalDeclaration local, Binding hiddenVariable, boolean isSpecialArgHidingField) {
        if (hiddenVariable instanceof LocalVariableBinding) {
            int id = local instanceof Argument ? 536871006 : 536871002;
            int severity = this.computeSeverity(id);
            if (severity == -1) {
                return;
            }
            String[] arguments = new String[]{new String(local.name)};
            this.handle(id, arguments, arguments, severity, this.nodeSourceStart(hiddenVariable, local), this.nodeSourceEnd(hiddenVariable, local));
        } else if (hiddenVariable instanceof FieldBinding) {
            if (isSpecialArgHidingField && !this.options.reportSpecialParameterHidingField) {
                return;
            }
            int id = local instanceof Argument ? 536871007 : 570425435;
            int severity = this.computeSeverity(id);
            if (severity == -1) {
                return;
            }
            FieldBinding field = (FieldBinding)hiddenVariable;
            this.handle(id, new String[]{new String(local.name), new String(field.declaringClass.readableName())}, new String[]{new String(local.name), new String(field.declaringClass.shortReadableName())}, severity, local.sourceStart, local.sourceEnd);
        }
    }

    public void localVariableNonNullComparedToNull(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871370);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871370, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariableNullComparedToNonNull(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871366);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871366, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariableNullInstanceof(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871368);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871368, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariableNullReference(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871363);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871363, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariablePotentialNullReference(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871364);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871364, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariableRedundantCheckOnNonNull(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871369);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871369, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariableRedundantCheckOnNull(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871365);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871365, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void localVariableRedundantNullAssignment(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536871367);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536871367, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void methodNeedBody(AbstractMethodDeclaration methodDecl) {
        this.handle(603979883, NoArgument, NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void methodNeedingNoBody(MethodDeclaration methodDecl) {
        this.handle((methodDecl.modifiers & 0x100) != 0 ? 603979888 : 603979889, NoArgument, NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void methodWithConstructorName(MethodDeclaration methodDecl) {
        this.handle(67108974, NoArgument, NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void missingReturnType(AbstractMethodDeclaration methodDecl) {
        this.handle(16777327, NoArgument, NoArgument, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void missingSemiColon(Expression expression, int start, int end) {
        this.handle(0x600000E0, NoArgument, NoArgument, start, end);
    }

    public void mustDefineDimensionsOrInitializer(ArrayAllocationExpression expression) {
        this.handle(536871071, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void mustSpecifyPackage(CompilationUnitDeclaration compUnitDecl) {
        String[] arguments = new String[]{new String(compUnitDecl.getFileName())};
        this.handle(536871238, arguments, arguments, compUnitDecl.sourceStart, compUnitDecl.sourceStart + 1);
    }

    public void mustUseAStaticMethod(ASTNode messageSend, MethodBinding method) {
        this.handle(603979977, new String[]{new String(method.declaringClass.readableName()), new String(method.selector != null ? method.selector : "".toCharArray()), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector != null ? method.selector : "".toCharArray()), this.typesAsString(method.isVarargs(), method.parameters, true)}, messageSend.sourceStart, messageSend.sourceEnd);
    }

    public void nativeMethodsCannotBeStrictfp(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.getSafeName())};
        this.handle(67109231, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void needImplementation() {
        this.abortDueToInternalError(Messages.abort_missingCode);
    }

    public void needToEmulateFieldAccess(FieldBinding field, ASTNode location, boolean isReadAccess) {
        int id = isReadAccess ? 33554622 : 33554623;
        int severity = this.computeSeverity(id);
        if (severity == -1) {
            return;
        }
        this.handle(id, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void needToEmulateMethodAccess(MethodBinding method, ASTNode location) {
        if (method.isConstructor()) {
            int severity = this.computeSeverity(67109057);
            if (severity == -1) {
                return;
            }
            this.handle(67109057, new String[]{new String(method.declaringClass.readableName()), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
            return;
        }
        int severity = this.computeSeverity(0x40000C0);
        if (severity == -1) {
            return;
        }
        this.handle(0x40000C0, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, location.sourceStart, location.sourceEnd);
    }

    private int nodeSourceEnd(Binding field, ASTNode node) {
        return this.nodeSourceEnd(field, node, 0);
    }

    private int nodeSourceEnd(Binding field, ASTNode node, int index) {
        if (node instanceof ArrayTypeReference) {
            return ((ArrayTypeReference)node).originalSourceEnd;
        }
        if (node instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)node;
            if (ref.binding == field) {
                return (int)ref.sourcePositions[ref.indexOfFirstFieldBinding - 1];
            }
            FieldBinding[] otherFields = ref.otherBindings;
            if (otherFields != null) {
                int offset = ref.indexOfFirstFieldBinding;
                int i = 0;
                int length = otherFields.length;
                while (i < length) {
                    if (otherFields[i] == field) {
                        return (int)ref.sourcePositions[i + offset];
                    }
                    ++i;
                }
            }
        } else if (node instanceof ArrayQualifiedTypeReference) {
            ArrayQualifiedTypeReference arrayQualifiedTypeReference = (ArrayQualifiedTypeReference)node;
            int length = arrayQualifiedTypeReference.sourcePositions.length;
            return (int)arrayQualifiedTypeReference.sourcePositions[length - 1];
        }
        return node.sourceEnd;
    }

    private int nodeSourceStart(Binding field, ASTNode node) {
        if (node instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)node;
            return (int)(fieldReference.nameSourcePosition >> 32);
        }
        if (node instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)node;
            if (ref.binding == field) {
                return (int)(ref.sourcePositions[ref.indexOfFirstFieldBinding - 1] >> 32);
            }
            FieldBinding[] otherFields = ref.otherBindings;
            if (otherFields != null) {
                int offset = ref.indexOfFirstFieldBinding;
                int i = 0;
                int length = otherFields.length;
                while (i < length) {
                    if (otherFields[i] == field) {
                        return (int)(ref.sourcePositions[i + offset] >> 32);
                    }
                    ++i;
                }
            }
        }
        return node.sourceStart;
    }

    public void noMoreAvailableSpaceForArgument(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.name)};
        this.handle(536870977, arguments, arguments, 159, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void noMoreAvailableSpaceForConstant(TypeDeclaration typeDeclaration) {
        this.handle(536871343, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 159, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void noMoreAvailableSpaceForLocal(LocalVariableBinding local, ASTNode location) {
        String[] arguments = new String[]{new String(local.name)};
        this.handle(0x20000042, arguments, arguments, 159, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void noMoreAvailableSpaceInConstantPool(TypeDeclaration typeDeclaration) {
        this.handle(536871342, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 159, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void nonExternalizedStringLiteral(ASTNode location) {
        this.handle(536871173, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void nonStaticAccessToStaticField(ASTNode location, FieldBinding field) {
        int severity = this.computeSeverity(570425420);
        if (severity == -1) {
            return;
        }
        this.handle(570425420, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void nonStaticAccessToStaticMethod(ASTNode location, MethodBinding method) {
        this.handle(603979893, new String[]{new String(method.declaringClass.readableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(method.selector), this.typesAsString(method.isVarargs(), method.parameters, true)}, location.sourceStart, location.sourceEnd);
    }

    public void looseVariableDecleration(ASTNode location, Assignment assignment) {
        String[] arguments = new String[]{assignment.lhs.toString()};
        this.handle(536871009, arguments, arguments, assignment.sourceStart, assignment.sourceEnd);
    }

    public void optionalSemicolon(ASTNode location) {
        System.out.println("Optional Semi");
    }

    public void noSuchEnclosingInstance(TypeBinding targetType, ASTNode location, boolean isConstructorCall) {
        int id = isConstructorCall ? 536870940 : (location instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)location).accessMode == 1 ? 0x1000014 : (location instanceof AllocationExpression && (((AllocationExpression)location).binding.declaringClass.isMemberType() || ((AllocationExpression)location).binding.declaringClass.isAnonymousType() && ((AllocationExpression)location).binding.declaringClass.superclass().isMemberType()) ? 0x1000015 : 0x1000016));
        this.handle(id, new String[]{new String(targetType.readableName())}, new String[]{new String(targetType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void notCompatibleTypesError(EqualExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x100000F, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void notCompatibleTypesError(InstanceOfExpression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x1000010, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void notCompatibleTypesErrorInForeach(Expression expression, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(16777796, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, expression.sourceStart, expression.sourceEnd);
    }

    public void objectCannotHaveSuperTypes(SourceTypeBinding type) {
        this.handle(536871241, NoArgument, NoArgument, type.sourceStart(), type.sourceEnd());
    }

    public void objectMustBeClass(SourceTypeBinding type) {
        this.handle(536871242, NoArgument, NoArgument, type.sourceStart(), type.sourceEnd());
    }

    public void operatorOnlyValidOnNumericType(CompoundAssignment assignment, TypeBinding leftType, TypeBinding rightType) {
        String rightShortName;
        String leftName = new String(leftType.readableName());
        String rightName = new String(rightType.readableName());
        String leftShortName = new String(leftType.shortReadableName());
        if (leftShortName.equals(rightShortName = new String(rightType.shortReadableName()))) {
            leftShortName = leftName;
            rightShortName = rightName;
        }
        this.handle(0x1000011, new String[]{leftName, rightName}, new String[]{leftShortName, rightShortName}, assignment.sourceStart, assignment.sourceEnd);
    }

    public void overridesDeprecatedMethod(MethodBinding localMethod, MethodBinding inheritedMethod) {
        this.handle(67109276, new String[]{new String(CharOperation.concat(localMethod.declaringClass.readableName(), localMethod.readableName(), '.')), new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(CharOperation.concat(localMethod.declaringClass.shortReadableName(), localMethod.shortReadableName(), '.')), new String(inheritedMethod.declaringClass.shortReadableName())}, localMethod.sourceStart(), localMethod.sourceEnd());
    }

    public void overridesMethodWithoutSuperInvocation(MethodBinding localMethod) {
        this.handle(67109280, new String[]{new String(CharOperation.concat(localMethod.declaringClass.readableName(), localMethod.readableName(), '.'))}, new String[]{new String(CharOperation.concat(localMethod.declaringClass.shortReadableName(), localMethod.shortReadableName(), '.'))}, localMethod.sourceStart(), localMethod.sourceEnd());
    }

    public void overridesPackageDefaultMethod(MethodBinding localMethod, MethodBinding inheritedMethod) {
        this.handle(67109274, new String[]{new String(CharOperation.concat(localMethod.declaringClass.readableName(), localMethod.readableName(), '.')), new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(CharOperation.concat(localMethod.declaringClass.shortReadableName(), localMethod.shortReadableName(), '.')), new String(inheritedMethod.declaringClass.shortReadableName())}, localMethod.sourceStart(), localMethod.sourceEnd());
    }

    public void packageCollidesWithType(CompilationUnitDeclaration compUnitDecl) {
        String[] arguments = new String[]{CharOperation.toString(compUnitDecl.currentPackage.tokens)};
        this.handle(0x1000141, arguments, arguments, compUnitDecl.currentPackage.sourceStart, compUnitDecl.currentPackage.sourceEnd);
    }

    public void packageIsNotExpectedPackage(CompilationUnitDeclaration compUnitDecl) {
        String[] arguments = new String[]{CharOperation.toString(compUnitDecl.compilationResult.getPackageName()), compUnitDecl.currentPackage == null ? "" : CharOperation.toString(compUnitDecl.currentPackage.tokens)};
        this.handle(536871240, arguments, arguments, compUnitDecl.currentPackage == null ? 0 : compUnitDecl.currentPackage.sourceStart, compUnitDecl.currentPackage == null ? 0 : compUnitDecl.currentPackage.sourceEnd);
    }

    public void parameterAssignment(LocalVariableBinding local, ASTNode location) {
        int severity = this.computeSeverity(536870971);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(local.readableName())};
        this.handle(536870971, arguments, arguments, severity, this.nodeSourceStart(local, location), this.nodeSourceEnd(local, location));
    }

    public void parseError(int startPosition, int endPosition, int currentToken, char[] currentTokenSource, String errorTokenName, String[] possibleTokens) {
        if (possibleTokens.length == 0) {
            if (this.isKeyword(currentToken)) {
                String[] arguments = new String[]{new String(currentTokenSource)};
                this.handle(1610612946, arguments, arguments, startPosition, endPosition);
                return;
            }
            String[] arguments = new String[]{errorTokenName};
            this.handle(1610612941, arguments, arguments, startPosition, endPosition);
            return;
        }
        StringBuffer list = new StringBuffer(20);
        int i = 0;
        int max = possibleTokens.length;
        while (i < max) {
            if (i > 0) {
                list.append(", ");
            }
            list.append('\"');
            list.append(possibleTokens[i]);
            list.append('\"');
            ++i;
        }
        if (this.isKeyword(currentToken)) {
            String[] arguments = new String[]{new String(currentTokenSource), list.toString()};
            this.handle(1610612945, arguments, arguments, startPosition, endPosition);
            return;
        }
        if (this.isLiteral(currentToken) || this.isIdentifier(currentToken)) {
            errorTokenName = new String(currentTokenSource);
        }
        String[] arguments = new String[]{errorTokenName, list.toString()};
        this.handle(0x600000CC, arguments, arguments, startPosition, endPosition);
    }

    public void parseErrorDeleteToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName) {
        this.syntaxError(1610612968, start, end, currentKind, errorTokenSource, errorTokenName, null);
    }

    public void parseErrorDeleteTokens(int start, int end) {
        this.handle(1610612969, NoArgument, NoArgument, start, end);
    }

    public void parseErrorInsertAfterToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(1610612967, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorInsertBeforeToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(0x600000E6, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorInsertToComplete(int start, int end, String inserted, String completed) {
        String[] arguments = new String[]{inserted, completed};
        if (";".equals(inserted)) {
            return;
        }
        this.handle(0x600000F0, arguments, arguments, start, end);
    }

    public void parseErrorInsertToCompletePhrase(int start, int end, String inserted) {
        String[] arguments = new String[]{inserted};
        this.handle(1610612978, arguments, arguments, start, end);
    }

    public void parseErrorInsertToCompleteScope(int start, int end, String inserted) {
        String[] arguments = new String[]{inserted};
        this.handle(1610612977, arguments, arguments, start, end);
    }

    public void parseErrorInvalidToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(1610612971, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorMergeTokens(int start, int end, String expectedToken) {
        String[] arguments = new String[]{expectedToken};
        this.handle(1610612970, arguments, arguments, start, end);
    }

    public void parseErrorMisplacedConstruct(int start, int end) {
        this.handle(1610612972, NoArgument, NoArgument, start, end);
    }

    public void parseErrorNoSuggestion(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName) {
        this.syntaxError(1610612941, start, end, currentKind, errorTokenSource, errorTokenName, null);
    }

    public void parseErrorNoSuggestionForTokens(int start, int end) {
        this.handle(0x600000EE, NoArgument, NoArgument, start, end);
    }

    public void parseErrorReplaceToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        this.syntaxError(0x600000CC, start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
    }

    public void parseErrorReplaceTokens(int start, int end, String expectedToken) {
        String[] arguments = new String[]{expectedToken};
        this.handle(1610612973, arguments, arguments, start, end);
    }

    public void parseErrorUnexpectedEnd(int start, int end) {
        String[] arguments = this.referenceContext instanceof ConstructorDeclaration ? new String[]{Messages.parser_endOfConstructor} : (this.referenceContext instanceof MethodDeclaration ? new String[]{Messages.parser_endOfMethod} : (this.referenceContext instanceof TypeDeclaration ? new String[]{Messages.parser_endOfInitializer} : new String[]{Messages.parser_endOfFile}));
        this.handle(1610612975, arguments, arguments, start, end);
    }

    public void possibleAccidentalBooleanAssignment(Assignment assignment) {
        this.handle(536871091, NoArgument, NoArgument, assignment.sourceStart, assignment.sourceEnd);
    }

    public void possibleFallThroughCase(CaseStatement caseStatement) {
        this.handle(0x200000C2, NoArgument, NoArgument, caseStatement.sourceStart, caseStatement.sourceEnd);
    }

    public void recursiveConstructorInvocation(ExplicitConstructorCall constructorCall) {
        this.handle(0x8000089, new String[]{new String(constructorCall.binding.declaringClass.readableName()), this.typesAsString(constructorCall.binding.isVarargs(), constructorCall.binding.parameters, false)}, new String[]{new String(constructorCall.binding.declaringClass.shortReadableName()), this.typesAsString(constructorCall.binding.isVarargs(), constructorCall.binding.parameters, true)}, constructorCall.sourceStart, constructorCall.sourceEnd);
    }

    public void redefineArgument(Argument arg) {
        String[] arguments = new String[]{new String(arg.name)};
        this.handle(536870968, arguments, arguments, arg.sourceStart, arg.sourceEnd);
    }

    public void redefineLocal(LocalDeclaration localDecl) {
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(536870967, arguments, arguments, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void referenceMustBeArrayTypeAt(TypeBinding arrayType, ArrayReference arrayRef) {
        this.handle(536871062, new String[]{new String(arrayType.readableName())}, new String[]{new String(arrayType.shortReadableName())}, arrayRef.sourceStart, arrayRef.sourceEnd);
    }

    public void reset() {
        this.positionScanner = null;
    }

    private int retrieveEndingPositionAfterOpeningParenthesis(int sourceStart, int sourceEnd, int numberOfParen) {
        if (this.referenceContext == null) {
            return sourceEnd;
        }
        CompilationResult compilationResult = this.referenceContext.compilationResult();
        if (compilationResult == null) {
            return sourceEnd;
        }
        ICompilationUnit compilationUnit = compilationResult.getCompilationUnit();
        if (compilationUnit == null) {
            return sourceEnd;
        }
        char[] contents = compilationUnit.getContents();
        if (contents.length == 0) {
            return sourceEnd;
        }
        if (this.positionScanner == null) {
            this.positionScanner = new Scanner(false, false, false, this.options.sourceLevel, this.options.complianceLevel, null, null, false);
        }
        this.positionScanner.setSource(contents);
        this.positionScanner.resetTo(sourceStart, sourceEnd);
        try {
            int token;
            int previousSourceEnd = sourceEnd;
            while ((token = this.positionScanner.getNextToken()) != 55) {
                switch (token) {
                    case 33: {
                        return previousSourceEnd;
                    }
                }
                previousSourceEnd = this.positionScanner.currentPosition - 1;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return sourceEnd;
    }

    private int retrieveStartingPositionAfterOpeningParenthesis(int sourceStart, int sourceEnd, int numberOfParen) {
        if (this.referenceContext == null) {
            return sourceStart;
        }
        CompilationResult compilationResult = this.referenceContext.compilationResult();
        if (compilationResult == null) {
            return sourceStart;
        }
        ICompilationUnit compilationUnit = compilationResult.getCompilationUnit();
        if (compilationUnit == null) {
            return sourceStart;
        }
        char[] contents = compilationUnit.getContents();
        if (contents.length == 0) {
            return sourceStart;
        }
        if (this.positionScanner == null) {
            this.positionScanner = new Scanner(false, false, false, this.options.sourceLevel, this.options.complianceLevel, null, null, false);
        }
        this.positionScanner.setSource(contents);
        this.positionScanner.resetTo(sourceStart, sourceEnd);
        int count = 0;
        try {
            int token;
            while ((token = this.positionScanner.getNextToken()) != 55) {
                switch (token) {
                    case 3: {
                        if (++count != numberOfParen) break;
                        this.positionScanner.getNextToken();
                        return this.positionScanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return sourceStart;
    }

    public void returnTypeCannotBeVoidArray(MethodDeclaration methodDecl) {
        this.handle(536870966, NoArgument, NoArgument, methodDecl.returnType.sourceStart, methodDecl.returnType.sourceEnd);
    }

    public void scannerError(Parser parser, String errorTokenName) {
        String[] stringArray;
        char[] source;
        Scanner scanner = parser.scanner;
        int flag = 1610612941;
        int startPos = scanner.startPosition;
        int endPos = scanner.currentPosition - 1;
        if (errorTokenName.equals("End_Of_Source")) {
            flag = 1610612986;
        } else if (errorTokenName.equals("Invalid_Hexa_Literal")) {
            flag = 1610612987;
        } else if (errorTokenName.equals("Invalid_Octal_Literal")) {
            flag = 1610612988;
        } else if (errorTokenName.equals("Invalid_Character_Constant")) {
            flag = 1610612989;
        } else if (errorTokenName.equals("Invalid_Escape")) {
            flag = 1610612990;
        } else if (errorTokenName.equals("Invalid_Unicode_Escape")) {
            flag = 0x60000100;
            int checkPos = scanner.currentPosition - 1;
            source = scanner.source;
            if (checkPos >= source.length) {
                checkPos = source.length - 1;
            }
            while (checkPos >= startPos) {
                if (source[checkPos] == '\\') break;
                --checkPos;
            }
            startPos = checkPos;
        } else if (errorTokenName.equals("Invalid_Low_Surrogate")) {
            flag = 1610612999;
        } else if (errorTokenName.equals("Invalid_High_Surrogate")) {
            flag = 1610613000;
            source = scanner.source;
            int checkPos = scanner.startPosition + 1;
            while (checkPos <= endPos) {
                if (source[checkPos] == '\\') break;
                ++checkPos;
            }
            endPos = checkPos - 1;
        } else if (errorTokenName.equals("Invalid_Float_Literal")) {
            flag = 0x60000101;
        } else if (errorTokenName.equals("Unterminated_String")) {
            flag = 1610612995;
        } else if (errorTokenName.equals("Unterminated_Comment")) {
            flag = 1610612996;
        } else if (errorTokenName.equals("Invalid_Char_In_String")) {
            flag = 1610612995;
        } else if (errorTokenName.equals("Invalid_Digit")) {
            flag = 0x60000106;
        }
        if (flag == 1610612941) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorTokenName;
        } else {
            stringArray = NoArgument;
        }
        String[] arguments = stringArray;
        this.handle(flag, arguments, arguments, startPos, endPos, parser.compilationUnit.compilationResult);
    }

    public void shouldReturn(TypeBinding returnType, ASTNode location) {
        this.handle(603979884, new String[]{new String(returnType.readableName())}, new String[]{new String(returnType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void staticAndInstanceConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod.isStatic()) {
            this.handle(67109271, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
        } else {
            this.handle(67109270, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
        }
    }

    public void staticFieldAccessToNonStaticVariable(ASTNode location, FieldBinding field) {
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(33554506, arguments, arguments, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void staticInheritedMethodConflicts(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        this.handle(67109272, new String[]{new String(concreteMethod.readableName()), new String(abstractMethods[0].declaringClass.readableName())}, new String[]{new String(concreteMethod.readableName()), new String(abstractMethods[0].declaringClass.shortReadableName())}, type.sourceStart(), type.sourceEnd());
    }

    public void stringConstantIsExceedingUtf8Limit(ASTNode location) {
        this.handle(536871064, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void superclassMustBeAClass(SourceTypeBinding type, TypeReference superclassRef, ReferenceBinding superType) {
        this.handle(16777528, new String[]{new String(superType.readableName()), new String(type.sourceName())}, new String[]{new String(superType.shortReadableName()), new String(type.sourceName())}, superclassRef.sourceStart, superclassRef.sourceEnd);
    }

    public void superclassMustBeAClass(SourceTypeBinding type, InferredType superclassRef, ReferenceBinding superType) {
        this.handle(16777528, new String[]{new String(superType.readableName()), new String(type.sourceName())}, new String[]{new String(superType.shortReadableName()), new String(type.sourceName())}, superclassRef.sourceStart, superclassRef.sourceEnd);
    }

    public void superfluousSemicolon(int sourceStart, int sourceEnd) {
        this.handle(536871092, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    private void syntaxError(int id, int startPosition, int endPosition, int currentKind, char[] currentTokenSource, String errorTokenName, String expectedToken) {
        String eTokenName = this.isKeyword(currentKind) || this.isLiteral(currentKind) || this.isIdentifier(currentKind) ? new String(currentTokenSource) : errorTokenName;
        String[] arguments = expectedToken != null ? new String[]{eTokenName, expectedToken} : new String[]{eTokenName};
        this.handle(id, arguments, arguments, startPosition, endPosition);
    }

    public void task(String tag, String message, String priority, int start, int end) {
        this.handle(536871362, new String[]{tag, message, priority}, new String[]{tag, message, priority}, start, end);
    }

    public void tooManyDimensions(ASTNode expression) {
        this.handle(0x20000044, NoArgument, NoArgument, expression.sourceStart, expression.sourceEnd);
    }

    public void tooManyFields(TypeDeclaration typeDeclaration) {
        this.handle(536871344, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 159, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void tooManyMethods(TypeDeclaration typeDeclaration) {
        this.handle(536871345, new String[]{new String(typeDeclaration.binding.readableName())}, new String[]{new String(typeDeclaration.binding.shortReadableName())}, 159, typeDeclaration.sourceStart, typeDeclaration.sourceEnd);
    }

    public void typeCollidesWithEnclosingType(TypeDeclaration typeDecl) {
        String[] arguments = new String[]{new String(typeDecl.name)};
        this.handle(16777534, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void typeCollidesWithPackage(CompilationUnitDeclaration compUnitDecl, TypeDeclaration typeDecl) {
        this.referenceContext = typeDecl;
        String[] arguments = new String[]{new String(compUnitDecl.getFileName()), new String(typeDecl.name)};
        this.handle(16777538, arguments, arguments, typeDecl.sourceStart, typeDecl.sourceEnd, compUnitDecl.compilationResult);
    }

    public void typeHiding(TypeDeclaration typeDecl, TypeBinding hiddenType) {
        int severity = this.computeSeverity(0x1000021);
        if (severity == -1) {
            return;
        }
        this.handle(0x1000021, new String[]{new String(typeDecl.name), new String(hiddenType.shortReadableName())}, new String[]{new String(typeDecl.name), new String(hiddenType.readableName())}, severity, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void typeMismatchError(TypeBinding actualType, TypeBinding expectedType, ASTNode location) {
        this.handle(0x1000011, new String[]{new String(actualType.readableName()), new String(expectedType.readableName())}, new String[]{new String(actualType.shortReadableName()), new String(expectedType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    private String typesAsString(boolean isVarargs, TypeBinding[] types, boolean makeShort) {
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        int length = types.length;
        while (i < length) {
            boolean isVarargType;
            if (i != 0) {
                buffer.append(", ");
            }
            TypeBinding type = types[i];
            boolean bl = isVarargType = isVarargs && i == length - 1;
            if (isVarargType) {
                type = ((ArrayBinding)type).elementsType();
            }
            buffer.append(new String(makeShort ? type.shortReadableName() : type.readableName()));
            if (isVarargType) {
                buffer.append("...");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void undefinedLabel(BranchStatement statement) {
        if (this.isRecoveredName(statement.label)) {
            return;
        }
        String[] arguments = new String[]{new String(statement.label)};
        this.handle(536871086, arguments, arguments, statement.sourceStart, statement.sourceEnd);
    }

    public void undocumentedEmptyBlock(int blockStart, int blockEnd) {
        this.handle(536871372, NoArgument, NoArgument, blockStart, blockEnd);
    }

    public void unexpectedStaticModifierForField(SourceTypeBinding type, FieldDeclaration fieldDecl) {
        String[] arguments = new String[]{new String(fieldDecl.name)};
        this.handle(33554778, arguments, arguments, fieldDecl.sourceStart, fieldDecl.sourceEnd);
    }

    public void unexpectedStaticModifierForMethod(ReferenceBinding type, AbstractMethodDeclaration methodDecl) {
        String[] arguments = new String[]{new String(type.sourceName()), new String(methodDecl.getSafeName())};
        this.handle(67109225, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void unhandledException(TypeBinding exceptionType, ASTNode location) {
        boolean insideImplicitConstructorCall;
        boolean insideDefaultConstructor = this.referenceContext instanceof ConstructorDeclaration && ((ConstructorDeclaration)this.referenceContext).isDefaultConstructor();
        boolean bl = insideImplicitConstructorCall = location instanceof ExplicitConstructorCall && ((ExplicitConstructorCall)location).accessMode == 1;
        this.handle(insideDefaultConstructor ? 16777362 : (insideImplicitConstructorCall ? 0x800008F : 16777384), new String[]{new String(exceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void uninitializedBlankFinalField(FieldBinding field, ASTNode location) {
        String[] arguments = new String[]{new String(field.readableName())};
        this.handle(33554513, arguments, arguments, this.nodeSourceStart(field, location), this.nodeSourceEnd(field, location));
    }

    public void uninitializedLocalVariable(LocalVariableBinding binding, ASTNode location) {
        int severity = this.computeSeverity(0x20000033);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(binding.readableName())};
        this.handle(0x20000033, arguments, arguments, severity, this.nodeSourceStart(binding, location), this.nodeSourceEnd(binding, location));
    }

    public void uninitializedGlobalVariable(LocalVariableBinding binding, ASTNode location) {
        int severity = this.computeSeverity(0x20000062);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(binding.readableName())};
        this.handle(0x20000062, arguments, arguments, severity, this.nodeSourceStart(binding, location), this.nodeSourceEnd(binding, location));
    }

    public void unmatchedBracket(int position, ReferenceContext context, CompilationResult compilationResult) {
        this.handle(1610612956, NoArgument, NoArgument, position, position, context, compilationResult);
    }

    public void unnecessaryElse(ASTNode location) {
        this.handle(536871101, NoArgument, NoArgument, location.sourceStart, location.sourceEnd);
    }

    public void unnecessaryEnclosingInstanceSpecification(Expression expression, ReferenceBinding targetType) {
        this.handle(0x1000017, new String[]{new String(targetType.readableName())}, new String[]{new String(targetType.shortReadableName())}, expression.sourceStart, expression.sourceEnd);
    }

    public void unnecessaryInstanceof(InstanceOfExpression instanceofExpression, TypeBinding checkType) {
        int severity = this.computeSeverity(553648311);
        if (severity == -1) {
            return;
        }
        TypeBinding expressionType = instanceofExpression.expression.resolvedType;
        this.handle(553648311, new String[]{new String(expressionType.readableName()), new String(checkType.readableName())}, new String[]{new String(expressionType.shortReadableName()), new String(checkType.shortReadableName())}, severity, instanceofExpression.sourceStart, instanceofExpression.sourceEnd);
    }

    public void unnecessaryNLSTags(int sourceStart, int sourceEnd) {
        this.handle(536871177, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void unqualifiedFieldAccess(NameReference reference, FieldBinding field) {
        int sourceStart = reference.sourceStart;
        int sourceEnd = reference.sourceEnd;
        if (reference instanceof SingleNameReference) {
            int numberOfParens = (reference.bits & 0x1FE00000) >> 21;
            if (numberOfParens != 0) {
                sourceStart = this.retrieveStartingPositionAfterOpeningParenthesis(sourceStart, sourceEnd, numberOfParens);
                sourceEnd = this.retrieveEndingPositionAfterOpeningParenthesis(sourceStart, sourceEnd, numberOfParens);
            } else {
                sourceStart = this.nodeSourceStart(field, reference);
                sourceEnd = this.nodeSourceEnd(field, reference);
            }
        } else {
            sourceStart = this.nodeSourceStart(field, reference);
            sourceEnd = this.nodeSourceEnd(field, reference);
        }
        this.handle(570425423, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, sourceStart, sourceEnd);
    }

    public void unreachableCatchBlock(ReferenceBinding exceptionType, ASTNode location) {
        this.handle(83886247, new String[]{new String(exceptionType.readableName())}, new String[]{new String(exceptionType.shortReadableName())}, location.sourceStart, location.sourceEnd);
    }

    public void unreachableCode(Statement statement) {
        int statemendEnd;
        int sourceStart = statement.sourceStart;
        int sourceEnd = statement.sourceEnd;
        if (statement instanceof LocalDeclaration) {
            LocalDeclaration declaration = (LocalDeclaration)statement;
            sourceStart = declaration.declarationSourceStart;
            sourceEnd = declaration.declarationSourceEnd;
        } else if (statement instanceof Expression && (statemendEnd = ((Expression)statement).statementEnd) != -1) {
            sourceEnd = statemendEnd;
        }
        this.handle(536871073, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void unresolvableReference(NameReference nameRef, Binding binding) {
        String[] arguments = new String[]{new String(binding.readableName())};
        int end = nameRef.sourceEnd;
        if (nameRef instanceof QualifiedNameReference) {
            QualifiedNameReference ref = (QualifiedNameReference)nameRef;
            if (this.isRecoveredName(ref.tokens)) {
                return;
            }
            if (ref.indexOfFirstFieldBinding >= 1) {
                end = (int)ref.sourcePositions[ref.indexOfFirstFieldBinding - 1];
            }
        } else {
            SingleNameReference ref = (SingleNameReference)nameRef;
            if (this.isRecoveredName(ref.token)) {
                return;
            }
        }
        this.handle(0x22000032, arguments, arguments, nameRef.sourceStart, end);
    }

    public void unusedArgument(LocalDeclaration localDecl) {
        int severity = this.computeSeverity(536870974);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(536870974, arguments, arguments, severity, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void unusedDeclaredThrownException(ReferenceBinding exceptionType, AbstractMethodDeclaration method, ASTNode location) {
        boolean isConstructor = method.isConstructor();
        int severity = this.computeSeverity(isConstructor ? 536871098 : 536871097);
        if (severity == -1) {
            return;
        }
        if (isConstructor) {
            this.handle(536871098, new String[]{new String(method.binding.declaringClass.readableName()), this.typesAsString(method.binding.isVarargs(), method.binding.parameters, false), new String(exceptionType.readableName())}, new String[]{new String(method.binding.declaringClass.shortReadableName()), this.typesAsString(method.binding.isVarargs(), method.binding.parameters, true), new String(exceptionType.shortReadableName())}, severity, location.sourceStart, location.sourceEnd);
        } else {
            this.handle(536871097, new String[]{new String(method.binding.declaringClass.readableName()), new String(method.getSafeName()), this.typesAsString(method.binding.isVarargs(), method.binding.parameters, false), new String(exceptionType.readableName())}, new String[]{new String(method.binding.declaringClass.shortReadableName()), new String(method.getSafeName()), this.typesAsString(method.binding.isVarargs(), method.binding.parameters, true), new String(exceptionType.shortReadableName())}, severity, location.sourceStart, location.sourceEnd);
        }
    }

    public void unusedLabel(LabeledStatement statement) {
        int severity = this.computeSeverity(536871111);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(statement.label)};
        this.handle(536871111, arguments, arguments, severity, statement.sourceStart, statement.labelEnd);
    }

    public void unusedLocalVariable(LocalDeclaration localDecl) {
        int severity = this.computeSeverity(536870973);
        if (severity == -1) {
            return;
        }
        String[] arguments = new String[]{new String(localDecl.name)};
        this.handle(536870973, arguments, arguments, severity, localDecl.sourceStart, localDecl.sourceEnd);
    }

    public void unusedPrivateConstructor(ConstructorDeclaration constructorDecl) {
        int severity = this.computeSeverity(603979910);
        if (severity == -1) {
            return;
        }
        MethodBinding constructor = constructorDecl.binding;
        this.handle(603979910, new String[]{new String(constructor.declaringClass.readableName()), this.typesAsString(constructor.isVarargs(), constructor.parameters, false)}, new String[]{new String(constructor.declaringClass.shortReadableName()), this.typesAsString(constructor.isVarargs(), constructor.parameters, true)}, severity, constructorDecl.sourceStart, constructorDecl.sourceEnd);
    }

    public void unusedPrivateField(FieldDeclaration fieldDecl) {
        int severity = this.computeSeverity(570425421);
        if (severity == -1) {
            return;
        }
        FieldBinding field = fieldDecl.binding;
        this.handle(570425421, new String[]{new String(field.declaringClass.readableName()), new String(field.name)}, new String[]{new String(field.declaringClass.shortReadableName()), new String(field.name)}, severity, this.nodeSourceStart(field, fieldDecl), this.nodeSourceEnd(field, fieldDecl));
    }

    public void unusedPrivateMethod(AbstractMethodDeclaration methodDecl) {
        int severity = this.computeSeverity(603979894);
        if (severity == -1) {
            return;
        }
        MethodBinding method = methodDecl.binding;
        char[] methodSelector = method.selector;
        if (methodSelector == null) {
            methodSelector = methodDecl.getSafeName();
        }
        if (!method.isStatic() && 1 == method.returnType.id && method.parameters.length == 0 && CharOperation.equals(methodSelector, TypeConstants.READRESOLVE)) {
            return;
        }
        if (!method.isStatic() && 1 == method.returnType.id && method.parameters.length == 0 && CharOperation.equals(methodSelector, TypeConstants.WRITEREPLACE)) {
            return;
        }
        this.handle(603979894, new String[]{new String(method.declaringClass.readableName()), new String(methodSelector), this.typesAsString(method.isVarargs(), method.parameters, false)}, new String[]{new String(method.declaringClass.shortReadableName()), new String(methodSelector), this.typesAsString(method.isVarargs(), method.parameters, true)}, severity, methodDecl.sourceStart, methodDecl.sourceEnd);
    }

    public void unusedPrivateType(TypeDeclaration typeDecl) {
        int severity = this.computeSeverity(553648135);
        if (severity == -1) {
            return;
        }
        SourceTypeBinding type = typeDecl.binding;
        this.handle(553648135, new String[]{new String(type.readableName())}, new String[]{new String(type.shortReadableName())}, severity, typeDecl.sourceStart, typeDecl.sourceEnd);
    }

    public void useAssertAsAnIdentifier(char[] keyword, int sourceStart, int sourceEnd) {
        this.handle(536871352, new String[]{new String(keyword)}, new String[]{new String(keyword)}, sourceStart, sourceEnd);
    }

    public void useEnumAsAnIdentifier(int sourceStart, int sourceEnd) {
        this.handle(536871353, NoArgument, NoArgument, sourceStart, sourceEnd);
    }

    public void variableTypeCannotBeVoid(AbstractVariableDeclaration varDecl) {
        String[] arguments = new String[]{new String(varDecl.name)};
        this.handle(536870964, arguments, arguments, varDecl.sourceStart, varDecl.sourceEnd);
    }

    public void variableTypeCannotBeVoidArray(AbstractVariableDeclaration varDecl) {
        this.handle(536870966, NoArgument, NoArgument, varDecl.type.sourceStart, varDecl.type.sourceEnd);
    }

    public void visibilityConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        this.handle(67109273, new String[]{new String(inheritedMethod.declaringClass.readableName())}, new String[]{new String(inheritedMethod.declaringClass.shortReadableName())}, currentMethod.sourceStart(), currentMethod.sourceEnd());
    }
}

