/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JavaElementImplementationHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IMethod fMethod;
    private final boolean fQualify;
    private IEditorPart fEditor;
    static /* synthetic */ Class class$0;

    public JavaElementImplementationHyperlink(IRegion region, SelectionDispatchAction openAction, IMethod method, boolean qualify, IEditorPart editor) {
        Assert.isNotNull((Object)((Object)openAction));
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)method);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fMethod = method;
        this.fQualify = qualify;
        this.fEditor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)this.fMethod, JavaElementLabels.ALL_FULLY_QUALIFIED);
            return Messages.format(JavaEditorMessages.JavaElementImplementationHyperlink_hyperlinkText_qualified, new Object[]{methodLabel});
        }
        return JavaEditorMessages.JavaElementImplementationHyperlink_hyperlinkText;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        JavaElementImplementationHyperlink.openImplementations(this.fEditor, this.fRegion, this.fMethod, this.fOpenAction);
    }

    public static void openImplementations(IEditorPart editor, IRegion region, final IMethod method, SelectionDispatchAction openAction) {
        ArrayList links;
        boolean[] isMethodAbstract;
        block17: {
            IType receiverType;
            try {
                if (JavaElementImplementationHyperlink.cannotBeOverriddenMethod(method)) {
                    openAction.run((IStructuredSelection)new StructuredSelection((Object)method));
                    return;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return;
            }
            ITypeRoot editorInput = EditorUtility.getEditorInputJavaElement(editor, false);
            CompilationUnit ast = SharedASTProvider.getAST(editorInput, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            if (ast == null) {
                JavaElementImplementationHyperlink.openQuickHierarchy(editor);
                return;
            }
            ASTNode node = NodeFinder.perform((ASTNode)ast, (int)region.getOffset(), (int)region.getLength());
            ITypeBinding parentTypeBinding = null;
            if (node instanceof SimpleName) {
                ASTNode parent = node.getParent();
                if (parent instanceof MethodInvocation) {
                    Expression expression = ((MethodInvocation)parent).getExpression();
                    parentTypeBinding = expression == null ? Bindings.getBindingOfParentType(node) : expression.resolveTypeBinding();
                } else {
                    if (parent instanceof SuperMethodInvocation) {
                        openAction.run((IStructuredSelection)new StructuredSelection((Object)method));
                        return;
                    }
                    if (parent instanceof MethodDeclaration) {
                        parentTypeBinding = Bindings.getBindingOfParentType(node);
                    }
                }
            }
            IType iType = receiverType = parentTypeBinding != null ? (IType)parentTypeBinding.getJavaElement() : null;
            if (receiverType == null) {
                JavaElementImplementationHyperlink.openQuickHierarchy(editor);
                return;
            }
            isMethodAbstract = new boolean[1];
            final String dummyString = new String();
            links = new ArrayList();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            IJavaSearchScope hierarchyScope;
                            String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)method, JavaElementLabels.DEFAULT_QUALIFIED);
                            monitor.beginTask(Messages.format(JavaEditorMessages.JavaElementImplementationHyperlink_search_method_implementors, methodLabel), 10);
                            SearchRequestor requestor = new SearchRequestor(this, links, dummyString){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ ArrayList val$links;
                                private final /* synthetic */ String val$dummyString;
                                {
                                    this.this$1 = var1_1;
                                    this.val$links = arrayList;
                                    this.val$dummyString = string;
                                }

                                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                    IMethod methodFound;
                                    Object element;
                                    if (match.getAccuracy() == 0 && (element = match.getElement()) instanceof IMethod && !JdtFlags.isAbstract((IMember)(methodFound = (IMethod)element))) {
                                        this.val$links.add(methodFound);
                                        if (this.val$links.size() > 1) {
                                            throw new OperationCanceledException(this.val$dummyString);
                                        }
                                    }
                                }
                            };
                            if (receiverType.isInterface()) {
                                hierarchyScope = SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
                            } else if (JavaElementImplementationHyperlink.isFullHierarchyNeeded((IProgressMonitor)new SubProgressMonitor(monitor, 3), method, receiverType)) {
                                hierarchyScope = SearchEngine.createHierarchyScope((IType)receiverType);
                            } else {
                                isMethodAbstract[0] = JdtFlags.isAbstract((IMember)method);
                                hierarchyScope = SearchEngine.createStrictHierarchyScope(null, (IType)receiverType, (boolean)true, (!isMethodAbstract[0] ? 1 : 0) != 0, null);
                            }
                            int limitTo = 48;
                            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)method, (int)limitTo);
                            Assert.isNotNull((Object)pattern);
                            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                            SearchEngine engine = new SearchEngine();
                            engine.search(pattern, participants, hierarchyScope, requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                IWorkbenchWindow context = editor.getSite().getWorkbenchWindow();
                context.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(JavaEditorMessages.JavaElementImplementationHyperlink_error_status_message, method.getElementName()), e.getCause());
                JavaPlugin.log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JavaEditorMessages.JavaElementImplementationHyperlink_hyperlinkText, (String)JavaEditorMessages.JavaElementImplementationHyperlink_error_no_implementations_found_message, (IStatus)status);
            }
            catch (InterruptedException e) {
                if (e.getMessage() == dummyString) break block17;
                return;
            }
        }
        if (links.isEmpty() && isMethodAbstract[0]) {
            openAction.run((IStructuredSelection)new StructuredSelection((Object)method));
        } else if (links.size() == 1) {
            openAction.run((IStructuredSelection)new StructuredSelection(links.get(0)));
        } else {
            JavaElementImplementationHyperlink.openQuickHierarchy(editor);
        }
    }

    private static boolean cannotBeOverriddenMethod(IMethod method) throws JavaModelException {
        return JdtFlags.isPrivate((IMember)method) || JdtFlags.isFinal((IMember)method) || JdtFlags.isStatic((IMember)method) || method.isConstructor() || JdtFlags.isFinal((IMember)method.getParent());
    }

    private static boolean isFullHierarchyNeeded(IProgressMonitor monitor, IMethod method, IType receiverType) throws JavaModelException {
        ITypeHierarchy superTypeHierarchy = receiverType.newSupertypeHierarchy(monitor);
        MethodOverrideTester methodOverrideTester = new MethodOverrideTester(receiverType, superTypeHierarchy);
        return methodOverrideTester.findOverriddenMethodInType(receiverType, method) == null;
    }

    private static void openQuickHierarchy(IEditorPart editor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextOperationTarget textOperationTarget = (ITextOperationTarget)editor.getAdapter((Class)clazz);
        textOperationTarget.doOperation(53);
    }
}

