/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class NLSKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private AccessorClassReference fAccessorClassReference;
    private IEditorPart fEditor;
    private final String fKeyName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NLSKeyHyperlink(IRegion region, String keyName, AccessorClassReference ref, IEditorPart editor) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)keyName);
        Assert.isNotNull((Object)ref);
        Assert.isNotNull((Object)editor);
        this.fRegion = region;
        this.fKeyName = keyName;
        this.fAccessorClassReference = ref;
        this.fEditor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        IStorage propertiesFile = null;
        try {
            ITypeBinding typeBinding = this.fAccessorClassReference.getBinding();
            propertiesFile = NLSHintHelper.getResourceBundle(typeBinding.getJavaElement().getJavaProject(), this.fAccessorClassReference);
        }
        catch (JavaModelException javaModelException) {}
        NLSKeyHyperlink.openKeyInPropertiesFile(this.fKeyName, propertiesFile, this.fEditor);
    }

    public static void openKeyInPropertiesFile(String keyName, IStorage propertiesFile, IEditorPart activeEditor) {
        IEditorPart editor;
        if (propertiesFile == null) {
            NLSKeyHyperlink.showErrorInStatusLine(activeEditor, JavaEditorMessages.Editor_OpenPropertiesFile_error_fileNotFound_dialogMessage);
            return;
        }
        try {
            editor = EditorUtility.openInEditor(propertiesFile, true);
        }
        catch (PartInitException partInitException) {
            NLSKeyHyperlink.handleOpenPropertiesFileFailed(propertiesFile, activeEditor);
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = null;
        if (editor instanceof ITextEditor) {
            document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editorInput);
        } else {
            IFile file;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)editorInput.getAdapter((Class)clazz)) != null) {
                IPath path = file.getFullPath();
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                try {
                    manager.connect(path, LocationKind.IFILE, null);
                    try {
                        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                        if (buffer != null) {
                            document = buffer.getDocument();
                        }
                    }
                    finally {
                        manager.disconnect(path, LocationKind.IFILE, null);
                    }
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex);
                }
            }
        }
        boolean found = false;
        IRegion region = null;
        if (document != null) {
            FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
            PropertyKeyHyperlinkDetector detector = new PropertyKeyHyperlinkDetector();
            detector.setContext((IAdaptable)editor);
            String key = PropertyFileDocumentModel.escape(keyName, false);
            int offset = document.getLength() - 1;
            try {
                while (!found && offset >= 0) {
                    region = finder.find(offset, key, false, true, false, false);
                    if (region == null) {
                        offset = -1;
                        continue;
                    }
                    IHyperlink[] hyperlinks = detector.detectHyperlinks(null, region, false);
                    if (hyperlinks != null) {
                        int i = 0;
                        while (i < hyperlinks.length) {
                            IRegion hyperlinkRegion = hyperlinks[i].getHyperlinkRegion();
                            found = key.equals(document.get(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength()));
                            ++i;
                        }
                    } else if (document instanceof IDocumentExtension3) {
                        ITypedRegion partition = null;
                        partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", region.getOffset(), false);
                        found = "__dftl_partition_content_type".equals(partition.getType()) && key.equals(document.get(partition.getOffset(), partition.getLength()).trim());
                    }
                    offset = offset == region.getOffset() ? -1 : region.getOffset();
                }
            }
            catch (BadLocationException badLocationException) {
                found = false;
            }
            catch (BadPartitioningException badPartitioningException) {
                found = false;
            }
        }
        if (found) {
            EditorUtility.revealInEditor(editor, region);
        } else {
            EditorUtility.revealInEditor(editor, 0, 0);
            NLSKeyHyperlink.showErrorInStatusLine(editor, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_keyNotFound, keyName));
        }
    }

    private static void showErrorInStatusLine(IEditorPart editor, final String message) {
        IEditorStatusLine statusLine;
        Display display = editor.getSite().getShell().getDisplay();
        display.beep();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)editor.getAdapter((Class)clazz)) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }

    private static void handleOpenPropertiesFileFailed(IStorage propertiesFile, IEditorPart editor) {
        NLSKeyHyperlink.showErrorInStatusLine(editor, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_openEditor_dialogMessage, BasicElementLabels.getPathLabel(propertiesFile.getFullPath(), true)));
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String bundleName = this.fAccessorClassReference.getResourceBundleName();
        String propertyFileName = BasicElementLabels.getResourceName(String.valueOf(bundleName.substring(bundleName.lastIndexOf(46) + 1, bundleName.length())) + ".properties");
        return Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_hyperlinkText, new Object[]{propertyFileName});
    }
}

