/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.breadcrumb;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbItem;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormColors;

class BreadcrumbItemDropDown {
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/BreadcrumbItemDropDown"));
    private static final boolean IS_MAC_WORKAROUND = "carbon".equals(SWT.getPlatform());
    private static final int DROP_DOWN_MIN_WIDTH = 250;
    private static final int DROP_DOWN_MAX_WIDTH = 500;
    private static final int DROP_DOWN_DEFAULT_MIN_HEIGHT = 200;
    private static final int DROP_DOWN_DEFAULT_MAX_HEIGHT = 300;
    private static final String DIALOG_SETTINGS = "BreadcrumbItemDropDown";
    private static final String DIALOG_HEIGHT = "height";
    private final BreadcrumbItem fParent;
    private final Composite fParentComposite;
    private final ToolBar fToolBar;
    private boolean fMenuIsShown;
    private boolean fEnabled;
    private TreeViewer fDropDownViewer;
    private Shell fShell;
    private boolean isResizingProgrammatically;

    public BreadcrumbItemDropDown(BreadcrumbItem parent, Composite composite) {
        this.fParent = parent;
        this.fParentComposite = composite;
        this.fMenuIsShown = false;
        this.fEnabled = true;
        this.fToolBar = new ToolBar(composite, 0x800000);
        this.fToolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        SWTUtil.setAccessibilityText((Control)this.fToolBar, BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_toolTip);
        ToolBarManager manager = new ToolBarManager(this.fToolBar);
        final Action showDropDownMenuAction = new Action(null, 0){

            public void run() {
                Shell shell = BreadcrumbItemDropDown.this.fParent.getDropDownShell();
                if (shell != null) {
                    return;
                }
                shell = BreadcrumbItemDropDown.this.fParent.getViewer().getDropDownShell();
                if (shell != null) {
                    shell.close();
                }
                BreadcrumbItemDropDown.this.showMenu();
                BreadcrumbItemDropDown.this.fShell.setFocus();
            }
        };
        showDropDownMenuAction.setImageDescriptor((ImageDescriptor)new AccessibelArrowImage(this.isLTR()));
        showDropDownMenuAction.setToolTipText(BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_toolTip);
        manager.add((IAction)showDropDownMenuAction);
        manager.update(true);
        if (IS_MAC_WORKAROUND) {
            manager.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    showDropDownMenuAction.run();
                }
            });
        }
    }

    public int getWidth() {
        return this.fToolBar.computeSize((int)-1, (int)-1).x;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.fToolBar.setVisible(enabled);
    }

    public boolean isMenuShown() {
        return this.fMenuIsShown;
    }

    public Shell getDropDownShell() {
        if (!this.isMenuShown()) {
            return null;
        }
        return this.fShell;
    }

    public ISelectionProvider getDropDownSelectionProvider() {
        if (!this.fMenuIsShown) {
            return null;
        }
        return this.fDropDownViewer;
    }

    public void showMenu() {
        if (DEBUG) {
            System.out.println("BreadcrumbItemDropDown.showMenu()");
        }
        if (!this.fEnabled || this.fMenuIsShown) {
            return;
        }
        this.fMenuIsShown = true;
        this.fShell = new Shell(this.fToolBar.getShell(), 16404);
        if (DEBUG) {
            System.out.println("\tcreating new shell");
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fShell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this.fShell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.fDropDownViewer = new ProblemTreeViewer(composite, 772);
        this.fDropDownViewer.setUseHashlookup(true);
        final Tree tree = (Tree)this.fDropDownViewer.getControl();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        Object input = this.fParent.getData();
        this.fParent.getViewer().configureDropDownViewer(this.fDropDownViewer, input);
        this.fDropDownViewer.setInput(input);
        this.setShellBounds(this.fShell);
        this.fShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (BreadcrumbItemDropDown.this.isResizingProgrammatically) {
                    return;
                }
                Point size = BreadcrumbItemDropDown.this.fShell.getSize();
                BreadcrumbItemDropDown.this.getDialogSettings().put(BreadcrumbItemDropDown.DIALOG_HEIGHT, size.y);
            }
        });
        this.fDropDownViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection;
                if (DEBUG) {
                    System.out.println("BreadcrumbItemDropDown.showMenu()$treeViewer>open");
                }
                if (!((selection = event.getSelection()) instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element == null) {
                    return;
                }
                BreadcrumbItemDropDown.this.openElement(element);
            }
        });
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (DEBUG) {
                    System.out.println("BreadcrumbItemDropDown.showMenu()$treeViewer>mouseUp");
                }
                if (e.button != 1) {
                    return;
                }
                if ((OpenStrategy.getOpenMethod() & 1) != 0) {
                    return;
                }
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                BreadcrumbItemDropDown.this.openElement(item.getData());
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    if (o != null && !o.equals(this.fLastItem) || this.fLastItem != null && o == null) {
                        boolean showHandPointer = false;
                        if (o instanceof TreeItem) {
                            Object itemData = o.getData();
                            if (itemData instanceof IJavaElement) {
                                int elementType = ((IJavaElement)itemData).getElementType();
                                if (elementType != 2 && elementType != 4 && elementType != 3) {
                                    showHandPointer = true;
                                }
                            } else if (itemData instanceof IFile) {
                                showHandPointer = true;
                            } else if (itemData instanceof IJarEntryResource) {
                                showHandPointer = ((IJarEntryResource)itemData).isFile();
                            }
                        }
                        tree.setCursor(showHandPointer ? tree.getDisplay().getSystemCursor(21) : null);
                    }
                    if (o instanceof TreeItem) {
                        int index;
                        Rectangle clientArea = tree.getClientArea();
                        TreeItem currentItem = o;
                        if (!o.equals(this.fLastItem)) {
                            this.fLastItem = o;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                            if (currentItem.getParentItem() == null) {
                                index = tree.indexOf(o);
                                if (index < 1) {
                                    return;
                                }
                                this.fLastItem = tree.getItem(index - 1);
                                tree.setSelection(new TreeItem[]{this.fLastItem});
                            } else {
                                Point p = tree.toDisplay(e.x, e.y);
                                Item item = BreadcrumbItemDropDown.this.fDropDownViewer.scrollUp(p.x, p.y);
                                if (item instanceof TreeItem) {
                                    this.fLastItem = (TreeItem)item;
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                }
                            }
                        } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                            if (currentItem.getParentItem() == null) {
                                index = tree.indexOf(o);
                                if (index >= tree.getItemCount() - 1) {
                                    return;
                                }
                                this.fLastItem = tree.getItem(index + 1);
                                tree.setSelection(new TreeItem[]{this.fLastItem});
                            } else {
                                Point p = tree.toDisplay(e.x, e.y);
                                Item item = BreadcrumbItemDropDown.this.fDropDownViewer.scrollDown(p.x, p.y);
                                if (item instanceof TreeItem) {
                                    this.fLastItem = (TreeItem)item;
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                }
                            }
                        }
                    } else if (o == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    TreeItem[] selection = tree.getSelection();
                    if (selection.length != 1) {
                        return;
                    }
                    int selectionIndex = tree.indexOf(selection[0]);
                    if (selectionIndex != 0) {
                        return;
                    }
                    BreadcrumbItemDropDown.this.fShell.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fDropDownViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                tree.setRedraw(false);
                BreadcrumbItemDropDown.this.fShell.getDisplay().asyncExec(new Runnable(this, tree){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ Tree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$tree = tree;
                    }

                    public void run() {
                        if (BreadcrumbItemDropDown.access$2(8.access$0(this.this$1)).isDisposed()) {
                            return;
                        }
                        try {
                            BreadcrumbItemDropDown.access$8(8.access$0(this.this$1), BreadcrumbItemDropDown.access$2(8.access$0(this.this$1)));
                        }
                        finally {
                            this.val$tree.setRedraw(true);
                        }
                    }
                });
            }

            static /* synthetic */ BreadcrumbItemDropDown access$0(8 var0) {
                return var0.BreadcrumbItemDropDown.this;
            }
        });
        int index = this.fParent.getViewer().getIndexOfItem(this.fParent);
        if (index < this.fParent.getViewer().getItemCount() - 1) {
            BreadcrumbItem childItem = this.fParent.getViewer().getItem(index + 1);
            Object child = childItem.getData();
            this.fDropDownViewer.setSelection((ISelection)new StructuredSelection(child), true);
            TreeItem[] selection = tree.getSelection();
            if (selection.length > 0) {
                tree.setTopItem(selection[0]);
            }
        }
        this.fShell.setVisible(true);
        this.installCloser(this.fShell);
    }

    private void openElement(Object data) {
        boolean treeHasFocus;
        if (data == null) {
            return;
        }
        this.fParent.getViewer().fireMenuSelection(data);
        boolean bl = treeHasFocus = !this.fShell.isDisposed() && this.fDropDownViewer.getTree().isFocusControl();
        if (DEBUG) {
            System.out.println("\tisDisposed: " + this.fShell.isDisposed());
            System.out.println("\tshell hasFocus: " + (!this.fShell.isDisposed() && this.fShell.isFocusControl()));
            System.out.println("\ttree hasFocus: " + treeHasFocus);
        }
        if (this.fShell.isDisposed()) {
            return;
        }
        if (!treeHasFocus) {
            this.fShell.close();
            return;
        }
        this.toggleExpansionState(data);
    }

    private void toggleExpansionState(Object element) {
        Tree tree = this.fDropDownViewer.getTree();
        if (this.fDropDownViewer.getExpandedState(element)) {
            this.fDropDownViewer.collapseToLevel(element, 1);
        } else {
            tree.setRedraw(false);
            try {
                this.fDropDownViewer.expandToLevel(element, 1);
                this.resizeShell(this.fShell);
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private void installCloser(final Shell shell) {
        final Listener focusListener = new Listener(){

            public void handleEvent(Event event) {
                Widget focusElement = event.widget;
                boolean isFocusBreadcrumbTreeFocusWidget = focusElement == shell || focusElement instanceof Tree && ((Tree)focusElement).getShell() == shell;
                boolean isFocusWidgetParentShell = focusElement instanceof Control && ((Control)focusElement).getShell().getParent() == shell;
                switch (event.type) {
                    case 15: {
                        if (DEBUG) {
                            System.out.println("focusIn - is breadcrumb tree: " + isFocusBreadcrumbTreeFocusWidget);
                        }
                        if (isFocusBreadcrumbTreeFocusWidget || isFocusWidgetParentShell) break;
                        if (DEBUG) {
                            System.out.println("==> closing shell since focus in other widget");
                        }
                        shell.close();
                        break;
                    }
                    case 16: {
                        if (DEBUG) {
                            System.out.println("focusOut - is breadcrumb tree: " + isFocusBreadcrumbTreeFocusWidget);
                        }
                        if (event.display.getActiveShell() != null) break;
                        if (DEBUG) {
                            System.out.println("==> closing shell since event.display.getActiveShell() == null");
                        }
                        shell.close();
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
            }
        };
        final Display display = shell.getDisplay();
        display.addFilter(15, focusListener);
        display.addFilter(16, focusListener);
        final ControlListener controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                shell.close();
            }

            public void controlResized(ControlEvent e) {
                shell.close();
            }
        };
        this.fToolBar.getShell().addControlListener(controlListener);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DEBUG) {
                    System.out.println("==> shell disposed");
                }
                display.removeFilter(15, focusListener);
                display.removeFilter(16, focusListener);
                if (!BreadcrumbItemDropDown.this.fToolBar.isDisposed()) {
                    BreadcrumbItemDropDown.this.fToolBar.getShell().removeControlListener(controlListener);
                }
            }
        });
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                if (DEBUG) {
                    System.out.println("==> shellClosed");
                }
                if (!BreadcrumbItemDropDown.this.fMenuIsShown) {
                    return;
                }
                BreadcrumbItemDropDown.this.fMenuIsShown = false;
                BreadcrumbItemDropDown.this.fDropDownViewer = null;
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings javaSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = javaSettings.getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = javaSettings.addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    private int getMaxHeight() {
        try {
            return this.getDialogSettings().getInt(DIALOG_HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {
            return 300;
        }
    }

    private void setShellBounds(Shell shell) {
        Rectangle rect = this.fParentComposite.getBounds();
        Rectangle toolbarBounds = this.fToolBar.getBounds();
        shell.pack();
        Point size = shell.getSize();
        int height = Math.max(Math.min(size.y, this.getMaxHeight()), 200);
        int width = Math.max(Math.min(size.x, 500), 250);
        int imageBoundsX = 0;
        if (this.fDropDownViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.fDropDownViewer.getTree().getItem(0);
            imageBoundsX = item.getImageBounds((int)0).x;
        }
        Rectangle trim = this.fShell.computeTrim(0, 0, width, height);
        int x = toolbarBounds.x + toolbarBounds.width + 2 + trim.x - imageBoundsX;
        if (!this.isLTR()) {
            x += width;
        }
        Point pt = new Point(x, rect.y + rect.height);
        pt = this.fParentComposite.toDisplay(pt);
        Rectangle monitor = BreadcrumbItemDropDown.getClosestMonitor(shell.getDisplay(), pt).getClientArea();
        int overlap = pt.x + width - (monitor.x + monitor.width);
        if (overlap > 0) {
            pt.x -= overlap;
        }
        if (pt.x < monitor.x) {
            pt.x = monitor.x;
        }
        shell.setLocation(pt);
        shell.setSize(width, height);
    }

    private static Monitor getClosestMonitor(Display display, Point point) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = display.getMonitors();
        Monitor result = monitors[0];
        int i = 0;
        while (i < monitors.length) {
            Monitor current = monitors[i];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(point)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)point);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++i;
        }
        return result;
    }

    private void resizeShell(Shell shell) {
        Point size = shell.getSize();
        int currentWidth = size.x;
        int currentHeight = size.y;
        int maxHeight = this.getMaxHeight();
        if (currentHeight >= maxHeight && currentWidth >= 500) {
            return;
        }
        Point preferedSize = shell.computeSize(-1, -1, true);
        int newWidth = currentWidth >= 500 ? currentWidth : Math.min(Math.max(preferedSize.x, currentWidth), 500);
        int newHeight = currentHeight >= maxHeight ? currentHeight : Math.min(Math.max(preferedSize.y, currentHeight), maxHeight);
        if (newHeight != currentHeight || newWidth != currentWidth) {
            shell.setRedraw(false);
            try {
                this.isResizingProgrammatically = true;
                shell.setSize(newWidth, newHeight);
                if (!this.isLTR()) {
                    Point location = shell.getLocation();
                    shell.setLocation(location.x - (newWidth - currentWidth), location.y);
                }
            }
            finally {
                this.isResizingProgrammatically = false;
                shell.setRedraw(true);
            }
        }
    }

    private boolean isLTR() {
        return (this.fParentComposite.getStyle() & 0x4000000) == 0;
    }

    static /* synthetic */ void access$8(BreadcrumbItemDropDown breadcrumbItemDropDown, Shell shell) {
        breadcrumbItemDropDown.resizeShell(shell);
    }

    private final class AccessibelArrowImage
    extends CompositeImageDescriptor {
        private static final int ARROW_SIZE = 5;
        private final boolean fLTR;

        public AccessibelArrowImage(boolean ltr) {
            this.fLTR = ltr;
        }

        protected void drawCompositeImage(int width, int height) {
            int x;
            Display display = BreadcrumbItemDropDown.this.fParentComposite.getDisplay();
            Image image = new Image((Device)display, 5, 10);
            GC gc = new GC((Drawable)image);
            Color triangle = this.createColor(24, 25, 20, display);
            Color aliasing = this.createColor(24, 25, 30, display);
            gc.setBackground(triangle);
            if (this.fLTR) {
                int[] nArray = new int[6];
                nArray[0] = this.mirror(0);
                nArray[2] = this.mirror(5);
                nArray[3] = 5;
                nArray[4] = this.mirror(0);
                nArray[5] = 10;
                gc.fillPolygon(nArray);
            } else {
                int[] nArray = new int[6];
                nArray[0] = 5;
                nArray[3] = 5;
                nArray[4] = 5;
                nArray[5] = 10;
                gc.fillPolygon(nArray);
            }
            gc.setForeground(aliasing);
            gc.drawLine(this.mirror(0), 1, this.mirror(4), 5);
            gc.drawLine(this.mirror(4), 5, this.mirror(0), 9);
            gc.dispose();
            triangle.dispose();
            aliasing.dispose();
            ImageData imageData = image.getImageData();
            int y = 1;
            while (y < 5) {
                x = 0;
                while (x < y) {
                    imageData.setAlpha(this.mirror(x), y, 255);
                    ++x;
                }
                ++y;
            }
            y = 0;
            while (y < 5) {
                x = 0;
                while (x <= y) {
                    imageData.setAlpha(this.mirror(x), 10 - y - 1, 255);
                    ++x;
                }
                ++y;
            }
            int offset = this.fLTR ? 0 : -1;
            this.drawImage(imageData, width / 2 - 2 + offset, height / 2 - 5 - 1);
            image.dispose();
        }

        private int mirror(int x) {
            if (this.fLTR) {
                return x;
            }
            return 5 - x - 1;
        }

        protected Point getSize() {
            return new Point(10, 16);
        }

        private Color createColor(int color1, int color2, int ratio, Display display) {
            RGB rgb1 = display.getSystemColor(color1).getRGB();
            RGB rgb2 = display.getSystemColor(color2).getRGB();
            RGB blend = FormColors.blend((RGB)rgb2, (RGB)rgb1, (int)ratio);
            return new Color((Device)display, blend);
        }
    }
}

