/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_action");
    }

    public OpenAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ISourceReference || element instanceof IFile || JavaModelUtil.isOpenableStorage(element)) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, false);
            elements = this.selectOpenableElements(elements);
            if (elements == null || elements.length == 0) {
                IEditorStatusLine statusLine;
                if (!ActionUtil.isProcessable(this.fEditor)) {
                    return;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((statusLine = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) != null) {
                    statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            IJavaElement element = elements[0];
            if (elements.length > 1 && (element = SelectionConverter.selectJavaElement(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element)) == null) {
                return;
            }
            this.run(new Object[]{element});
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IJavaElement[] selectOpenableElements(IJavaElement[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            switch (element.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: {
                    break;
                }
                default: {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, ActionMessages.OpenAction_multistatus_message, null);
        int i = 0;
        while (i < elements.length) {
            String message;
            Object element = elements[i];
            try {
                element = this.getElementToOpen(element);
                boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                IEditorPart part = EditorUtility.openInEditor(element, activateOnOpen);
                if (part != null && element instanceof IJavaElement) {
                    JavaUI.revealInEditor(part, (IJavaElement)element);
                }
            }
            catch (PartInitException e) {
                message = Messages.format(ActionMessages.OpenAction_error_problem_opening_editor, new String[]{JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_DEFAULT), e.getStatus().getMessage()});
                status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
            }
            catch (CoreException e) {
                message = Messages.format(ActionMessages.OpenAction_error_problem_opening_editor, new String[]{JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_DEFAULT), e.getStatus().getMessage()});
                status.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, message, null));
                JavaPlugin.log(e);
            }
            ++i;
        }
        if (!status.isOK()) {
            IStatus[] children = status.getChildren();
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_message, (IStatus)(children.length == 1 ? children[0] : status));
        }
    }

    public Object getElementToOpen(Object object) throws JavaModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }
}

