/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.tasks.FileTaskScannerRegistryReader;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.TaskTagPreferencePage;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.osgi.service.prefs.Preferences;

class ExclusionsTab
implements IPreferenceTab {
    private static final boolean _debugPreferences = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.core/tasks/preferences"));
    private CheckboxTreeViewer fContentTypeList;
    private IContentTypeManager fContentTypeManager = null;
    ContentTypeSorter fContentTypeSorter = new ContentTypeSorter();
    private IContentType[] fIgnoreContentTypes = null;
    private IContentType[] fOriginalIgnoreContentTypes = null;
    private TaskTagPreferencePage fOwner = null;
    private IScopeContext[] fPreferencesLookupOrder = null;
    private IPreferencesService fPreferencesService = null;
    private List fSupportedContentTypes = null;

    public ExclusionsTab(TaskTagPreferencePage parent, IPreferencesService preferencesService, IScopeContext[] lookupOrder) {
        this.fOwner = parent;
        this.fPreferencesLookupOrder = lookupOrder;
        this.fPreferencesService = preferencesService;
        this.fContentTypeManager = Platform.getContentTypeManager();
        String[] supportedContentTypeIDs = FileTaskScannerRegistryReader.getInstance().getSupportedContentTypeIds();
        this.fSupportedContentTypes = new ArrayList(supportedContentTypeIDs.length);
        int i = 0;
        while (i < supportedContentTypeIDs.length) {
            IContentType type = this.fContentTypeManager.getContentType(supportedContentTypeIDs[i]);
            if (type != null) {
                this.fSupportedContentTypes.add(type);
            }
            ++i;
        }
        String[] ignoreContentTypes = StringUtils.unpack((String)this.fPreferencesService.getString("org.eclipse.wst.sse.core/task-tags", "ignored-contentTypes", SSECorePlugin.getDefault().getPluginPreferences().getDefaultString("ignored-contentTypes"), this.fPreferencesLookupOrder));
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>();
        int i2 = 0;
        while (i2 < ignoreContentTypes.length) {
            IContentType type = this.fContentTypeManager.getContentType(ignoreContentTypes[i2]);
            if (type != null) {
                contentTypes.add(type);
            }
            ++i2;
        }
        this.fIgnoreContentTypes = contentTypes.toArray(new IContentType[contentTypes.size()]);
        this.fOriginalIgnoreContentTypes = this.fIgnoreContentTypes;
    }

    public Control createContents(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Label description = new Label(composite, 0);
        description.setText(SSEUIMessages.TaskTagExclusionTab_02);
        this.fContentTypeList = new CheckboxTreeViewer(composite, 2820);
        this.fContentTypeList.setLabelProvider((IBaseLabelProvider)new ContentTypeLabelProvider());
        this.fContentTypeList.setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.fContentTypeList.setInput((Object)this.fSupportedContentTypes.toArray());
        this.fContentTypeList.setCheckedElements(this.fSupportedContentTypes.toArray());
        this.fContentTypeList.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        int i = 0;
        while (i < this.fIgnoreContentTypes.length) {
            this.fContentTypeList.setChecked((Object)this.fIgnoreContentTypes[i], false);
            ++i;
        }
        Button selectAll = new Button(composite, 8);
        selectAll.setText(SSEUIMessages.TaskTagPreferenceTab_17);
        selectAll.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExclusionsTab.this.fContentTypeList.setCheckedElements(ExclusionsTab.this.fSupportedContentTypes.toArray());
            }
        });
        Button selectNone = new Button(composite, 8);
        selectNone.setText(SSEUIMessages.TaskTagPreferenceTab_18);
        selectNone.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExclusionsTab.this.fContentTypeList.setCheckedElements(new Object[0]);
            }
        });
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label affectedTypesLabel = new Label(composite, 0);
        affectedTypesLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        affectedTypesLabel.setText(SSEUIMessages.TaskTagExclusionTab_03);
        final TreeViewer contentTypeTreeViewer = new TreeViewer(composite, 2820);
        contentTypeTreeViewer.setLabelProvider((IBaseLabelProvider)new ContentTypeLabelProvider());
        contentTypeTreeViewer.setContentProvider((IContentProvider)new ContentTypeTreeProvider());
        contentTypeTreeViewer.setInput((Object)new Object[0]);
        contentTypeTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fContentTypeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object[] o = ((IStructuredSelection)event.getSelection()).toArray();
                    contentTypeTreeViewer.setInput((Object)o);
                    contentTypeTreeViewer.expandAll();
                    if (o.length > 0) {
                        contentTypeTreeViewer.reveal(o[0]);
                    }
                }
            }
        });
        return composite;
    }

    public String getTitle() {
        return SSEUIMessages.TaskTagExclusionTab_01;
    }

    public void performApply() {
        this.save();
    }

    public void performDefaults() {
        if (_debugPreferences) {
            System.out.println("Loading defaults in " + this.getClass().getName());
        }
        IEclipsePreferences[] defaultPreferences = new IEclipsePreferences[this.fPreferencesLookupOrder.length - 1];
        int i = 1;
        while (i < defaultPreferences.length) {
            defaultPreferences[i - 1] = this.fPreferencesLookupOrder[i].getNode("org.eclipse.wst.sse.core/task-tags");
            ++i;
        }
        String[] defaultIgnoreTypes = StringUtils.unpack((String)this.fPreferencesService.get("ignored-contentTypes", null, (Preferences[])defaultPreferences));
        ArrayList<IContentType> contentTypes = new ArrayList<IContentType>();
        int i2 = 0;
        while (i2 < defaultIgnoreTypes.length) {
            IContentType type = this.fContentTypeManager.getContentType(defaultIgnoreTypes[i2]);
            if (type != null) {
                contentTypes.add(type);
            }
            ++i2;
        }
        this.fIgnoreContentTypes = contentTypes.toArray(new IContentType[contentTypes.size()]);
        this.fContentTypeList.setCheckedElements((Object[])this.fContentTypeManager.getAllContentTypes());
        i2 = 0;
        while (i2 < this.fIgnoreContentTypes.length) {
            this.fContentTypeList.setChecked((Object)this.fIgnoreContentTypes[i2], false);
            ++i2;
        }
    }

    public void performOk() {
        List ignoredIds = this.save();
        String[] ignoreIDs = (String[])new StringSorter().sort(ignoredIds.toArray());
        this.fIgnoreContentTypes = new IContentType[ignoreIDs.length];
        int i = 0;
        while (i < ignoreIDs.length) {
            this.fIgnoreContentTypes[i] = this.fContentTypeManager.getContentType(ignoreIDs[i]);
            ++i;
        }
        if (!Arrays.equals(this.fOriginalIgnoreContentTypes, this.fIgnoreContentTypes)) {
            this.fOwner.requestRedetection();
        }
        this.fOriginalIgnoreContentTypes = this.fIgnoreContentTypes;
    }

    private List save() {
        ArrayList<String> ignoredIds = new ArrayList<String>();
        List<Object> checked = Arrays.asList(this.fContentTypeList.getCheckedElements());
        int i = 0;
        while (i < this.fSupportedContentTypes.size()) {
            if (!checked.contains(this.fSupportedContentTypes.get(i))) {
                ignoredIds.add(((IContentType)this.fSupportedContentTypes.get(i)).getId());
            }
            ++i;
        }
        IEclipsePreferences[] defaultPreferences = new IEclipsePreferences[this.fPreferencesLookupOrder.length - 1];
        int i2 = 1;
        while (i2 < defaultPreferences.length) {
            defaultPreferences[i2 - 1] = this.fPreferencesLookupOrder[i2].getNode("org.eclipse.wst.sse.core/task-tags");
            ++i2;
        }
        String defaultIgnoredContentTypeIds = StringUtils.pack((String[])((String[])new StringSorter().sort(StringUtils.unpack((String)this.fPreferencesService.get("ignored-contentTypes", "", (Preferences[])defaultPreferences)))));
        String ignoredContentTypeIds = StringUtils.pack((String[])((String[])new StringSorter().sort(ignoredIds.toArray())));
        if (ignoredContentTypeIds.equals(defaultIgnoredContentTypeIds)) {
            if (_debugPreferences) {
                System.out.println(String.valueOf(this.getClass().getName()) + " removing " + "ignored-contentTypes" + " from scope " + this.fPreferencesLookupOrder[0].getName() + ":" + this.fPreferencesLookupOrder[0].getLocation());
            }
            this.fPreferencesLookupOrder[0].getNode("org.eclipse.wst.sse.core/task-tags").remove("ignored-contentTypes");
        } else {
            if (_debugPreferences) {
                System.out.println(String.valueOf(this.getClass().getName()) + " setting " + "ignored-contentTypes" + " \"" + ignoredContentTypeIds + "\" in scope " + this.fPreferencesLookupOrder[0].getName() + ":" + this.fPreferencesLookupOrder[0].getLocation());
            }
            this.fPreferencesLookupOrder[0].getNode("org.eclipse.wst.sse.core/task-tags").put("ignored-contentTypes", ignoredContentTypeIds);
        }
        return ignoredIds;
    }

    private class ArrayTreeContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return ExclusionsTab.this.fContentTypeSorter.sort((Object[])parentElement);
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ContentTypeLabelProvider
    extends LabelProvider {
        private ContentTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element != null) {
                Object o = element;
                if (o instanceof String) {
                    o = ExclusionsTab.this.fContentTypeManager.getContentType(o.toString());
                }
                if (o instanceof IContentType) {
                    return ((IContentType)o).getName();
                }
            }
            return super.getText(element);
        }
    }

    private class ContentTypeSorter
    extends Sorter {
        private Collator collator = Collator.getInstance((Locale)Locale.ENGLISH);

        private ContentTypeSorter() {
        }

        public boolean compare(Object elementOne, Object elementTwo) {
            return this.collator.compare(((IContentType)elementOne).getName(), ((IContentType)elementTwo).getName()) < 0;
        }

        public Object[] sort(Object[] unSortedCollection) {
            Object[] types = super.sort(unSortedCollection);
            Object[] sortedTypes = new IContentType[types.length];
            if (types.length > 0) {
                System.arraycopy(types, 0, sortedTypes, 0, sortedTypes.length);
            }
            return sortedTypes;
        }
    }

    private class ContentTypeTreeProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        boolean equals(Object left, Object right) {
            return left == null ? right == null : right != null && left.equals(right);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof IContentType) {
                ArrayList<IContentType> elements = new ArrayList<IContentType>(0);
                IContentType[] allTypes = ExclusionsTab.this.fContentTypeManager.getAllContentTypes();
                int i = 0;
                while (i < allTypes.length) {
                    if (!ExclusionsTab.this.fSupportedContentTypes.contains(allTypes[i]) && this.equals(allTypes[i].getBaseType(), parentElement)) {
                        elements.add(allTypes[i]);
                    }
                    ++i;
                }
                return ExclusionsTab.this.fContentTypeSorter.sort(elements.toArray());
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            IContentType parent = null;
            if (element instanceof IContentType) {
                parent = ((IContentType)element).getBaseType();
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class StringSorter
    extends Sorter {
        Collator collator = Collator.getInstance((Locale)Locale.ENGLISH);

        private StringSorter() {
        }

        public boolean compare(Object elementOne, Object elementTwo) {
            return this.collator.compare(elementOne.toString(), elementTwo.toString()) < 0;
        }

        public Object[] sort(Object[] unSortedCollection) {
            Object[] sortedCollection = super.sort(unSortedCollection);
            Object[] strings = new String[sortedCollection.length];
            if (strings.length > 0) {
                System.arraycopy(sortedCollection, 0, strings, 0, strings.length);
            }
            return strings;
        }
    }
}

