/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.IFailedStatusEvaluator;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallOperation
extends ProfileChangeOperation {
    private Collection<IInstallableUnit> toInstall;

    public InstallOperation(ProvisioningSession session, Collection<IInstallableUnit> toInstall) {
        super(session);
        this.toInstall = toInstall;
    }

    @Override
    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        this.request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)this.session.getProvisioningAgent(), (String)this.profileId);
        IProfile profile = this.session.getProfileRegistry().getProfile(this.profileId);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallOperation_ComputeProfileChangeProgress, (int)this.toInstall.size());
        for (IInstallableUnit entryToInstall : this.toInstall) {
            IQueryResult alreadyInstalled;
            if (QueryUtil.isPatch((IInstallableUnit)entryToInstall)) {
                this.request.setInstallableUnitInclusionRules(entryToInstall, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)entryToInstall));
            }
            if (!(alreadyInstalled = profile.query(QueryUtil.createIUQuery((String)entryToInstall.getId()), null)).isEmpty()) {
                IInstallableUnit installedIU = (IInstallableUnit)alreadyInstalled.iterator().next();
                int compareTo = entryToInstall.getVersion().compareTo((Object)installedIU.getVersion());
                if (compareTo > 0) {
                    boolean lockedForUpdate = false;
                    String value = profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.lock");
                    if (value != null) {
                        boolean bl = lockedForUpdate = (Integer.parseInt(value) & 2) == 2;
                    }
                    if (lockedForUpdate) {
                        status.merge(PlanAnalyzer.getStatus(10013, entryToInstall));
                    } else {
                        this.request.add(entryToInstall);
                        this.request.remove(installedIU);
                        status.merge(PlanAnalyzer.getStatus(10003, entryToInstall));
                        if (!UserVisibleRootQuery.isUserVisible((IInstallableUnit)installedIU, (IProfile)profile)) {
                            this.request.setInstallableUnitProfileProperty(entryToInstall, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                        }
                    }
                } else if (compareTo < 0) {
                    status.merge(PlanAnalyzer.getStatus(10004, entryToInstall));
                } else if (UserVisibleRootQuery.isUserVisible((IInstallableUnit)installedIU, (IProfile)profile)) {
                    status.merge(PlanAnalyzer.getStatus(10005, entryToInstall));
                } else {
                    status.merge(PlanAnalyzer.getStatus(10006, entryToInstall));
                    this.request.setInstallableUnitProfileProperty(entryToInstall, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                }
            } else {
                this.request.add(entryToInstall);
                this.request.setInstallableUnitProfileProperty(entryToInstall, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
            }
            sub.worked(1);
        }
        sub.done();
    }

    @Override
    protected String getResolveJobName() {
        return Messages.InstallOperation_ResolveJobName;
    }

    @Override
    protected String getProvisioningJobName() {
        return Messages.InstallOperation_InstallJobName;
    }

    @Override
    ProvisioningContext getFirstPassProvisioningContext() {
        this.context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", null);
        return this.context;
    }

    @Override
    IFailedStatusEvaluator getSecondPassEvaluator() {
        return new IFailedStatusEvaluator(){

            public ProvisioningContext getSecondPassProvisioningContext(IProvisioningPlan failedPlan) {
                if (InstallOperation.this.missingRequirement(failedPlan)) {
                    InstallOperation.this.context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", Boolean.toString(true));
                }
                return InstallOperation.this.context;
            }
        };
    }

    boolean missingRequirement(IProvisioningPlan failedPlan) {
        IStatus status = failedPlan.getStatus();
        RequestStatus requestStatus = null;
        if (status instanceof PlannerStatus) {
            requestStatus = ((PlannerStatus)status).getRequestStatus();
        }
        return requestStatus != null && requestStatus.getShortExplanation() == 1;
    }
}

