/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site.compatibility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.site.compatibility.Feature;
import org.eclipse.pde.internal.build.site.compatibility.FeatureEntry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser
extends DefaultHandler
implements IPDEBuildConstants {
    private SAXParser parser;
    private Feature result;
    private URL url;
    private StringBuffer characters = null;
    private MultiStatus status = null;
    private boolean hasImports = false;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FeatureParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    public Feature parse(URL featureURL) throws SAXException, IOException {
        this.result = null;
        InputStream in = null;
        try {
            this.url = featureURL;
            in = featureURL.openStream();
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return this.result;
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("plugin".equals(localName)) {
            this.processPlugin(attributes);
        } else if ("description".equals(localName)) {
            this.processDescription(attributes);
        } else if ("license".equals(localName)) {
            this.processLicense(attributes);
        } else if ("copyright".equals(localName)) {
            this.processCopyright(attributes);
        } else if ("feature".equals(localName)) {
            this.processFeature(attributes);
        } else if ("import".equals(localName)) {
            this.processImport(attributes);
        } else if ("includes".equals(localName)) {
            this.processIncludes(attributes);
        } else if ("install-handler".equals(localName)) {
            this.processInstallHandler(attributes);
        } else if ("update".equals(localName)) {
            this.processUpdateSite(attributes);
        } else if ("discovery".equals(localName)) {
            this.processDiscoverySite(attributes);
        }
    }

    private void processImport(Attributes attributes) {
        String id = attributes.getValue("feature");
        FeatureEntry entry = null;
        if (id != null) {
            entry = FeatureEntry.createRequires(id, attributes.getValue("version"), attributes.getValue("match"), attributes.getValue("filter"), false);
        } else {
            id = attributes.getValue("plugin");
            entry = FeatureEntry.createRequires(id, attributes.getValue("version"), attributes.getValue("match"), attributes.getValue("filter"), true);
        }
        this.hasImports = true;
        this.result.addEntry(entry);
    }

    private void processIncludes(Attributes attributes) {
        FeatureEntry entry = new FeatureEntry(attributes.getValue("id"), attributes.getValue("version"), false);
        String flag = attributes.getValue("unpack");
        if (flag != null) {
            entry.setUnpack(Boolean.valueOf(flag));
        }
        if ((flag = attributes.getValue("optional")) != null) {
            entry.setOptional(Boolean.valueOf(flag));
        }
        this.setEnvironment(attributes, entry);
        this.result.addEntry(entry);
    }

    private void processInstallHandler(Attributes attributes) {
        this.result.setInstallHandler(attributes.getValue("handler"));
        this.result.setInstallHandlerLibrary(attributes.getValue("library"));
        this.result.setInstallHandlerURL(attributes.getValue("url"));
    }

    private void processUpdateSite(Attributes attributes) {
        this.result.setUpdateSiteLabel(attributes.getValue("label"));
        this.result.setUpdateSiteURL(attributes.getValue("url"));
    }

    private void processDiscoverySite(Attributes attributes) {
        this.result.addDiscoverySite(attributes.getValue("label"), attributes.getValue("url"));
    }

    private void setEnvironment(Attributes attributes, FeatureEntry entry) {
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        String nl = attributes.getValue("nl");
        String arch = attributes.getValue("arch");
        entry.setEnvironment(os, ws, arch, nl);
    }

    protected Feature createFeature(String id, String version) {
        return new Feature(id, version);
    }

    protected void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            this.error(NLS.bind((String)Messages.feature_parse_invalidIdOrVersion, (Object[])new String[]{id, ver}));
        } else {
            this.result = this.createFeature(id, ver);
            String os = attributes.getValue("os");
            String ws = attributes.getValue("ws");
            String nl = attributes.getValue("nl");
            String arch = attributes.getValue("arch");
            this.result.setEnvironment(os, ws, arch, nl);
            if ("file".equals(this.url.getProtocol())) {
                File f = new File(this.url.getFile().replace('/', File.separatorChar));
                this.result.setURL("features/" + f.getParentFile().getName() + "/");
            }
            this.result.setProviderName(attributes.getValue("provider-name"));
            this.result.setLabel(attributes.getValue("label"));
            this.result.setImage(attributes.getValue("image"));
            this.result.setBrandingPlugin(attributes.getValue("plugin"));
            this.result.setLicenseFeature(attributes.getValue("license-feature"));
            this.result.setLicenseFeatureVersion(attributes.getValue("license-feature-version"));
        }
    }

    private void processPlugin(Attributes attributes) {
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        if (id == null || id.trim().equals("") || version == null || version.trim().equals("")) {
            this.error(NLS.bind((String)Messages.feature_parse_invalidIdOrVersion, (Object[])new String[]{id, version}));
        } else {
            String filter;
            String fragment;
            FeatureEntry plugin = new FeatureEntry(id, version, true);
            this.setEnvironment(attributes, plugin);
            String unpack = attributes.getValue("unpack");
            if (unpack != null) {
                plugin.setUnpack(Boolean.valueOf(unpack));
            }
            if ((fragment = attributes.getValue("fragment")) != null) {
                plugin.setFragment(Boolean.valueOf(fragment));
            }
            if ((filter = attributes.getValue("filter")) != null) {
                plugin.setFilter(filter);
            }
            this.result.addEntry(plugin);
        }
    }

    private void processLicense(Attributes attributes) {
        this.result.setLicenseURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processCopyright(Attributes attributes) {
        this.result.setCopyrightURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processDescription(Attributes attributes) {
        this.result.setDescriptionURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.characters == null) {
            return;
        }
        this.characters.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) {
        if ("requires".equals(localName) && !this.hasImports) {
            this.error(Messages.feature_parse_emptyRequires);
        }
        if (this.characters == null) {
            return;
        }
        if ("description".equals(localName)) {
            this.result.setDescription(this.characters.toString().trim());
        } else if ("license".equals(localName)) {
            this.result.setLicense(this.characters.toString().trim());
        } else if ("copyright".equals(localName)) {
            this.result.setCopyright(this.characters.toString().trim());
        }
        this.characters = null;
    }

    private void error(String message) {
        if (this.status == null) {
            String msg = NLS.bind((String)Messages.exception_featureParse, (Object)this.url.toExternalForm());
            this.status = new MultiStatus("org.eclipse.pde.build", 17, msg, null);
        }
        this.status.add((IStatus)new Status(4, "org.eclipse.pde.build", 17, message, null));
    }
}

